/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.command.AlterTableAddColumnsCommand;
import org.apache.spark.sql.execution.command.AlterTableAddPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand;
import org.apache.spark.sql.execution.command.AlterTableDropPartitionCommand;
import org.apache.spark.sql.execution.command.AlterTableRenameCommand;
import org.apache.spark.sql.execution.command.CreateDataSourceTableCommand;
import org.apache.spark.sql.execution.command.DropTableCommand;
import org.apache.spark.sql.execution.command.ShowCreateTableCommand;
import org.apache.spark.sql.execution.command.ShowPartitionsCommand;
import org.apache.spark.sql.execution.command.TruncateTableCommand;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$;
import org.apache.spark.sql.hudi.analysis.HoodieAnalysis$MatchCreateTableLike$;
import org.apache.spark.sql.hudi.analysis.HoodiePostAnalysisRule$;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddPartitionCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableChangeColumnCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableDropPartitionCommand;
import org.apache.spark.sql.hudi.command.AlterHoodieTableRenameCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableCommand;
import org.apache.spark.sql.hudi.command.CreateHoodieTableLikeCommand;
import org.apache.spark.sql.hudi.command.DropHoodieTableCommand;
import org.apache.spark.sql.hudi.command.RepairHoodieTableCommand;
import org.apache.spark.sql.hudi.command.ShowHoodieCreateTableCommand;
import org.apache.spark.sql.hudi.command.ShowHoodieTablePartitionsCommand;
import org.apache.spark.sql.hudi.command.TruncateHoodieTableCommand;
import org.apache.spark.sql.types.StructField;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005c\u0001\u0002\f\u0018\u0001\u0012B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\t\u0002\u0011\t\u0012)A\u0005\u0001\")Q\t\u0001C\u0001\r\")!\n\u0001C!\u0017\"9a\nAA\u0001\n\u0003y\u0005bB)\u0001#\u0003%\tA\u0015\u0005\b;\u0002\t\t\u0011\"\u0011_\u0011\u001d9\u0007!!A\u0005\u0002!Dq\u0001\u001c\u0001\u0002\u0002\u0013\u0005Q\u000eC\u0004t\u0001\u0005\u0005I\u0011\t;\t\u000fm\u0004\u0011\u0011!C\u0001y\"I\u00111\u0001\u0001\u0002\u0002\u0013\u0005\u0013Q\u0001\u0005\n\u0003\u000f\u0001\u0011\u0011!C!\u0003\u0013A\u0011\"a\u0003\u0001\u0003\u0003%\t%!\u0004\b\u0013\u0005Eq#!A\t\u0002\u0005Ma\u0001\u0003\f\u0018\u0003\u0003E\t!!\u0006\t\r\u0015\u0003B\u0011AA\u0012\u0011%\t9\u0001EA\u0001\n\u000b\nI\u0001\u0003\u0005K!\u0005\u0005I\u0011QA\u0013\u0011%\tI\u0003EA\u0001\n\u0003\u000bY\u0003C\u0005\u00028A\t\t\u0011\"\u0003\u0002:\t1\u0002j\\8eS\u0016\u0004vn\u001d;B]\u0006d\u0017p]5t%VdWM\u0003\u0002\u00193\u0005A\u0011M\\1msNL7O\u0003\u0002\u001b7\u0005!\u0001.\u001e3j\u0015\taR$A\u0002tc2T!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\u0002\u0001'\u0011\u0001Q%N\u001e\u0011\u0007\u0019ZS&D\u0001(\u0015\tA\u0013&A\u0003sk2,7O\u0003\u0002+7\u0005A1-\u0019;bYf\u001cH/\u0003\u0002-O\t!!+\u001e7f!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0004m_\u001eL7-\u00197\u000b\u0005IJ\u0013!\u00029mC:\u001c\u0018B\u0001\u001b0\u0005-aunZ5dC2\u0004F.\u00198\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\u000fA\u0013x\u000eZ;diB\u0011a\u0007P\u0005\u0003{]\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fAb\u001d9be.\u001cVm]:j_:,\u0012\u0001\u0011\t\u0003\u0003\nk\u0011aG\u0005\u0003\u0007n\u0011Ab\u00159be.\u001cVm]:j_:\fQb\u001d9be.\u001cVm]:j_:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002H\u0013B\u0011\u0001\nA\u0007\u0002/!)ah\u0001a\u0001\u0001\u0006)\u0011\r\u001d9msR\u0011Q\u0006\u0014\u0005\u0006\u001b\u0012\u0001\r!L\u0001\u0005a2\fg.\u0001\u0003d_BLHCA$Q\u0011\u001dqT\u0001%AA\u0002\u0001\u000babY8qs\u0012\"WMZ1vYR$\u0013'F\u0001TU\t\u0001EkK\u0001V!\t16,D\u0001X\u0015\tA\u0016,A\u0005v]\u000eDWmY6fI*\u0011!lN\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001/X\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003}\u0003\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\t1\fgn\u001a\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002SB\u0011aG[\u0005\u0003W^\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"A\\9\u0011\u0005Yz\u0017B\u000198\u0005\r\te.\u001f\u0005\be&\t\t\u00111\u0001j\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tQ\u000fE\u0002ws:l\u0011a\u001e\u0006\u0003q^\n!bY8mY\u0016\u001cG/[8o\u0013\tQxO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA?\u0002\u0002A\u0011aG`\u0005\u0003\u007f^\u0012qAQ8pY\u0016\fg\u000eC\u0004s\u0017\u0005\u0005\t\u0019\u00018\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012![\u0001\ti>\u001cFO]5oOR\tq,\u0001\u0004fcV\fGn\u001d\u000b\u0004{\u0006=\u0001b\u0002:\u000f\u0003\u0003\u0005\rA\\\u0001\u0017\u0011>|G-[3Q_N$\u0018I\\1msNL7OU;mKB\u0011\u0001\nE\n\u0005!\u0005]1\b\u0005\u0004\u0002\u001a\u0005}\u0001iR\u0007\u0003\u00037Q1!!\b8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\t\u0002\u001c\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005MAcA$\u0002(!)ah\u0005a\u0001\u0001\u00069QO\\1qa2LH\u0003BA\u0017\u0003g\u0001BANA\u0018\u0001&\u0019\u0011\u0011G\u001c\u0003\r=\u0003H/[8o\u0011!\t)\u0004FA\u0001\u0002\u00049\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0004E\u0002a\u0003{I1!a\u0010b\u0005\u0019y%M[3di\u0002")
public class HoodiePostAnalysisRule
extends Rule<LogicalPlan>
implements Product,
Serializable {
    private final SparkSession sparkSession;

    public static Option<SparkSession> unapply(HoodiePostAnalysisRule hoodiePostAnalysisRule) {
        return HoodiePostAnalysisRule$.MODULE$.unapply(hoodiePostAnalysisRule);
    }

    public static <A> Function1<SparkSession, A> andThen(Function1<HoodiePostAnalysisRule, A> function1) {
        return HoodiePostAnalysisRule$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, HoodiePostAnalysisRule> compose(Function1<A, SparkSession> function1) {
        return HoodiePostAnalysisRule$.MODULE$.compose(function1);
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public LogicalPlan apply(LogicalPlan plan) {
        Option<Tuple6<TableIdentifier, TableIdentifier, CatalogStorageFormat, Option<String>, Map<String, String>, Object>> option;
        void var2_19;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof CreateDataSourceTableCommand) {
            CreateDataSourceTableCommand createDataSourceTableCommand = (CreateDataSourceTableCommand)logicalPlan;
            CatalogTable table = createDataSourceTableCommand.table();
            boolean ignoreIfExists = createDataSourceTableCommand.ignoreIfExists();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(table)) {
                CreateHoodieTableCommand createHoodieTableCommand = new CreateHoodieTableCommand(table, ignoreIfExists);
                return var2_19;
            }
        }
        if (!(option = HoodieAnalysis$MatchCreateTableLike$.MODULE$.unapply(logicalPlan)).isEmpty()) {
            TableIdentifier targetTable = (TableIdentifier)((Tuple6)option.get())._1();
            TableIdentifier sourceTable = (TableIdentifier)((Tuple6)option.get())._2();
            CatalogStorageFormat fileFormat = (CatalogStorageFormat)((Tuple6)option.get())._3();
            Option provider = (Option)((Tuple6)option.get())._4();
            Map properties = (Map)((Tuple6)option.get())._5();
            boolean ifNotExists = BoxesRunTime.unboxToBoolean((Object)((Tuple6)option.get())._6());
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable((String)provider.orNull(Predef$.MODULE$.$conforms()))) {
                CreateHoodieTableLikeCommand createHoodieTableLikeCommand = new CreateHoodieTableLikeCommand(targetTable, sourceTable, fileFormat, (Map<String, String>)properties, ifNotExists);
                return var2_19;
            }
        }
        if (logicalPlan instanceof DropTableCommand) {
            DropTableCommand dropTableCommand = (DropTableCommand)logicalPlan;
            TableIdentifier tableName = dropTableCommand.tableName();
            boolean ifExists = dropTableCommand.ifExists();
            boolean bl = dropTableCommand.isView();
            boolean purge = dropTableCommand.purge();
            if (!bl && this.sparkSession().sessionState().catalog().tableExists(tableName) && HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                DropHoodieTableCommand dropHoodieTableCommand = new DropHoodieTableCommand(tableName, ifExists, false, purge);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableAddPartitionCommand) {
            AlterTableAddPartitionCommand alterTableAddPartitionCommand = (AlterTableAddPartitionCommand)logicalPlan;
            TableIdentifier tableName = alterTableAddPartitionCommand.tableName();
            Seq partitionSpecsAndLocs = alterTableAddPartitionCommand.partitionSpecsAndLocs();
            boolean ifNotExists = alterTableAddPartitionCommand.ifNotExists();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableAddPartitionCommand alterHoodieTableAddPartitionCommand = new AlterHoodieTableAddPartitionCommand(tableName, (Seq<Tuple2<Map<String, String>, Option<String>>>)partitionSpecsAndLocs, ifNotExists);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableDropPartitionCommand) {
            AlterTableDropPartitionCommand alterTableDropPartitionCommand = (AlterTableDropPartitionCommand)logicalPlan;
            TableIdentifier tableName = alterTableDropPartitionCommand.tableName();
            Seq specs = alterTableDropPartitionCommand.specs();
            boolean ifExists = alterTableDropPartitionCommand.ifExists();
            boolean purge = alterTableDropPartitionCommand.purge();
            boolean retainData = alterTableDropPartitionCommand.retainData();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableDropPartitionCommand alterHoodieTableDropPartitionCommand = new AlterHoodieTableDropPartitionCommand(tableName, (Seq<Map<String, String>>)specs, ifExists, purge, retainData);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableAddColumnsCommand) {
            AlterTableAddColumnsCommand alterTableAddColumnsCommand = (AlterTableAddColumnsCommand)logicalPlan;
            TableIdentifier tableId = alterTableAddColumnsCommand.table();
            Seq colsToAdd = alterTableAddColumnsCommand.colsToAdd();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableId, this.sparkSession())) {
                AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = new AlterHoodieTableAddColumnsCommand(tableId, (Seq<StructField>)colsToAdd);
                return var2_19;
            }
        }
        if (logicalPlan instanceof ShowCreateTableCommand) {
            ShowCreateTableCommand showCreateTableCommand = (ShowCreateTableCommand)logicalPlan;
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(showCreateTableCommand.table(), this.sparkSession())) {
                ShowHoodieCreateTableCommand showHoodieCreateTableCommand = new ShowHoodieCreateTableCommand(showCreateTableCommand.table());
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableRenameCommand) {
            AlterTableRenameCommand alterTableRenameCommand = (AlterTableRenameCommand)logicalPlan;
            TableIdentifier oldName = alterTableRenameCommand.oldName();
            TableIdentifier newName = alterTableRenameCommand.newName();
            boolean isView = alterTableRenameCommand.isView();
            if (!isView && HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(oldName, this.sparkSession())) {
                AlterHoodieTableRenameCommand alterHoodieTableRenameCommand = new AlterHoodieTableRenameCommand(oldName, newName, isView);
                return var2_19;
            }
        }
        if (logicalPlan instanceof AlterTableChangeColumnCommand) {
            AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)logicalPlan;
            TableIdentifier tableName = alterTableChangeColumnCommand.tableName();
            String columnName = alterTableChangeColumnCommand.columnName();
            StructField newColumn = alterTableChangeColumnCommand.newColumn();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                AlterHoodieTableChangeColumnCommand alterHoodieTableChangeColumnCommand = new AlterHoodieTableChangeColumnCommand(tableName, columnName, newColumn);
                return var2_19;
            }
        }
        if (logicalPlan instanceof ShowPartitionsCommand) {
            ShowPartitionsCommand showPartitionsCommand = (ShowPartitionsCommand)logicalPlan;
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(showPartitionsCommand.tableName(), this.sparkSession())) {
                ShowHoodieTablePartitionsCommand showHoodieTablePartitionsCommand = new ShowHoodieTablePartitionsCommand(showPartitionsCommand.tableName(), (Option<Map<String, String>>)showPartitionsCommand.spec());
                return var2_19;
            }
        }
        if (logicalPlan instanceof TruncateTableCommand) {
            TruncateTableCommand truncateTableCommand = (TruncateTableCommand)logicalPlan;
            TableIdentifier tableName = truncateTableCommand.tableName();
            Option partitionSpec = truncateTableCommand.partitionSpec();
            if (HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName, this.sparkSession())) {
                TruncateHoodieTableCommand truncateHoodieTableCommand = new TruncateHoodieTableCommand(tableName, (Option<Map<String, String>>)partitionSpec);
                return var2_19;
            }
        }
        if (!HoodieAnalysis$.MODULE$.sparkAdapter().getCatalystPlanUtils().isRepairTable(logicalPlan)) {
            LogicalPlan logicalPlan2 = plan;
            return var2_19;
        }
        Tuple4 tuple4 = (Tuple4)HoodieAnalysis$.MODULE$.sparkAdapter().getCatalystPlanUtils().getRepairTableChildren(logicalPlan).get();
        if (tuple4 == null) throw new MatchError((Object)tuple4);
        TableIdentifier tableName = (TableIdentifier)tuple4._1();
        boolean enableAddPartitions = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
        boolean enableDropPartitions = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        String cmd = (String)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)tableName, (Object)BoxesRunTime.boxToBoolean((boolean)enableAddPartitions), (Object)BoxesRunTime.boxToBoolean((boolean)enableDropPartitions), (Object)cmd);
        Tuple4 tuple43 = tuple42;
        TableIdentifier tableName2 = (TableIdentifier)tuple43._1();
        boolean enableAddPartitions2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
        boolean enableDropPartitions2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
        String cmd2 = (String)tuple43._4();
        LogicalPlan logicalPlan3 = HoodieAnalysis$.MODULE$.sparkAdapter().isHoodieTable(tableName2, this.sparkSession()) ? new RepairHoodieTableCommand(tableName2, enableAddPartitions2, enableDropPartitions2, cmd2) : logicalPlan;
        return var2_19;
    }

    public HoodiePostAnalysisRule copy(SparkSession sparkSession) {
        return new HoodiePostAnalysisRule(sparkSession);
    }

    public SparkSession copy$default$1() {
        return this.sparkSession();
    }

    public String productPrefix() {
        return "HoodiePostAnalysisRule";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.sparkSession();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HoodiePostAnalysisRule;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HoodiePostAnalysisRule)) return false;
        boolean bl = true;
        if (!bl) return false;
        HoodiePostAnalysisRule hoodiePostAnalysisRule = (HoodiePostAnalysisRule)((Object)x$1);
        SparkSession sparkSession = this.sparkSession();
        SparkSession sparkSession2 = hoodiePostAnalysisRule.sparkSession();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!hoodiePostAnalysisRule.canEqual((Object)this)) return false;
        return true;
    }

    public HoodiePostAnalysisRule(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Product.$init$((Product)this);
    }
}

