/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.CommitsCompareProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001E\t\u0001A!)\u0001\u0006\u0001C\u0001S!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u001c\u0001A\u0003%Q\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001-\u0011\u0015\t\u0005\u0001\"\u00019\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u0015I\u0006\u0001\"\u0011[\u000f\u0015q\u0016\u0003#\u0001`\r\u0015\u0001\u0012\u0003#\u0001a\u0011\u0015A3\u0002\"\u0001e\u0011\u001d)7B1A\u0005\u0002\u0019Daa\\\u0006!\u0002\u00139\u0007\"\u00029\f\t\u0003\t(aF\"p[6LGo]\"p[B\f'/\u001a)s_\u000e,G-\u001e:f\u0015\t\u00112#\u0001\u0006qe>\u001cW\rZ;sKNT!\u0001F\u000b\u0002\u000f\r|W.\\1oI*\u0011acF\u0001\u0005QV$\u0017N\u0003\u0002\u00193\u0005\u00191/\u001d7\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001C\u0015\u0002\"AI\u0012\u000e\u0003EI!\u0001J\t\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0011c%\u0003\u0002(#\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0002\"A\t\u0001\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u0001.!\rq\u0013gM\u0007\u0002_)\t\u0001'A\u0003tG\u0006d\u0017-\u0003\u00023_\t)\u0011I\u001d:bsB\u0011!\u0005N\u0005\u0003kE\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003e\u0002\"AO\u001f\u000e\u0003mR!\u0001P\f\u0002\u000bQL\b/Z:\n\u0005yZ$AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGC\u0001#U!\r)U\n\u0015\b\u0003\r.s!a\u0012&\u000e\u0003!S!!S\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0014B\u0001'0\u0003\u001d\u0001\u0018mY6bO\u0016L!AT(\u0003\u0007M+\u0017O\u0003\u0002M_A\u0011\u0011KU\u0007\u0002/%\u00111k\u0006\u0002\u0004%><\b\"B+\t\u0001\u00041\u0016\u0001B1sON\u0004\"AI,\n\u0005a\u000b\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-F\u0001\\!\t\u0011C,\u0003\u0002^#\tI\u0001K]8dK\u0012,(/Z\u0001\u0018\u0007>lW.\u001b;t\u0007>l\u0007/\u0019:f!J|7-\u001a3ve\u0016\u0004\"AI\u0006\u0014\u0005-\t\u0007C\u0001\u0018c\u0013\t\u0019wF\u0001\u0004B]f\u0014VM\u001a\u000b\u0002?\u0006!a*Q'F+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0011a\u0017M\\4\u000b\u00031\fAA[1wC&\u0011a.\u001b\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\t!\u000fE\u0002tq\u0016j\u0011\u0001\u001e\u0006\u0003kZ\f\u0001BZ;oGRLwN\u001c\u0006\u0003o.\fA!\u001e;jY&\u0011\u0011\u0010\u001e\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class CommitsCompareProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.required(1, "path", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("compare_detail", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return CommitsCompareProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return CommitsCompareProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq seq;
        String sourceLatestCommit;
        super.checkArgs(this.PARAMETERS(), args2);
        String table = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        String path = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient source = this.createMetaClient(this.jsc(), basePath);
        HoodieTableMetaClient target = this.createMetaClient(this.jsc(), path);
        HoodieTimeline sourceTimeline = source.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        HoodieTimeline targetTimeline = target.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String targetLatestCommit = targetTimeline.getInstants().iterator().hasNext() ? targetTimeline.lastInstant().get().requestedTime() : "0";
        String string = sourceLatestCommit = sourceTimeline.getInstants().iterator().hasNext() ? sourceTimeline.lastInstant().get().requestedTime() : "0";
        if (sourceLatestCommit != null && InstantComparison.compareTimestamps(targetLatestCommit, InstantComparison.GREATER_THAN, sourceLatestCommit)) {
            java.util.List commitsToCatchup = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(targetTimeline.findInstantsAfter(sourceLatestCommit, Integer.MAX_VALUE).getInstants().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)instant -> instant.requestedTime()).toList()).asJava();
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(53).append("Source ").append(source.getTableConfig().getTableName()).append(" is behind by ").append(commitsToCatchup.size()).append(" commits. Commits to catch up - ").append(commitsToCatchup).toString()})), (List)Nil$.MODULE$);
        } else {
            java.util.List commitsToCatchup = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(sourceTimeline.findInstantsAfter(targetLatestCommit, Integer.MAX_VALUE).getInstants().iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)instant -> instant.requestedTime()).toList()).asJava();
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(52).append("Source ").append(source.getTableConfig().getTableName()).append(" is ahead by ").append(commitsToCatchup.size()).append(" commits. Commits to catch up - ").append(commitsToCatchup).toString()})), (List)Nil$.MODULE$);
        }
        return seq;
    }

    @Override
    public Procedure build() {
        return new CommitsCompareProcedure();
    }
}

