/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPartitionMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.FileStatus$;
import org.apache.spark.sql.hudi.command.procedures.FileStatusInfo;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowFileStatusProcedure$;
import org.apache.spark.sql.hudi.command.procedures.TimelineType$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001\u0002\u000e\u001c\u0001)BQ\u0001\u0011\u0001\u0005\u0002\u0005Cqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004N\u0001\u0001\u0006I!\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003P\u0011\u0019I\u0006\u0001)A\u0005!\"9!\f\u0001b\u0001\n\u0013Y\u0006B\u00022\u0001A\u0003%A\fC\u0003d\u0001\u0011\u0005C\rC\u0003i\u0001\u0011\u0005s\nC\u0003j\u0001\u0011\u00053\fC\u0003k\u0001\u0011\u00053\u000eC\u0004\u0002\u0004\u0001!I!!\u0002\t\u000f\u0005\u0005\u0003\u0001\"\u0003\u0002D!9\u00111\n\u0001\u0005\n\u00055\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003W\u0002A\u0011BA7\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a \u0001\t\u0013\t\t\tC\u0004\u0002\u000e\u0002!I!a$\b\u000f\u0005e5\u0004#\u0001\u0002\u001c\u001a1!d\u0007E\u0001\u0003;Ca\u0001Q\u000b\u0005\u0002\u0005\u0015\u0006\u0002CAT+\t\u0007I\u0011\u0001#\t\u000f\u0005%V\u0003)A\u0005\u000b\"9\u00111V\u000b\u0005\u0002\u00055&aF*i_^4\u0015\u000e\\3Ti\u0006$Xo\u001d)s_\u000e,G-\u001e:f\u0015\taR$\u0001\u0006qe>\u001cW\rZ;sKNT!AH\u0010\u0002\u000f\r|W.\\1oI*\u0011\u0001%I\u0001\u0005QV$\u0017N\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001aE\u0003\u0001W=\u0012$\b\u0005\u0002-[5\t1$\u0003\u0002/7\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"\u0001\f\u0019\n\u0005EZ\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\t\u0019\u0004(D\u00015\u0015\t)d'A\u0006fqB\u0014Xm]:j_:\u001c(BA\u001c\"\u0003!\u0019\u0017\r^1msN$\u0018BA\u001d5\u0005=\u0001&/\u001a3jG\u0006$X\rS3ma\u0016\u0014\bCA\u001e?\u001b\u0005a$BA\u001f$\u0003!Ig\u000e^3s]\u0006d\u0017BA =\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\"\u0011\u00051\u0002\u0011!\u0004#F\r\u0006+F\nV0W\u00032+V)F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0003mC:<'\"\u0001&\u0002\t)\fg/Y\u0005\u0003\u0019\u001e\u0013aa\u0015;sS:<\u0017A\u0004#F\r\u0006+F\nV0W\u00032+V\tI\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001)\u0011\u0007E#f+D\u0001S\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0005\u0015\t%O]1z!\tas+\u0003\u0002Y7\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011q,I\u0001\u0006if\u0004Xm]\u0005\u0003Cz\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0003\u0015\u0011W/\u001b7e+\u0005)\u0007C\u0001\u0017g\u0013\t97DA\u0005Qe>\u001cW\rZ;sK\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGC\u00017}!\riW\u000f\u001f\b\u0003]Nt!a\u001c:\u000e\u0003AT!!]\u0015\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016B\u0001;S\u0003\u001d\u0001\u0018mY6bO\u0016L!A^<\u0003\u0007M+\u0017O\u0003\u0002u%B\u0011\u0011P_\u0007\u0002C%\u001110\t\u0002\u0004%><\b\"B?\f\u0001\u0004q\u0018\u0001B1sON\u0004\"\u0001L@\n\u0007\u0005\u00051DA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\nSN$U\r\\3uK\u0012$\u0002\"a\u0002\u0002\u0014\u0005%\u0012Q\b\t\u0006#\u0006%\u0011QB\u0005\u0004\u0003\u0017\u0011&AB(qi&|g\u000eE\u0002-\u0003\u001fI1!!\u0005\u001c\u000591\u0015\u000e\\3Ti\u0006$Xo]%oM>Dq!!\u0006\r\u0001\u0004\t9\"\u0001\u0006nKR\f7\t\\5f]R\u0004B!!\u0007\u0002&5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0003uC\ndWM\u0003\u0003\u0002\"\u0005\r\u0012AB2p[6|gN\u0003\u0002!K%!\u0011qEA\u000e\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDq!a\u000b\r\u0001\u0004\ti#A\u0005qCJ$\u0018\u000e^5p]B)\u0011+!\u0003\u00020A!\u0011\u0011GA\u001d\u001d\u0011\t\u0019$!\u000e\u0011\u0005=\u0014\u0016bAA\u001c%\u00061\u0001K]3eK\u001aL1\u0001TA\u001e\u0015\r\t9D\u0015\u0005\b\u0003\u007fa\u0001\u0019AA\u0018\u0003!1\u0017\u000e\\3OC6,\u0017\u0001F2iK\u000e\\'+Z:u_J,W*\u001a;bI\u0006$\u0018\r\u0006\u0005\u0002\b\u0005\u0015\u0013qIA%\u0011\u001d\t)\"\u0004a\u0001\u0003/Aq!a\u000b\u000e\u0001\u0004\ti\u0003C\u0004\u0002@5\u0001\r!a\f\u0002+\rDWmY6S_2d'-Y2l\u001b\u0016$\u0018\rZ1uCRA\u0011qAA(\u0003#\n\u0019\u0006C\u0004\u0002\u00169\u0001\r!a\u0006\t\u000f\u0005-b\u00021\u0001\u0002.!9\u0011q\b\bA\u0002\u0005=\u0012!H2iK\u000e\\'k\u001c7mE\u0006\u001c7.T3uC\u0012\fG/Y%oi\u0016\u0014h.\u00197\u0015\u0011\u0005\u001d\u0011\u0011LA4\u0003SBq!a\u0017\u0010\u0001\u0004\ti&\u0001\u0005uS6,G.\u001b8f!\u0011\ty&a\u0019\u000e\u0005\u0005\u0005$\u0002BA.\u00037IA!!\u001a\u0002b\tq\u0001j\\8eS\u0016$\u0016.\\3mS:,\u0007bBA\u0016\u001f\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u007fy\u0001\u0019AA\u0018\u0003I\u0019\u0007.Z2l\u00072,\u0017M\\'fi\u0006$\u0017\r^1\u0015\u0011\u0005\u001d\u0011qNA9\u0003gBq!!\u0006\u0011\u0001\u0004\t9\u0002C\u0004\u0002,A\u0001\r!!\f\t\u000f\u0005}\u0002\u00031\u0001\u00020\u0005Q2\r[3dW\u000ecW-\u00198NKR\fG-\u0019;b\u0013:$XM\u001d8bYRA\u0011qAA=\u0003w\ni\bC\u0004\u0002\\E\u0001\r!!\u0018\t\u000f\u0005-\u0012\u00031\u0001\u0002.!9\u0011qH\tA\u0002\u0005=\u0012!C4fiJ+7/\u001e7u)!\t9!a!\u0002\u0006\u0006%\u0005bBA.%\u0001\u0007\u0011Q\f\u0005\b\u0003\u000f\u0013\u0002\u0019AA\u0018\u0003\u0019\t7\r^5p]\"9\u00111\u0012\nA\u0002\u0005=\u0012!\u0003;j[\u0016\u001cH/Y7q\u0003e\u0011X\r\\8bIRKW.\u001a7j]\u0016LeMT3dKN\u001c\u0018M]=\u0015\t\u0005E\u0015q\u0013\t\u0004#\u0006M\u0015bAAK%\n!QK\\5u\u0011\u001d\tYf\u0005a\u0001\u0003;\nqc\u00155po\u001aKG.Z*uCR,8\u000f\u0015:pG\u0016$WO]3\u0011\u00051*2cA\u000b\u0002 B\u0019\u0011+!)\n\u0007\u0005\r&K\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u00037\u000bAAT!N\u000b\u0006)a*Q'FA\u00059!-^5mI\u0016\u0014XCAAX!\u0015\t\t,a/0\u001b\t\t\u0019L\u0003\u0003\u00026\u0006]\u0016\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\u0007\u0005e\u0016*\u0001\u0003vi&d\u0017\u0002BA_\u0003g\u0013\u0001bU;qa2LWM\u001d")
public class ShowFileStatusProcedure
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper {
    private final String DEFAULT_VALUE;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowFileStatusProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowFileStatusProcedure$.MODULE$.NAME();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String DEFAULT_VALUE() {
        return this.DEFAULT_VALUE;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public Procedure build() {
        return new ShowFileStatusProcedure();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> tableName = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        Option<Object> partition = this.getArgValueOrDefault(args2, this.PARAMETERS()[1]);
        Option<Object> fileName = this.getArgValueOrDefault(args2, this.PARAMETERS()[2]);
        String basePath = this.getBasePath(tableName, (Option<Object>)Option$.MODULE$.empty());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        SparkRDDWriteClient<?> client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.spark(), basePath, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), tableName);
        HoodieSparkTable table = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
        if (partition.isEmpty() && table.isPartitioned()) {
            throw new HoodieException(new StringBuilder(99).append("table ").append(tableName).append(" is a partitioned table. Please specify the partition name where the current file is located.").toString());
        }
        Option<FileStatusInfo> fileStatus = this.isDeleted(metaClient, partition, (String)fileName.get());
        if (fileStatus.isDefined()) {
            FileStatusInfo res = (FileStatusInfo)fileStatus.get();
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{res.status(), res.action(), res.instant(), res.timeline(), res.fullPath()})), (List)Nil$.MODULE$);
        } else {
            FileSystem fs = new Path(basePath).getFileSystem(this.spark().sessionState().newHadoopConf());
            Path path = null;
            path = partition.nonEmpty() ? new Path(basePath, (String)partition.get()) : new Path(basePath);
            seq = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(path))).toList().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$call$1(fileName, f))).map((Function1 & Serializable & scala.Serializable)f -> (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FileStatus$.MODULE$.EXIST().toString(), this.DEFAULT_VALUE(), this.DEFAULT_VALUE(), TimelineType$.MODULE$.ACTIVE().toString(), f.getPath().toUri().getPath()})), (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{FileStatus$.MODULE$.UNKNOWN().toString(), this.DEFAULT_VALUE(), this.DEFAULT_VALUE(), this.DEFAULT_VALUE(), this.DEFAULT_VALUE()})), (List)Nil$.MODULE$));
        }
        return seq;
    }

    private Option<FileStatusInfo> isDeleted(HoodieTableMetaClient metaClient, Option<String> partition, String fileName) {
        return this.checkCleanMetadata(metaClient, partition, fileName).orElse((Function0 & Serializable & scala.Serializable)() -> this.checkRollbackMetadata(metaClient, partition, fileName).orElse((Function0 & Serializable & scala.Serializable)() -> this.checkRestoreMetadata(metaClient, partition, fileName)));
    }

    private Option<FileStatusInfo> checkRestoreMetadata(HoodieTableMetaClient metaClient, Option<String> partition, String fileName) {
        Buffer restoreInstant2 = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(metaClient.reloadActiveTimeline().getRestoreTimeline().filterCompletedInstants().getReverseOrderedInstants().collect(Collectors.toList())).asScala();
        return restoreInstant2.find((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRestoreMetadata$1(metaClient, partition, fileName, instant))).map((Function1 & Serializable & scala.Serializable)restoreInstant -> new FileStatusInfo(FileStatus$.MODULE$.DELETED().toString(), "restore", restoreInstant.requestedTime(), TimelineType$.MODULE$.ACTIVE().toString(), this.DEFAULT_VALUE()));
    }

    private Option<FileStatusInfo> checkRollbackMetadata(HoodieTableMetaClient metaClient, Option<String> partition, String fileName) {
        return this.checkRollbackMetadataInternal(metaClient.getActiveTimeline(), partition, fileName).orElse((Function0 & Serializable & scala.Serializable)() -> this.checkRollbackMetadataInternal(metaClient.getArchivedTimeline(), partition, fileName));
    }

    private Option<FileStatusInfo> checkRollbackMetadataInternal(HoodieTimeline timeline, Option<String> partition, String fileName) {
        Buffer rollbackInstant = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(timeline.getRollbackTimeline().filterCompletedInstants().getReverseOrderedInstants().collect(Collectors.toList())).asScala();
        this.reloadTimelineIfNecessary(timeline);
        return rollbackInstant.find((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRollbackMetadataInternal$1(timeline, partition, fileName, instant))).map((Function1 & Serializable & scala.Serializable)instant -> (FileStatusInfo)this.getResult(timeline, "rollback", instant.requestedTime()).get());
    }

    private Option<FileStatusInfo> checkCleanMetadata(HoodieTableMetaClient metaClient, Option<String> partition, String fileName) {
        return this.checkCleanMetadataInternal(metaClient.getActiveTimeline(), partition, fileName).orElse((Function0 & Serializable & scala.Serializable)() -> this.checkCleanMetadataInternal(metaClient.getArchivedTimeline(), partition, fileName));
    }

    private Option<FileStatusInfo> checkCleanMetadataInternal(HoodieTimeline timeline, Option<String> partition, String fileName) {
        Buffer cleanedInstant = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(timeline.getCleanerTimeline().filterCompletedInstants().getReverseOrderedInstants().collect(Collectors.toList())).asScala();
        this.reloadTimelineIfNecessary(timeline);
        return cleanedInstant.find((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkCleanMetadataInternal$1(timeline, partition, fileName, instant))).map((Function1 & Serializable & scala.Serializable)instant -> (FileStatusInfo)this.getResult(timeline, "clean", instant.requestedTime()).get());
    }

    private Option<FileStatusInfo> getResult(HoodieTimeline timeline, String action, String timestamp) {
        Option option;
        HoodieTimeline hoodieTimeline = timeline;
        if (hoodieTimeline instanceof HoodieActiveTimeline) {
            option = Option$.MODULE$.apply((Object)new FileStatusInfo(FileStatus$.MODULE$.DELETED().toString(), action, timestamp, TimelineType$.MODULE$.ACTIVE().toString(), this.DEFAULT_VALUE()));
        } else if (hoodieTimeline instanceof HoodieArchivedTimeline) {
            option = Option$.MODULE$.apply((Object)new FileStatusInfo(FileStatus$.MODULE$.DELETED().toString(), action, timestamp, TimelineType$.MODULE$.ARCHIVED().toString(), this.DEFAULT_VALUE()));
        } else {
            throw new HoodieException(new StringBuilder(27).append("Unsupported timeline type: ").append(timeline.getClass()).toString());
        }
        return option;
    }

    private void reloadTimelineIfNecessary(HoodieTimeline timeline) {
        HoodieTimeline hoodieTimeline = timeline;
        if (hoodieTimeline instanceof HoodieArchivedTimeline) {
            HoodieArchivedTimeline archivalTimeline = (HoodieArchivedTimeline)timeline;
            archivalTimeline.loadCompletedInstantDetailsInMemory();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$call$1(Option fileName$1, FileStatus f) {
        return f.getPath().getName().equals(fileName$1.get());
    }

    public static final /* synthetic */ boolean $anonfun$checkRestoreMetadata$7(String fileName$3, HoodieRollbackPartitionMetadata x$3) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$3.getSuccessDeleteFiles()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains(fileName$3)));
    }

    public static final /* synthetic */ boolean $anonfun$checkRestoreMetadata$3(Option partition$2, String fileName$3, HoodieRollbackMetadata rollbackMetadata) {
        Map<String, HoodieRollbackPartitionMetadata> partitionRollbackMetadata = rollbackMetadata.getPartitionMetadata();
        return partition$2.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.apply(partitionRollbackMetadata.get(p)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$1.getSuccessDeleteFiles()).asScala()).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(fileName$3))))).isDefined() || ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(partitionRollbackMetadata.values().iterator()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRestoreMetadata$7(fileName$3, x$3)));
    }

    public static final /* synthetic */ boolean $anonfun$checkRestoreMetadata$2(Option partition$2, String fileName$3, java.util.List metadata) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata).asScala()).exists((Function1 & Serializable & scala.Serializable)rollbackMetadata -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRestoreMetadata$3(partition$2, fileName$3, rollbackMetadata)));
    }

    public static final /* synthetic */ boolean $anonfun$checkRestoreMetadata$1(HoodieTableMetaClient metaClient$2, Option partition$2, String fileName$3, HoodieInstant instant) {
        HoodieRestoreMetadata hoodieRestoreMetadata = metaClient$2.getActiveTimeline().readRestoreMetadata(instant);
        Iterable restoreMetadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(hoodieRestoreMetadata.getHoodieRestoreMetadata().values()).asScala();
        return restoreMetadata.exists((Function1 & Serializable & scala.Serializable)metadata -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRestoreMetadata$2(partition$2, fileName$3, metadata)));
    }

    public static final /* synthetic */ boolean $anonfun$checkRollbackMetadataInternal$5(String fileName$5, HoodieRollbackPartitionMetadata x$7) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$7.getSuccessDeleteFiles()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.contains(fileName$5)));
    }

    public static final /* synthetic */ boolean $anonfun$checkRollbackMetadataInternal$1(HoodieTimeline timeline$1, Option partition$4, String fileName$5, HoodieInstant instant) {
        HoodieRollbackMetadata rollbackMetadata = timeline$1.readRollbackMetadata(instant);
        Map<String, HoodieRollbackPartitionMetadata> partitionRollbackMetadata = rollbackMetadata.getPartitionMetadata();
        return partition$4.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.apply(partitionRollbackMetadata.get(p)).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$5.getSuccessDeleteFiles()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.contains(fileName$5))))).isDefined() || ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(partitionRollbackMetadata.values().iterator()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkRollbackMetadataInternal$5(fileName$5, x$7)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCleanMetadataInternal$5(String fileName$7, HoodieCleanPartitionMetadata x$11) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$11.getSuccessDeleteFiles()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.contains(fileName$7)));
    }

    public static final /* synthetic */ boolean $anonfun$checkCleanMetadataInternal$1(HoodieTimeline timeline$2, Option partition$6, String fileName$7, HoodieInstant instant) {
        HoodieCleanMetadata cleanMetadata = timeline$2.readCleanMetadata(instant);
        Map<String, HoodieCleanPartitionMetadata> partitionCleanMetadata = cleanMetadata.getPartitionMetadata();
        return partition$6.flatMap((Function1 & Serializable & scala.Serializable)p -> Option$.MODULE$.apply(partitionCleanMetadata.get(p)).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(x$9.getSuccessDeleteFiles()).asScala()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.contains(fileName$7))))).isDefined() || ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(partitionCleanMetadata.values().iterator()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ShowFileStatusProcedure.$anonfun$checkCleanMetadataInternal$5(fileName$7, x$11)));
    }

    public ShowFileStatusProcedure() {
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.DEFAULT_VALUE = "";
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "partition", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.required(2, "file", DataTypes.StringType)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("status", DataTypes.StringType, false, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("timeline", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("full_path", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

