/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.vectorized;

import java.util.function.UnaryOperator;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public class ColumnarBatchUtils {
    public static UnaryOperator<ColumnarBatch> generateProjection(StructType from, StructType to) {
        if (from.length() < to.length()) {
            throw new IllegalStateException(from + " has less columns than " + to);
        }
        if (from.equals((Object)to)) {
            return UnaryOperator.identity();
        }
        int[] projection = new int[to.size()];
        for (int i = 0; i < to.length(); ++i) {
            projection[i] = from.fieldIndex(to.fields()[i].name());
        }
        return columnarBatch -> {
            ColumnVector[] vectors = new ColumnVector[projection.length];
            for (int i = 0; i < projection.length; ++i) {
                vectors[i] = columnarBatch.column(projection[i]);
            }
            ColumnarBatch b = new ColumnarBatch(vectors);
            b.setNumRows(columnarBatch.numRows());
            return b;
        };
    }
}

