/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.TimeZone;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.spark.sql.avro.AvroDeserializer$;
import org.apache.spark.sql.avro.AvroDeserializer$RebaseSpec$;
import org.apache.spark.sql.avro.AvroUtils;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.NoopFilters;
import org.apache.spark.sql.catalyst.StructFilters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011Uc!\u0002.\\\u0001u+\u0007\u0002\u00037\u0001\u0005\u0003\u0005\u000b\u0011\u00028\t\u0011M\u0004!\u0011!Q\u0001\nQD\u0001B\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001f\u0005\t}\u0002\u0011\t\u0011)A\u0005\u007f\"Q!1\f\u0001\u0003\u0002\u0003\u0006IA!\u0018\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0003j!9\u0011Q\u0005\u0001\u0005\u0002\t]\u0004B\u0003BA\u0001!\u0015\r\u0011\"\u0003\u0003\u0004\"I!q\u0013\u0001C\u0002\u0013%!\u0011\u0014\u0005\t\u00057\u0003\u0001\u0015!\u0003\u0003<!I!Q\u0014\u0001C\u0002\u0013%!q\u0014\u0005\t\u0005C\u0003\u0001\u0015!\u0003\u0003N!I!1\u0015\u0001C\u0002\u0013%!Q\u0015\u0005\t\u0005W\u0003\u0001\u0015!\u0003\u0003(\"9!Q\u0016\u0001\u0005\u0002\t=\u0006b\u0002B[\u0001\u0011%!q\u0017\u0005\b\t\u0007\u0001A\u0011\u0002C\u0003\u0011\u001d!y\u0002\u0001C\u0005\tCAq\u0001\"\u0013\u0001\t\u0013!YEB\u0005\u0003D\u0002\u0001\n1!\t\u0003F\"9!q\u0019\u000b\u0005\u0002\t%\u0007b\u0002Bi)\u0019\u0005!1\u001b\u0005\b\u0005;$B\u0011\u0001Bp\u0011\u001d\u0011\u0019\u000f\u0006C\u0001\u0005KDqAa;\u0015\t\u0003\u0011i\u000fC\u0004\u0003zR!\tAa?\t\u000f\r\u001dA\u0003\"\u0001\u0004\n!91q\u0002\u000b\u0005\u0002\rE\u0001bBB\f)\u0011\u00051\u0011\u0004\u0005\b\u0007K!B\u0011AB\u0014\u0011\u001d\u0019\u0019\u0004\u0006C\u0001\u0007k1aa!&\u0001\u0005\r]\u0005BCBMA\t\u0005\t\u0015!\u0003\u0004\u001c\"9\u0011Q\u0005\u0011\u0005\u0002\r\u0005\u0006b\u0002BiA\u0011\u00053q\u0015\u0005\b\u0005;\u0004C\u0011IBW\u0011\u001d\u0011\u0019\u000f\tC!\u0007cCqAa;!\t\u0003\u001a9\fC\u0004\u0003z\u0002\"\te!0\t\u000f\r\u001d\u0001\u0005\"\u0011\u0004D\"91q\u0002\u0011\u0005B\r%\u0007bBB\fA\u0011\u00053q\u001a\u0005\b\u0007K\u0001C\u0011IBk\u0011\u001d\u0019\u0019\u0004\tC!\u000774aaa\u0011\u0001\u0005\r\u0015\u0003BCB$[\t\u0005\t\u0015!\u0003\u0004J!9\u0011QE\u0017\u0005\u0002\rU\u0003b\u0002Bi[\u0011\u000531\f\u0005\b\u0005;lC\u0011IB1\u0011\u001d\u0011\u0019/\fC!\u0007KBqAa;.\t\u0003\u001aY\u0007C\u0004\u0003z6\"\te!\u001d\t\u000f\r\u001dQ\u0006\"\u0011\u0004x!91qB\u0017\u0005B\ru\u0004bBB\f[\u0011\u000531\u0011\u0005\b\u0007KiC\u0011IBE\u0011\u001d\u0019\u0019$\fC!\u0007\u001f;q!!\b\\\u0011\u0003\tyB\u0002\u0004[7\"\u0005\u00111\u0005\u0005\b\u0003KYD\u0011AA\u0014\r\u0019\tIc\u000f!\u0002,!Q\u0011\u0011H\u001f\u0003\u0016\u0004%\t!a\u000f\t\u0015\u0005uSH!E!\u0002\u0013\ti\u0004\u0003\u0006\u0002`u\u0012)\u001a!C\u0001\u0003CB!\"!\u001f>\u0005#\u0005\u000b\u0011BA2\u0011\u001d\t)#\u0010C\u0001\u0003wBq!!\">\t\u0003\t9\tC\u0005\u0002\nv\n\t\u0011\"\u0001\u0002\f\"I\u0011\u0011S\u001f\u0012\u0002\u0013\u0005\u00111\u0013\u0005\n\u0003Sk\u0014\u0013!C\u0001\u0003WC\u0011\"a,>\u0003\u0003%\t%!-\t\u0013\u0005\u0005W(!A\u0005\u0002\u0005\r\u0007\"CAf{\u0005\u0005I\u0011AAg\u0011%\tI.PA\u0001\n\u0003\nY\u000eC\u0005\u0002jv\n\t\u0011\"\u0001\u0002l\"I\u0011q^\u001f\u0002\u0002\u0013\u0005\u0013\u0011\u001f\u0005\n\u0003gl\u0014\u0011!C!\u0003kD\u0011\"a>>\u0003\u0003%\t%!?\b\u0013\u0005u8(!A\t\u0002\u0005}h!CA\u0015w\u0005\u0005\t\u0012\u0001B\u0001\u0011\u001d\t)\u0003\u0015C\u0001\u0005\u001fA\u0011\"a=Q\u0003\u0003%)%!>\t\u0013\tE\u0001+!A\u0005\u0002\nM\u0001\"\u0003B\r!F\u0005I\u0011AAV\u0011%\u0011Y\u0002UA\u0001\n\u0003\u0013i\u0002C\u0005\u0003,A\u000b\n\u0011\"\u0001\u0002,\"I!Q\u0006)\u0002\u0002\u0013%!q\u0006\u0005\b\u0005oYD\u0011\u0001B\u001d\u0011\u001d\u0011Ie\u000fC\u0001\u0005\u0017\u0012\u0001#\u0011<s_\u0012+7/\u001a:jC2L'0\u001a:\u000b\u0005qk\u0016\u0001B1we>T!AX0\u0002\u0007M\fHN\u0003\u0002aC\u0006)1\u000f]1sW*\u0011!mY\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\f1a\u001c:h'\t\u0001a\r\u0005\u0002hU6\t\u0001NC\u0001j\u0003\u0015\u00198-\u00197b\u0013\tY\u0007N\u0001\u0004B]f\u0014VMZ\u0001\re>|G/\u0011<s_RK\b/Z\u0002\u0001!\ty\u0017/D\u0001q\u0015\ta\u0016-\u0003\u0002sa\n11k\u00195f[\u0006\f\u0001C]8pi\u000e\u000bG/\u00197zgR$\u0016\u0010]3\u0011\u0005UDX\"\u0001<\u000b\u0005]l\u0016!\u0002;za\u0016\u001c\u0018BA=w\u0005!!\u0015\r^1UsB,\u0017\u0001\u00069pg&$\u0018n\u001c8bY\u001aKW\r\u001c3NCR\u001c\u0007\u000e\u0005\u0002hy&\u0011Q\u0010\u001b\u0002\b\u0005>|G.Z1o\u0003I!\u0017\r^3uS6,'+\u001a2bg\u0016\u001c\u0006/Z2\u0011\u0007\u0005\u0005QHD\u0002\u0002\u0004irA!!\u0002\u0002\u001c9!\u0011qAA\r\u001d\u0011\tI!a\u0006\u000f\t\u0005-\u0011Q\u0003\b\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C7\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0017B\u00012d\u0013\t\u0001\u0017-\u0003\u0002_?&\u0011A,X\u0001\u0011\u0003Z\u0014x\u000eR3tKJL\u0017\r\\5{KJ\u00042!!\t<\u001b\u0005Y6CA\u001eg\u0003\u0019a\u0014N\\5u}Q\u0011\u0011q\u0004\u0002\u000b%\u0016\u0014\u0017m]3Ta\u0016\u001c7CB\u001fg\u0003[\t\u0019\u0004E\u0002h\u0003_I1!!\ri\u0005\u001d\u0001&o\u001c3vGR\u00042aZA\u001b\u0013\r\t9\u0004\u001b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005[>$W-\u0006\u0002\u0002>A!\u0011qHA+\u001d\u0011\t\t%a\u0014\u000f\t\u0005\r\u0013\u0011\n\b\u0005\u0003\u000b\t)%C\u0002\u0002Hu\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0003\u0017\ni%A\u0004T#2\u001buN\u001c4\u000b\u0007\u0005\u001dS,\u0003\u0003\u0002R\u0005M\u0013\u0001\u0006'fO\u0006\u001c\u0017PQ3iCZLwN\u001d)pY&\u001c\u0017P\u0003\u0003\u0002L\u00055\u0013\u0002BA,\u00033\u0012QAV1mk\u0016L1!a\u0017i\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u000b5|G-\u001a\u0011\u0002\u001d=\u0014\u0018nZ5o)&lWMW8oKV\u0011\u00111\r\t\u0006O\u0006\u0015\u0014\u0011N\u0005\u0004\u0003OB'AB(qi&|g\u000e\u0005\u0003\u0002l\u0005Md\u0002BA7\u0003_\u00022!!\u0004i\u0013\r\t\t\b[\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0014q\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0004.A\bpe&<\u0017N\u001c+j[\u0016TvN\\3!)\u0019\ti(!!\u0002\u0004B\u0019\u0011qP\u001f\u000e\u0003mBq!!\u000fC\u0001\u0004\ti\u0004C\u0005\u0002`\t\u0003\n\u00111\u0001\u0002d\u0005AA/[7f5>tW-\u0006\u0002\u0002j\u0005!1m\u001c9z)\u0019\ti(!$\u0002\u0010\"I\u0011\u0011\b#\u0011\u0002\u0003\u0007\u0011Q\b\u0005\n\u0003?\"\u0005\u0013!a\u0001\u0003G\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0016*\"\u0011QHALW\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u0013Ut7\r[3dW\u0016$'bAARQ\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0016Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003[SC!a\u0019\u0002\u0018\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!a-\u0011\t\u0005U\u0016qX\u0007\u0003\u0003oSA!!/\u0002<\u0006!A.\u00198h\u0015\t\ti,\u0001\u0003kCZ\f\u0017\u0002BA;\u0003o\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!2\u0011\u0007\u001d\f9-C\u0002\u0002J\"\u00141!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a4\u0002VB\u0019q-!5\n\u0007\u0005M\u0007NA\u0002B]fD\u0011\"a6J\u0003\u0003\u0005\r!!2\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ti\u000e\u0005\u0004\u0002`\u0006\u0015\u0018qZ\u0007\u0003\u0003CT1!a9i\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003O\f\tO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dGcA>\u0002n\"I\u0011q[&\u0002\u0002\u0003\u0007\u0011qZ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011QY\u0001\ti>\u001cFO]5oOR\u0011\u00111W\u0001\u0007KF,\u0018\r\\:\u0015\u0007m\fY\u0010C\u0005\u0002X:\u000b\t\u00111\u0001\u0002P\u0006Q!+\u001a2bg\u0016\u001c\u0006/Z2\u0011\u0007\u0005}\u0004kE\u0003Q\u0005\u0007\t\u0019\u0004\u0005\u0006\u0003\u0006\t-\u0011QHA2\u0003{j!Aa\u0002\u000b\u0007\t%\u0001.A\u0004sk:$\u0018.\\3\n\t\t5!q\u0001\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA\u0000\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tiH!\u0006\u0003\u0018!9\u0011\u0011H*A\u0002\u0005u\u0002\"CA0'B\u0005\t\u0019AA2\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005?\u00119\u0003E\u0003h\u0003K\u0012\t\u0003E\u0004h\u0005G\ti$a\u0019\n\u0007\t\u0015\u0002N\u0001\u0004UkBdWM\r\u0005\n\u0005S)\u0016\u0011!a\u0001\u0003{\n1\u0001\u001f\u00131\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0004\u0005\u0003\u00026\nM\u0012\u0002\u0002B\u001b\u0003o\u0013aa\u00142kK\u000e$\u0018AG2sK\u0006$X\rR1uKJ+'-Y:f\rVt7-\u00138SK\u0006$GC\u0002B\u001e\u0005\u0003\u0012)\u0005E\u0004h\u0005{\t)-!2\n\u0007\t}\u0002NA\u0005Gk:\u001cG/[8oc!9!1\t-A\u0002\u0005u\u0012A\u0003:fE\u0006\u001cX-T8eK\"9!q\t-A\u0002\u0005%\u0014A\u00024pe6\fG/A\u0010de\u0016\fG/\u001a+j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001c\u0017J\u001c*fC\u0012$bA!\u0014\u0003V\te\u0003cB4\u0003>\t=#q\n\t\u0004O\nE\u0013b\u0001B*Q\n!Aj\u001c8h\u0011\u001d\u00119&\u0017a\u0001\u0003{\n!B]3cCN,7\u000b]3d\u0011\u001d\u00119%\u0017a\u0001\u0003S\nqAZ5mi\u0016\u00148\u000f\u0005\u0003\u0003`\t\u0015TB\u0001B1\u0015\r\u0011\u0019'X\u0001\tG\u0006$\u0018\r\\=ti&!!q\rB1\u00055\u0019FO];di\u001aKG\u000e^3sgRa!1\u000eB7\u0005_\u0012\tHa\u001d\u0003vA\u0019\u0011\u0011\u0005\u0001\t\u000b14\u0001\u0019\u00018\t\u000bM4\u0001\u0019\u0001;\t\u000bi4\u0001\u0019A>\t\u000by4\u0001\u0019A@\t\u000f\tmc\u00011\u0001\u0003^QA!1\u000eB=\u0005w\u0012i\bC\u0003m\u000f\u0001\u0007a\u000eC\u0003t\u000f\u0001\u0007A\u000fC\u0004\u0003\u0000\u001d\u0001\r!!\u001b\u0002%\u0011\fG/\u001a;j[\u0016\u0014VMY1tK6{G-Z\u0001\u0013I\u0016\u001c\u0017.\\1m\u0007>tg/\u001a:tS>t7/\u0006\u0002\u0003\u0006B!!q\u0011BI\u001d\u0011\u0011II!$\u000f\t\u0005%!1R\u0005\u00039\u0006L1Aa$q\u0003-\u0019uN\u001c<feNLwN\\:\n\t\tM%Q\u0013\u0002\u0012\t\u0016\u001c\u0017.\\1m\u0007>tg/\u001a:tS>t'b\u0001BHa\u0006qA-\u0019;f%\u0016\u0014\u0017m]3Gk:\u001cWC\u0001B\u001e\u0003=!\u0017\r^3SK\n\f7/\u001a$v]\u000e\u0004\u0013a\u0005;j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001cWC\u0001B'\u0003Q!\u0018.\\3ti\u0006l\u0007OU3cCN,g)\u001e8dA\u0005I1m\u001c8wKJ$XM]\u000b\u0003\u0005O\u0003ra\u001aB\u001f\u0003\u001f\u0014I\u000bE\u0003h\u0003K\ny-\u0001\u0006d_:4XM\u001d;fe\u0002\n1\u0002Z3tKJL\u0017\r\\5{KR!!\u0011\u0016BY\u0011\u001d\u0011\u0019l\u0004a\u0001\u0003\u001f\fA\u0001Z1uC\u0006Ia.Z<Xe&$XM\u001d\u000b\u000b\u0005s\u001b\to!:\u0004j\u000e}\bcC4\u0003<\n}\u0016QYAh\u0005\u0017L1A!0i\u0005%1UO\\2uS>t7\u0007E\u0002\u0003BRi\u0011\u0001\u0001\u0002\u0014\u0007\u0006$\u0018\r\\=ti\u0012\u000bG/Y+qI\u0006$XM]\n\u0003)\u0019\fa\u0001J5oSR$CC\u0001Bf!\r9'QZ\u0005\u0004\u0005\u001fD'\u0001B+oSR\f1a]3u)\u0019\u0011YM!6\u0003Z\"9!q\u001b\fA\u0002\u0005\u0015\u0017aB8sI&t\u0017\r\u001c\u0005\b\u000574\u0002\u0019AAh\u0003\u00151\u0018\r\\;f\u0003%\u0019X\r\u001e(vY2\fE\u000f\u0006\u0003\u0003L\n\u0005\bb\u0002Bl/\u0001\u0007\u0011QY\u0001\u000bg\u0016$(i\\8mK\u0006tGC\u0002Bf\u0005O\u0014I\u000fC\u0004\u0003Xb\u0001\r!!2\t\r\tm\u0007\u00041\u0001|\u0003\u001d\u0019X\r\u001e\"zi\u0016$bAa3\u0003p\nE\bb\u0002Bl3\u0001\u0007\u0011Q\u0019\u0005\b\u00057L\u0002\u0019\u0001Bz!\r9'Q_\u0005\u0004\u0005oD'\u0001\u0002\"zi\u0016\f\u0001b]3u'\"|'\u000f\u001e\u000b\u0007\u0005\u0017\u0014iPa@\t\u000f\t]'\u00041\u0001\u0002F\"9!1\u001c\u000eA\u0002\r\u0005\u0001cA4\u0004\u0004%\u00191Q\u00015\u0003\u000bMCwN\u001d;\u0002\rM,G/\u00138u)\u0019\u0011Yma\u0003\u0004\u000e!9!q[\u000eA\u0002\u0005\u0015\u0007b\u0002Bn7\u0001\u0007\u0011QY\u0001\bg\u0016$Hj\u001c8h)\u0019\u0011Yma\u0005\u0004\u0016!9!q\u001b\u000fA\u0002\u0005\u0015\u0007b\u0002Bn9\u0001\u0007!qJ\u0001\ng\u0016$Hi\\;cY\u0016$bAa3\u0004\u001c\ru\u0001b\u0002Bl;\u0001\u0007\u0011Q\u0019\u0005\b\u00057l\u0002\u0019AB\u0010!\r97\u0011E\u0005\u0004\u0007GA'A\u0002#pk\ndW-\u0001\u0005tKR4En\\1u)\u0019\u0011Ym!\u000b\u0004,!9!q\u001b\u0010A\u0002\u0005\u0015\u0007b\u0002Bn=\u0001\u00071Q\u0006\t\u0004O\u000e=\u0012bAB\u0019Q\n)a\t\\8bi\u0006Q1/\u001a;EK\u000eLW.\u00197\u0015\r\t-7qGB\u001d\u0011\u001d\u00119n\ba\u0001\u0003\u000bDqAa7 \u0001\u0004\u0019Y\u0004E\u0002v\u0007{I1aa\u0010w\u0005\u001d!UmY5nC2L3\u0001F\u0017!\u0005A\t%O]1z\t\u0006$\u0018-\u00169eCR,'o\u0005\u0003.M\n}\u0016!B1se\u0006L\b\u0003BB&\u0007#j!a!\u0014\u000b\t\r=#\u0011M\u0001\u0005kRLG.\u0003\u0003\u0004T\r5#!C!se\u0006LH)\u0019;b)\u0011\u00199f!\u0017\u0011\u0007\t\u0005W\u0006C\u0004\u0004H=\u0002\ra!\u0013\u0015\r\t-7QLB0\u0011\u001d\u00119\u000e\ra\u0001\u0003\u000bDqAa71\u0001\u0004\ty\r\u0006\u0003\u0003L\u000e\r\u0004b\u0002Blc\u0001\u0007\u0011Q\u0019\u000b\u0007\u0005\u0017\u001c9g!\u001b\t\u000f\t]'\u00071\u0001\u0002F\"1!1\u001c\u001aA\u0002m$bAa3\u0004n\r=\u0004b\u0002Blg\u0001\u0007\u0011Q\u0019\u0005\b\u00057\u001c\u0004\u0019\u0001Bz)\u0019\u0011Yma\u001d\u0004v!9!q\u001b\u001bA\u0002\u0005\u0015\u0007b\u0002Bni\u0001\u00071\u0011\u0001\u000b\u0007\u0005\u0017\u001cIha\u001f\t\u000f\t]W\u00071\u0001\u0002F\"9!1\\\u001bA\u0002\u0005\u0015GC\u0002Bf\u0007\u007f\u001a\t\tC\u0004\u0003XZ\u0002\r!!2\t\u000f\tmg\u00071\u0001\u0003PQ1!1ZBC\u0007\u000fCqAa68\u0001\u0004\t)\rC\u0004\u0003\\^\u0002\raa\b\u0015\r\t-71RBG\u0011\u001d\u00119\u000e\u000fa\u0001\u0003\u000bDqAa79\u0001\u0004\u0019i\u0003\u0006\u0004\u0003L\u000eE51\u0013\u0005\b\u0005/L\u0004\u0019AAc\u0011\u001d\u0011Y.\u000fa\u0001\u0007w\u0011!BU8x+B$\u0017\r^3s'\u0011\u0001cMa0\u0002\u0007I|w\u000f\u0005\u0003\u0003`\ru\u0015\u0002BBP\u0005C\u00121\"\u00138uKJt\u0017\r\u001c*poR!11UBS!\r\u0011\t\r\t\u0005\b\u00073\u0013\u0003\u0019ABN)\u0019\u0011Ym!+\u0004,\"9!q[\u0012A\u0002\u0005\u0015\u0007b\u0002BnG\u0001\u0007\u0011q\u001a\u000b\u0005\u0005\u0017\u001cy\u000bC\u0004\u0003X\u0012\u0002\r!!2\u0015\r\t-71WB[\u0011\u001d\u00119.\na\u0001\u0003\u000bDaAa7&\u0001\u0004YHC\u0002Bf\u0007s\u001bY\fC\u0004\u0003X\u001a\u0002\r!!2\t\u000f\tmg\u00051\u0001\u0003tR1!1ZB`\u0007\u0003DqAa6(\u0001\u0004\t)\rC\u0004\u0003\\\u001e\u0002\ra!\u0001\u0015\r\t-7QYBd\u0011\u001d\u00119\u000e\u000ba\u0001\u0003\u000bDqAa7)\u0001\u0004\t)\r\u0006\u0004\u0003L\u000e-7Q\u001a\u0005\b\u0005/L\u0003\u0019AAc\u0011\u001d\u0011Y.\u000ba\u0001\u0005\u001f\"bAa3\u0004R\u000eM\u0007b\u0002BlU\u0001\u0007\u0011Q\u0019\u0005\b\u00057T\u0003\u0019AB\u0010)\u0019\u0011Yma6\u0004Z\"9!q[\u0016A\u0002\u0005\u0015\u0007b\u0002BnW\u0001\u00071Q\u0006\u000b\u0007\u0005\u0017\u001cina8\t\u000f\t]G\u00061\u0001\u0002F\"9!1\u001c\u0017A\u0002\rm\u0002BBBr!\u0001\u0007a.\u0001\u0005bmJ|G+\u001f9f\u0011\u0019\u00199\u000f\u0005a\u0001i\u0006a1-\u0019;bYf\u001cH\u000fV=qK\"911\u001e\tA\u0002\r5\u0018\u0001C1we>\u0004\u0016\r\u001e5\u0011\r\r=8\u0011`A5\u001d\u0011\u0019\tp!>\u000f\t\u0005511_\u0005\u0002S&\u00191q\u001f5\u0002\u000fA\f7m[1hK&!11`B\u007f\u0005\r\u0019V-\u001d\u0006\u0004\u0007oD\u0007b\u0002C\u0001!\u0001\u00071Q^\u0001\rG\u0006$\u0018\r\\=tiB\u000bG\u000f[\u0001\u000eGJ,\u0017\r^3EK\u000eLW.\u00197\u0015\u0011\rmBq\u0001C\f\t7Aq\u0001\"\u0003\u0012\u0001\u0004!Y!A\u0004eK\u000eLW.\u00197\u0011\t\u00115A1C\u0007\u0003\t\u001fQA\u0001\"\u0005\u0002<\u0006!Q.\u0019;i\u0013\u0011!)\u0002b\u0004\u0003\u0015\tKw\rR3dS6\fG\u000eC\u0004\u0005\u001aE\u0001\r!!2\u0002\u0013A\u0014XmY5tS>t\u0007b\u0002C\u000f#\u0001\u0007\u0011QY\u0001\u0006g\u000e\fG.Z\u0001\u0010O\u0016$(+Z2pe\u0012<&/\u001b;feRaA1\u0005C\u001b\to!y\u0004\"\u0011\u0005DAAq\r\"\n\u0003@\u0012%20C\u0002\u0005(!\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\t\u0011-B\u0011G\u0007\u0003\t[Q1\u0001b\fq\u0003\u001d9WM\\3sS\u000eLA\u0001b\r\u0005.\tiq)\u001a8fe&\u001c'+Z2pe\u0012Daaa9\u0013\u0001\u0004q\u0007bBBt%\u0001\u0007A\u0011\b\t\u0004k\u0012m\u0012b\u0001C\u001fm\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\r-(\u00031\u0001\u0004n\"9A\u0011\u0001\nA\u0002\r5\bb\u0002C#%\u0001\u0007AqI\u0001\rCB\u0004H.\u001f$jYR,'o\u001d\t\u0007O\nu\u0012QY>\u0002\u001f\r\u0014X-\u0019;f\u0003J\u0014\u0018-\u001f#bi\u0006$ba!\u0013\u0005N\u0011E\u0003B\u0002C('\u0001\u0007A/A\u0006fY\u0016lWM\u001c;UsB,\u0007b\u0002C*'\u0001\u0007\u0011QY\u0001\u0007Y\u0016tw\r\u001e5")
public class AvroDeserializer {
    private Conversions.DecimalConversion decimalConversions;
    private final Schema rootAvroType;
    private final DataType rootCatalystType;
    private final boolean positionalFieldMatch;
    private final StructFilters filters;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Option<Object>> converter;
    private volatile boolean bitmap$0;

    public static Function1<Object, Object> createTimestampRebaseFuncInRead(RebaseSpec rebaseSpec, String string) {
        return AvroDeserializer$.MODULE$.createTimestampRebaseFuncInRead(rebaseSpec, string);
    }

    public static Function1<Object, Object> createDateRebaseFuncInRead(Enumeration.Value value, String string) {
        return AvroDeserializer$.MODULE$.createDateRebaseFuncInRead(value, string);
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroDeserializer avroDeserializer = this;
        synchronized (avroDeserializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        if (!this.bitmap$0) {
            return this.decimalConversions$lzycompute();
        }
        return this.decimalConversions;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Option<Object>> converter() {
        return this.converter;
    }

    public Option<Object> deserialize(Object data) {
        return (Option)this.converter().apply(data);
    }

    private Function3<CatalystDataUpdater, Object, Object, BoxedUnit> newWriter(Schema avroType, DataType catalystType, Seq<String> avroPath, Seq<String> catalystPath) {
        Schema.Type type;
        Schema.Type type2;
        Tuple2 tuple2;
        String incompatibleMsg;
        block51: {
            block52: {
                StructType structType;
                DataType dataType;
                Some some;
                Schema nonNullAvroType;
                Buffer nonNullTypes;
                while (true) {
                    Schema.Type type3;
                    Schema.Type type4;
                    Schema.Type type5;
                    String errorPrefix = new StringBuilder(37).append("Cannot convert Avro ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" to ").append("SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" because ").toString();
                    incompatibleMsg = new StringBuilder(48).append(errorPrefix).append("schema is incompatible (avroType = ").append(avroType).append(", sqlType = ").append(catalystType.sql()).append(")").toString();
                    tuple2 = new Tuple2((Object)avroType.getType(), (Object)catalystType);
                    if (tuple2 != null) {
                        Schema.Type type6 = (Schema.Type)tuple2._1();
                        DataType dataType2 = (DataType)tuple2._2();
                        if (Schema.Type.NULL.equals(type6) && NullType$.MODULE$.equals(dataType2)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, x$4) -> {
                                updater.setNullAt(BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type7 = (Schema.Type)tuple2._1();
                        DataType dataType3 = (DataType)tuple2._2();
                        if (Schema.Type.BOOLEAN.equals(type7) && BooleanType$.MODULE$.equals(dataType3)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setBoolean(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToBoolean((Object)value));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type8 = (Schema.Type)tuple2._1();
                        DataType dataType4 = (DataType)tuple2._2();
                        if (Schema.Type.INT.equals(type8) && IntegerType$.MODULE$.equals(dataType4)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToInt((Object)value));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type9 = (Schema.Type)tuple2._1();
                        DataType dataType5 = (DataType)tuple2._2();
                        if (Schema.Type.INT.equals(type9) && DateType$.MODULE$.equals(dataType5)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), this.dateRebaseFunc().apply$mcII$sp(BoxesRunTime.unboxToInt((Object)value)));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type10 = (Schema.Type)tuple2._1();
                        DataType dataType6 = (DataType)tuple2._2();
                        if (Schema.Type.LONG.equals(type10) && LongType$.MODULE$.equals(dataType6)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setLong(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToLong((Object)value));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type11 = (Schema.Type)tuple2._1();
                        DataType dataType7 = (DataType)tuple2._2();
                        if (Schema.Type.LONG.equals(type11) && TimestampType$.MODULE$.equals(dataType7)) {
                            LogicalType logicalType = avroType.getLogicalType();
                            if (logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis) {
                                return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                    AvroDeserializer.$anonfun$newWriter$6(this, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                    return BoxedUnit.UNIT;
                                };
                            }
                            if (logicalType instanceof LogicalTypes.TimestampMicros) {
                                return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                    AvroDeserializer.$anonfun$newWriter$7(this, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                    return BoxedUnit.UNIT;
                                };
                            }
                            throw new IncompatibleSchemaException(new StringBuilder(52).append(errorPrefix).append("Avro logical type ").append(logicalType).append(" cannot be converted to SQL type ").append(TimestampType$.MODULE$.sql()).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type12 = (Schema.Type)tuple2._1();
                        DataType dataType8 = (DataType)tuple2._2();
                        if (Schema.Type.LONG.equals(type12) && TimestampNTZType$.MODULE$.equals(dataType8)) {
                            LogicalType logicalType = avroType.getLogicalType();
                            if (logicalType == null ? true : logicalType instanceof LogicalTypes.LocalTimestampMillis) {
                                return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                    AvroDeserializer.$anonfun$newWriter$8(updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                    return BoxedUnit.UNIT;
                                };
                            }
                            if (logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                                return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                    AvroDeserializer.$anonfun$newWriter$9(updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                    return BoxedUnit.UNIT;
                                };
                            }
                            throw new IncompatibleSchemaException(new StringBuilder(52).append(errorPrefix).append("Avro logical type ").append(logicalType).append(" cannot be converted to SQL type ").append(TimestampNTZType$.MODULE$.sql()).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type13 = (Schema.Type)tuple2._1();
                        DataType dataType9 = (DataType)tuple2._2();
                        if (Schema.Type.LONG.equals(type13) && DateType$.MODULE$.equals(dataType9)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), (int)(BoxesRunTime.unboxToLong((Object)value) / 86400000L));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type14 = (Schema.Type)tuple2._1();
                        DataType dataType10 = (DataType)tuple2._2();
                        if (Schema.Type.FLOAT.equals(type14) && FloatType$.MODULE$.equals(dataType10)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setFloat(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToFloat((Object)value));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type15 = (Schema.Type)tuple2._1();
                        DataType dataType11 = (DataType)tuple2._2();
                        if (Schema.Type.DOUBLE.equals(type15) && DoubleType$.MODULE$.equals(dataType11)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.setDouble(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToDouble((Object)value));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type16 = (Schema.Type)tuple2._1();
                        DataType dataType12 = (DataType)tuple2._2();
                        if (Schema.Type.STRING.equals(type16) && StringType$.MODULE$.equals(dataType12)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$13(updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type17 = (Schema.Type)tuple2._1();
                        DataType dataType13 = (DataType)tuple2._2();
                        if (Schema.Type.ENUM.equals(type17) && StringType$.MODULE$.equals(dataType13)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.set(BoxesRunTime.unboxToInt((Object)ordinal), UTF8String.fromString((String)value.toString()));
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type18 = (Schema.Type)tuple2._1();
                        DataType dataType14 = (DataType)tuple2._2();
                        if (Schema.Type.FIXED.equals(type18) && BinaryType$.MODULE$.equals(dataType14)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                updater.set(BoxesRunTime.unboxToInt((Object)ordinal), ((GenericFixed)value).bytes().clone());
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type19 = (Schema.Type)tuple2._1();
                        DataType dataType15 = (DataType)tuple2._2();
                        if (Schema.Type.BYTES.equals(type19) && BinaryType$.MODULE$.equals(dataType15)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$16(errorPrefix, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null && Schema.Type.FIXED.equals(type5 = (Schema.Type)tuple2._1()) && tuple2._2() instanceof DecimalType) {
                        return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                            AvroDeserializer.$anonfun$newWriter$17(this, avroType, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                            return BoxedUnit.UNIT;
                        };
                    }
                    if (tuple2 != null && Schema.Type.BYTES.equals(type4 = (Schema.Type)tuple2._1()) && tuple2._2() instanceof DecimalType) {
                        return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                            AvroDeserializer.$anonfun$newWriter$18(this, avroType, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                            return BoxedUnit.UNIT;
                        };
                    }
                    if (tuple2 != null) {
                        Schema.Type type20 = (Schema.Type)tuple2._1();
                        DataType st = (DataType)tuple2._2();
                        if (Schema.Type.RECORD.equals(type20) && st instanceof StructType) {
                            StructType structType2 = (StructType)st;
                            Function2<CatalystDataUpdater, GenericRecord, Object> writeRecord = this.getRecordWriter(avroType, structType2, avroPath, catalystPath, (Function1<Object, Object>)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$5 -> false);
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$20(this, structType2, writeRecord, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type21 = (Schema.Type)tuple2._1();
                        DataType dataType16 = (DataType)tuple2._2();
                        if (Schema.Type.ARRAY.equals(type21) && dataType16 instanceof ArrayType) {
                            ArrayType arrayType = (ArrayType)dataType16;
                            DataType elementType = arrayType.elementType();
                            boolean containsNull = arrayType.containsNull();
                            Seq avroElementPath = (Seq)avroPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom());
                            Function3<CatalystDataUpdater, Object, Object, BoxedUnit> elementWriter = this.newWriter(avroType.getElementType(), elementType, (Seq<String>)avroElementPath, (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())));
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$21(this, elementType, containsNull, avroElementPath, elementWriter, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                    if (tuple2 != null) {
                        Schema.Type type22 = (Schema.Type)tuple2._1();
                        DataType dataType17 = (DataType)tuple2._2();
                        if (Schema.Type.MAP.equals(type22) && dataType17 instanceof MapType) {
                            MapType mapType = (MapType)dataType17;
                            DataType keyType = mapType.keyType();
                            DataType valueType = mapType.valueType();
                            boolean valueContainsNull = mapType.valueContainsNull();
                            DataType dataType18 = keyType;
                            StringType$ stringType$ = StringType$.MODULE$;
                            if (!(dataType18 != null ? !dataType18.equals(stringType$) : stringType$ != null)) {
                                Function3<CatalystDataUpdater, Object, Object, BoxedUnit> keyWriter = this.newWriter((Schema)SchemaBuilder.builder().stringType(), (DataType)StringType$.MODULE$, (Seq<String>)((Seq)avroPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom())));
                                Function3<CatalystDataUpdater, Object, Object, BoxedUnit> valueWriter = this.newWriter(avroType.getValueType(), valueType, (Seq<String>)((Seq)avroPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())));
                                return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                    AvroDeserializer.$anonfun$newWriter$22(this, keyType, valueType, keyWriter, valueContainsNull, avroPath, valueWriter, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                    return BoxedUnit.UNIT;
                                };
                            }
                        }
                    }
                    if (tuple2 == null || !Schema.Type.UNION.equals(type3 = (Schema.Type)tuple2._1())) break block51;
                    Buffer allTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
                    nonNullTypes = (Buffer)allTypes.filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)AvroDeserializer.$anonfun$newWriter$23(x$6)));
                    nonNullAvroType = Schema.createUnion((java.util.List)((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(nonNullTypes).asJava()));
                    if (!nonNullTypes.nonEmpty()) break block52;
                    if (nonNullTypes.length() != 1) break;
                    avroType = (Schema)nonNullTypes.head();
                }
                Seq seq = ((SeqLike)nonNullTypes.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getType(), Buffer$.MODULE$.canBuildFrom())).toSeq();
                Some some2 = Seq$.MODULE$.unapplySeq(seq);
                if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                    Schema.Type a = (Schema.Type)((SeqLike)some2.get()).apply(0);
                    Schema.Type b = (Schema.Type)((SeqLike)some2.get()).apply(1);
                    GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{a, b}));
                    GenTraversable genTraversable2 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.INT, Schema.Type.LONG}));
                    if (!(genTraversable != null ? !genTraversable.equals(genTraversable2) : genTraversable2 != null)) {
                        DataType dataType19 = catalystType;
                        LongType$ longType$ = LongType$.MODULE$;
                        if (!(dataType19 != null ? !dataType19.equals(longType$) : longType$ != null)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$25(updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                }
                if (!(some = Seq$.MODULE$.unapplySeq(seq)).isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(2) == 0) {
                    Schema.Type a = (Schema.Type)((SeqLike)some.get()).apply(0);
                    Schema.Type b = (Schema.Type)((SeqLike)some.get()).apply(1);
                    GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{a, b}));
                    GenTraversable genTraversable3 = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Schema.Type[]{Schema.Type.FLOAT, Schema.Type.DOUBLE}));
                    if (!(genTraversable != null ? !genTraversable.equals(genTraversable3) : genTraversable3 != null)) {
                        DataType dataType20 = catalystType;
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                        if (!(dataType20 != null ? !dataType20.equals(doubleType$) : doubleType$ != null)) {
                            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                                AvroDeserializer.$anonfun$newWriter$26(updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                                return BoxedUnit.UNIT;
                            };
                        }
                    }
                }
                if ((dataType = catalystType) instanceof StructType && (structType = (StructType)dataType).length() == nonNullTypes.size()) {
                    Function3[] fieldWriters = (Function3[])((TraversableOnce)((TraversableLike)nonNullTypes.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])structType.fields()), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 != null) {
                            Schema schema = (Schema)tuple2._1();
                            StructField field = (StructField)tuple2._2();
                            return this.newWriter(schema, field.dataType(), avroPath, (Seq<String>)((Seq)catalystPath.$colon$plus((Object)field.name(), Seq$.MODULE$.canBuildFrom())));
                        }
                        throw new MatchError((Object)tuple2);
                    }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function3.class));
                    return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                        AvroDeserializer.$anonfun$newWriter$28(this, structType, nonNullAvroType, fieldWriters, updater, BoxesRunTime.unboxToInt((Object)ordinal), value);
                        return BoxedUnit.UNIT;
                    };
                }
                throw new IncompatibleSchemaException(incompatibleMsg, IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, x$8) -> {
                updater.setNullAt(BoxesRunTime.unboxToInt((Object)ordinal));
                return BoxedUnit.UNIT;
            };
        }
        if (tuple2 != null && Schema.Type.INT.equals(type2 = (Schema.Type)tuple2._1()) && tuple2._2() instanceof YearMonthIntervalType) {
            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                updater.setInt(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToInt((Object)value));
                return BoxedUnit.UNIT;
            };
        }
        if (tuple2 != null && Schema.Type.LONG.equals(type = (Schema.Type)tuple2._1()) && tuple2._2() instanceof DayTimeIntervalType) {
            return (Function3 & Serializable & scala.Serializable)(updater, ordinal, value) -> {
                updater.setLong(BoxesRunTime.unboxToInt((Object)ordinal), BoxesRunTime.unboxToLong((Object)value));
                return BoxedUnit.UNIT;
            };
        }
        throw new IncompatibleSchemaException(incompatibleMsg, IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    private Decimal createDecimal(BigDecimal decimal, int precision, int scale) {
        if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return Decimal$.MODULE$.apply(decimal.unscaledValue().longValue(), precision, scale);
        }
        return Decimal$.MODULE$.apply(decimal, precision, scale);
    }

    private Function2<CatalystDataUpdater, GenericRecord, Object> getRecordWriter(Schema avroType, StructType catalystType, Seq<String> avroPath, Seq<String> catalystPath, Function1<Object, Object> applyFilters) {
        AvroUtils.AvroSchemaHelper avroSchemaHelper = new AvroUtils.AvroSchemaHelper(avroType, catalystType, avroPath, catalystPath, this.positionalFieldMatch);
        avroSchemaHelper.validateNoExtraCatalystFields(true);
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)avroSchemaHelper.matchedFields().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AvroUtils.AvroMatchedField avroMatchedField = x0$1;
            if (avroMatchedField != null) {
                StructField catalystField = avroMatchedField.catalystField();
                int ordinal = avroMatchedField.catalystPosition();
                Schema.Field avroField = avroMatchedField.avroField();
                Function3<CatalystDataUpdater, Object, Object, BoxedUnit> baseWriter = this.newWriter(avroField.schema(), catalystField.dataType(), (Seq<String>)((Seq)avroPath.$colon$plus((Object)avroField.name(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name(), Seq$.MODULE$.canBuildFrom())));
                Function2 & Serializable & scala.Serializable fieldWriter = (Function2 & Serializable & scala.Serializable)(fieldUpdater, value) -> {
                    AvroDeserializer.$anonfun$getRecordWriter$2(ordinal, baseWriter, fieldUpdater, value);
                    return BoxedUnit.UNIT;
                };
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), (Object)fieldWriter);
            }
            throw new MatchError((Object)avroMatchedField);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] validFieldIndexes = (int[])tuple2._1();
        Function2[] fieldWriters = (Function2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)validFieldIndexes, (Object)fieldWriters);
        int[] validFieldIndexes2 = (int[])tuple22._1();
        Function2[] fieldWriters2 = (Function2[])tuple22._2();
        return (Function2 & Serializable & scala.Serializable)(fieldUpdater, record) -> BoxesRunTime.boxToBoolean((boolean)AvroDeserializer.$anonfun$getRecordWriter$3(validFieldIndexes2, fieldWriters2, applyFilters, fieldUpdater, record));
    }

    private ArrayData createArrayData(DataType elementType, int length) {
        DataType dataType = elementType;
        if (BooleanType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((boolean[])new boolean[length]);
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((byte[])new byte[length]);
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((short[])new short[length]);
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((int[])new int[length]);
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((long[])new long[length]);
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((float[])new float[length]);
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return UnsafeArrayData.fromPrimitiveArray((double[])new double[length]);
        }
        return new GenericArrayData(new Object[length]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final /* synthetic */ Function1 liftedTree1$1() {
        try {
            Function1 & Serializable & scala.Serializable intersect;
            boolean bl = false;
            StructType structType = null;
            DataType dataType = this.rootCatalystType;
            if (dataType instanceof StructType) {
                bl = true;
                structType = (StructType)dataType;
                if (structType.isEmpty()) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$1 -> new Some((Object)InternalRow$.MODULE$.empty());
                    return intersect;
                }
            }
            if (bl) {
                SpecificInternalRow resultRow = new SpecificInternalRow((Seq)structType.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.dataType(), Seq$.MODULE$.canBuildFrom()));
                RowUpdater fieldUpdater = new RowUpdater(this, (InternalRow)resultRow);
                JFunction1.mcZI.sp & Serializable & scala.Serializable applyFilters = (JFunction1.mcZI.sp & Serializable & scala.Serializable)x$3 -> $this.filters.skipRow((InternalRow)resultRow, x$3);
                Function2<CatalystDataUpdater, GenericRecord, Object> writer = this.getRecordWriter(this.rootAvroType, structType, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$, (Function1<Object, Object>)applyFilters);
                intersect = (Function1 & Serializable & scala.Serializable)data -> {
                    GenericRecord record = (GenericRecord)data;
                    boolean skipRow = BoxesRunTime.unboxToBoolean((Object)writer.apply((Object)fieldUpdater, (Object)record));
                    if (skipRow) {
                        return None$.MODULE$;
                    }
                    return new Some((Object)resultRow);
                };
                return intersect;
            }
            SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)new .colon.colon((Object)this.rootCatalystType, (List)Nil$.MODULE$));
            RowUpdater fieldUpdater = new RowUpdater(this, (InternalRow)tmpRow);
            Function3<CatalystDataUpdater, Object, Object, BoxedUnit> writer = this.newWriter(this.rootAvroType, this.rootCatalystType, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
            intersect = (Function1 & Serializable & scala.Serializable)data -> {
                writer.apply((Object)fieldUpdater, (Object)BoxesRunTime.boxToInteger((int)0), data);
                return new Some(tmpRow.get(0, $this.rootCatalystType));
            };
            return intersect;
        }
        catch (IncompatibleSchemaException ise) {
            throw new IncompatibleSchemaException(new StringBuilder(39).append("Cannot convert Avro type ").append(this.rootAvroType).append(" to SQL type ").append(this.rootCatalystType.sql()).append(".").toString(), (Throwable)ise);
        }
    }

    public static final /* synthetic */ void $anonfun$newWriter$6(AvroDeserializer $this, CatalystDataUpdater updater, int ordinal, Object value) {
        long millis = BoxesRunTime.unboxToLong((Object)value);
        long micros = DateTimeUtils$.MODULE$.millisToMicros(millis);
        updater.setLong(ordinal, $this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$newWriter$7(AvroDeserializer $this, CatalystDataUpdater updater, int ordinal, Object value) {
        long micros = BoxesRunTime.unboxToLong((Object)value);
        updater.setLong(ordinal, $this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$newWriter$8(CatalystDataUpdater updater, int ordinal, Object value) {
        long millis = BoxesRunTime.unboxToLong((Object)value);
        long micros = DateTimeUtils$.MODULE$.millisToMicros(millis);
        updater.setLong(ordinal, micros);
    }

    public static final /* synthetic */ void $anonfun$newWriter$9(CatalystDataUpdater updater, int ordinal, Object value) {
        long micros = BoxesRunTime.unboxToLong((Object)value);
        updater.setLong(ordinal, micros);
    }

    public static final /* synthetic */ void $anonfun$newWriter$13(CatalystDataUpdater updater, int ordinal, Object value) {
        UTF8String uTF8String;
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            uTF8String = UTF8String.fromString((String)string);
        } else if (object instanceof Utf8) {
            Utf8 utf8 = (Utf8)object;
            byte[] bytes = new byte[utf8.getByteLength()];
            System.arraycopy(utf8.getBytes(), 0, bytes, 0, utf8.getByteLength());
            uTF8String = UTF8String.fromBytes((byte[])bytes);
        } else if (object instanceof GenericData.EnumSymbol) {
            GenericData.EnumSymbol enumSymbol = (GenericData.EnumSymbol)object;
            uTF8String = UTF8String.fromString((String)enumSymbol.toString());
        } else {
            throw new MatchError(object);
        }
        UTF8String str = uTF8String;
        updater.set(ordinal, str);
    }

    public static final /* synthetic */ void $anonfun$newWriter$16(String errorPrefix$1, CatalystDataUpdater updater, int ordinal, Object value) {
        byte[] byArray;
        Object object = value;
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            byteBuffer.rewind();
            byArray = bytes;
        } else if (object instanceof byte[]) {
            byte[] byArray2;
            byArray = byArray2 = (byte[])object;
        } else {
            throw new RuntimeException(new StringBuilder(28).append(errorPrefix$1).append(object).append(" is not a valid avro binary.").toString());
        }
        byte[] bytes = byArray;
        updater.set(ordinal, bytes);
    }

    public static final /* synthetic */ void $anonfun$newWriter$17(AvroDeserializer $this, Schema avroType$1, CatalystDataUpdater updater, int ordinal, Object value) {
        LogicalTypes.Decimal d = (LogicalTypes.Decimal)avroType$1.getLogicalType();
        BigDecimal bigDecimal = $this.decimalConversions().fromFixed((GenericFixed)value, avroType$1, (LogicalType)d);
        Decimal decimal = $this.createDecimal(bigDecimal, d.getPrecision(), d.getScale());
        updater.setDecimal(ordinal, decimal);
    }

    public static final /* synthetic */ void $anonfun$newWriter$18(AvroDeserializer $this, Schema avroType$1, CatalystDataUpdater updater, int ordinal, Object value) {
        LogicalTypes.Decimal d = (LogicalTypes.Decimal)avroType$1.getLogicalType();
        BigDecimal bigDecimal = $this.decimalConversions().fromBytes((ByteBuffer)value, avroType$1, (LogicalType)d);
        Decimal decimal = $this.createDecimal(bigDecimal, d.getPrecision(), d.getScale());
        updater.setDecimal(ordinal, decimal);
    }

    public static final /* synthetic */ void $anonfun$newWriter$20(AvroDeserializer $this, StructType x80$1, Function2 writeRecord$1, CatalystDataUpdater updater, int ordinal, Object value) {
        SpecificInternalRow row = new SpecificInternalRow(x80$1);
        writeRecord$1.apply((Object)new RowUpdater($this, (InternalRow)row), (Object)((GenericRecord)value));
        updater.set(ordinal, row);
    }

    public static final /* synthetic */ void $anonfun$newWriter$21(AvroDeserializer $this, DataType elementType$1, boolean containsNull$1, Seq avroElementPath$1, Function3 elementWriter$1, CatalystDataUpdater updater, int ordinal, Object value) {
        Collection collection = (Collection)value;
        ArrayData result = $this.createArrayData(elementType$1, collection.size());
        ArrayDataUpdater elementUpdater = new ArrayDataUpdater($this, result);
        int i = 0;
        for (Object element : collection) {
            Object object;
            if (element == null) {
                if (!containsNull$1) {
                    throw new RuntimeException(new StringBuilder(46).append("Array value at path ").append(AvroUtils$.MODULE$.toFieldStr((Seq<String>)avroElementPath$1)).append(" is not allowed to be null").toString());
                }
                elementUpdater.setNullAt(i);
                object = BoxedUnit.UNIT;
            } else {
                object = elementWriter$1.apply((Object)elementUpdater, (Object)BoxesRunTime.boxToInteger((int)i), element);
            }
            ++i;
        }
        updater.set(ordinal, result);
    }

    public static final /* synthetic */ void $anonfun$newWriter$22(AvroDeserializer $this, DataType keyType$1, DataType valueType$1, Function3 keyWriter$1, boolean valueContainsNull$1, Seq avroPath$1, Function3 valueWriter$1, CatalystDataUpdater updater, int ordinal, Object value) {
        Map map = (Map)value;
        ArrayData keyArray = $this.createArrayData(keyType$1, map.size());
        ArrayDataUpdater keyUpdater = new ArrayDataUpdater($this, keyArray);
        ArrayData valueArray = $this.createArrayData(valueType$1, map.size());
        ArrayDataUpdater valueUpdater = new ArrayDataUpdater($this, valueArray);
        java.util.Iterator iter = map.entrySet().iterator();
        int i = 0;
        while (iter.hasNext()) {
            Object object;
            Map.Entry entry = iter.next();
            Predef$.MODULE$.assert(entry.getKey() != null);
            keyWriter$1.apply((Object)keyUpdater, (Object)BoxesRunTime.boxToInteger((int)i), entry.getKey());
            if (entry.getValue() == null) {
                if (!valueContainsNull$1) {
                    throw new RuntimeException(new StringBuilder(44).append("Map value at path ").append(AvroUtils$.MODULE$.toFieldStr((Seq<String>)((Seq)avroPath$1.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())))).append(" is not allowed to be null").toString());
                }
                valueUpdater.setNullAt(i);
                object = BoxedUnit.UNIT;
            } else {
                object = valueWriter$1.apply((Object)valueUpdater, (Object)BoxesRunTime.boxToInteger((int)i), entry.getValue());
            }
            ++i;
        }
        updater.set(ordinal, new ArrayBasedMapData(keyArray, valueArray));
    }

    public static final /* synthetic */ boolean $anonfun$newWriter$23(Schema x$6) {
        Schema.Type type = x$6.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public static final /* synthetic */ void $anonfun$newWriter$25(CatalystDataUpdater updater, int ordinal, Object value) {
        Object object = value;
        if (object == null) {
            updater.setNullAt(ordinal);
            return;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            updater.setLong(ordinal, Predef$.MODULE$.Long2long(l));
            return;
        }
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            updater.setLong(ordinal, n.longValue());
            return;
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ void $anonfun$newWriter$26(CatalystDataUpdater updater, int ordinal, Object value) {
        Object object = value;
        if (object == null) {
            updater.setNullAt(ordinal);
            return;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            updater.setDouble(ordinal, Predef$.MODULE$.Double2double(d));
            return;
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            updater.setDouble(ordinal, f.doubleValue());
            return;
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ void $anonfun$newWriter$28(AvroDeserializer $this, StructType x2$1, Schema nonNullAvroType$1, Function3[] fieldWriters$1, CatalystDataUpdater updater, int ordinal, Object value) {
        SpecificInternalRow row = new SpecificInternalRow(x2$1);
        RowUpdater fieldUpdater = new RowUpdater($this, (InternalRow)row);
        int i = GenericData.get().resolveUnion(nonNullAvroType$1, value);
        fieldWriters$1[i].apply((Object)fieldUpdater, (Object)BoxesRunTime.boxToInteger((int)i), value);
        updater.set(ordinal, row);
    }

    public static final /* synthetic */ void $anonfun$getRecordWriter$2(int ordinal$1, Function3 baseWriter$1, CatalystDataUpdater fieldUpdater, Object value) {
        if (value == null) {
            fieldUpdater.setNullAt(ordinal$1);
            return;
        }
        baseWriter$1.apply((Object)fieldUpdater, (Object)BoxesRunTime.boxToInteger((int)ordinal$1), value);
    }

    public static final /* synthetic */ boolean $anonfun$getRecordWriter$3(int[] validFieldIndexes$1, Function2[] fieldWriters$2, Function1 applyFilters$1, CatalystDataUpdater fieldUpdater, GenericRecord record) {
        boolean skipRow = false;
        for (int i = 0; i < validFieldIndexes$1.length && !skipRow; ++i) {
            fieldWriters$2[i].apply((Object)fieldUpdater, record.get(validFieldIndexes$1[i]));
            skipRow = applyFilters$1.apply$mcZI$sp(i);
        }
        return skipRow;
    }

    public AvroDeserializer(Schema rootAvroType, DataType rootCatalystType, boolean positionalFieldMatch, RebaseSpec datetimeRebaseSpec, StructFilters filters) {
        this.rootAvroType = rootAvroType;
        this.rootCatalystType = rootCatalystType;
        this.positionalFieldMatch = positionalFieldMatch;
        this.filters = filters;
        this.dateRebaseFunc = AvroDeserializer$.MODULE$.createDateRebaseFuncInRead(datetimeRebaseSpec.mode(), "Avro");
        this.timestampRebaseFunc = AvroDeserializer$.MODULE$.createTimestampRebaseFuncInRead(datetimeRebaseSpec, "Avro");
        this.converter = this.liftedTree1$1();
    }

    public AvroDeserializer(Schema rootAvroType, DataType rootCatalystType, String datetimeRebaseMode) {
        this(rootAvroType, rootCatalystType, false, new RebaseSpec(SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(datetimeRebaseMode), AvroDeserializer$RebaseSpec$.MODULE$.apply$default$2()), (StructFilters)new NoopFilters());
    }

    public final class ArrayDataUpdater
    implements CatalystDataUpdater {
        private final ArrayData array;
        private final /* synthetic */ AvroDeserializer $outer;

        @Override
        public void set(int ordinal, Object value) {
            this.array.update(ordinal, value);
        }

        @Override
        public void setNullAt(int ordinal) {
            this.array.setNullAt(ordinal);
        }

        @Override
        public void setBoolean(int ordinal, boolean value) {
            this.array.setBoolean(ordinal, value);
        }

        @Override
        public void setByte(int ordinal, byte value) {
            this.array.setByte(ordinal, value);
        }

        @Override
        public void setShort(int ordinal, short value) {
            this.array.setShort(ordinal, value);
        }

        @Override
        public void setInt(int ordinal, int value) {
            this.array.setInt(ordinal, value);
        }

        @Override
        public void setLong(int ordinal, long value) {
            this.array.setLong(ordinal, value);
        }

        @Override
        public void setDouble(int ordinal, double value) {
            this.array.setDouble(ordinal, value);
        }

        @Override
        public void setFloat(int ordinal, float value) {
            this.array.setFloat(ordinal, value);
        }

        @Override
        public void setDecimal(int ordinal, Decimal value) {
            this.array.update(ordinal, (Object)value);
        }

        @Override
        public /* synthetic */ AvroDeserializer org$apache$spark$sql$avro$AvroDeserializer$CatalystDataUpdater$$$outer() {
            return this.$outer;
        }

        public ArrayDataUpdater(AvroDeserializer $outer, ArrayData array) {
            this.array = array;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            CatalystDataUpdater.$init$(this);
        }
    }

    public interface CatalystDataUpdater {
        public void set(int var1, Object var2);

        public static /* synthetic */ void setNullAt$(CatalystDataUpdater $this, int ordinal) {
            $this.setNullAt(ordinal);
        }

        default public void setNullAt(int ordinal) {
            this.set(ordinal, null);
        }

        public static /* synthetic */ void setBoolean$(CatalystDataUpdater $this, int ordinal, boolean value) {
            $this.setBoolean(ordinal, value);
        }

        default public void setBoolean(int ordinal, boolean value) {
            this.set(ordinal, BoxesRunTime.boxToBoolean((boolean)value));
        }

        public static /* synthetic */ void setByte$(CatalystDataUpdater $this, int ordinal, byte value) {
            $this.setByte(ordinal, value);
        }

        default public void setByte(int ordinal, byte value) {
            this.set(ordinal, BoxesRunTime.boxToByte((byte)value));
        }

        public static /* synthetic */ void setShort$(CatalystDataUpdater $this, int ordinal, short value) {
            $this.setShort(ordinal, value);
        }

        default public void setShort(int ordinal, short value) {
            this.set(ordinal, BoxesRunTime.boxToShort((short)value));
        }

        public static /* synthetic */ void setInt$(CatalystDataUpdater $this, int ordinal, int value) {
            $this.setInt(ordinal, value);
        }

        default public void setInt(int ordinal, int value) {
            this.set(ordinal, BoxesRunTime.boxToInteger((int)value));
        }

        public static /* synthetic */ void setLong$(CatalystDataUpdater $this, int ordinal, long value) {
            $this.setLong(ordinal, value);
        }

        default public void setLong(int ordinal, long value) {
            this.set(ordinal, BoxesRunTime.boxToLong((long)value));
        }

        public static /* synthetic */ void setDouble$(CatalystDataUpdater $this, int ordinal, double value) {
            $this.setDouble(ordinal, value);
        }

        default public void setDouble(int ordinal, double value) {
            this.set(ordinal, BoxesRunTime.boxToDouble((double)value));
        }

        public static /* synthetic */ void setFloat$(CatalystDataUpdater $this, int ordinal, float value) {
            $this.setFloat(ordinal, value);
        }

        default public void setFloat(int ordinal, float value) {
            this.set(ordinal, BoxesRunTime.boxToFloat((float)value));
        }

        public static /* synthetic */ void setDecimal$(CatalystDataUpdater $this, int ordinal, Decimal value) {
            $this.setDecimal(ordinal, value);
        }

        default public void setDecimal(int ordinal, Decimal value) {
            this.set(ordinal, value);
        }

        public /* synthetic */ AvroDeserializer org$apache$spark$sql$avro$AvroDeserializer$CatalystDataUpdater$$$outer();

        public static void $init$(CatalystDataUpdater $this) {
        }
    }

    public static class RebaseSpec
    implements Product,
    scala.Serializable {
        private final Enumeration.Value mode;
        private final Option<String> originTimeZone;

        public Enumeration.Value mode() {
            return this.mode;
        }

        public Option<String> originTimeZone() {
            return this.originTimeZone;
        }

        public String timeZone() {
            return (String)this.originTimeZone().getOrElse((Function0 & Serializable & scala.Serializable)() -> TimeZone.getDefault().getID());
        }

        public RebaseSpec copy(Enumeration.Value mode, Option<String> originTimeZone) {
            return new RebaseSpec(mode, originTimeZone);
        }

        public Enumeration.Value copy$default$1() {
            return this.mode();
        }

        public Option<String> copy$default$2() {
            return this.originTimeZone();
        }

        public String productPrefix() {
            return "RebaseSpec";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.mode();
                }
                case 1: {
                    return this.originTimeZone();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof RebaseSpec;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof RebaseSpec)) return false;
            boolean bl = true;
            if (!bl) return false;
            RebaseSpec rebaseSpec = (RebaseSpec)x$1;
            Enumeration.Value value = this.mode();
            Enumeration.Value value2 = rebaseSpec.mode();
            if (value == null) {
                if (value2 != null) {
                    return false;
                }
            } else if (!value.equals(value2)) return false;
            Option<String> option = this.originTimeZone();
            Option<String> option2 = rebaseSpec.originTimeZone();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!rebaseSpec.canEqual(this)) return false;
            return true;
        }

        public RebaseSpec(Enumeration.Value mode, Option<String> originTimeZone) {
            this.mode = mode;
            this.originTimeZone = originTimeZone;
            Product.$init$((Product)this);
        }
    }

    public final class RowUpdater
    implements CatalystDataUpdater {
        private final InternalRow row;
        private final /* synthetic */ AvroDeserializer $outer;

        @Override
        public void set(int ordinal, Object value) {
            this.row.update(ordinal, value);
        }

        @Override
        public void setNullAt(int ordinal) {
            this.row.setNullAt(ordinal);
        }

        @Override
        public void setBoolean(int ordinal, boolean value) {
            this.row.setBoolean(ordinal, value);
        }

        @Override
        public void setByte(int ordinal, byte value) {
            this.row.setByte(ordinal, value);
        }

        @Override
        public void setShort(int ordinal, short value) {
            this.row.setShort(ordinal, value);
        }

        @Override
        public void setInt(int ordinal, int value) {
            this.row.setInt(ordinal, value);
        }

        @Override
        public void setLong(int ordinal, long value) {
            this.row.setLong(ordinal, value);
        }

        @Override
        public void setDouble(int ordinal, double value) {
            this.row.setDouble(ordinal, value);
        }

        @Override
        public void setFloat(int ordinal, float value) {
            this.row.setFloat(ordinal, value);
        }

        @Override
        public void setDecimal(int ordinal, Decimal value) {
            this.row.setDecimal(ordinal, value, value.precision());
        }

        @Override
        public /* synthetic */ AvroDeserializer org$apache$spark$sql$avro$AvroDeserializer$CatalystDataUpdater$$$outer() {
            return this.$outer;
        }

        public RowUpdater(AvroDeserializer $outer, InternalRow row) {
            this.row = row;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            CatalystDataUpdater.$init$(this);
        }
    }
}

