/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.transaction.lock.FileSystemBasedLockProvider;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.SparkException;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HoodieCLIUtils$ {
    public static HoodieCLIUtils$ MODULE$;

    static {
        new HoodieCLIUtils$();
    }

    public SparkRDDWriteClient<?> createHoodieWriteClient(SparkSession sparkSession, String basePath, scala.collection.immutable.Map<String, String> conf, Option<String> tableName) {
        scala.collection.immutable.Map<String, String> map;
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HadoopFSUtils.getStorageConf(sparkSession.sessionState().newHadoopConf())).build();
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        String schemaStr = schemaUtil.getTableAvroSchema(false).toString();
        Option<String> option = tableName;
        if (option instanceof Some) {
            Some some = (Some)option;
            String value = (String)some.value();
            map = HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs(this.getHoodieCatalogTable(sparkSession, value).catalogProperties());
        } else if (None$.MODULE$.equals(option)) {
            map = Predef$.MODULE$.Map().empty();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Map<String, String> catalogProps = map;
        scala.collection.immutable.Map<String, String> finalParameters = HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults((scala.collection.immutable.Map<String, String>)((MapLike)catalogProps.$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metaClient.getTableConfig().getProps()).asScala()).toMap(Predef$.MODULE$.$conforms()), Map$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)sparkSession.sqlContext().getAllConfs().filterKeys((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlCommonUtils$.MODULE$.isHoodieConfigKey(key)))).$plus$plus(conf).toMap(Predef$.MODULE$.$conforms()));
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        return DataSourceUtils.createHoodieClient(jsc, schemaStr, basePath, metaClient.getTableConfig().getTableName(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(finalParameters).asJava());
    }

    public String extractPartitions(Seq<HoodieClusteringGroup> clusteringGroups) {
        ObjectRef partitionPaths = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        clusteringGroups.foreach((Function1 & Serializable & scala.Serializable)g -> {
            HoodieCLIUtils$.$anonfun$extractPartitions$1(partitionPaths, g);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)((Seq)partitionPaths.elem).sorted((Ordering)Ordering.String$.MODULE$)).mkString(",");
    }

    public HoodieCatalogTable getHoodieCatalogTable(SparkSession sparkSession, String table) {
        WrappedArray seq = Predef$.MODULE$.wrapRefArray((Object[])new StringOps(Predef$.MODULE$.augmentString(table)).split('.'));
        WrappedArray wrappedArray = seq;
        Some some = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            return HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName));
        }
        Some some2 = Seq$.MODULE$.unapplySeq((Seq)wrappedArray);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            String database = (String)((SeqLike)some2.get()).apply(0);
            String tableName = (String)((SeqLike)some2.get()).apply(1);
            return HoodieCatalogTable$.MODULE$.apply(sparkSession, TableIdentifier$.MODULE$.apply(tableName, (Option)new Some((Object)database)));
        }
        throw new SparkException(new StringBuilder(23).append("Unsupported identifier ").append(table).toString());
    }

    public Tuple2<String, Option<String>> getTableIdentifier(String table) {
        String[] arrayStr = new StringOps(Predef$.MODULE$.augmentString(table)).split('.');
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arrayStr)).toSeq();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            return new Tuple2((Object)tableName, (Object)None$.MODULE$);
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
            String database = (String)((SeqLike)some2.get()).apply(0);
            String tableName = (String)((SeqLike)some2.get()).apply(1);
            return new Tuple2((Object)tableName, (Object)new Some((Object)database));
        }
        throw new SparkException(new StringBuilder(23).append("Unsupported identifier ").append(table).toString());
    }

    public scala.collection.immutable.Map<String, String> extractOptions(String s) {
        return ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(StringUtils.split(s, ",")).asScala()).map((Function1 & Serializable & scala.Serializable)split -> StringUtils.split(split, "="), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)pair -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(pair.get(0)), pair.get(1)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, String> getLockOptions(String tablePath) {
        TypedProperties props = FileSystemBasedLockProvider.getLockConfig(tablePath);
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(props.stringPropertyNames()).asScala()).map((Function1 & Serializable & scala.Serializable)key -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)props.getString((String)key)), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ void $anonfun$extractPartitions$1(ObjectRef partitionPaths$1, HoodieClusteringGroup g) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(g.getSlices()).asScala()).foreach((Function1 & Serializable & scala.Serializable)slice -> {
            partitionPaths$1.elem = (Seq)((Seq)partitionPaths$1.elem).$colon$plus((Object)slice.getPartitionPath(), Seq$.MODULE$.canBuildFrom());
            return BoxedUnit.UNIT;
        });
    }

    private HoodieCLIUtils$() {
        MODULE$ = this;
    }
}

