/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.lock.LockState;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ZookeeperBasedLockProvider
implements LockProvider<InterProcessMutex>,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperBasedLockProvider.class);
    private final transient CuratorFramework curatorFrameworkClient;
    private volatile InterProcessMutex lock = null;
    protected LockConfiguration lockConfiguration;

    public ZookeeperBasedLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        this.curatorFrameworkClient = CuratorFrameworkFactory.builder().connectString(lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.url")).retryPolicy(new BoundedExponentialBackoffRetry(lockConfiguration.getConfig().getInteger("hoodie.write.lock.wait_time_ms_between_retry"), lockConfiguration.getConfig().getInteger("hoodie.write.lock.max_wait_time_ms_between_retry"), lockConfiguration.getConfig().getInteger("hoodie.write.lock.num_retries"))).sessionTimeoutMs(lockConfiguration.getConfig().getInteger("hoodie.write.lock.zookeeper.session_timeout_ms", 60000)).connectionTimeoutMs(lockConfiguration.getConfig().getInteger("hoodie.write.lock.zookeeper.connection_timeout_ms", 15000)).build();
        this.curatorFrameworkClient.start();
        this.createPathIfNotExists();
    }

    private String getLockPath() {
        return this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.base_path") + "/" + this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.lock_key");
    }

    private void createPathIfNotExists() {
        try {
            String lockPath = this.getLockPath();
            LOG.info(String.format("Creating zookeeper path %s if not exists", lockPath));
            String[] parts = lockPath.split("/");
            StringBuilder currentPath = new StringBuilder();
            for (String part : parts) {
                if (part.isEmpty()) continue;
                currentPath.append("/").append(part);
                this.createNodeIfNotExists(currentPath.toString());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to create ZooKeeper path: " + e.getMessage());
            throw new HoodieLockException("Failed to initialize ZooKeeper path", e);
        }
    }

    private void createNodeIfNotExists(String path) throws Exception {
        if (this.curatorFrameworkClient.checkExists().forPath(path) == null) {
            try {
                this.curatorFrameworkClient.create().forPath(path);
            }
            catch (KeeperException e) {
                if (e.code() == KeeperException.Code.NODEEXISTS) {
                    LOG.debug(String.format("Node already exist for path = %s", path));
                }
                throw new HoodieLockException("Failed to create zookeeper node", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZookeeperBasedLockProvider(LockConfiguration lockConfiguration, CuratorFramework curatorFrameworkClient) {
        this.checkRequiredProps(lockConfiguration);
        this.lockConfiguration = lockConfiguration;
        CuratorFramework curatorFramework = this.curatorFrameworkClient = curatorFrameworkClient;
        synchronized (curatorFramework) {
            if (this.curatorFrameworkClient.getState() != CuratorFrameworkState.STARTED) {
                this.curatorFrameworkClient.start();
                this.createPathIfNotExists();
            }
        }
    }

    @Override
    public boolean tryLock(long time, TimeUnit unit) {
        LOG.info(this.generateLogStatement(LockState.ACQUIRING, this.generateLogSuffixString()));
        try {
            this.acquireLock(time, unit);
            LOG.info(this.generateLogStatement(LockState.ACQUIRED, this.generateLogSuffixString()));
        }
        catch (HoodieLockException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()), e);
        }
        return this.lock != null && this.lock.isAcquiredInThisProcess();
    }

    @Override
    public void unlock() {
        try {
            LOG.info(this.generateLogStatement(LockState.RELEASING, this.generateLogSuffixString()));
            if (this.lock == null || !this.lock.isAcquiredInThisProcess()) {
                return;
            }
            this.lock.release();
            this.lock = null;
            LOG.info(this.generateLogStatement(LockState.RELEASED, this.generateLogSuffixString()));
        }
        catch (Exception e) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()), e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.lock != null) {
                this.lock.release();
                this.lock = null;
            }
            this.curatorFrameworkClient.close();
        }
        catch (Exception e) {
            LOG.error(this.generateLogStatement(LockState.FAILED_TO_RELEASE, this.generateLogSuffixString()));
        }
    }

    @Override
    public InterProcessMutex getLock() {
        return this.lock;
    }

    private void acquireLock(long time, TimeUnit unit) throws Exception {
        ValidationUtils.checkArgument(this.lock == null, this.generateLogStatement(LockState.ALREADY_ACQUIRED, this.generateLogSuffixString()));
        InterProcessMutex newLock = new InterProcessMutex(this.curatorFrameworkClient, this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.base_path") + "/" + this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.lock_key"));
        boolean acquired = newLock.acquire(time, unit);
        if (!acquired) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()));
        }
        if (!newLock.isAcquiredInThisProcess()) {
            throw new HoodieLockException(this.generateLogStatement(LockState.FAILED_TO_ACQUIRE, this.generateLogSuffixString()));
        }
        this.lock = newLock;
    }

    private void checkRequiredProps(LockConfiguration config) {
        ValidationUtils.checkArgument(config.getConfig().getString("hoodie.write.lock.zookeeper.url") != null);
        ValidationUtils.checkArgument(config.getConfig().getString("hoodie.write.lock.zookeeper.base_path") != null);
        ValidationUtils.checkArgument(config.getConfig().getString("hoodie.write.lock.zookeeper.lock_key") != null);
    }

    private String generateLogSuffixString() {
        String zkBasePath = this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.base_path");
        String lockKey = this.lockConfiguration.getConfig().getString("hoodie.write.lock.zookeeper.lock_key");
        return StringUtils.join("ZkBasePath = ", zkBasePath, ", lock key = ", lockKey);
    }

    protected String generateLogStatement(LockState state, String suffix) {
        return StringUtils.join(state.name(), " lock at", suffix);
    }
}

