/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.concurrent.Immutable;
import org.apache.avro.Schema;
import org.apache.hudi.common.bootstrap.index.NoOpBootstrapIndex;
import org.apache.hudi.common.bootstrap.index.hfile.HFileBootstrapIndex;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.OrderedProperties;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigClassProperty(name="Hudi Table Basic Configs", groupName=ConfigGroups.Names.TABLE_CONFIG, description="Configurations of the Hudi Table like type of ingestion, storage formats, hive table name etc. Configurations are loaded from hoodie.properties, these properties are usually set during initializing a path as hoodie base path and never changes during the lifetime of a hoodie table.")
@Immutable
public class HoodieTableConfig
extends HoodieConfig {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableConfig.class);
    public static final String HOODIE_PROPERTIES_FILE = "hoodie.properties";
    public static final String HOODIE_PROPERTIES_FILE_BACKUP = "hoodie.properties.backup";
    public static final String HOODIE_WRITE_TABLE_NAME_KEY = "hoodie.datasource.write.table.name";
    public static final String HOODIE_TABLE_NAME_KEY = "hoodie.table.name";
    public static final ConfigProperty<String> DATABASE_NAME = ConfigProperty.key("hoodie.database.name").noDefaultValue("Database name can't have default value as it's used to toggle Hive incremental query feature. See HUDI-2837").withDocumentation("Database name that will be used for incremental query.If different databases have the same table name during incremental query, we can set it to limit the table name under a specific database");
    public static final ConfigProperty<String> NAME = ConfigProperty.key("hoodie.table.name").noDefaultValue().withDocumentation("Table name that will be used for registering with Hive. Needs to be same across runs.");
    public static final ConfigProperty<HoodieTableType> TYPE = ConfigProperty.key("hoodie.table.type").defaultValue(HoodieTableType.COPY_ON_WRITE).withDocumentation("The table type for the underlying data, for this write. This can\u2019t change between writes.");
    public static final ConfigProperty<HoodieTableVersion> VERSION = ConfigProperty.key("hoodie.table.version").defaultValue(HoodieTableVersion.ZERO).withDocumentation("Version of table, used for running upgrade/downgrade steps between releases with potentially breaking/backwards compatible changes.");
    public static final ConfigProperty<String> PRECOMBINE_FIELD = ConfigProperty.key("hoodie.table.precombine.field").noDefaultValue().withDocumentation("Field used in preCombining before actual write. By default, when two records have the same key value, the largest value for the precombine field determined by Object.compareTo(..), is picked.");
    public static final ConfigProperty<String> PARTITION_FIELDS = ConfigProperty.key("hoodie.table.partition.fields").noDefaultValue().withDocumentation("Fields used to partition the table. Concatenated values of these fields are used as the partition path, by invoking toString()");
    public static final ConfigProperty<String> RECORDKEY_FIELDS = ConfigProperty.key("hoodie.table.recordkey.fields").noDefaultValue().withDocumentation("Columns used to uniquely identify the table. Concatenated values of these fields are used as  the record key component of HoodieKey.");
    public static final ConfigProperty<Boolean> CDC_ENABLED = ConfigProperty.key("hoodie.table.cdc.enabled").defaultValue(false).sinceVersion("0.13.0").withDocumentation("When enable, persist the change data if necessary, and can be queried as a CDC query mode.");
    public static final ConfigProperty<String> CDC_SUPPLEMENTAL_LOGGING_MODE = ConfigProperty.key("hoodie.table.cdc.supplemental.logging.mode").defaultValue(HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER.name()).withDocumentation(HoodieCDCSupplementalLoggingMode.class).sinceVersion("0.13.0");
    public static final ConfigProperty<String> CREATE_SCHEMA = ConfigProperty.key("hoodie.table.create.schema").noDefaultValue().withDocumentation("Schema used when creating the table, for the first time.");
    public static final ConfigProperty<HoodieFileFormat> BASE_FILE_FORMAT = ConfigProperty.key("hoodie.table.base.file.format").defaultValue(HoodieFileFormat.PARQUET).withAlternatives("hoodie.table.ro.file.format").withDocumentation("Base file format to store all the base file data.");
    public static final ConfigProperty<HoodieFileFormat> LOG_FILE_FORMAT = ConfigProperty.key("hoodie.table.log.file.format").defaultValue(HoodieFileFormat.HOODIE_LOG).withAlternatives("hoodie.table.rt.file.format").withDocumentation("Log format used for the delta logs.");
    public static final ConfigProperty<String> TIMELINE_LAYOUT_VERSION = ConfigProperty.key("hoodie.timeline.layout.version").noDefaultValue().withDocumentation("Version of timeline used, by the table.");
    public static final ConfigProperty<String> PAYLOAD_CLASS_NAME = ConfigProperty.key("hoodie.compaction.payload.class").defaultValue(OverwriteWithLatestAvroPayload.class.getName()).withDocumentation("Payload class to use for performing compactions, i.e merge delta logs with current base file and then  produce a new base file.");
    public static final ConfigProperty<String> RECORD_MERGER_STRATEGY = ConfigProperty.key("hoodie.compaction.record.merger.strategy").defaultValue("eeb8d96f-b1e4-49fd-bbf8-28ac514178e5").sinceVersion("0.13.0").withDocumentation("Id of merger strategy. Hudi will pick HoodieRecordMerger implementations in hoodie.datasource.write.record.merger.impls which has the same merger strategy id");
    public static final ConfigProperty<String> ARCHIVELOG_FOLDER = ConfigProperty.key("hoodie.archivelog.folder").defaultValue("archived").withDocumentation("path under the meta folder, to store archived timeline instants at.");
    public static final ConfigProperty<Boolean> BOOTSTRAP_INDEX_ENABLE = ConfigProperty.key("hoodie.bootstrap.index.enable").defaultValue(true).withDocumentation("Whether or not, this is a bootstrapped table, with bootstrap base data and an mapping index defined, default true.");
    public static final ConfigProperty<String> BOOTSTRAP_INDEX_CLASS_NAME = ConfigProperty.key("hoodie.bootstrap.index.class").defaultValue(HFileBootstrapIndex.class.getName()).withDocumentation("Implementation to use, for mapping base files to bootstrap base file, that contain actual data.");
    public static final ConfigProperty<String> BOOTSTRAP_BASE_PATH = ConfigProperty.key("hoodie.bootstrap.base.path").noDefaultValue().withDocumentation("Base path of the dataset that needs to be bootstrapped as a Hudi table");
    public static final ConfigProperty<Boolean> POPULATE_META_FIELDS = ConfigProperty.key("hoodie.populate.meta.fields").defaultValue(true).withDocumentation("When enabled, populates all meta fields. When disabled, no meta fields are populated and incremental queries will not be functional. This is only meant to be used for append only/immutable data for batch processing");
    public static final ConfigProperty<String> KEY_GENERATOR_CLASS_NAME = ConfigProperty.key("hoodie.table.keygenerator.class").noDefaultValue().withDocumentation("Key Generator class property for the hoodie table");
    public static final ConfigProperty<HoodieTimelineTimeZone> TIMELINE_TIMEZONE = ConfigProperty.key("hoodie.table.timeline.timezone").defaultValue(HoodieTimelineTimeZone.LOCAL).withDocumentation("User can set hoodie commit timeline timezone, such as utc, local and so on. local is default");
    public static final ConfigProperty<Boolean> PARTITION_METAFILE_USE_BASE_FORMAT = ConfigProperty.key("hoodie.partition.metafile.use.base.format").defaultValue(false).withDocumentation("If true, partition metafiles are saved in the same format as base-files for this dataset (e.g. Parquet / ORC). If false (default) partition metafiles are saved as properties files.");
    public static final ConfigProperty<Boolean> DROP_PARTITION_COLUMNS = ConfigProperty.key("hoodie.datasource.write.drop.partition.columns").defaultValue(false).markAdvanced().withDocumentation("When set to true, will not write the partition columns into hudi. By default, false.");
    public static final ConfigProperty<String> URL_ENCODE_PARTITIONING = KeyGeneratorOptions.URL_ENCODE_PARTITIONING;
    public static final ConfigProperty<String> HIVE_STYLE_PARTITIONING_ENABLE = KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE;
    public static final List<ConfigProperty<String>> PERSISTED_CONFIG_LIST = Arrays.asList(TimestampKeyGeneratorConfig.INPUT_TIME_UNIT, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT, TimestampKeyGeneratorConfig.DATE_TIME_PARSER);
    public static final String NO_OP_BOOTSTRAP_INDEX_CLASS = NoOpBootstrapIndex.class.getName();
    public static final ConfigProperty<String> TABLE_CHECKSUM = ConfigProperty.key("hoodie.table.checksum").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Table checksum is used to guard against partial writes in HDFS. It is added as the last entry in hoodie.properties and then used to validate while reading table config.");
    public static final ConfigProperty<String> TABLE_METADATA_PARTITIONS_INFLIGHT = ConfigProperty.key("hoodie.table.metadata.partitions.inflight").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Comma-separated list of metadata partitions whose building is in progress. These partitions are not yet ready for use by the readers.");
    public static final ConfigProperty<String> TABLE_METADATA_PARTITIONS = ConfigProperty.key("hoodie.table.metadata.partitions").noDefaultValue().sinceVersion("0.11.0").withDocumentation("Comma-separated list of metadata partitions that have been completely built and in-sync with data table. These partitions are ready for use by the readers");
    public static final ConfigProperty<String> SECONDARY_INDEXES_METADATA = ConfigProperty.key("hoodie.table.secondary.indexes.metadata").noDefaultValue().sinceVersion("0.13.0").withDocumentation("The metadata of secondary indexes");
    private static final String TABLE_CHECKSUM_FORMAT = "%s.%s";
    private static final int MAX_READ_RETRIES = 5;
    private static final int READ_RETRY_DELAY_MSEC = 1000;
    @Deprecated
    public static final String HOODIE_RO_FILE_FORMAT_PROP_NAME = "hoodie.table.ro.file.format";
    @Deprecated
    public static final String HOODIE_RT_FILE_FORMAT_PROP_NAME = "hoodie.table.rt.file.format";
    @Deprecated
    public static final String HOODIE_TABLE_NAME_PROP_NAME = NAME.key();
    @Deprecated
    public static final String HOODIE_TABLE_TYPE_PROP_NAME = TYPE.key();
    @Deprecated
    public static final String HOODIE_TABLE_VERSION_PROP_NAME = VERSION.key();
    @Deprecated
    public static final String HOODIE_TABLE_PRECOMBINE_FIELD = PRECOMBINE_FIELD.key();
    @Deprecated
    public static final String HOODIE_BASE_FILE_FORMAT_PROP_NAME = BASE_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_LOG_FILE_FORMAT_PROP_NAME = LOG_FILE_FORMAT.key();
    @Deprecated
    public static final String HOODIE_TIMELINE_LAYOUT_VERSION = TIMELINE_LAYOUT_VERSION.key();
    @Deprecated
    public static final String HOODIE_PAYLOAD_CLASS_PROP_NAME = PAYLOAD_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_ARCHIVELOG_FOLDER_PROP_NAME = ARCHIVELOG_FOLDER.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_INDEX_CLASS_PROP_NAME = BOOTSTRAP_INDEX_CLASS_NAME.key();
    @Deprecated
    public static final String HOODIE_BOOTSTRAP_BASE_PATH = BOOTSTRAP_BASE_PATH.key();
    @Deprecated
    public static final HoodieTableType DEFAULT_TABLE_TYPE = TYPE.defaultValue();
    @Deprecated
    public static final HoodieTableVersion DEFAULT_TABLE_VERSION = VERSION.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_BASE_FILE_FORMAT = BASE_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final HoodieFileFormat DEFAULT_LOG_FILE_FORMAT = LOG_FILE_FORMAT.defaultValue();
    @Deprecated
    public static final String DEFAULT_PAYLOAD_CLASS = PAYLOAD_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_BOOTSTRAP_INDEX_CLASS = BOOTSTRAP_INDEX_CLASS_NAME.defaultValue();
    @Deprecated
    public static final String DEFAULT_ARCHIVELOG_FOLDER = ARCHIVELOG_FOLDER.defaultValue();

    public HoodieTableConfig(HoodieStorage storage, StoragePath metaPath, String payloadClassName, String recordMergerStrategyId) {
        block16: {
            StoragePath propertyPath = new StoragePath(metaPath, HOODIE_PROPERTIES_FILE);
            LOG.info("Loading table properties from " + propertyPath);
            try {
                this.props = HoodieTableConfig.fetchConfigs(storage, metaPath.toString());
                boolean needStore = false;
                if (this.contains(PAYLOAD_CLASS_NAME) && payloadClassName != null && !this.getString(PAYLOAD_CLASS_NAME).equals(payloadClassName)) {
                    this.setValue(PAYLOAD_CLASS_NAME, payloadClassName);
                    needStore = true;
                }
                if (this.contains(RECORD_MERGER_STRATEGY) && recordMergerStrategyId != null && !this.getString(RECORD_MERGER_STRATEGY).equals(recordMergerStrategyId)) {
                    this.setValue(RECORD_MERGER_STRATEGY, recordMergerStrategyId);
                    needStore = true;
                }
                if (!needStore) break block16;
                try (OutputStream outputStream = storage.create(propertyPath);){
                    HoodieTableConfig.storeProperties(this.props, outputStream);
                }
            }
            catch (IOException e) {
                throw new HoodieIOException("Could not load Hoodie properties from " + propertyPath, e);
            }
        }
    }

    private static Properties getOrderedPropertiesWithTableChecksum(Properties props) {
        OrderedProperties orderedProps = new OrderedProperties(props);
        ((Properties)orderedProps).put(TABLE_CHECKSUM.key(), String.valueOf(HoodieTableConfig.generateChecksum(props)));
        return orderedProps;
    }

    private static String storeProperties(Properties props, OutputStream outputStream) throws IOException {
        String checksum;
        if (HoodieTableConfig.isValidChecksum(props)) {
            checksum = props.getProperty(TABLE_CHECKSUM.key());
            props.store(outputStream, "Updated at " + Instant.now());
        } else {
            Properties propsWithChecksum = HoodieTableConfig.getOrderedPropertiesWithTableChecksum(props);
            propsWithChecksum.store(outputStream, "Properties saved on " + Instant.now());
            checksum = propsWithChecksum.getProperty(TABLE_CHECKSUM.key());
            props.setProperty(TABLE_CHECKSUM.key(), checksum);
        }
        return checksum;
    }

    private static boolean isValidChecksum(Properties props) {
        return props.containsKey(TABLE_CHECKSUM.key()) && HoodieTableConfig.validateChecksum(props);
    }

    public HoodieTableConfig() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TypedProperties fetchConfigs(HoodieStorage storage, String metaPath) throws IOException {
        StoragePath cfgPath = new StoragePath(metaPath, HOODIE_PROPERTIES_FILE);
        StoragePath backupCfgPath = new StoragePath(metaPath, HOODIE_PROPERTIES_FILE_BACKUP);
        int readRetryCount = 0;
        boolean found = false;
        TypedProperties props = new TypedProperties();
        while (true) {
            if (readRetryCount++ >= 5) {
                if (!found) throw new HoodieIOException("Could not load Hoodie properties from " + cfgPath);
                throw new IllegalArgumentException("hoodie.properties file seems invalid. Please check for left over `.updated` files if any, manually copy it to hoodie.properties and retry");
            }
            for (StoragePath path : Arrays.asList(cfgPath, backupCfgPath)) {
                try (InputStream is = storage.open(path);){
                    props.clear();
                    props.load(is);
                    found = true;
                    if (props.containsKey(TABLE_CHECKSUM.key())) {
                        ValidationUtils.checkArgument(HoodieTableConfig.validateChecksum(props));
                    }
                    TypedProperties typedProperties = props;
                    return typedProperties;
                }
                catch (IOException e) {
                    LOG.warn(String.format("Could not read properties from %s: %s", path, e));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn(String.format("Invalid properties file %s: %s", path, props));
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting");
                continue;
            }
            break;
        }
    }

    public static void recover(HoodieStorage fs, StoragePath metadataFolder) throws IOException {
        StoragePath cfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        StoragePath backupCfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE_BACKUP);
        HoodieTableConfig.recoverIfNeeded(fs, cfgPath, backupCfgPath);
    }

    static void recoverIfNeeded(HoodieStorage storage, StoragePath cfgPath, StoragePath backupCfgPath) throws IOException {
        if (!storage.exists(cfgPath)) {
            try (InputStream in = storage.open(backupCfgPath);
                 OutputStream out = storage.create(cfgPath, false);){
                FileIOUtils.copy(in, out);
            }
        }
        storage.deleteFile(backupCfgPath);
    }

    private static void upsertProperties(Properties current, Properties updated) {
        updated.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.setProperty(k.toString(), v.toString())));
    }

    private static void deleteProperties(Properties current, Properties deleted) {
        deleted.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> current.remove(k.toString())));
    }

    private static void modify(HoodieStorage storage, StoragePath metadataFolder, Properties modifyProps, BiConsumer<Properties, Properties> modifyFn) {
        StoragePath cfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        StoragePath backupCfgPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE_BACKUP);
        try {
            String checksum;
            HoodieTableConfig.recoverIfNeeded(storage, cfgPath, backupCfgPath);
            TypedProperties props = HoodieTableConfig.fetchConfigs(storage, metadataFolder.toString());
            try (OutputStream out = storage.create(backupCfgPath, false);){
                HoodieTableConfig.storeProperties(props, out);
            }
            storage.deleteFile(cfgPath);
            try (OutputStream out = storage.create(cfgPath, true);){
                modifyFn.accept(props, modifyProps);
                checksum = HoodieTableConfig.storeProperties(props, out);
            }
            var9_12 = null;
            try (InputStream in = storage.open(cfgPath);){
                props.clear();
                props.load(in);
                if (!props.containsKey(TABLE_CHECKSUM.key()) || !props.getProperty(TABLE_CHECKSUM.key()).equals(checksum)) {
                    storage.deleteFile(cfgPath);
                    throw new HoodieIOException("Checksum property missing or does not match.");
                }
            }
            catch (Throwable throwable) {
                var9_12 = throwable;
                throw throwable;
            }
            storage.deleteFile(backupCfgPath);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error updating table configs.", e);
        }
    }

    public static void update(HoodieStorage storage, StoragePath metadataFolder, Properties updatedProps) {
        HoodieTableConfig.modify(storage, metadataFolder, updatedProps, HoodieTableConfig::upsertProperties);
    }

    public static void delete(HoodieStorage storage, StoragePath metadataFolder, Set<String> deletedProps) {
        Properties props = new Properties();
        deletedProps.forEach(p -> props.setProperty((String)p, ""));
        HoodieTableConfig.modify(storage, metadataFolder, props, HoodieTableConfig::deleteProperties);
    }

    public static void create(HoodieStorage storage, StoragePath metadataFolder, Properties properties) throws IOException {
        if (!storage.exists(metadataFolder)) {
            storage.createDirectory(metadataFolder);
        }
        HoodieConfig hoodieConfig = new HoodieConfig(properties);
        StoragePath propertyPath = new StoragePath(metadataFolder, HOODIE_PROPERTIES_FILE);
        try (OutputStream outputStream = storage.create(propertyPath);){
            if (!hoodieConfig.contains(NAME)) {
                throw new IllegalArgumentException(NAME.key() + " property needs to be specified");
            }
            hoodieConfig.setDefaultValue(TYPE);
            if (hoodieConfig.getString(TYPE).equals(HoodieTableType.MERGE_ON_READ.name())) {
                hoodieConfig.setDefaultValue(PAYLOAD_CLASS_NAME);
                hoodieConfig.setDefaultValue(RECORD_MERGER_STRATEGY);
            }
            hoodieConfig.setDefaultValue(ARCHIVELOG_FOLDER);
            if (!hoodieConfig.contains(TIMELINE_LAYOUT_VERSION)) {
                hoodieConfig.setValue(TIMELINE_LAYOUT_VERSION, TimelineLayoutVersion.CURR_VERSION.toString());
            }
            if (hoodieConfig.contains(BOOTSTRAP_BASE_PATH)) {
                hoodieConfig.setDefaultValue(BOOTSTRAP_INDEX_CLASS_NAME, HoodieTableConfig.getDefaultBootstrapIndexClass(properties));
            }
            if (hoodieConfig.contains(TIMELINE_TIMEZONE)) {
                HoodieInstantTimeGenerator.setCommitTimeZone(HoodieTimelineTimeZone.valueOf(hoodieConfig.getString(TIMELINE_TIMEZONE)));
            }
            hoodieConfig.setDefaultValue(DROP_PARTITION_COLUMNS);
            HoodieTableConfig.storeProperties(hoodieConfig.getProps(), outputStream);
        }
    }

    public static long generateChecksum(Properties props) {
        if (!props.containsKey(NAME.key())) {
            throw new IllegalArgumentException(NAME.key() + " property needs to be specified");
        }
        String table = props.getProperty(NAME.key());
        String database = props.getProperty(DATABASE_NAME.key(), "");
        return BinaryUtil.generateChecksum(StringUtils.getUTF8Bytes(String.format(TABLE_CHECKSUM_FORMAT, database, table)));
    }

    public static boolean validateChecksum(Properties props) {
        return Long.parseLong(props.getProperty(TABLE_CHECKSUM.key())) == HoodieTableConfig.generateChecksum(props);
    }

    public HoodieTableType getTableType() {
        return HoodieTableType.valueOf(this.getStringOrDefault(TYPE));
    }

    public Option<TimelineLayoutVersion> getTimelineLayoutVersion() {
        return this.contains(TIMELINE_LAYOUT_VERSION) ? Option.of(new TimelineLayoutVersion(this.getInt(TIMELINE_LAYOUT_VERSION))) : Option.empty();
    }

    public HoodieTableVersion getTableVersion() {
        return this.contains(VERSION) ? HoodieTableVersion.versionFromCode(this.getInt(VERSION)) : VERSION.defaultValue();
    }

    public void setTableVersion(HoodieTableVersion tableVersion) {
        this.setValue(VERSION, Integer.toString(tableVersion.versionCode()));
    }

    public String getPayloadClass() {
        return this.getStringOrDefault(PAYLOAD_CLASS_NAME).replace("com.uber.hoodie", "org.apache.hudi");
    }

    public String getRecordMergerStrategy() {
        return this.getStringOrDefault(RECORD_MERGER_STRATEGY);
    }

    public String getPreCombineField() {
        return this.getString(PRECOMBINE_FIELD);
    }

    public Option<String[]> getRecordKeyFields() {
        String keyFieldsValue = this.getStringOrDefault(RECORDKEY_FIELDS, null);
        if (keyFieldsValue == null) {
            return Option.empty();
        }
        return Option.of(Arrays.stream(keyFieldsValue.split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0]));
    }

    public Option<String[]> getPartitionFields() {
        if (this.contains(PARTITION_FIELDS)) {
            return Option.of(Arrays.stream(this.getString(PARTITION_FIELDS).split(",")).filter(p -> p.length() > 0).collect(Collectors.toList()).toArray(new String[0]));
        }
        return Option.empty();
    }

    public boolean isTablePartitioned() {
        return this.getPartitionFields().map(pfs -> ((String[])pfs).length > 0).orElse(false);
    }

    public Option<String> getSecondaryIndexesMetadata() {
        if (this.contains(SECONDARY_INDEXES_METADATA)) {
            return Option.of(this.getString(SECONDARY_INDEXES_METADATA));
        }
        return Option.empty();
    }

    @Deprecated
    public String getPartitionFieldProp() {
        return Option.ofNullable(this.getString(PARTITION_FIELDS)).orElse("");
    }

    public String getBootstrapIndexClass() {
        return this.getStringOrDefault(BOOTSTRAP_INDEX_CLASS_NAME, HoodieTableConfig.getDefaultBootstrapIndexClass(this.props));
    }

    public static String getDefaultBootstrapIndexClass(Properties props) {
        HoodieConfig hoodieConfig = new HoodieConfig(props);
        String defaultClass = BOOTSTRAP_INDEX_CLASS_NAME.defaultValue();
        if (!hoodieConfig.getBooleanOrDefault(BOOTSTRAP_INDEX_ENABLE)) {
            defaultClass = NO_OP_BOOTSTRAP_INDEX_CLASS;
        }
        return defaultClass;
    }

    public Option<String> getBootstrapBasePath() {
        return Option.ofNullable(this.getString(BOOTSTRAP_BASE_PATH));
    }

    public Option<Schema> getTableCreateSchema() {
        if (this.contains(CREATE_SCHEMA)) {
            return Option.of(new Schema.Parser().parse(this.getString(CREATE_SCHEMA)));
        }
        return Option.empty();
    }

    public String getDatabaseName() {
        return this.getString(DATABASE_NAME);
    }

    public String getTableName() {
        return this.getString(NAME);
    }

    public HoodieFileFormat getBaseFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(BASE_FILE_FORMAT));
    }

    public HoodieFileFormat getLogFileFormat() {
        return HoodieFileFormat.valueOf(this.getStringOrDefault(LOG_FILE_FORMAT));
    }

    public String getArchivelogFolder() {
        return this.getStringOrDefault(ARCHIVELOG_FOLDER);
    }

    public boolean populateMetaFields() {
        return Boolean.parseBoolean(this.getStringOrDefault(POPULATE_META_FIELDS));
    }

    public String getRecordKeyFieldProp() {
        return this.getStringOrDefault(RECORDKEY_FIELDS, HoodieRecord.RECORD_KEY_METADATA_FIELD);
    }

    public String getRawRecordKeyFieldProp() {
        return this.getStringOrDefault(RECORDKEY_FIELDS, null);
    }

    public boolean isCDCEnabled() {
        return this.getBooleanOrDefault(CDC_ENABLED);
    }

    public HoodieCDCSupplementalLoggingMode cdcSupplementalLoggingMode() {
        return HoodieCDCSupplementalLoggingMode.valueOf(this.getStringOrDefault(CDC_SUPPLEMENTAL_LOGGING_MODE).toUpperCase());
    }

    public String getKeyGeneratorClassName() {
        return this.getString(KEY_GENERATOR_CLASS_NAME);
    }

    public HoodieTimelineTimeZone getTimelineTimezone() {
        return HoodieTimelineTimeZone.valueOf(this.getStringOrDefault(TIMELINE_TIMEZONE));
    }

    public String getHiveStylePartitioningEnable() {
        return this.getStringOrDefault(HIVE_STYLE_PARTITIONING_ENABLE);
    }

    public String getUrlEncodePartitioning() {
        return this.getStringOrDefault(URL_ENCODE_PARTITIONING);
    }

    public Boolean shouldDropPartitionColumns() {
        return this.getBooleanOrDefault(DROP_PARTITION_COLUMNS);
    }

    private Long getTableChecksum() {
        return this.getLong(TABLE_CHECKSUM);
    }

    public Set<String> getMetadataPartitionsInflight() {
        return new HashSet<String>(StringUtils.split(this.getStringOrDefault(TABLE_METADATA_PARTITIONS_INFLIGHT, ""), ","));
    }

    public Set<String> getMetadataPartitions() {
        return new HashSet<String>(StringUtils.split(this.getStringOrDefault(TABLE_METADATA_PARTITIONS, ""), ","));
    }

    public boolean isMetadataTableAvailable() {
        return this.isMetadataPartitionAvailable(MetadataPartitionType.FILES);
    }

    public boolean isMetadataPartitionAvailable(MetadataPartitionType partition) {
        return this.getMetadataPartitions().contains(partition.getPartitionPath());
    }

    public void setMetadataPartitionState(HoodieTableMetaClient metaClient, MetadataPartitionType partitionType, boolean enabled) {
        ValidationUtils.checkArgument(!partitionType.getPartitionPath().contains(","), "Metadata Table partition path cannot contain a comma: " + partitionType.getPartitionPath());
        Set<String> partitions = this.getMetadataPartitions();
        Set<String> partitionsInflight = this.getMetadataPartitionsInflight();
        if (enabled) {
            partitions.add(partitionType.getPartitionPath());
            partitionsInflight.remove(partitionType.getPartitionPath());
        } else if (partitionType.equals((Object)MetadataPartitionType.FILES)) {
            partitions.clear();
            partitionsInflight.clear();
        } else {
            partitions.remove(partitionType.getPartitionPath());
            partitionsInflight.remove(partitionType.getPartitionPath());
        }
        this.setValue(TABLE_METADATA_PARTITIONS, partitions.stream().sorted().collect(Collectors.joining(",")));
        this.setValue(TABLE_METADATA_PARTITIONS_INFLIGHT, partitionsInflight.stream().sorted().collect(Collectors.joining(",")));
        HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), this.getProps());
        LOG.info(String.format("MDT %s partition %s has been %s", metaClient.getBasePathV2(), partitionType.name(), enabled ? "enabled" : "disabled"));
    }

    public void setMetadataPartitionsInflight(HoodieTableMetaClient metaClient, List<MetadataPartitionType> partitionTypes) {
        Set<String> partitionsInflight = this.getMetadataPartitionsInflight();
        partitionTypes.forEach(t -> {
            ValidationUtils.checkArgument(!t.getPartitionPath().contains(","), "Metadata Table partition path cannot contain a comma: " + t.getPartitionPath());
            partitionsInflight.add(t.getPartitionPath());
        });
        this.setValue(TABLE_METADATA_PARTITIONS_INFLIGHT, partitionsInflight.stream().sorted().collect(Collectors.joining(",")));
        HoodieTableConfig.update(metaClient.getStorage(), metaClient.getMetaPath(), this.getProps());
        LOG.info(String.format("MDT %s partitions %s have been set to inflight", metaClient.getBasePathV2(), partitionTypes));
    }

    public void setMetadataPartitionsInflight(HoodieTableMetaClient metaClient, MetadataPartitionType ... partitionTypes) {
        this.setMetadataPartitionsInflight(metaClient, Arrays.stream(partitionTypes).collect(Collectors.toList()));
    }

    public void clearMetadataPartitions(HoodieTableMetaClient metaClient) {
        this.setMetadataPartitionState(metaClient, MetadataPartitionType.FILES, false);
    }

    public Option<HoodieFileFormat> getPartitionMetafileFormat() {
        if (this.getBooleanOrDefault(PARTITION_METAFILE_USE_BASE_FORMAT)) {
            return Option.of(this.getBaseFileFormat());
        }
        return Option.empty();
    }

    public Map<String, String> propsMap() {
        return this.props.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
    }
}

