/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.CachingIterator;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.Option;

public class LogFileIterator<T>
extends CachingIterator<HoodieRecord<T>> {
    HoodieMergedLogRecordScanner scanner;
    Map<String, HoodieRecord> records;
    Iterator<HoodieRecord> iterator;

    protected Option<HoodieRecord> removeLogRecord(String key) {
        return Option.ofNullable(this.records.remove(key));
    }

    public LogFileIterator(HoodieMergedLogRecordScanner scanner) {
        this.scanner = scanner;
        this.records = scanner.getRecords();
    }

    private boolean hasNextInternal() {
        if (this.iterator == null) {
            this.iterator = this.records.values().iterator();
        }
        if (this.iterator.hasNext()) {
            this.nextRecord = this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    protected boolean doHasNext() {
        return this.hasNextInternal();
    }
}

