/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;

public class HoodieHFileRecordReader
implements RecordReader<NullWritable, ArrayWritable> {
    private long count = 0L;
    private ArrayWritable valueObj;
    private HoodieFileReader reader;
    private ClosableIterator<HoodieRecord<IndexedRecord>> recordIterator;
    private Schema schema;

    public HoodieHFileRecordReader(Configuration conf, InputSplit split, JobConf job) throws IOException {
        FileSplit fileSplit = (FileSplit)split;
        StoragePath path = HadoopFSUtils.convertToStoragePath(fileSplit.getPath());
        StorageConfiguration<Configuration> storageConf = HadoopFSUtils.getStorageConf(conf);
        HoodieConfig hoodieConfig = ConfigUtils.getReaderConfigs(storageConf);
        this.reader = HoodieIOFactory.getIOFactory(new HoodieHadoopStorage(path, storageConf)).getReaderFactory(HoodieRecord.HoodieRecordType.AVRO).getFileReader(hoodieConfig, path, HoodieFileFormat.HFILE, Option.empty());
        this.schema = this.reader.getSchema();
        this.valueObj = new ArrayWritable(Writable.class, new Writable[this.schema.getFields().size()]);
    }

    public boolean next(NullWritable key, ArrayWritable value) throws IOException {
        if (this.recordIterator == null) {
            this.recordIterator = this.reader.getRecordIterator(this.schema);
        }
        if (!this.recordIterator.hasNext()) {
            return false;
        }
        IndexedRecord record = (IndexedRecord)((HoodieRecord)this.recordIterator.next()).getData();
        ArrayWritable aWritable = (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(record, this.schema);
        value.set(aWritable.get());
        ++this.count;
        return true;
    }

    public NullWritable createKey() {
        return null;
    }

    public ArrayWritable createValue() {
        return this.valueObj;
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.recordIterator != null) {
            this.recordIterator.close();
            this.recordIterator = null;
        }
    }

    public float getProgress() throws IOException {
        return 1.0f * (float)this.count / (float)this.reader.getTotalRecords();
    }
}

