/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hadoop.utils.HoodieHiveUtils;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieROTablePathFilter
implements Configurable,
PathFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieROTablePathFilter.class);
    private Map<String, HashSet<Path>> hoodiePathCache = new ConcurrentHashMap<String, HashSet<Path>>();
    Set<String> nonHoodiePathCache = new HashSet<String>();
    Map<String, HoodieTableMetaClient> metaClientCache;
    private StorageConfiguration<?> conf;
    private transient HoodieLocalEngineContext engineContext;
    private transient HoodieStorage storage;

    public HoodieROTablePathFilter() {
        this(new Configuration());
    }

    public HoodieROTablePathFilter(Configuration conf) {
        this.conf = HadoopFSUtils.getStorageConfWithCopy(conf);
        this.metaClientCache = new HashMap<String, HoodieTableMetaClient>();
    }

    private Path safeGetParentsParent(Path path) {
        if (path.getParent() != null && path.getParent().getParent() != null && path.getParent().getParent().getParent() != null) {
            return path.getParent().getParent().getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accept(Path path) {
        if (this.engineContext == null) {
            this.engineContext = new HoodieLocalEngineContext(this.conf);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Checking acceptance for path " + path);
        }
        Path folder = null;
        try {
            Path baseDir;
            if (this.storage == null) {
                this.storage = new HoodieHadoopStorage(HadoopFSUtils.convertToStoragePath(path), this.conf);
            }
            if (this.nonHoodiePathCache.contains((folder = path.getParent()).toString())) {
                if (!LOG.isDebugEnabled()) return true;
                LOG.debug("Accepting non-hoodie path from cache: " + path);
                return true;
            }
            if (this.hoodiePathCache.containsKey(folder.toString())) {
                if (!LOG.isDebugEnabled()) return this.hoodiePathCache.get(folder.toString()).contains(path);
                LOG.debug(String.format("%s Hoodie path checked against cache, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                return this.hoodiePathCache.get(folder.toString()).contains(path);
            }
            String filePath = path.toString();
            if (filePath.contains("/.hoodie/") || filePath.endsWith("/.hoodie")) {
                if (!LOG.isDebugEnabled()) return false;
                LOG.debug(String.format("Skipping Hoodie Metadata file  %s \n", filePath));
                return false;
            }
            StoragePath storagePath = HadoopFSUtils.convertToStoragePath(folder);
            if (HoodiePartitionMetadata.hasPartitionMetadata(this.storage, storagePath)) {
                HoodiePartitionMetadata metadata = new HoodiePartitionMetadata(this.storage, storagePath);
                metadata.readFromFS();
                baseDir = HoodieHiveUtils.getNthParent(folder, metadata.getPartitionDepth());
            } else {
                baseDir = this.safeGetParentsParent(folder);
            }
            if (baseDir != null) {
                if (this.nonHoodiePathCache.contains(baseDir.toString())) {
                    if (!LOG.isDebugEnabled()) return true;
                    LOG.debug("Accepting non-hoodie path from cache: " + path);
                    return true;
                }
                try (HoodieTableFileSystemView fsView = null;){
                    Configuration conf;
                    String timestampAsOf;
                    HoodieTableMetaClient metaClient = this.metaClientCache.get(baseDir.toString());
                    if (null == metaClient) {
                        metaClient = HoodieTableMetaClient.builder().setConf(this.storage.getConf().newInstance()).setBasePath(baseDir.toString()).setLoadActiveTimelineOnLoad(true).build();
                        this.metaClientCache.put(baseDir.toString(), metaClient);
                    }
                    if (StringUtils.nonEmpty(timestampAsOf = (conf = this.getConf()).get(HoodieCommonConfig.TIMESTAMP_AS_OF.key()))) {
                        TimelineUtils.validateTimestampAsOf(metaClient, timestampAsOf);
                        fsView = FileSystemViewManager.createInMemoryFileSystemViewWithTimeline(this.engineContext, metaClient, HoodieInputFormatUtils.buildMetadataConfig(conf), metaClient.getActiveTimeline().filterCompletedInstants().findInstantsBeforeOrEquals(timestampAsOf));
                    } else {
                        fsView = FileSystemViewManager.createInMemoryFileSystemView(this.engineContext, metaClient, HoodieInputFormatUtils.buildMetadataConfig(conf));
                    }
                    String partition = HadoopFSUtils.getRelativePartitionPath(new Path(metaClient.getBasePath()), folder);
                    List latestFiles = fsView.getLatestBaseFiles(partition).collect(Collectors.toList());
                    if (!this.hoodiePathCache.containsKey(folder.toString())) {
                        this.hoodiePathCache.put(folder.toString(), new HashSet());
                    }
                    LOG.info("Based on hoodie metadata from base path: " + baseDir.toString() + ", caching " + latestFiles.size() + " files under " + folder);
                    for (HoodieBaseFile lfile : latestFiles) {
                        this.hoodiePathCache.get(folder.toString()).add(new Path(lfile.getPath()));
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("%s checked after cache population, accept => %s \n", path, this.hoodiePathCache.get(folder.toString()).contains(path)));
                    }
                    boolean bl = this.hoodiePathCache.get(folder.toString()).contains(path);
                    return bl;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("(2) Caching non-hoodie path under %s \n", folder.toString()));
            }
            this.nonHoodiePathCache.add(folder.toString());
            return true;
        }
        catch (Exception e) {
            String msg = "Error checking path :" + path + ", under folder: " + folder;
            LOG.error(msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    public void setConf(Configuration conf) {
        this.conf = HadoopFSUtils.getStorageConfWithCopy(conf);
    }

    public Configuration getConf() {
        return this.conf.unwrapAs(Configuration.class);
    }
}

