/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop.fs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.apache.hudi.common.util.RetryHelper;

public class HoodieRetryWrapperFileSystem
extends FileSystem {
    private FileSystem fileSystem;
    private long maxRetryIntervalMs;
    private int maxRetryNumbers;
    private long initialRetryIntervalMs;
    private String retryExceptionsList;

    public HoodieRetryWrapperFileSystem(FileSystem fs, long maxRetryIntervalMs, int maxRetryNumbers, long initialRetryIntervalMs, String retryExceptions) {
        this.fileSystem = fs;
        this.maxRetryIntervalMs = maxRetryIntervalMs;
        this.maxRetryNumbers = maxRetryNumbers;
        this.initialRetryIntervalMs = initialRetryIntervalMs;
        this.retryExceptionsList = retryExceptions;
    }

    public URI getUri() {
        return this.fileSystem.getUri();
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.open(f, bufferSize)).start();
    }

    public FSDataInputStream open(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.open(f)).start();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, permission, overwrite, bufferSize, replication, blockSize, progress)).start();
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, overwrite)).start();
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f)).start();
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, progress)).start();
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, replication)).start();
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, replication, progress)).start();
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, overwrite, bufferSize)).start();
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, overwrite, bufferSize, progress)).start();
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, overwrite, bufferSize, replication, blockSize, progress)).start();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, permission, flags, bufferSize, replication, blockSize, progress)).start();
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt)).start();
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.create(f, overwrite, bufferSize, replication, blockSize)).start();
    }

    public boolean createNewFile(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.createNewFile(f)).start();
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.append(f, bufferSize, progress)).start();
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.append(f)).start();
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.append(f, bufferSize)).start();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.rename(src, dst)).start();
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.delete(f, recursive)).start();
    }

    public boolean delete(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.delete(f, true)).start();
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listStatus(f)).start();
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listStatus(f, filter)).start();
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listStatus(files)).start();
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listStatus(files, filter)).start();
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.globStatus(pathPattern)).start();
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.globStatus(pathPattern, filter)).start();
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listLocatedStatus(f)).start();
    }

    public RemoteIterator<LocatedFileStatus> listFiles(Path f, boolean recursive) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.listFiles(f, recursive)).start();
    }

    public void setWorkingDirectory(Path newDir) {
        this.fileSystem.setWorkingDirectory(newDir);
    }

    public Path getWorkingDirectory() {
        return this.fileSystem.getWorkingDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.mkdirs(f, permission)).start();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.getFileStatus(f)).start();
    }

    public boolean exists(Path f) throws IOException {
        return new RetryHelper(this.maxRetryIntervalMs, this.maxRetryNumbers, this.initialRetryIntervalMs, this.retryExceptionsList).tryWith(() -> this.fileSystem.exists(f)).start();
    }

    public Configuration getConf() {
        return this.fileSystem.getConf();
    }

    public String getScheme() {
        return this.fileSystem.getScheme();
    }

    public short getDefaultReplication() {
        return this.fileSystem.getDefaultReplication();
    }

    public short getDefaultReplication(Path path) {
        return this.fileSystem.getDefaultReplication(path);
    }
}

