/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Arrays;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieBucketIndex
extends HoodieIndex<Object, Object> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBucketIndex.class);
    protected final int numBuckets;
    protected final List<String> indexKeyFields;

    public HoodieBucketIndex(HoodieWriteConfig config) {
        super(config);
        this.numBuckets = config.getBucketIndexNumBuckets();
        this.indexKeyFields = Arrays.asList(config.getBucketIndexHashField().split(","));
        LOG.info("Use bucket index, numBuckets = " + this.numBuckets + ", indexFields: " + this.indexKeyFields);
    }

    @Override
    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable) throws HoodieIndexException {
        return writeStatuses;
    }

    @Override
    public boolean requiresTagging(WriteOperationType operationType) {
        switch (operationType) {
            case INSERT: 
            case INSERT_OVERWRITE: 
            case UPSERT: 
            case DELETE: 
            case DELETE_PREPPED: 
            case BULK_INSERT: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean rollbackCommit(String instantTime) {
        return true;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    @Override
    public boolean canIndexLogFiles() {
        return true;
    }

    @Override
    public boolean isImplicitWithStorage() {
        return true;
    }

    public int getNumBuckets() {
        return this.numBuckets;
    }
}

