/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieRollbackRequest;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.marker.MarkerBasedRollbackUtils;
import org.apache.hudi.table.marker.WriteMarkers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerBasedRollbackStrategy<T, I, K, O>
implements BaseRollbackPlanActionExecutor.RollbackStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(MarkerBasedRollbackStrategy.class);
    protected final HoodieTable<?, ?, ?, ?> table;
    protected final transient HoodieEngineContext context;
    protected final HoodieWriteConfig config;
    protected final String basePath;
    protected final String instantTime;

    public MarkerBasedRollbackStrategy(HoodieTable<?, ?, ?, ?> table, HoodieEngineContext context, HoodieWriteConfig config, String instantTime) {
        this.table = table;
        this.context = context;
        this.basePath = table.getMetaClient().getBasePathV2().toString();
        this.config = config;
        this.instantTime = instantTime;
    }

    @Override
    public List<HoodieRollbackRequest> getRollbackRequests(HoodieInstant instantToRollback) {
        try {
            List<String> markerPaths = MarkerBasedRollbackUtils.getAllMarkerPaths(this.table, this.context, instantToRollback.getTimestamp(), this.config.getRollbackParallelism());
            int parallelism = Math.max(Math.min(markerPaths.size(), this.config.getRollbackParallelism()), 1);
            return this.context.map(markerPaths, markerFilePath -> {
                String typeStr = markerFilePath.substring(markerFilePath.lastIndexOf(".") + 1);
                IOType type = IOType.valueOf(typeStr);
                String fileNameWithPartitionToRollback = WriteMarkers.stripMarkerSuffix(markerFilePath);
                Path fullFilePathToRollback = new Path(this.basePath, fileNameWithPartitionToRollback);
                String partitionPath = HadoopFSUtils.getRelativePartitionPath(new Path(this.basePath), fullFilePathToRollback.getParent());
                switch (type) {
                    case MERGE: 
                    case CREATE: {
                        String fileId = null;
                        String baseInstantTime = null;
                        if (HadoopFSUtils.isBaseFile(fullFilePathToRollback)) {
                            HoodieBaseFile baseFileToDelete = new HoodieBaseFile(fullFilePathToRollback.toString());
                            fileId = baseFileToDelete.getFileId();
                            baseInstantTime = baseFileToDelete.getCommitTime();
                        } else if (HadoopFSUtils.isLogFile(fullFilePathToRollback)) {
                            throw new HoodieRollbackException("Log files should have only APPEND as IOTypes " + fullFilePathToRollback);
                        }
                        Objects.requireNonNull(fileId, "Cannot find valid fileId from path: " + fullFilePathToRollback);
                        Objects.requireNonNull(baseInstantTime, "Cannot find valid base instant from path: " + fullFilePathToRollback);
                        return new HoodieRollbackRequest(partitionPath, fileId, baseInstantTime, Collections.singletonList(fullFilePathToRollback.toString()), Collections.emptyMap());
                    }
                    case APPEND: {
                        return this.getRollbackRequestForAppend(instantToRollback, fileNameWithPartitionToRollback);
                    }
                }
                throw new HoodieRollbackException("Unknown marker type, during rollback of " + instantToRollback);
            }, parallelism);
        }
        catch (Exception e) {
            throw new HoodieRollbackException("Error rolling back using marker files written for " + instantToRollback, e);
        }
    }

    protected HoodieRollbackRequest getRollbackRequestForAppend(HoodieInstant instantToRollback, String fileNameWithPartitionToRollback) {
        StoragePath fullLogFilePath = new StoragePath(this.basePath, fileNameWithPartitionToRollback);
        String relativePartitionPath = FSUtils.getRelativePartitionPath(new StoragePath(this.basePath), fullLogFilePath.getParent());
        Map<Object, Object> logBlocksToBeDeleted = new HashMap();
        if (FSUtils.isBaseFile(fullLogFilePath)) {
            LOG.warn("Find old marker type for log file: " + fileNameWithPartitionToRollback);
            String fileId = FSUtils.getFileIdFromFilePath(fullLogFilePath);
            String baseCommitTime = FSUtils.getCommitTime(fullLogFilePath.getName());
            StoragePath partitionPath = FSUtils.constructAbsolutePath(this.config.getBasePath(), relativePartitionPath);
            try {
                Option<HoodieLogFile> latestLogFileOption = FSUtils.getLatestLogFile(this.table.getMetaClient().getStorage(), partitionPath, fileId, HoodieFileFormat.HOODIE_LOG.getFileExtension(), baseCommitTime);
                if (latestLogFileOption.isPresent() && baseCommitTime.equals(instantToRollback.getTimestamp())) {
                    StoragePath fullDeletePath = new StoragePath(partitionPath, latestLogFileOption.get().getFileName());
                    return new HoodieRollbackRequest(relativePartitionPath, "", "", Collections.singletonList(fullDeletePath.toString()), Collections.emptyMap());
                }
                if (latestLogFileOption.isPresent()) {
                    HoodieLogFile latestLogFile = latestLogFileOption.get();
                    logBlocksToBeDeleted = Collections.singletonMap(latestLogFile.getPathInfo().getPath().toString(), latestLogFile.getPathInfo().getLength());
                }
                return new HoodieRollbackRequest(relativePartitionPath, fileId, baseCommitTime, Collections.emptyList(), logBlocksToBeDeleted);
            }
            catch (IOException ioException) {
                throw new HoodieIOException("Failed to get latestLogFile for fileId: " + fileId + " in partition: " + partitionPath, ioException);
            }
        }
        HoodieLogFile logFileToRollback = new HoodieLogFile(fullLogFilePath);
        String fileId = logFileToRollback.getFileId();
        String baseCommitTime = logFileToRollback.getBaseCommitTime();
        logBlocksToBeDeleted = Collections.singletonMap(logFileToRollback.getPath().getName(), 1L);
        return new HoodieRollbackRequest(relativePartitionPath, fileId, baseCommitTime, Collections.emptyList(), logBlocksToBeDeleted);
    }
}

