/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.timeline.service.handlers.marker;

import java.util.ConcurrentModificationException;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.common.conflict.detection.TimelineServerBasedDetectionStrategy;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.exception.HoodieEarlyConflictDetectionException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.timeline.service.handlers.MarkerHandler;
import org.apache.hudi.timeline.service.handlers.marker.MarkerBasedEarlyConflictDetectionRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTimelineServerBasedDetectionStrategy
extends TimelineServerBasedDetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncTimelineServerBasedDetectionStrategy.class);
    private AtomicBoolean hasConflict = new AtomicBoolean(false);
    private ScheduledExecutorService asyncDetectorExecutor;

    public AsyncTimelineServerBasedDetectionStrategy(String basePath, String markerDir, String markerName, Boolean checkCommitConflict) {
        super(basePath, markerDir, markerName, checkCommitConflict);
    }

    @Override
    public boolean hasMarkerConflict() {
        return this.hasConflict.get();
    }

    @Override
    public void resolveMarkerConflict(String basePath, String markerDir, String markerName) {
        throw new HoodieEarlyConflictDetectionException(new ConcurrentModificationException("Early conflict detected but cannot resolve conflicts for overlapping writes"));
    }

    @Override
    public void startAsyncDetection(Long initialDelayMs, Long periodMs, String markerDir, String basePath, Long maxAllowableHeartbeatIntervalInMs, HoodieStorage storage, Object markerHandler, Set<HoodieInstant> completedCommits) {
        if (this.asyncDetectorExecutor != null) {
            this.asyncDetectorExecutor.shutdown();
        }
        this.hasConflict.set(false);
        this.asyncDetectorExecutor = Executors.newSingleThreadScheduledExecutor();
        this.asyncDetectorExecutor.scheduleAtFixedRate(new MarkerBasedEarlyConflictDetectionRunnable(this.hasConflict, (MarkerHandler)markerHandler, markerDir, basePath, storage, maxAllowableHeartbeatIntervalInMs, completedCommits, this.checkCommitConflict), initialDelayMs, periodMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void detectAndResolveConflictIfNecessary() throws HoodieEarlyConflictDetectionException {
        if (this.hasMarkerConflict()) {
            this.resolveMarkerConflict(this.basePath, this.markerDir, this.markerName);
        }
    }

    @Override
    public void stop() {
        if (this.asyncDetectorExecutor != null) {
            this.asyncDetectorExecutor.shutdown();
        }
    }
}

