/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificData;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.storage.StoragePath;
import org.apache.parquet.avro.HoodieAvroReadSupport;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.InputFile;

public class HoodieAvroParquetReaderBuilder<T>
extends ParquetReader.Builder<T> {
    private GenericData model = null;
    private boolean enableCompatibility = true;
    private boolean isReflect = true;

    @Deprecated
    public HoodieAvroParquetReaderBuilder(StoragePath path) {
        super(new Path(path.toUri()));
    }

    public HoodieAvroParquetReaderBuilder(InputFile file) {
        super(file);
    }

    public HoodieAvroParquetReaderBuilder<T> withDataModel(GenericData model) {
        this.model = model;
        if (model.getClass() != GenericData.class && model.getClass() != SpecificData.class) {
            this.isReflect = true;
        }
        return this;
    }

    public HoodieAvroParquetReaderBuilder<T> disableCompatibility() {
        this.enableCompatibility = false;
        return this;
    }

    public HoodieAvroParquetReaderBuilder<T> withCompatibility(boolean enableCompatibility) {
        this.enableCompatibility = enableCompatibility;
        return this;
    }

    protected ReadSupport<T> getReadSupport() {
        if (this.isReflect) {
            this.conf.setBoolean("parquet.avro.compatible", false);
        } else {
            this.conf.setBoolean("parquet.avro.compatible", this.enableCompatibility);
        }
        return new HoodieAvroReadSupport(this.model);
    }
}

