/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.HoodieSQLOption;
import org.apache.spark.sql.hudi.HoodieSQLOptionBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HoodieOptionConfig$ {
    public static HoodieOptionConfig$ MODULE$;
    private Map<String, String> sqlOptionKeyToWriteConfigKey;
    private Map<String, String> writeConfigKeyToSqlOptionKey;
    private Map<String, String> sqlOptionKeyToTableConfigKey;
    private Map<String, String> tableConfigKeyToSqlOptionKey;
    private Map<String, String> hoodieConfigValueToSqlOptionValue;
    private final String SQL_VALUE_TABLE_TYPE_COW;
    private final String SQL_VALUE_TABLE_TYPE_MOR;
    private final HoodieSQLOption<String> SQL_KEY_TABLE_PRIMARY_KEY;
    private final HoodieSQLOption<String> SQL_KEY_TABLE_TYPE;
    private final HoodieSQLOption<String> SQL_KEY_PRECOMBINE_FIELD;
    private final HoodieSQLOption<String> SQL_PAYLOAD_CLASS;
    private final HoodieSQLOption<String> SQL_RECORD_MERGER_STRATEGY;
    private final Map<String, String> sqlOptionValueToHoodieConfigValue;
    private final Map<String, String> defaultSqlOptions;
    private volatile byte bitmap$0;

    static {
        new HoodieOptionConfig$();
    }

    public String SQL_VALUE_TABLE_TYPE_COW() {
        return this.SQL_VALUE_TABLE_TYPE_COW;
    }

    public String SQL_VALUE_TABLE_TYPE_MOR() {
        return this.SQL_VALUE_TABLE_TYPE_MOR;
    }

    public HoodieSQLOption<String> SQL_KEY_TABLE_PRIMARY_KEY() {
        return this.SQL_KEY_TABLE_PRIMARY_KEY;
    }

    public HoodieSQLOption<String> SQL_KEY_TABLE_TYPE() {
        return this.SQL_KEY_TABLE_TYPE;
    }

    public HoodieSQLOption<String> SQL_KEY_PRECOMBINE_FIELD() {
        return this.SQL_KEY_PRECOMBINE_FIELD;
    }

    public HoodieSQLOption<String> SQL_PAYLOAD_CLASS() {
        return this.SQL_PAYLOAD_CLASS;
    }

    public HoodieSQLOption<String> SQL_RECORD_MERGER_STRATEGY() {
        return this.SQL_RECORD_MERGER_STRATEGY;
    }

    private Map<String, String> sqlOptionKeyToWriteConfigKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.sqlOptionKeyToWriteConfigKey = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getClass().getDeclaredFields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToWriteConfigKey$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> {
                    f.setAccessible(true);
                    return (HoodieSQLOption)f.get(MODULE$);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieSQLOption.class))))).map((Function1 & Serializable & scala.Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), (Object)option.hoodieKeyName()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sqlOptionKeyToWriteConfigKey;
    }

    private Map<String, String> sqlOptionKeyToWriteConfigKey() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sqlOptionKeyToWriteConfigKey$lzycompute();
        }
        return this.sqlOptionKeyToWriteConfigKey;
    }

    private Map<String, String> writeConfigKeyToSqlOptionKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.writeConfigKeyToSqlOptionKey = (Map)this.sqlOptionKeyToWriteConfigKey().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()), Map$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.writeConfigKeyToSqlOptionKey;
    }

    private Map<String, String> writeConfigKeyToSqlOptionKey() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.writeConfigKeyToSqlOptionKey$lzycompute();
        }
        return this.writeConfigKeyToSqlOptionKey;
    }

    private Map<String, String> sqlOptionKeyToTableConfigKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.sqlOptionKeyToTableConfigKey = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getClass().getDeclaredFields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToTableConfigKey$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> {
                    f.setAccessible(true);
                    return (HoodieSQLOption)f.get(MODULE$);
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieSQLOption.class))))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$sqlOptionKeyToTableConfigKey$3(x$1))))).map((Function1 & Serializable & scala.Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), option.tableConfigKey().get()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.sqlOptionKeyToTableConfigKey;
    }

    private Map<String, String> sqlOptionKeyToTableConfigKey() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.sqlOptionKeyToTableConfigKey$lzycompute();
        }
        return this.sqlOptionKeyToTableConfigKey;
    }

    private Map<String, String> tableConfigKeyToSqlOptionKey$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.tableConfigKeyToSqlOptionKey = (Map)this.sqlOptionKeyToTableConfigKey().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()), Map$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.tableConfigKeyToSqlOptionKey;
    }

    private Map<String, String> tableConfigKeyToSqlOptionKey() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.tableConfigKeyToSqlOptionKey$lzycompute();
        }
        return this.tableConfigKeyToSqlOptionKey;
    }

    private Map<String, String> sqlOptionValueToHoodieConfigValue() {
        return this.sqlOptionValueToHoodieConfigValue;
    }

    private Map<String, String> hoodieConfigValueToSqlOptionValue$lzycompute() {
        HoodieOptionConfig$ hoodieOptionConfig$ = this;
        synchronized (hoodieOptionConfig$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.hoodieConfigValueToSqlOptionValue = (Map)this.sqlOptionValueToHoodieConfigValue().map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), f._1()), Map$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.hoodieConfigValueToSqlOptionValue;
    }

    private Map<String, String> hoodieConfigValueToSqlOptionValue() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.hoodieConfigValueToSqlOptionValue$lzycompute();
        }
        return this.hoodieConfigValueToSqlOptionValue;
    }

    public Map<String, String> withDefaultSqlOptions(Map<String, String> options) {
        return this.defaultSqlOptions().$plus$plus(options);
    }

    public Map<String, String> mapSqlOptionsToDataSourceWriteConfigs(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.sqlOptionKeyToWriteConfigKey().getOrElse(kv._1(), (Function0 & Serializable & scala.Serializable)() -> (String)kv._1())), MODULE$.sqlOptionValueToHoodieConfigValue().getOrElse(kv._2(), (Function0 & Serializable & scala.Serializable)() -> (String)kv._2())), Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> mapHoodieConfigsToSqlOptions(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (MODULE$.writeConfigKeyToSqlOptionKey().contains((Object)k)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.writeConfigKeyToSqlOptionKey().apply((Object)k)), MODULE$.hoodieConfigValueToSqlOptionValue().getOrElse((Object)v, (Function0 & Serializable & scala.Serializable)() -> v));
                }
                if (MODULE$.tableConfigKeyToSqlOptionKey().contains((Object)k)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.tableConfigKeyToSqlOptionKey().apply((Object)k)), MODULE$.hoodieConfigValueToSqlOptionValue().getOrElse((Object)v, (Function0 & Serializable & scala.Serializable)() -> v));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> mapSqlOptionsToTableConfigs(Map<String, String> options) {
        return (Map)options.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (MODULE$.sqlOptionKeyToTableConfigKey().contains((Object)k)) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.sqlOptionKeyToTableConfigKey().apply((Object)k)), MODULE$.sqlOptionValueToHoodieConfigValue().getOrElse((Object)v.toLowerCase(), (Function0 & Serializable & scala.Serializable)() -> v));
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> defaultSqlOptions() {
        return this.defaultSqlOptions;
    }

    public String getTableType(Map<String, String> options) {
        Map<String, String> params = this.mapSqlOptionsToDataSourceWriteConfigs(options);
        return (String)params.getOrElse((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), (Function0 & Serializable & scala.Serializable)() -> DataSourceWriteOptions$.MODULE$.TABLE_TYPE().defaultValue());
    }

    public Option<String> getPreCombineField(Map<String, String> options) {
        Map<String, String> params = this.mapSqlOptionsToDataSourceWriteConfigs(options);
        return params.get((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$getPreCombineField$1(x$2)));
    }

    public Map<String, String> deleteHoodieOptions(Map<String, String> options) {
        return (Map)options.filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$deleteHoodieOptions$1(x$3))).filterNot((Function1 & Serializable & scala.Serializable)kv -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$deleteHoodieOptions$2(kv)));
    }

    public Map<String, String> extractHoodieOptions(Map<String, String> options) {
        return ((MapLike)options.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$extractHoodieOptions$1(x$4)))).$plus$plus(this.extractSqlOptions(options));
    }

    public Map<String, String> extractSqlOptions(Map<String, String> options) {
        Map<String, String> sqlOptions = this.mapHoodieConfigsToSqlOptions(options);
        Set targetOptions = (Set)this.sqlOptionKeyToWriteConfigKey().keySet().$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SQL_PAYLOAD_CLASS().sqlKeyName()}))).$minus$minus((GenTraversableOnce)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.SQL_RECORD_MERGER_STRATEGY().sqlKeyName()})));
        return sqlOptions.filterKeys((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)targetOptions.contains((Object)elem))).toMap(Predef$.MODULE$.$conforms());
    }

    public void validateTable(SparkSession spark, StructType schema, Map<String, String> sqlOptions) {
        Option preCombineKey;
        Function2 resolver2 = spark.sessionState().conf().resolver();
        Option primaryKeys = sqlOptions.get((Object)this.SQL_KEY_TABLE_PRIMARY_KEY().sqlKeyName()).map((Function1 & Serializable & scala.Serializable)x$5 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$5.split(","))).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$2(x$6))));
        if (primaryKeys.isDefined()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])primaryKeys.get())).foreach((Function1 & Serializable & scala.Serializable)primaryKey -> {
                HoodieOptionConfig$.$anonfun$validateTable$3(schema, resolver2, primaryKey);
                return BoxedUnit.UNIT;
            });
        }
        if ((preCombineKey = sqlOptions.get((Object)this.SQL_KEY_PRECOMBINE_FIELD().sqlKeyName())).isDefined() && new StringOps(Predef$.MODULE$.augmentString((String)preCombineKey.get())).nonEmpty()) {
            ValidationUtils.checkArgument(schema.exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$5(resolver2, preCombineKey, f))), new StringBuilder(32).append("Can't find preCombineKey `").append(preCombineKey.get()).append("` in ").append(schema.treeString()).append(".").toString());
        }
        Option tableType = sqlOptions.get((Object)this.SQL_KEY_TABLE_TYPE().sqlKeyName());
        ValidationUtils.checkArgument(tableType.nonEmpty(), "No `type` is specified.");
        ValidationUtils.checkArgument(((String)tableType.get()).equalsIgnoreCase(this.SQL_VALUE_TABLE_TYPE_COW()) || ((String)tableType.get()).equalsIgnoreCase(this.SQL_VALUE_TABLE_TYPE_MOR()), new StringBuilder(23).append("'type' must be '").append(this.SQL_VALUE_TABLE_TYPE_COW()).append("' or '").append(this.SQL_VALUE_TABLE_TYPE_MOR()).append("'").toString());
        Option indexType = sqlOptions.get((Object)HoodieIndexConfig.INDEX_TYPE.key());
        if (!indexType.isEmpty()) {
            HoodieIndexConfig.INDEX_TYPE.checkValues((String)indexType.get());
            return;
        }
    }

    public <T> HoodieSQLOptionBuilder<T> buildConf() {
        return new HoodieSQLOptionBuilder();
    }

    public Map<String, String> makeOptionsCaseInsensitive(Map<String, String> sqlOptions) {
        Seq standardOptions = (Seq)((TraversableLike)new .colon.colon(this.SQL_KEY_TABLE_PRIMARY_KEY(), (List)new .colon.colon(this.SQL_KEY_PRECOMBINE_FIELD(), (List)new .colon.colon(this.SQL_KEY_TABLE_TYPE(), (List)new .colon.colon(this.SQL_PAYLOAD_CLASS(), (List)new .colon.colon(this.SQL_RECORD_MERGER_STRATEGY(), (List)Nil$.MODULE$)))))).map((Function1 & Serializable & scala.Serializable)key -> key.sqlKeyName(), Seq$.MODULE$.canBuildFrom());
        return (Map)sqlOptions.map((Function1 & Serializable & scala.Serializable)option -> {
            Option option2 = standardOptions.find((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$makeOptionsCaseInsensitive$3(option, x)));
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                String standardKey = (String)some.value();
                return new Tuple2((Object)standardKey, option._2());
            }
            if (None$.MODULE$.equals(option2)) {
                return new Tuple2(option._1(), option._2());
            }
            throw new MatchError((Object)option2);
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToWriteConfigKey$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToTableConfigKey$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sqlOptionKeyToTableConfigKey$3(HoodieSQLOption x$1) {
        return x$1.tableConfigKey().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$defaultSqlOptions$1(Field f) {
        Class<?> clazz = f.getType();
        Class<HoodieSQLOption> clazz2 = HoodieSQLOption.class;
        return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$defaultSqlOptions$3(HoodieSQLOption option) {
        return option.tableConfigKey().isDefined() && option.defaultValue().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$getPreCombineField$1(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$deleteHoodieOptions$1(Tuple2 x$3) {
        return ((String)x$3._1()).startsWith("hoodie.");
    }

    public static final /* synthetic */ boolean $anonfun$deleteHoodieOptions$2(Tuple2 kv) {
        return MODULE$.sqlOptionKeyToWriteConfigKey().contains(kv._1());
    }

    public static final /* synthetic */ boolean $anonfun$extractHoodieOptions$1(Tuple2 x$4) {
        return ((String)x$4._1()).startsWith("hoodie.");
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$2(String x$6) {
        return x$6.length() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$4(Function2 resolver$1, String primaryKey$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)HoodieAvroUtils.getRootLevelFieldName(primaryKey$1)));
    }

    public static final /* synthetic */ void $anonfun$validateTable$3(StructType schema$1, Function2 resolver$1, String primaryKey) {
        ValidationUtils.checkArgument(schema$1.exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$validateTable$4(resolver$1, primaryKey, f))), new StringBuilder(29).append("Can't find primaryKey `").append(primaryKey).append("` in ").append(schema$1.treeString()).append(".").toString());
    }

    public static final /* synthetic */ boolean $anonfun$validateTable$5(Function2 resolver$1, Option preCombineKey$1, StructField f) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)f.name(), (Object)HoodieAvroUtils.getRootLevelFieldName((String)preCombineKey$1.get())));
    }

    public static final /* synthetic */ boolean $anonfun$makeOptionsCaseInsensitive$3(Tuple2 option$1, String x) {
        return x.toLowerCase().contains(((String)option$1._1()).toLowerCase());
    }

    private HoodieOptionConfig$() {
        MODULE$ = this;
        this.SQL_VALUE_TABLE_TYPE_COW = "cow";
        this.SQL_VALUE_TABLE_TYPE_MOR = "mor";
        this.SQL_KEY_TABLE_PRIMARY_KEY = this.buildConf().withSqlKey("primaryKey").withHoodieKey(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()).withTableConfigKey(HoodieTableConfig.RECORDKEY_FIELDS.key()).build();
        this.SQL_KEY_TABLE_TYPE = this.buildConf().withSqlKey("type").withHoodieKey(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()).withTableConfigKey(HoodieTableConfig.TYPE.key()).defaultValue(this.SQL_VALUE_TABLE_TYPE_COW()).build();
        this.SQL_KEY_PRECOMBINE_FIELD = this.buildConf().withSqlKey("preCombineField").withHoodieKey(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()).withTableConfigKey(HoodieTableConfig.PRECOMBINE_FIELD.key()).build();
        this.SQL_PAYLOAD_CLASS = this.buildConf().withSqlKey("payloadClass").withHoodieKey(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().key()).withTableConfigKey(HoodieTableConfig.PAYLOAD_CLASS_NAME.key()).defaultValue(DataSourceWriteOptions$.MODULE$.PAYLOAD_CLASS_NAME().defaultValue()).build();
        this.SQL_RECORD_MERGER_STRATEGY = this.buildConf().withSqlKey("recordMergerStrategy").withHoodieKey(DataSourceWriteOptions$.MODULE$.RECORD_MERGER_STRATEGY().key()).withTableConfigKey(HoodieTableConfig.RECORD_MERGER_STRATEGY.key()).defaultValue("eeb8d96f-b1e4-49fd-bbf8-28ac514178e5").build();
        this.sqlOptionValueToHoodieConfigValue = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SQL_VALUE_TABLE_TYPE_COW()), (Object)HoodieTableType.COPY_ON_WRITE.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.SQL_VALUE_TABLE_TYPE_MOR()), (Object)HoodieTableType.MERGE_ON_READ.name())}));
        this.defaultSqlOptions = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getClass().getDeclaredFields())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$defaultSqlOptions$1(f))))).map((Function1 & Serializable & scala.Serializable)f -> {
            f.setAccessible(true);
            return (HoodieSQLOption)f.get(MODULE$);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieSQLOption.class))))).filter((Function1 & Serializable & scala.Serializable)option -> BoxesRunTime.boxToBoolean((boolean)HoodieOptionConfig$.$anonfun$defaultSqlOptions$3(option))))).map((Function1 & Serializable & scala.Serializable)option -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)option.sqlKeyName()), (Object)option.defaultValue().get().toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }
}

