/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowInvalidParquetProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001]4A\u0001E\t\u0001A!)\u0001\u0006\u0001C\u0001S!91\u0006\u0001b\u0001\n\u0013a\u0003B\u0002\u001c\u0001A\u0003%Q\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\r}\u0002\u0001\u0015!\u0003:\u0011\u0015\u0001\u0005\u0001\"\u0001-\u0011\u0015\t\u0005\u0001\"\u00019\u0011\u0015\u0011\u0005\u0001\"\u0011D\u0011\u0015I\u0006\u0001\"\u0011[\u000f\u0015Y\u0016\u0003#\u0001]\r\u0015\u0001\u0012\u0003#\u0001^\u0011\u0015A3\u0002\"\u0001b\u0011\u001d\u00117B1A\u0005\u0002\rDa\u0001\\\u0006!\u0002\u0013!\u0007\"B7\f\t\u0003q'aG*i_^LeN^1mS\u0012\u0004\u0016M]9vKR\u0004&o\\2fIV\u0014XM\u0003\u0002\u0013'\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005Q)\u0012aB2p[6\fg\u000e\u001a\u0006\u0003-]\tA\u0001[;eS*\u0011\u0001$G\u0001\u0004gFd'B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002=\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!I\u0013\u0011\u0005\t\u001aS\"A\t\n\u0005\u0011\n\"!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002#M%\u0011q%\u0005\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#\u0001\u0016\u0011\u0005\t\u0002\u0011A\u0003)B%\u0006kU\tV#S'V\tQ\u0006E\u0002/cMj\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003EQJ!!N\t\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006%A\u0006P+R\u0003V\u000bV0U3B+U#A\u001d\u0011\u0005ijT\"A\u001e\u000b\u0005q:\u0012!\u0002;za\u0016\u001c\u0018B\u0001 <\u0005)\u0019FO];diRK\b/Z\u0001\r\u001fV#\u0006+\u0016+`)f\u0003V\tI\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\t!E\u000bE\u0002F\u001bBs!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%{\u0012A\u0002\u001fs_>$h(C\u00011\u0013\tau&A\u0004qC\u000e\\\u0017mZ3\n\u00059{%aA*fc*\u0011Aj\f\t\u0003#Jk\u0011aF\u0005\u0003'^\u00111AU8x\u0011\u0015)\u0006\u00021\u0001W\u0003\u0011\t'oZ:\u0011\u0005\t:\u0016B\u0001-\u0012\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\u0006)!-^5mIV\t!&A\u000eTQ><\u0018J\u001c<bY&$\u0007+\u0019:rk\u0016$\bK]8dK\u0012,(/\u001a\t\u0003E-\u0019\"a\u00030\u0011\u00059z\u0016B\u000110\u0005\u0019\te.\u001f*fMR\tA,\u0001\u0003O\u00036+U#\u00013\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017\u0001\u00027b]\u001eT\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lM\n11\u000b\u001e:j]\u001e\fQAT!N\u000b\u0002\nqAY;jY\u0012,'/F\u0001p!\r\u0001X/J\u0007\u0002c*\u0011!o]\u0001\tMVt7\r^5p]*\u0011A\u000f[\u0001\u0005kRLG.\u0003\u0002wc\nA1+\u001e9qY&,'\u000f")
public class ShowInvalidParquetProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "path", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("path", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowInvalidParquetProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowInvalidParquetProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        super.checkArgs(this.PARAMETERS(), args2);
        String srcPath = (String)this.getArgValueOrDefault(args2, this.PARAMETERS()[0]).get();
        StorageConfiguration<Configuration> storageConf = HadoopFSUtils.getStorageConfWithCopy(this.jsc().hadoopConfiguration());
        HoodieHadoopStorage storage = new HoodieHadoopStorage(srcPath, storageConf);
        List<String> partitionPaths = FSUtils.getAllPartitionPaths(new HoodieSparkEngineContext(this.jsc()), storage, srcPath, false, false);
        JavaRDD javaRdd = this.jsc().parallelize(partitionPaths, partitionPaths.size());
        return Predef$.MODULE$.wrapRefArray((Object[])javaRdd.rdd().map((Function1 & Serializable & scala.Serializable)part -> {
            FileSystem fs = HadoopFSUtils.getFs(new Path(srcPath), (Configuration)storageConf.unwrap());
            return HadoopFSUtils.getAllDataFilesInPartition(fs, HadoopFSUtils.constructAbsolutePathInHadoopPath(srcPath, part));
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(FileStatus.class))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).toList(), ClassTag$.MODULE$.apply(FileStatus.class)).filter((Function1 & Serializable & scala.Serializable)status -> BoxesRunTime.boxToBoolean((boolean)ShowInvalidParquetProcedure.$anonfun$call$3(storageConf, status))).map((Function1 & Serializable & scala.Serializable)status -> Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.getPath().toString()})), ClassTag$.MODULE$.apply(Row.class)).collect());
    }

    @Override
    public ShowInvalidParquetProcedure build() {
        return new ShowInvalidParquetProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$3(StorageConfiguration storageConf$1, FileStatus status) {
        BoxedUnit boxedUnit;
        Path filePath = status.getPath();
        boolean isInvalid = false;
        if (filePath.toString().endsWith(".parquet")) {
            try {
                boxedUnit = ParquetFileReader.readFooter((Configuration)((Configuration)storageConf$1.unwrap()), (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
            }
            catch (Exception e) {
                isInvalid = e.getMessage().contains("is not a Parquet file");
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return isInvalid;
    }
}

