/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.uber.m3.tally.m3.thrift;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import org.apache.hudi.com.uber.m3.tally.m3.thrift.TUdpTransport;
import org.apache.thrift.transport.TTransportException;

public class TUdpClient
extends TUdpTransport
implements AutoCloseable {
    public TUdpClient(SocketAddress socketAddress) throws SocketException {
        super(socketAddress);
    }

    TUdpClient(SocketAddress socketAddress, DatagramSocket socket) {
        super(socketAddress, socket);
    }

    @Override
    public void open() throws TTransportException {
        try {
            this.socket.connect(this.socketAddress);
            this.open = true;
            this.logger.info("UDP socket has been opened");
        }
        catch (SocketException e) {
            throw new TTransportException("Error opening transport", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws TTransportException {
        Object object = this.sendLock;
        synchronized (object) {
            try {
                this.socket.send(new DatagramPacket(this.writeBuffer.array(), this.writeBuffer.position()));
            }
            catch (IOException e) {
                throw new TTransportException((Throwable)e);
            }
            finally {
                this.writeBuffer.clear();
            }
        }
    }
}

