/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.LogFileIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieFileReader;
import org.apache.hudi.keygen.BaseKeyGenerator;

public class HoodieFileSliceReader<T>
extends LogFileIterator<T> {
    private Option<Iterator<HoodieRecord>> baseFileIterator;
    private HoodieMergedLogRecordScanner scanner;
    private Schema schema;
    private Properties props;
    private TypedProperties payloadProps = new TypedProperties();
    private Option<Pair<String, String>> simpleKeyGenFieldsOpt;
    private Option<BaseKeyGenerator> keyGeneratorOpt;
    Map<String, HoodieRecord> records;
    HoodieRecordMerger merger;

    public HoodieFileSliceReader(Option<HoodieFileReader> baseFileReader, HoodieMergedLogRecordScanner scanner, Schema schema, String preCombineField, HoodieRecordMerger merger, Properties props, Option<Pair<String, String>> simpleKeyGenFieldsOpt, Option<BaseKeyGenerator> keyGeneratorOpt) throws IOException {
        super(scanner);
        this.baseFileIterator = baseFileReader.isPresent() ? Option.of(baseFileReader.get().getRecordIterator(schema)) : Option.empty();
        this.scanner = scanner;
        this.schema = schema;
        this.merger = merger;
        if (preCombineField != null) {
            this.payloadProps.setProperty("hoodie.payload.ordering.field", preCombineField);
        }
        this.props = props;
        this.simpleKeyGenFieldsOpt = simpleKeyGenFieldsOpt;
        this.keyGeneratorOpt = keyGeneratorOpt;
        this.records = scanner.getRecords();
    }

    private boolean hasNextInternal() {
        while (this.baseFileIterator.isPresent() && this.baseFileIterator.get().hasNext()) {
            try {
                HoodieRecord currentRecord = this.baseFileIterator.get().next();
                String recordKey = currentRecord.getRecordKey(this.schema, this.keyGeneratorOpt);
                Option<HoodieRecord> logRecord = this.removeLogRecord(recordKey);
                if (!logRecord.isPresent()) {
                    this.nextRecord = currentRecord.wrapIntoHoodieRecordPayloadWithParams(this.schema, this.props, this.simpleKeyGenFieldsOpt, this.scanner.isWithOperationField(), this.scanner.getPartitionNameOverride(), false, Option.empty());
                    return true;
                }
                Option<Pair<HoodieRecord, Schema>> mergedRecordOpt = this.merger.merge(currentRecord, this.schema, logRecord.get(), this.schema, this.payloadProps);
                if (!mergedRecordOpt.isPresent()) continue;
                HoodieRecord mergedRecord = mergedRecordOpt.get().getLeft();
                this.nextRecord = mergedRecord.wrapIntoHoodieRecordPayloadWithParams(this.schema, this.props, this.simpleKeyGenFieldsOpt, this.scanner.isWithOperationField(), this.scanner.getPartitionNameOverride(), false, Option.empty());
                return true;
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to wrapIntoHoodieRecordPayloadWithParams: " + e.getMessage());
            }
        }
        return super.doHasNext();
    }

    @Override
    protected boolean doHasNext() {
        return this.hasNextInternal();
    }
}

