/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.parser.BaseHoodieDateTimeParser;

public class KeyGenUtils {
    protected static final String NULL_RECORDKEY_PLACEHOLDER = "__null__";
    protected static final String EMPTY_RECORDKEY_PLACEHOLDER = "__empty__";
    protected static final String HUDI_DEFAULT_PARTITION_PATH = "__HIVE_DEFAULT_PARTITION__";
    public static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    public static final String DEFAULT_RECORD_KEY_PARTS_SEPARATOR = ",";
    public static final String DEFAULT_COLUMN_VALUE_SEPARATOR = ":";
    public static final String RECORD_KEY_GEN_PARTITION_ID_CONFIG = "_hoodie.record.key.gen.partition.id";
    public static final String RECORD_KEY_GEN_INSTANT_TIME_CONFIG = "_hoodie.record.key.gen.instant.time";

    public static KeyGeneratorType inferKeyGeneratorType(Option<String> recordsKeyFields, String partitionFields) {
        int numRecordKeyFields = recordsKeyFields.map(fields -> fields.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR).length).orElse(0);
        KeyGeneratorType partitionKeyGeneratorType = KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields(partitionFields);
        if (numRecordKeyFields <= 1) {
            return partitionKeyGeneratorType;
        }
        if (partitionKeyGeneratorType == KeyGeneratorType.SIMPLE) {
            return KeyGeneratorType.COMPLEX;
        }
        return partitionKeyGeneratorType;
    }

    static KeyGeneratorType inferKeyGeneratorTypeFromPartitionFields(String partitionFields) {
        if (!StringUtils.isNullOrEmpty(partitionFields)) {
            String[] partitonFields = partitionFields.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
            if (partitonFields[0].contains(DEFAULT_COLUMN_VALUE_SEPARATOR)) {
                return KeyGeneratorType.CUSTOM;
            }
            if (partitonFields.length == 1) {
                return KeyGeneratorType.SIMPLE;
            }
            return KeyGeneratorType.COMPLEX;
        }
        return KeyGeneratorType.NON_PARTITION;
    }

    public static String getRecordKeyFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? keyGeneratorOpt.get().getRecordKey(genericRecord) : genericRecord.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    public static String getPartitionPathFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? keyGeneratorOpt.get().getPartitionPath(genericRecord) : genericRecord.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
    }

    public static String[] extractRecordKeys(String recordKey) {
        return KeyGenUtils.extractRecordKeysByFields(recordKey, Collections.emptyList());
    }

    public static String[] extractRecordKeysByFields(String recordKey, List<String> fields) {
        String[] stringArray;
        if (!recordKey.contains(DEFAULT_RECORD_KEY_PARTS_SEPARATOR) || !recordKey.contains(DEFAULT_COLUMN_VALUE_SEPARATOR)) {
            return new String[]{recordKey};
        }
        ArrayList<String> values2 = new ArrayList<String>();
        int processed = 0;
        while (processed < recordKey.length()) {
            int commaPosition;
            int keyValueSep1 = recordKey.indexOf(DEFAULT_COLUMN_VALUE_SEPARATOR, processed);
            String currentField = recordKey.substring(processed, keyValueSep1);
            int keyValueSep2 = recordKey.indexOf(DEFAULT_COLUMN_VALUE_SEPARATOR, keyValueSep1 + 1);
            if (fields.isEmpty() || fields.size() == 1 && fields.get(0).isEmpty() || fields.contains(currentField)) {
                String currentValue;
                if (keyValueSep2 < 0) {
                    currentValue = recordKey.substring(keyValueSep1 + 1);
                    processed = recordKey.length();
                } else {
                    commaPosition = recordKey.lastIndexOf(DEFAULT_RECORD_KEY_PARTS_SEPARATOR, keyValueSep2);
                    while (commaPosition < keyValueSep1 && keyValueSep2 > 0) {
                        keyValueSep2 = recordKey.indexOf(DEFAULT_COLUMN_VALUE_SEPARATOR, keyValueSep2 + 1);
                        commaPosition = recordKey.lastIndexOf(DEFAULT_RECORD_KEY_PARTS_SEPARATOR, keyValueSep2);
                    }
                    if (commaPosition > 0) {
                        currentValue = recordKey.substring(keyValueSep1 + 1, commaPosition);
                        processed = commaPosition + 1;
                    } else {
                        currentValue = recordKey.substring(keyValueSep1 + 1);
                        processed = recordKey.length();
                    }
                }
                if (currentValue.equals(NULL_RECORDKEY_PLACEHOLDER)) {
                    values2.add(null);
                    continue;
                }
                if (currentValue.equals(EMPTY_RECORDKEY_PLACEHOLDER)) {
                    values2.add("");
                    continue;
                }
                values2.add(currentValue);
                continue;
            }
            if (keyValueSep2 < 0) {
                processed = recordKey.length();
                continue;
            }
            commaPosition = recordKey.lastIndexOf(DEFAULT_RECORD_KEY_PARTS_SEPARATOR, keyValueSep2);
            while (commaPosition < keyValueSep1) {
                keyValueSep2 = recordKey.indexOf(DEFAULT_COLUMN_VALUE_SEPARATOR, keyValueSep2 + 1);
                commaPosition = recordKey.lastIndexOf(DEFAULT_RECORD_KEY_PARTS_SEPARATOR, keyValueSep2);
            }
            if (commaPosition < 0) {
                processed = recordKey.length();
                continue;
            }
            processed = commaPosition + 1;
        }
        if (values2.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = recordKey;
        } else {
            stringArray = values2.toArray(new String[0]);
        }
        return stringArray;
    }

    public static String getRecordKey(GenericRecord record, List<String> recordKeyFields, boolean consistentLogicalTimestampEnabled) {
        boolean keyIsNullEmpty = true;
        StringBuilder recordKey = new StringBuilder();
        for (int i = 0; i < recordKeyFields.size(); ++i) {
            String recordKeyValue;
            String recordKeyField = recordKeyFields.get(i);
            try {
                recordKeyValue = HoodieAvroUtils.getNestedFieldValAsString(record, recordKeyField, false, consistentLogicalTimestampEnabled);
            }
            catch (HoodieException e) {
                throw new HoodieKeyException("Record key field '" + recordKeyField + "' does not exist in the input record");
            }
            if (recordKeyValue == null) {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(NULL_RECORDKEY_PLACEHOLDER);
            } else if (recordKeyValue.isEmpty()) {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(EMPTY_RECORDKEY_PLACEHOLDER);
            } else {
                recordKey.append(recordKeyField).append(DEFAULT_COLUMN_VALUE_SEPARATOR).append(recordKeyValue);
                keyIsNullEmpty = false;
            }
            if (i == recordKeyFields.size() - 1) continue;
            recordKey.append(DEFAULT_RECORD_KEY_PARTS_SEPARATOR);
        }
        if (keyIsNullEmpty) {
            throw new HoodieKeyException("recordKey values: \"" + recordKey + "\" for fields: " + recordKeyFields + " cannot be entirely null or empty.");
        }
        return recordKey.toString();
    }

    public static String getRecordPartitionPath(GenericRecord record, List<String> partitionPathFields, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        if (partitionPathFields.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < partitionPathFields.size(); ++i) {
            String partitionPathField = partitionPathFields.get(i);
            String fieldVal = HoodieAvroUtils.getNestedFieldValAsString(record, partitionPathField, true, consistentLogicalTimestampEnabled);
            if (fieldVal == null || fieldVal.isEmpty()) {
                if (hiveStylePartitioning) {
                    partitionPath.append(partitionPathField).append("=");
                }
                partitionPath.append(HUDI_DEFAULT_PARTITION_PATH);
            } else {
                if (encodePartitionPath) {
                    fieldVal = PartitionPathEncodeUtils.escapePathName(fieldVal);
                }
                if (hiveStylePartitioning) {
                    partitionPath.append(partitionPathField).append("=");
                }
                partitionPath.append(fieldVal);
            }
            if (i == partitionPathFields.size() - 1) continue;
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        return partitionPath.toString();
    }

    public static String getRecordKey(GenericRecord record, String recordKeyField, boolean consistentLogicalTimestampEnabled) {
        String recordKey = HoodieAvroUtils.getNestedFieldValAsString(record, recordKeyField, true, consistentLogicalTimestampEnabled);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + recordKeyField + "\" cannot be null or empty.");
        }
        return recordKey;
    }

    public static String getPartitionPath(GenericRecord record, String partitionPathField, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        String partitionPath = HoodieAvroUtils.getNestedFieldValAsString(record, partitionPathField, true, consistentLogicalTimestampEnabled);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = HUDI_DEFAULT_PARTITION_PATH;
        }
        if (encodePartitionPath) {
            partitionPath = PartitionPathEncodeUtils.escapePathName(partitionPath);
        }
        if (hiveStylePartitioning) {
            partitionPath = partitionPathField + "=" + partitionPath;
        }
        return partitionPath;
    }

    public static BaseHoodieDateTimeParser createDateTimeParser(TypedProperties props, String parserClass) throws IOException {
        try {
            return (BaseHoodieDateTimeParser)ReflectionUtils.loadClass(parserClass, props);
        }
        catch (Throwable e) {
            throw new IOException("Could not load date time parser class " + parserClass, e);
        }
    }

    public static KeyGenerator createKeyGeneratorByClassName(TypedProperties props) throws IOException {
        KeyGenerator keyGenerator = null;
        String keyGeneratorClass = props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), null);
        if (!StringUtils.isNullOrEmpty(keyGeneratorClass)) {
            try {
                keyGenerator = (KeyGenerator)ReflectionUtils.loadClass(keyGeneratorClass, props);
            }
            catch (Throwable e) {
                throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
            }
        }
        return keyGenerator;
    }

    public static List<String> getRecordKeyFields(TypedProperties props) {
        return Option.ofNullable(props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(DEFAULT_RECORD_KEY_PARTS_SEPARATOR)).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean isAutoGeneratedRecordKeysEnabled(TypedProperties props) {
        return !props.containsKey(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()) || props.getProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).equals("");
    }
}

