/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.merge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.spark.sql.HoodieInternalRowUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkRecordMergingUtils {
    private static final Map<Schema, Map<Integer, StructField>> FIELD_ID_TO_FIELD_MAPPING_CACHE = new ConcurrentHashMap<Schema, Map<Integer, StructField>>();
    private static final Map<Schema, Map<String, Integer>> FIELD_NAME_TO_ID_MAPPING_CACHE = new ConcurrentHashMap<Schema, Map<String, Integer>>();
    private static final Map<Pair<Pair<Schema, Schema>, Schema>, Pair<Map<Integer, StructField>, Pair<StructType, Schema>>> MERGED_SCHEMA_CACHE = new ConcurrentHashMap<Pair<Pair<Schema, Schema>, Schema>, Pair<Map<Integer, StructField>, Pair<StructType, Schema>>>();

    public static Pair<HoodieRecord, Schema> mergePartialRecords(HoodieSparkRecord older, Schema oldSchema, HoodieSparkRecord newer, Schema newSchema, Schema readerSchema, TypedProperties props) {
        Pair<Map<Integer, StructField>, Pair<StructType, Schema>> mergedSchemaPair = SparkRecordMergingUtils.getCachedMergedSchema(oldSchema, newSchema, readerSchema);
        boolean isNewerPartial = SparkRecordMergingUtils.isPartial(newSchema, mergedSchemaPair.getRight().getRight());
        if (isNewerPartial) {
            InternalRow oldRow = (InternalRow)older.getData();
            InternalRow newPartialRow = (InternalRow)newer.getData();
            Map<Integer, StructField> mergedIdToFieldMapping = mergedSchemaPair.getLeft();
            Map<String, Integer> oldNameToIdMapping = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(oldSchema);
            Map<String, Integer> newPartialNameToIdMapping = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(newSchema);
            ArrayList<Object> values2 = new ArrayList<Object>(mergedIdToFieldMapping.size());
            for (int fieldId = 0; fieldId < mergedIdToFieldMapping.size(); ++fieldId) {
                StructField structField = mergedIdToFieldMapping.get(fieldId);
                Integer ordInPartialUpdate = newPartialNameToIdMapping.get(structField.name());
                if (ordInPartialUpdate != null) {
                    values2.add(newPartialRow.get(ordInPartialUpdate.intValue(), structField.dataType()));
                    continue;
                }
                values2.add(oldRow.get(oldNameToIdMapping.get(structField.name()).intValue(), structField.dataType()));
            }
            GenericInternalRow mergedRow = new GenericInternalRow(values2.toArray());
            HoodieSparkRecord mergedSparkRecord = new HoodieSparkRecord((InternalRow)mergedRow, mergedSchemaPair.getRight().getLeft());
            return Pair.of(mergedSparkRecord, mergedSchemaPair.getRight().getRight());
        }
        return Pair.of(newer, newSchema);
    }

    public static Map<Integer, StructField> getCachedFieldIdToFieldMapping(Schema avroSchema) {
        return FIELD_ID_TO_FIELD_MAPPING_CACHE.computeIfAbsent(avroSchema, schema -> {
            StructType structType = HoodieInternalRowUtils.getCachedSchema(schema);
            HashMap<Integer, StructField> schemaFieldIdMapping = new HashMap<Integer, StructField>();
            int fieldId = 0;
            for (StructField field : structType.fields()) {
                schemaFieldIdMapping.put(fieldId, field);
                ++fieldId;
            }
            return schemaFieldIdMapping;
        });
    }

    public static Map<String, Integer> getCachedFieldNameToIdMapping(Schema avroSchema) {
        return FIELD_NAME_TO_ID_MAPPING_CACHE.computeIfAbsent(avroSchema, schema -> {
            StructType structType = HoodieInternalRowUtils.getCachedSchema(schema);
            HashMap<String, Integer> schemaFieldIdMapping = new HashMap<String, Integer>();
            int fieldId = 0;
            for (StructField field : structType.fields()) {
                schemaFieldIdMapping.put(field.name(), fieldId);
                ++fieldId;
            }
            return schemaFieldIdMapping;
        });
    }

    public static Pair<Map<Integer, StructField>, Pair<StructType, Schema>> getCachedMergedSchema(Schema oldSchema, Schema newSchema, Schema readerSchema) {
        return MERGED_SCHEMA_CACHE.computeIfAbsent(Pair.of(Pair.of(oldSchema, newSchema), readerSchema), schemaPair -> {
            Schema schema1 = (Schema)((Pair)schemaPair.getLeft()).getLeft();
            Schema schema2 = (Schema)((Pair)schemaPair.getLeft()).getRight();
            Schema refSchema = (Schema)schemaPair.getRight();
            Map<String, Integer> nameToIdMapping1 = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(schema1);
            Map<String, Integer> nameToIdMapping2 = SparkRecordMergingUtils.getCachedFieldNameToIdMapping(schema2);
            Map<Integer, StructField> refFieldIdToFieldMapping = SparkRecordMergingUtils.getCachedFieldIdToFieldMapping(refSchema);
            HashSet<String> fieldNameSet = new HashSet<String>();
            fieldNameSet.addAll(nameToIdMapping1.keySet());
            fieldNameSet.addAll(nameToIdMapping2.keySet());
            int fieldId = 0;
            HashMap<Integer, StructField> mergedMapping = new HashMap<Integer, StructField>();
            ArrayList<StructField> mergedFieldList = new ArrayList<StructField>();
            for (int i = 0; i < refFieldIdToFieldMapping.size(); ++i) {
                StructField field = refFieldIdToFieldMapping.get(i);
                if (!fieldNameSet.contains(field.name())) continue;
                mergedMapping.put(fieldId, field);
                mergedFieldList.add(field);
                ++fieldId;
            }
            StructType mergedStructType = new StructType(mergedFieldList.toArray(new StructField[0]));
            Schema mergedSchema = AvroConversionUtils.convertStructTypeToAvroSchema((DataType)mergedStructType, readerSchema.getName(), readerSchema.getNamespace());
            return Pair.of(mergedMapping, Pair.of(mergedStructType, mergedSchema));
        });
    }

    public static boolean isPartial(Schema schema, Schema mergedSchema) {
        return !schema.equals((Object)mergedSchema);
    }
}

