/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.avro.Schema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;

@ThreadSafe
public class HoodieMetadataLogRecordReader
implements Closeable {
    private final HoodieMergedLogRecordScanner logRecordScanner;

    private HoodieMetadataLogRecordReader(HoodieMergedLogRecordScanner logRecordScanner) {
        this.logRecordScanner = logRecordScanner;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HoodieRecord<HoodieMetadataPayload>> getRecords() {
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scan();
            return this.logRecordScanner.getRecords().values().stream().map(record -> record).collect(Collectors.toList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HoodieRecord<HoodieMetadataPayload>> getRecordsByKeyPrefixes(List<String> sortedKeyPrefixes) {
        if (sortedKeyPrefixes.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scanByKeyPrefixes(sortedKeyPrefixes);
            Predicate<String> p = HoodieMetadataLogRecordReader.createPrefixMatchingPredicate(sortedKeyPrefixes);
            return this.logRecordScanner.getRecords().entrySet().stream().filter(r -> r != null && p.test((String)r.getKey())).map(r -> (HoodieRecord)r.getValue()).collect(Collectors.toMap(HoodieRecord::getRecordKey, r -> r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HoodieRecord<HoodieMetadataPayload>> getRecordsByKeys(List<String> sortedKeys) {
        if (sortedKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scanByFullKeys(sortedKeys);
            Map<String, HoodieRecord> allRecords = this.logRecordScanner.getRecords();
            return sortedKeys.stream().map(key -> (HoodieRecord)allRecords.get(key)).filter(Objects::nonNull).collect(Collectors.toMap(HoodieRecord::getRecordKey, r -> r, (r1, r2) -> r2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<HoodieRecord<HoodieMetadataPayload>>> getAllRecordsByKeys(List<String> sortedKeys) {
        if (sortedKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HoodieMetadataLogRecordReader hoodieMetadataLogRecordReader = this;
        synchronized (hoodieMetadataLogRecordReader) {
            this.logRecordScanner.scanByFullKeys(sortedKeys);
            Map<String, HoodieRecord> allRecords = this.logRecordScanner.getRecords();
            return sortedKeys.stream().map(key -> (HoodieRecord)allRecords.get(key)).filter(Objects::nonNull).collect(Collectors.groupingBy(HoodieRecord::getRecordKey));
        }
    }

    @Override
    public void close() throws IOException {
        this.logRecordScanner.close();
    }

    private static Predicate<String> createPrefixMatchingPredicate(List<String> keyPrefixes) {
        if (keyPrefixes.size() == 1) {
            String keyPrefix = keyPrefixes.get(0);
            return key -> key.startsWith(keyPrefix);
        }
        return key -> keyPrefixes.stream().anyMatch(key::startsWith);
    }

    public static class Builder {
        private final HoodieMergedLogRecordScanner.Builder scannerBuilder = new HoodieMergedLogRecordScanner.Builder().withKeyFieldOverride("key").withReverseReader(false).withOperationField(false);

        public Builder withStorage(HoodieStorage storage) {
            this.scannerBuilder.withStorage(storage);
            return this;
        }

        public Builder withBasePath(String basePath) {
            this.scannerBuilder.withBasePath(basePath);
            return this;
        }

        public Builder withBasePath(StoragePath basePath) {
            this.scannerBuilder.withBasePath(basePath);
            return this;
        }

        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.scannerBuilder.withLogFilePaths((List)logFilePaths);
            return this;
        }

        public Builder withReaderSchema(Schema schema) {
            this.scannerBuilder.withReaderSchema(schema);
            return this;
        }

        public Builder withLatestInstantTime(String latestInstantTime) {
            this.scannerBuilder.withLatestInstantTime(latestInstantTime);
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.scannerBuilder.withBufferSize(bufferSize);
            return this;
        }

        public Builder withPartition(String partitionName) {
            this.scannerBuilder.withPartition(partitionName);
            return this;
        }

        public Builder withMaxMemorySizeInBytes(Long maxMemorySizeInBytes) {
            this.scannerBuilder.withMaxMemorySizeInBytes(maxMemorySizeInBytes);
            return this;
        }

        public Builder withSpillableMapBasePath(String spillableMapBasePath) {
            this.scannerBuilder.withSpillableMapBasePath(spillableMapBasePath);
            return this;
        }

        public Builder withDiskMapType(ExternalSpillableMap.DiskMapType diskMapType) {
            this.scannerBuilder.withDiskMapType(diskMapType);
            return this;
        }

        public Builder withBitCaskDiskMapCompressionEnabled(boolean isBitCaskDiskMapCompressionEnabled) {
            this.scannerBuilder.withBitCaskDiskMapCompressionEnabled(isBitCaskDiskMapCompressionEnabled);
            return this;
        }

        public Builder withLogBlockTimestamps(Set<String> validLogBlockTimestamps) {
            InstantRange instantRange = InstantRange.builder().rangeType(InstantRange.RangeType.EXACT_MATCH).explicitInstants(validLogBlockTimestamps).build();
            this.scannerBuilder.withInstantRange((Option)Option.of(instantRange));
            return this;
        }

        public Builder enableFullScan(boolean enableFullScan) {
            this.scannerBuilder.withForceFullScan(enableFullScan);
            return this;
        }

        public Builder withEnableOptimizedLogBlocksScan(boolean enableOptimizedLogBlocksScan) {
            this.scannerBuilder.withOptimizedLogBlocksScan(enableOptimizedLogBlocksScan);
            return this;
        }

        public Builder withTableMetaClient(HoodieTableMetaClient hoodieTableMetaClient) {
            this.scannerBuilder.withTableMetaClient(hoodieTableMetaClient);
            return this;
        }

        public HoodieMetadataLogRecordReader build() {
            return new HoodieMetadataLogRecordReader(this.scannerBuilder.build());
        }
    }
}

