/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.utils.FileSliceMetricUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.IncrementalPartitionAwareStrategy;

public abstract class CompactionStrategy
implements IncrementalPartitionAwareStrategy,
Serializable {
    public static final String TOTAL_IO_READ_MB = "TOTAL_IO_READ_MB";
    public static final String TOTAL_IO_WRITE_MB = "TOTAL_IO_WRITE_MB";
    public static final String TOTAL_IO_MB = "TOTAL_IO_MB";
    public static final String TOTAL_LOG_FILE_SIZE = "TOTAL_LOG_FILES_SIZE";
    public static final String TOTAL_LOG_FILES = "TOTAL_LOG_FILES";

    public Map<String, Double> captureMetrics(HoodieWriteConfig writeConfig, FileSlice slice) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        long defaultMaxParquetFileSize = writeConfig.getParquetMaxFileSize();
        FileSliceMetricUtils.addFileSliceCommonMetrics(Collections.singletonList(slice), metrics, defaultMaxParquetFileSize);
        return metrics;
    }

    public HoodieCompactionPlan generateCompactionPlan(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans, Map<String, String> params, Pair<List<String>, List<String>> partitionPair) {
        Pair<List<HoodieCompactionOperation>, List<String>> resPair = this.orderAndFilter(writeConfig, operations, pendingCompactionPlans);
        List<HoodieCompactionOperation> operationsToProcess = resPair.getLeft();
        List<String> missingPartitions = resPair.getRight();
        missingPartitions.addAll((Collection<String>)partitionPair.getRight());
        List<String> res = writeConfig.isIncrementalTableServiceEnabled() ? missingPartitions.stream().distinct().collect(Collectors.toList()) : null;
        return HoodieCompactionPlan.newBuilder().setOperations(operationsToProcess).setMissingSchedulePartitions(res).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).build();
    }

    public Pair<List<HoodieCompactionOperation>, List<String>> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        return Pair.of(operations, Collections.emptyList());
    }

    @Override
    public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> allPartitionPaths) {
        return Pair.of(allPartitionPaths, Collections.emptyList());
    }
}

