/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.HoodieSqlCommonUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ProvidesHoodieConfig$ {
    public static ProvidesHoodieConfig$ MODULE$;
    private final Logger log;

    static {
        new ProvidesHoodieConfig$();
    }

    private Logger log() {
        return this.log;
    }

    public Map<String, String> combineOptions(HoodieCatalogTable catalogTable, HoodieTableConfig tableConfig, SQLConf sqlConf, Map<String, String> defaultOpts, Map<String, String> overridingOpts) {
        return this.filterNullValues(defaultOpts).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).toMap(Predef$.MODULE$.$conforms())).$plus$plus(HoodieOptionConfig$.MODULE$.mapSqlOptionsToDataSourceWriteConfigs(catalogTable.catalogProperties())).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)tableConfig.getProps()).asScala()).toMap(Predef$.MODULE$.$conforms())).$plus$plus(HoodieSqlCommonUtils$.MODULE$.filterHoodieConfigs((Map<String, String>)sqlConf.getAllConfs())).$plus$plus(this.filterNullValues(overridingOpts));
    }

    public Map<String, String> combineOptions$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public String getPartitionPathFieldWriteConfig(String tableConfigKeyGeneratorClassName, String partitionFieldNamesWithoutKeyGenType, HoodieCatalogTable catalogTable) {
        if (StringUtils.isNullOrEmpty(tableConfigKeyGeneratorClassName)) {
            return partitionFieldNamesWithoutKeyGenType;
        }
        Option writeConfigPartitionField = catalogTable.catalogProperties().get((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key());
        Class<?> keyGenClass = ReflectionUtils.getClass(tableConfigKeyGeneratorClassName);
        if (CustomKeyGenerator.class.equals(keyGenClass) || CustomAvroKeyGenerator.class.equals(keyGenClass)) {
            String partitionFieldWithKeyGenType = HoodieTableConfig.getPartitionFieldPropForKeyGenerator(catalogTable.tableConfig()).orElse("");
            if (writeConfigPartitionField.isDefined()) {
                return (String)writeConfigPartitionField.get();
            }
            if (StringUtils.nonEmpty(partitionFieldWithKeyGenType)) {
                return partitionFieldWithKeyGenType;
            }
            this.log().warn("Write config \"hoodie.datasource.write.partitionpath.field\" is not set for custom key generator. This may fail the write operation.");
            return partitionFieldNamesWithoutKeyGenType;
        }
        return partitionFieldNamesWithoutKeyGenType;
    }

    public boolean isSchemaEvolutionEnabled(SparkSession sparkSession) {
        return new StringOps(Predef$.MODULE$.augmentString(sparkSession.sessionState().conf().getConfString(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key(), DFSPropertiesConfiguration.getGlobalProps().getString(HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.key(), HoodieCommonConfig.SCHEMA_EVOLUTION_ENABLE.defaultValue().toString())))).toBoolean();
    }

    private Map<String, String> filterNullValues(Map<String, String> opts) {
        return (Map)opts.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ProvidesHoodieConfig$.$anonfun$filterNullValues$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$filterNullValues$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String v = (String)tuple2._2();
            return v != null;
        }
        throw new MatchError((Object)tuple2);
    }

    private ProvidesHoodieConfig$() {
        MODULE$ = this;
        this.log = LoggerFactory.getLogger(this.getClass());
    }
}

