/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.plugin.metrics;

import io.javalin.Javalin;
import io.javalin.core.event.EventListener;
import io.javalin.core.plugin.Plugin;
import io.javalin.core.util.OptionalDependency;
import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.HandlerType;
import io.javalin.jetty.JettyServer;
import io.javalin.plugin.metrics.MicrometerPlugin;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.http.DefaultHttpServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.http.HttpServletRequestTagsProvider;
import io.micrometer.core.instrument.binder.jetty.JettyConnectionMetrics;
import io.micrometer.core.instrument.binder.jetty.JettyServerThreadPoolMetrics;
import io.micrometer.core.instrument.binder.jetty.TimedHandler;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.hudi.javax.servlet.http.HttpServletRequest;
import org.apache.hudi.javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.jetty.server.Server;
import org.apache.hudi.org.apache.jetty.server.handler.HandlerWrapper;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B?\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0014\u0010\u0010\u001a\u00020\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/javalin/plugin/metrics/MicrometerPlugin;", "Lio/javalin/core/plugin/Plugin;", "registry", "Lio/micrometer/core/instrument/MeterRegistry;", "tags", "", "Lio/micrometer/core/instrument/Tag;", "tagExceptionName", "", "tagRedirectPaths", "tagNotFoundMappedPaths", "(Lio/micrometer/core/instrument/MeterRegistry;Ljava/lang/Iterable;ZZZ)V", "apply", "", "app", "Lio/javalin/Javalin;", "prefixIfNot", "", "prefix", "Companion", "javalin"})
public final class MicrometerPlugin
implements Plugin {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MeterRegistry registry;
    @NotNull
    private final Iterable<Tag> tags;
    private final boolean tagExceptionName;
    private final boolean tagRedirectPaths;
    private final boolean tagNotFoundMappedPaths;
    @NotNull
    private static final String EXCEPTION_HEADER = "__micrometer_exception_name";
    @NotNull
    private static ExceptionHandler<Exception> EXCEPTION_HANDLER = MicrometerPlugin::EXCEPTION_HANDLER$lambda-4;

    @JvmOverloads
    public MicrometerPlugin(@NotNull MeterRegistry registry, @NotNull Iterable<? extends Tag> tags, boolean tagExceptionName, boolean tagRedirectPaths, boolean tagNotFoundMappedPaths) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this.registry = registry;
        this.tags = tags;
        this.tagExceptionName = tagExceptionName;
        this.tagRedirectPaths = tagRedirectPaths;
        this.tagNotFoundMappedPaths = tagNotFoundMappedPaths;
    }

    public /* synthetic */ MicrometerPlugin(MeterRegistry meterRegistry, Iterable iterable, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        CompositeMeterRegistry compositeMeterRegistry;
        if ((n & 1) != 0) {
            compositeMeterRegistry = Metrics.globalRegistry;
            Intrinsics.checkNotNullExpressionValue(compositeMeterRegistry, "globalRegistry");
            meterRegistry = (MeterRegistry)compositeMeterRegistry;
        }
        if ((n & 2) != 0) {
            compositeMeterRegistry = Tags.empty();
            Intrinsics.checkNotNullExpressionValue(compositeMeterRegistry, "empty()");
            iterable = (Iterable)compositeMeterRegistry;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = false;
        }
        this(meterRegistry, iterable, bl, bl2, bl3);
    }

    @Override
    public void apply(@NotNull Javalin app) {
        Server server;
        Intrinsics.checkNotNullParameter(app, "app");
        Util.ensureDependencyPresent$default(Util.INSTANCE, OptionalDependency.MICROMETER, false, 2, null);
        JettyServer jettyServer = app.jettyServer();
        if (jettyServer != null && (server = jettyServer.server()) != null) {
            Server server2 = server;
            boolean bl = false;
            boolean bl2 = false;
            Server server3 = server2;
            boolean bl3 = false;
            if (this.tagExceptionName) {
                app.exception(Exception.class, EXCEPTION_HANDLER);
            }
            server3.insertHandler((HandlerWrapper)new TimedHandler(this.registry, this.tags, (HttpServletRequestTagsProvider)new DefaultHttpServletRequestTagsProvider(this, app){
                final /* synthetic */ MicrometerPlugin this$0;
                final /* synthetic */ Javalin $app;
                {
                    this.this$0 = $receiver;
                    this.$app = $app;
                }

                @NotNull
                public Iterable<Tag> getTags(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
                    Intrinsics.checkNotNullParameter(request, "request");
                    Intrinsics.checkNotNullParameter(response, "response");
                    String exceptionName = MicrometerPlugin.access$getTagExceptionName$p(this.this$0) ? response.getHeader("__micrometer_exception_name") : "Unknown";
                    String string = request.getPathInfo();
                    Intrinsics.checkNotNullExpressionValue(string, "request.pathInfo");
                    String string2 = string;
                    string = this.$app._conf.contextPath;
                    Intrinsics.checkNotNullExpressionValue(string, "app._conf.contextPath");
                    String pathInfo = MicrometerPlugin.access$prefixIfNot(this.this$0, StringsKt.removePrefix(string2, (CharSequence)string), "/");
                    response.setHeader("__micrometer_exception_name", null);
                    String string3 = request.getMethod();
                    Intrinsics.checkNotNullExpressionValue(string3, "request.method");
                    HandlerType handlerType = HandlerType.valueOf(string3);
                    String string4 = (String)SequencesKt.firstOrNull(SequencesKt.map(SequencesKt.map(SequencesKt.map(SequencesKt.map(CollectionsKt.asSequence((Iterable)this.$app.javalinServlet().getMatcher().findEntries(handlerType, pathInfo)), apply.1.getTags.uri.1.INSTANCE), apply.1.getTags.uri.2.INSTANCE), (Function1)new Function1<String, String>(this.this$0, response){
                        final /* synthetic */ MicrometerPlugin this$0;
                        final /* synthetic */ HttpServletResponse $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                            super(1);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            if (!MicrometerPlugin.access$getTagRedirectPaths$p(this.this$0)) {
                                boolean bl;
                                int n = this.$response.getStatus();
                                if (300 <= n) {
                                    if (n <= 399) {
                                        return "REDIRECTION";
                                    }
                                    bl = false;
                                } else {
                                    bl = false;
                                }
                                if (bl) {
                                    return "REDIRECTION";
                                }
                            }
                            String string = it;
                            return string;
                        }
                    }), (Function1)new Function1<String, String>(this.this$0, response){
                        final /* synthetic */ MicrometerPlugin this$0;
                        final /* synthetic */ HttpServletResponse $response;
                        {
                            this.this$0 = $receiver;
                            this.$response = $response;
                            super(1);
                        }

                        @NotNull
                        public final String invoke(@NotNull String it) {
                            Intrinsics.checkNotNullParameter(it, "it");
                            return !MicrometerPlugin.access$getTagNotFoundMappedPaths$p(this.this$0) && this.$response.getStatus() == 404 ? "NOT_FOUND" : it;
                        }
                    }));
                    String uri2 = string4 == null ? "NOT_FOUND" : string4;
                    String[] stringArray = new String[4];
                    stringArray[0] = "uri";
                    stringArray[1] = uri2;
                    stringArray[2] = "exception";
                    String string5 = exceptionName;
                    stringArray[3] = string5 == null ? "None" : string5;
                    string4 = Tags.concat((Iterable)super.getTags(request, response), (String[])stringArray);
                    Intrinsics.checkNotNullExpressionValue(string4, "concat(\n                \u2026ne\"\n                    )");
                    return (Iterable)((Object)string4);
                }
            }));
            new JettyServerThreadPoolMetrics(server3.getThreadPool(), this.tags).bindTo(this.registry);
            app.events(arg_0 -> MicrometerPlugin.apply$lambda-2$lambda-1(server3, this, arg_0));
        }
    }

    private final String prefixIfNot(String $this$prefixIfNot, String prefix) {
        return StringsKt.startsWith$default($this$prefixIfNot, prefix, false, 2, null) ? $this$prefixIfNot : Intrinsics.stringPlus(prefix, $this$prefixIfNot);
    }

    @JvmOverloads
    public MicrometerPlugin(@NotNull MeterRegistry registry, @NotNull Iterable<? extends Tag> tags, boolean tagExceptionName, boolean tagRedirectPaths) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this(registry, tags, tagExceptionName, tagRedirectPaths, false, 16, null);
    }

    @JvmOverloads
    public MicrometerPlugin(@NotNull MeterRegistry registry, @NotNull Iterable<? extends Tag> tags, boolean tagExceptionName) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this(registry, tags, tagExceptionName, false, false, 24, null);
    }

    @JvmOverloads
    public MicrometerPlugin(@NotNull MeterRegistry registry, @NotNull Iterable<? extends Tag> tags) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        Intrinsics.checkNotNullParameter(tags, "tags");
        this(registry, tags, false, false, false, 28, null);
    }

    @JvmOverloads
    public MicrometerPlugin(@NotNull MeterRegistry registry) {
        Intrinsics.checkNotNullParameter(registry, "registry");
        this(registry, null, false, false, false, 30, null);
    }

    @JvmOverloads
    public MicrometerPlugin() {
        this(null, null, false, false, false, 31, null);
    }

    private static final void apply$lambda-2$lambda-1$lambda-0(Server $server, MicrometerPlugin this$0) {
        Intrinsics.checkNotNullParameter($server, "$server");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        JettyConnectionMetrics.addToAllConnectors((Server)$server, (MeterRegistry)this$0.registry, this$0.tags);
    }

    private static final void apply$lambda-2$lambda-1(Server $server, MicrometerPlugin this$0, EventListener it) {
        Intrinsics.checkNotNullParameter($server, "$server");
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        it.serverStarted(() -> MicrometerPlugin.apply$lambda-2$lambda-1$lambda-0($server, this$0));
    }

    private static final void EXCEPTION_HANDLER$lambda-4(Exception e, Context ctx) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter(e, "e");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        String simpleName = e.getClass().getSimpleName();
        Context context = ctx;
        String string = EXCEPTION_HEADER;
        CharSequence charSequence2 = simpleName;
        boolean bl = false;
        if (StringsKt.isBlank(charSequence2)) {
            String string2 = string;
            Context context2 = context;
            boolean bl2 = false;
            String string3 = e.getClass().getName();
            context = context2;
            string = string2;
            charSequence = string3;
        } else {
            charSequence = charSequence2;
        }
        CharSequence charSequence3 = charSequence;
        Intrinsics.checkNotNullExpressionValue(charSequence3, "simpleName.ifBlank { e.javaClass.name }");
        context.header(string, (String)charSequence3);
        ctx.status(500);
    }

    public static final /* synthetic */ boolean access$getTagExceptionName$p(MicrometerPlugin $this) {
        return $this.tagExceptionName;
    }

    public static final /* synthetic */ String access$prefixIfNot(MicrometerPlugin $this, String $receiver, String prefix) {
        return $this.prefixIfNot($receiver, prefix);
    }

    public static final /* synthetic */ boolean access$getTagRedirectPaths$p(MicrometerPlugin $this) {
        return $this.tagRedirectPaths;
    }

    public static final /* synthetic */ boolean access$getTagNotFoundMappedPaths$p(MicrometerPlugin $this) {
        return $this.tagNotFoundMappedPaths;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/javalin/plugin/metrics/MicrometerPlugin$Companion;", "", "()V", "EXCEPTION_HANDLER", "Lio/javalin/http/ExceptionHandler;", "Ljava/lang/Exception;", "getEXCEPTION_HANDLER", "()Lio/javalin/http/ExceptionHandler;", "setEXCEPTION_HANDLER", "(Lio/javalin/http/ExceptionHandler;)V", "EXCEPTION_HEADER", "", "javalin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExceptionHandler<Exception> getEXCEPTION_HANDLER() {
            return EXCEPTION_HANDLER;
        }

        public final void setEXCEPTION_HANDLER(@NotNull ExceptionHandler<Exception> exceptionHandler) {
            Intrinsics.checkNotNullParameter(exceptionHandler, "<set-?>");
            EXCEPTION_HANDLER = exceptionHandler;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

