/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.validator;

import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.validator.SparkPreCommitValidator;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieValidationException;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlQueryPreCommitValidator<T, I, K, O extends HoodieData<WriteStatus>>
extends SparkPreCommitValidator<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(SqlQueryPreCommitValidator.class);
    private static final AtomicInteger TABLE_COUNTER = new AtomicInteger(0);

    public SqlQueryPreCommitValidator(HoodieSparkTable<T> table, HoodieEngineContext engineContext, HoodieWriteConfig config) {
        super(table, engineContext, config);
    }

    @Override
    public void validateRecordsBeforeAndAfter(Dataset<Row> before, Dataset<Row> after, Set<String> partitionsAffected) {
        String hoodieTableName = "staged_table_" + TABLE_COUNTER.incrementAndGet();
        String hoodieTableBeforeCurrentCommit = hoodieTableName + "_before";
        String hoodieTableWithInflightCommit = hoodieTableName + "_after";
        before.registerTempTable(hoodieTableBeforeCurrentCommit);
        after.registerTempTable(hoodieTableWithInflightCommit);
        JavaSparkContext jsc = HoodieSparkEngineContext.getSparkContext(this.getEngineContext());
        SQLContext sqlContext = new SQLContext(jsc);
        String[] queries = this.getQueriesToRun();
        Arrays.asList(queries).parallelStream().forEach(query -> this.validateUsingQuery((String)query, hoodieTableBeforeCurrentCommit, hoodieTableWithInflightCommit, sqlContext));
    }

    protected String[] getQueriesToRun() {
        String sqlQueriesConfigured = this.getWriteConfig().getProps().getProperty(this.getQueryConfigName());
        if (StringUtils.isNullOrEmpty(sqlQueriesConfigured)) {
            throw new HoodieValidationException("Sql validator configured incorrectly. expecting at least one query. Found 0 queries in " + sqlQueriesConfigured);
        }
        return sqlQueriesConfigured.trim().split(";");
    }

    protected void printAllRowsIfDebugEnabled(Dataset<Row> dataset) {
        if (LOG.isDebugEnabled()) {
            dataset = dataset.cache();
            LOG.debug("Printing all rows from query validation:");
            dataset.show(Integer.MAX_VALUE, false);
        }
    }

    protected abstract String getQueryConfigName();

    protected abstract void validateUsingQuery(String var1, String var2, String var3, SQLContext var4);
}

