/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.serialization;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.serialization.CustomSerializer;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.SerializationUtils;

public class HoodieFileGroupSerializer
implements CustomSerializer<List<HoodieFileGroup>> {
    private final Map<HoodieFileGroupId, HoodieTimeline> fileGroupIdHoodieTimelineMap = new ConcurrentHashMap<HoodieFileGroupId, HoodieTimeline>();

    @Override
    public byte[] serialize(List<HoodieFileGroup> input) throws IOException {
        List fileGroupLites = input.stream().map(fileGroup -> {
            if (fileGroup.getTimeline() == null) {
                throw new IllegalStateException("Timeline is null for FileGroup: '" + fileGroup.getFileGroupId().toString() + "'. All filegroup states: [" + input.stream().map(fg -> fg.getFileGroupId().toString() + ":" + (fg.getTimeline() == null ? "NULL" : "OK")).collect(Collectors.joining(",")) + "]");
            }
            this.fileGroupIdHoodieTimelineMap.put(fileGroup.getFileGroupId(), fileGroup.getTimeline());
            return new HoodieFileGroupLite(fileGroup.getAllRawFileSlices().collect(Collectors.toList()), fileGroup.getFileGroupId());
        }).collect(Collectors.toList());
        return SerializationUtils.serialize(fileGroupLites);
    }

    @Override
    public List<HoodieFileGroup> deserialize(byte[] bytes) {
        List fileGroupLites = (List)SerializationUtils.deserialize(bytes);
        return fileGroupLites.stream().map(fileGroupLite -> {
            HoodieTimeline timeline = this.fileGroupIdHoodieTimelineMap.get(((HoodieFileGroupLite)fileGroupLite).fileGroupId);
            if (timeline == null) {
                throw new IllegalStateException("Timeline for fileGroupId: '" + ((HoodieFileGroupLite)fileGroupLite).fileGroupId + "' was not found in the map. Available fileGroupId in map: [" + this.fileGroupIdHoodieTimelineMap.keySet().stream().map(HoodieFileGroupId::toString).collect(Collectors.joining(",")) + "]. FileGroupId that we are deserializing: [" + fileGroupLites.stream().map(fg -> ((HoodieFileGroupLite)fg).fileGroupId.toString()).collect(Collectors.joining(",")) + "]");
            }
            HoodieFileGroup fileGroup = new HoodieFileGroup(((HoodieFileGroupLite)fileGroupLite).fileGroupId, timeline);
            ((HoodieFileGroupLite)fileGroupLite).fileSlices.forEach(fileGroup::addFileSlice);
            return fileGroup;
        }).collect(Collectors.toList());
    }

    private static class HoodieFileGroupLite
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<FileSlice> fileSlices;
        private final HoodieFileGroupId fileGroupId;

        HoodieFileGroupLite(List<FileSlice> fileSlices, HoodieFileGroupId fileGroupId) {
            this.fileSlices = fileSlices;
            this.fileGroupId = fileGroupId;
        }
    }
}

