/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.serialization.DefaultSerializer;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.DefaultSizeEstimator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.HoodieRecordSizeEstimator;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.InternalSchemaCache;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;

public abstract class FileGroupRecordBuffer<T>
implements HoodieFileGroupRecordBuffer<T> {
    protected final HoodieReaderContext<T> readerContext;
    protected final Schema readerSchema;
    protected final Option<String> orderingFieldName;
    protected final Option<String> partitionNameOverrideOpt;
    protected final Option<String[]> partitionPathFieldOpt;
    protected final RecordMergeMode recordMergeMode;
    protected final Option<HoodieRecordMerger> recordMerger;
    protected final Option<String> payloadClass;
    protected final TypedProperties props;
    protected final ExternalSpillableMap<Serializable, BufferedRecord<T>> records;
    protected final HoodieReadStats readStats;
    protected final boolean shouldCheckCustomDeleteMarker;
    protected final boolean shouldCheckBuiltInDeleteMarker;
    protected ClosableIterator<T> baseFileIterator;
    protected Iterator<BufferedRecord<T>> logRecordIterator;
    protected T nextRecord;
    protected boolean enablePartialMerging = false;
    protected InternalSchema internalSchema;
    protected HoodieTableMetaClient hoodieTableMetaClient;
    private long totalLogRecords = 0L;

    protected FileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        this.readerContext = readerContext;
        this.readerSchema = AvroSchemaCache.intern(readerContext.getSchemaHandler().getRequiredSchema());
        this.partitionNameOverrideOpt = partitionNameOverrideOpt;
        this.partitionPathFieldOpt = partitionPathFieldOpt;
        this.recordMergeMode = recordMergeMode;
        this.recordMerger = readerContext.getRecordMerger();
        this.payloadClass = this.recordMerger.isPresent() && this.recordMerger.get().getMergingStrategy().equals("00000000-0000-0000-0000-000000000000") ? Option.of(hoodieTableMetaClient.getTableConfig().getPayloadClass()) : Option.empty();
        this.orderingFieldName = recordMergeMode == RecordMergeMode.COMMIT_TIME_ORDERING ? Option.empty() : Option.ofNullable(ConfigUtils.getOrderingField(props)).or(() -> {
            String preCombineField = hoodieTableMetaClient.getTableConfig().getPreCombineField();
            if (StringUtils.isNullOrEmpty(preCombineField)) {
                return Option.empty();
            }
            return Option.of(preCombineField);
        });
        this.props = props;
        this.internalSchema = readerContext.getSchemaHandler().getInternalSchema();
        this.hoodieTableMetaClient = hoodieTableMetaClient;
        long maxMemorySizeInBytes = props.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.defaultValue());
        String spillableMapBasePath = props.getString(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), FileIOUtils.getDefaultSpillableMapBasePath());
        ExternalSpillableMap.DiskMapType diskMapType = ExternalSpillableMap.DiskMapType.valueOf(props.getString(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue().name()).toUpperCase(Locale.ROOT));
        boolean isBitCaskDiskMapCompressionEnabled = props.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue());
        this.readStats = readStats;
        try {
            this.records = new ExternalSpillableMap(maxMemorySizeInBytes, spillableMapBasePath, new DefaultSizeEstimator(), new HoodieRecordSizeEstimator(this.readerSchema), diskMapType, new DefaultSerializer(), isBitCaskDiskMapCompressionEnabled, this.getClass().getSimpleName());
        }
        catch (IOException e) {
            throw new HoodieIOException("IOException when creating ExternalSpillableMap at " + spillableMapBasePath, e);
        }
        this.shouldCheckCustomDeleteMarker = readerContext.getSchemaHandler().getCustomDeleteMarkerKeyValue().isPresent();
        this.shouldCheckBuiltInDeleteMarker = readerContext.getSchemaHandler().hasBuiltInDelete();
    }

    protected final boolean isCustomDeleteRecord(T record) {
        if (!this.shouldCheckCustomDeleteMarker) {
            return false;
        }
        Pair<String, String> markerKeyValue = this.readerContext.getSchemaHandler().getCustomDeleteMarkerKeyValue().get();
        Object deleteMarkerValue = this.readerContext.getValue(record, this.readerSchema, markerKeyValue.getLeft());
        return deleteMarkerValue != null && markerKeyValue.getRight().equals(deleteMarkerValue.toString());
    }

    protected final boolean isBuiltInDeleteRecord(T record) {
        if (!this.shouldCheckBuiltInDeleteMarker) {
            return false;
        }
        Object columnValue = this.readerContext.getValue(record, this.readerSchema, "_hoodie_is_deleted");
        return columnValue != null && this.readerContext.castToBoolean(columnValue);
    }

    @Override
    public void setBaseFileIterator(ClosableIterator<T> baseFileIterator) {
        this.baseFileIterator = baseFileIterator;
    }

    protected abstract boolean doHasNext() throws IOException;

    @Override
    public final boolean hasNext() throws IOException {
        return this.nextRecord != null || this.doHasNext();
    }

    @Override
    public final T next() {
        T record = this.nextRecord;
        this.nextRecord = null;
        return record;
    }

    @Override
    public Map<Serializable, BufferedRecord<T>> getLogRecords() {
        return this.records;
    }

    @Override
    public int size() {
        return this.records.size();
    }

    @Override
    public long getTotalLogRecords() {
        return this.totalLogRecords;
    }

    @Override
    public Iterator<BufferedRecord<T>> getLogRecordIterator() {
        return this.records.values().iterator();
    }

    @Override
    public void close() {
        this.records.close();
    }

    protected Option<BufferedRecord<T>> doProcessNextDataRecord(BufferedRecord<T> newRecord, BufferedRecord<T> existingRecord) throws IOException {
        ++this.totalLogRecords;
        if (existingRecord != null) {
            if (this.enablePartialMerging) {
                Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.recordMerger.get().partialMerge(this.readerContext.constructHoodieRecord(existingRecord), this.readerContext.getSchemaFromBufferRecord(existingRecord), this.readerContext.constructHoodieRecord(newRecord), this.readerContext.getSchemaFromBufferRecord(newRecord), this.readerSchema, this.props);
                if (!combinedRecordAndSchemaOpt.isPresent()) {
                    return Option.empty();
                }
                Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
                HoodieRecord combinedRecord = combinedRecordAndSchema.getLeft();
                if (combinedRecord.getData() != existingRecord.getRecord()) {
                    return Option.of(BufferedRecord.forRecordWithContext(combinedRecord, combinedRecordAndSchema.getRight(), this.readerContext, this.props));
                }
                return Option.empty();
            }
            switch (this.recordMergeMode) {
                case COMMIT_TIME_ORDERING: {
                    return Option.of(newRecord);
                }
                case EVENT_TIME_ORDERING: {
                    if (this.shouldKeepNewerRecord(existingRecord, newRecord)) {
                        return Option.of(newRecord);
                    }
                    return Option.empty();
                }
            }
            if (existingRecord.isDelete() || newRecord.isDelete()) {
                if (this.shouldKeepNewerRecord(existingRecord, newRecord)) {
                    return Option.of(newRecord);
                }
                return Option.empty();
            }
            if (this.payloadClass.isPresent()) {
                T combinedRecordData;
                Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.getMergedRecord(existingRecord, newRecord);
                if (combinedRecordAndSchemaOpt.isPresent() && (combinedRecordData = this.readerContext.convertAvroRecord((IndexedRecord)combinedRecordAndSchemaOpt.get().getLeft().getData())) != existingRecord.getRecord()) {
                    Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
                    return Option.of(BufferedRecord.forRecordWithContext(combinedRecordData, combinedRecordAndSchema.getRight(), this.readerContext, this.orderingFieldName, false));
                }
                return Option.empty();
            }
            Option<Pair<HoodieRecord, Schema>> combinedRecordAndSchemaOpt = this.recordMerger.get().merge(this.readerContext.constructHoodieRecord(existingRecord), this.readerContext.getSchemaFromBufferRecord(existingRecord), this.readerContext.constructHoodieRecord(newRecord), this.readerContext.getSchemaFromBufferRecord(newRecord), this.props);
            if (!combinedRecordAndSchemaOpt.isPresent()) {
                return Option.empty();
            }
            Pair<HoodieRecord, Schema> combinedRecordAndSchema = combinedRecordAndSchemaOpt.get();
            HoodieRecord combinedRecord = combinedRecordAndSchema.getLeft();
            if (combinedRecord.getData() != existingRecord.getRecord()) {
                return Option.of(BufferedRecord.forRecordWithContext(combinedRecord, combinedRecordAndSchema.getRight(), this.readerContext, this.props));
            }
            return Option.empty();
        }
        return Option.of(newRecord);
    }

    protected Option<DeleteRecord> doProcessNextDeletedRecord(DeleteRecord deleteRecord, BufferedRecord<T> existingRecord) {
        ++this.totalLogRecords;
        if (existingRecord != null) {
            boolean chooseExisting;
            switch (this.recordMergeMode) {
                case COMMIT_TIME_ORDERING: {
                    return Option.of(deleteRecord);
                }
            }
            if (existingRecord.isCommitTimeOrderingDelete()) {
                return Option.empty();
            }
            Comparable existingOrderingVal = existingRecord.getOrderingValue();
            Comparable<?> deleteOrderingVal = deleteRecord.getOrderingValue();
            boolean bl = chooseExisting = !deleteOrderingVal.equals(0) && ReflectionUtils.isSameClass(existingOrderingVal, deleteOrderingVal) && existingOrderingVal.compareTo(deleteOrderingVal) > 0;
            if (chooseExisting) {
                return Option.empty();
            }
        }
        return Option.of(deleteRecord);
    }

    protected Pair<ClosableIterator<T>, Schema> getRecordsIterator(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) {
        ClosableIterator<T> blockRecordsIterator;
        if (keySpecOpt.isPresent()) {
            KeySpec keySpec = keySpecOpt.get();
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext, keySpec.getKeys(), keySpec.isFullKey());
        } else {
            blockRecordsIterator = dataBlock.getEngineRecordIterator(this.readerContext);
        }
        Pair<Function<T, T>, Schema> schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
        return Pair.of(new CloseableMappingIterator<T, T>(blockRecordsIterator, schemaTransformerWithEvolvedSchema.getLeft()), schemaTransformerWithEvolvedSchema.getRight());
    }

    protected Option<Pair<Function<T, T>, Schema>> composeEvolvedSchemaTransformer(HoodieDataBlock dataBlock) {
        if (this.internalSchema.isEmptySchema()) {
            return Option.empty();
        }
        long currentInstantTime = Long.parseLong(dataBlock.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.INSTANT_TIME));
        InternalSchema fileSchema = InternalSchemaCache.searchSchemaAndCache(currentInstantTime, this.hoodieTableMetaClient);
        Pair<InternalSchema, Map<String, String>> mergedInternalSchema = new InternalSchemaMerger(fileSchema, this.internalSchema, true, false, false).mergeSchemaGetRenamed();
        Schema mergedAvroSchema = AvroInternalSchemaConverter.convert(mergedInternalSchema.getLeft(), this.readerSchema.getFullName());
        assert (mergedAvroSchema.equals((Object)this.readerSchema));
        return Option.of(Pair.of(this.readerContext.projectRecord(dataBlock.getSchema(), mergedAvroSchema, mergedInternalSchema.getRight()), mergedAvroSchema));
    }

    protected Pair<Boolean, T> merge(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) throws IOException {
        if (this.enablePartialMerging) {
            Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().partialMerge(this.readerContext.constructHoodieRecord(olderRecord), this.readerContext.getSchemaFromBufferRecord(olderRecord), this.readerContext.constructHoodieRecord(newerRecord), this.readerContext.getSchemaFromBufferRecord(newerRecord), this.readerSchema, this.props);
            if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
                HoodieRecord hoodieRecord = mergedRecord.get().getLeft();
                if (!mergedRecord.get().getRight().equals((Object)this.readerSchema)) {
                    Object data = hoodieRecord.rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData();
                    return Pair.of(false, data);
                }
                return Pair.of(false, hoodieRecord.getData());
            }
            return Pair.of(true, null);
        }
        switch (this.recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                return Pair.of(newerRecord.isDelete(), newerRecord.getRecord());
            }
            case EVENT_TIME_ORDERING: {
                if (newerRecord.isCommitTimeOrderingDelete()) {
                    return Pair.of(true, newerRecord.getRecord());
                }
                Comparable newOrderingValue = newerRecord.getOrderingValue();
                Comparable oldOrderingValue = olderRecord.getOrderingValue();
                if (!olderRecord.isCommitTimeOrderingDelete() && oldOrderingValue.compareTo(newOrderingValue) > 0) {
                    return Pair.of(olderRecord.isDelete(), olderRecord.getRecord());
                }
                return Pair.of(newerRecord.isDelete(), newerRecord.getRecord());
            }
        }
        if (this.payloadClass.isPresent()) {
            if (olderRecord.isDelete() || newerRecord.isDelete()) {
                if (this.shouldKeepNewerRecord(olderRecord, newerRecord)) {
                    return Pair.of(newerRecord.isDelete(), newerRecord.getRecord());
                }
                return Pair.of(olderRecord.isDelete(), olderRecord.getRecord());
            }
            Option<Pair<HoodieRecord, Schema>> mergedRecord = this.getMergedRecord(olderRecord, newerRecord);
            if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
                IndexedRecord indexedRecord = !mergedRecord.get().getRight().equals((Object)this.readerSchema) ? (IndexedRecord)mergedRecord.get().getLeft().rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData() : (IndexedRecord)mergedRecord.get().getLeft().getData();
                return Pair.of(false, this.readerContext.convertAvroRecord(indexedRecord));
            }
            return Pair.of(true, null);
        }
        if (olderRecord.isDelete() || newerRecord.isDelete()) {
            if (this.shouldKeepNewerRecord(olderRecord, newerRecord)) {
                return Pair.of(newerRecord.isDelete(), newerRecord.getRecord());
            }
            return Pair.of(olderRecord.isDelete(), olderRecord.getRecord());
        }
        Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().merge(this.readerContext.constructHoodieRecord(olderRecord), this.readerContext.getSchemaFromBufferRecord(olderRecord), this.readerContext.constructHoodieRecord(newerRecord), this.readerContext.getSchemaFromBufferRecord(newerRecord), this.props);
        if (mergedRecord.isPresent() && !mergedRecord.get().getLeft().isDelete(mergedRecord.get().getRight(), this.props)) {
            HoodieRecord hoodieRecord = mergedRecord.get().getLeft();
            if (!mergedRecord.get().getRight().equals((Object)this.readerSchema)) {
                return Pair.of(false, hoodieRecord.rewriteRecordWithNewSchema(mergedRecord.get().getRight(), null, this.readerSchema).getData());
            }
            return Pair.of(false, hoodieRecord.getData());
        }
        return Pair.of(true, null);
    }

    private boolean shouldKeepNewerRecord(BufferedRecord<T> oldRecord, BufferedRecord<T> newRecord) {
        if (newRecord.isCommitTimeOrderingDelete()) {
            return true;
        }
        return newRecord.getOrderingValue().compareTo(oldRecord.getOrderingValue()) >= 0;
    }

    private Option<Pair<HoodieRecord, Schema>> getMergedRecord(BufferedRecord<T> olderRecord, BufferedRecord<T> newerRecord) throws IOException {
        ValidationUtils.checkArgument(!Objects.equals(this.payloadClass, OverwriteWithLatestAvroPayload.class.getCanonicalName()) && !Objects.equals(this.payloadClass, DefaultHoodieRecordPayload.class.getCanonicalName()));
        HoodieRecord oldHoodieRecord = this.constructHoodieAvroRecord(this.readerContext, olderRecord);
        HoodieRecord newHoodieRecord = this.constructHoodieAvroRecord(this.readerContext, newerRecord);
        Option<Pair<HoodieRecord, Schema>> mergedRecord = this.recordMerger.get().merge(oldHoodieRecord, this.getSchemaForAvroPayloadMerge(oldHoodieRecord, olderRecord), newHoodieRecord, this.getSchemaForAvroPayloadMerge(newHoodieRecord, newerRecord), this.props);
        return mergedRecord;
    }

    private HoodieRecord constructHoodieAvroRecord(HoodieReaderContext<T> readerContext, BufferedRecord<T> bufferedRecord) {
        GenericRecord record = null;
        if (!bufferedRecord.isDelete()) {
            Schema recordSchema = readerContext.getSchemaFromBufferRecord(bufferedRecord);
            record = readerContext.convertToAvroRecord(bufferedRecord.getRecord(), recordSchema);
        }
        HoodieKey hoodieKey = new HoodieKey(bufferedRecord.getRecordKey(), null);
        return new HoodieAvroRecord(hoodieKey, HoodieRecordUtils.loadPayload(this.payloadClass.get(), new Object[]{record, bufferedRecord.getOrderingValue()}, GenericRecord.class, Comparable.class), null);
    }

    private Schema getSchemaForAvroPayloadMerge(HoodieRecord record, BufferedRecord<T> bufferedRecord) throws IOException {
        if (record.isDelete(this.readerSchema, this.props)) {
            return this.readerSchema;
        }
        return this.readerContext.getSchemaFromBufferRecord(bufferedRecord);
    }

    protected boolean hasNextBaseRecord(T baseRecord, BufferedRecord<T> logRecordInfo) throws IOException {
        if (logRecordInfo != null) {
            BufferedRecord<T> bufferedRecord = BufferedRecord.forRecordWithContext(baseRecord, this.readerSchema, this.readerContext, this.orderingFieldName, false);
            Pair<Boolean, T> isDeleteAndRecord = this.merge(bufferedRecord, logRecordInfo);
            if (!isDeleteAndRecord.getLeft().booleanValue()) {
                this.nextRecord = this.readerContext.seal(isDeleteAndRecord.getRight());
                this.readStats.incrementNumUpdates();
                return true;
            }
            this.readStats.incrementNumDeletes();
            return false;
        }
        this.nextRecord = this.readerContext.seal(baseRecord);
        this.readStats.incrementNumInserts();
        return true;
    }

    protected boolean hasNextLogRecord() {
        if (this.logRecordIterator == null) {
            this.logRecordIterator = this.records.values().iterator();
        }
        while (this.logRecordIterator.hasNext()) {
            BufferedRecord<T> nextRecordInfo = this.logRecordIterator.next();
            if (!nextRecordInfo.isDelete()) {
                this.nextRecord = nextRecordInfo.getRecord();
                this.readStats.incrementNumInserts();
                return true;
            }
            this.readStats.incrementNumDeletes();
        }
        return false;
    }

    protected Pair<Function<T, T>, Schema> getSchemaTransformerWithEvolvedSchema(HoodieDataBlock dataBlock) {
        Option<Pair<Function<Pair, Pair>, Schema>> schemaEvolutionTransformerOpt = this.composeEvolvedSchemaTransformer(dataBlock);
        Function transformer = schemaEvolutionTransformerOpt.map(Pair::getLeft).orElse(Function.identity());
        Schema evolvedSchema = schemaEvolutionTransformerOpt.map(Pair::getRight).orElseGet(dataBlock::getSchema);
        return Pair.of(transformer, evolvedSchema);
    }

    static boolean isCommitTimeOrderingValue(Comparable orderingValue) {
        return orderingValue == null || orderingValue.equals(0);
    }

    static Comparable getOrderingValue(HoodieReaderContext readerContext, DeleteRecord deleteRecord) {
        return FileGroupRecordBuffer.isCommitTimeOrderingValue(deleteRecord.getOrderingValue()) ? Integer.valueOf(0) : readerContext.convertValueToEngineType(deleteRecord.getOrderingValue());
    }

    private boolean isDeleteRecord(Option<T> record, Schema schema) {
        if (record.isEmpty()) {
            return true;
        }
        Object operation = this.readerContext.getValue(record.get(), schema, HoodieRecord.OPERATION_METADATA_FIELD);
        if (operation != null && HoodieOperation.isDeleteRecord(operation.toString())) {
            return true;
        }
        Object deleteMarker = this.readerContext.getValue(record.get(), schema, "_hoodie_is_deleted");
        return deleteMarker instanceof Boolean && (Boolean)deleteMarker != false;
    }
}

