/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.table.read.KeyBasedFileGroupRecordBuffer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.org.roaringbitmap.longlong.Roaring64NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositionBasedFileGroupRecordBuffer<T>
extends KeyBasedFileGroupRecordBuffer<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PositionBasedFileGroupRecordBuffer.class);
    private static final String ROW_INDEX_COLUMN_NAME = "row_index";
    public static final String ROW_INDEX_TEMPORARY_COLUMN_NAME = "_tmp_metadata_row_index";
    protected final String baseFileInstantTime;
    private long nextRecordPosition = 0L;
    private boolean needToDoHybridStrategy = false;

    public PositionBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, String baseFileInstantTime, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
        this.baseFileInstantTime = baseFileInstantTime;
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return this.readerContext.getShouldMergeUseRecordPosition() ? HoodieFileGroupRecordBuffer.BufferType.POSITION_BASED_MERGE : super.getBufferType();
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        List<Long> recordPositions = PositionBasedFileGroupRecordBuffer.extractRecordPositions(dataBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.warn("Falling back to key based merge for Read");
            this.fallbackToKeyBasedBuffer();
            super.processDataBlock(dataBlock, keySpecOpt);
            return;
        }
        HashSet<String> keys2 = new HashSet();
        boolean isFullKey = true;
        if (keySpecOpt.isPresent()) {
            if (!keySpecOpt.get().getKeys().isEmpty()) {
                keys2 = new HashSet<String>(keySpecOpt.get().getKeys());
            }
            isFullKey = keySpecOpt.get().isFullKey();
        }
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        Pair schemaTransformerWithEvolvedSchema = this.getSchemaTransformerWithEvolvedSchema(dataBlock);
        Schema schema = AvroSchemaCache.intern(schemaTransformerWithEvolvedSchema.getRight());
        try (ClosableIterator recordIterator = dataBlock.getEngineRecordIterator(this.readerContext);){
            int recordIndex = 0;
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                if (this.shouldSkip(nextRecord, dataBlock.getKeyFieldName(), isFullKey, keys2, dataBlock.getSchema())) {
                    ++recordIndex;
                    continue;
                }
                long recordPosition = recordPositions.get(recordIndex++);
                Object evolvedNextRecord = schemaTransformerWithEvolvedSchema.getLeft().apply(nextRecord);
                boolean isDelete = this.isBuiltInDeleteRecord(evolvedNextRecord) || this.isCustomDeleteRecord(evolvedNextRecord);
                BufferedRecord bufferedRecord = BufferedRecord.forRecordWithContext(evolvedNextRecord, schema, this.readerContext, this.orderingFieldName, isDelete);
                this.processNextDataRecord(bufferedRecord, Long.valueOf(recordPosition));
            }
        }
    }

    private void fallbackToKeyBasedBuffer() {
        this.readerContext.setShouldMergeUseRecordPosition(false);
        ArrayList positions = new ArrayList(this.records.keySet());
        for (Serializable position : positions) {
            BufferedRecord entry = (BufferedRecord)this.records.get(position);
            String recordKey = entry.getRecordKey();
            if (!entry.isDelete() || recordKey != null) {
                this.records.put(recordKey, entry);
                this.records.remove(position);
                continue;
            }
            this.needToDoHybridStrategy = true;
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            super.processDeleteBlock(deleteBlock);
            return;
        }
        List<Long> recordPositions = PositionBasedFileGroupRecordBuffer.extractRecordPositions(deleteBlock, this.baseFileInstantTime);
        if (recordPositions == null) {
            LOG.warn("Falling back to key based merge for Read");
            this.fallbackToKeyBasedBuffer();
            super.processDeleteBlock(deleteBlock);
            return;
        }
        switch (this.recordMergeMode) {
            case COMMIT_TIME_ORDERING: {
                int commitTimeBasedRecordIndex = 0;
                DeleteRecord[] deleteRecords = deleteBlock.getRecordsToDelete();
                for (Long recordPosition : recordPositions) {
                    DeleteRecord deleteRecord = deleteRecords[commitTimeBasedRecordIndex++];
                    BufferedRecord record = BufferedRecord.forDeleteRecord(deleteRecord, deleteRecord.getOrderingValue());
                    this.records.put(recordPosition, record);
                }
                return;
            }
        }
        int recordIndex = 0;
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            long recordPosition = recordPositions.get(recordIndex++);
            this.processNextDeletedRecord(record, Long.valueOf(recordPosition));
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable recordPosition) {
        BufferedRecord existingRecord = (BufferedRecord)this.records.get(recordPosition);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecord);
        if (recordOpt.isPresent()) {
            Comparable orderingValue = PositionBasedFileGroupRecordBuffer.getOrderingValue(this.readerContext, recordOpt.get());
            this.records.put(recordPosition, BufferedRecord.forDeleteRecord(recordOpt.get(), orderingValue));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.values().stream().filter(r -> !r.isDelete()).map(r -> this.readerContext.getRecordKey(r.getRecord(), this.readerSchema)).anyMatch(recordKey::equals);
    }

    @Override
    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        if (!this.readerContext.getShouldMergeUseRecordPosition()) {
            return this.doHasNextFallbackBaseRecord(baseRecord);
        }
        this.nextRecordPosition = this.readerContext.extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
        BufferedRecord logRecordInfo = (BufferedRecord)this.records.remove(this.nextRecordPosition++);
        Object resultRecord = null;
        if (logRecordInfo != null) {
            BufferedRecord<T> bufferedRecord = BufferedRecord.forRecordWithContext(baseRecord, this.readerSchema, this.readerContext, this.orderingFieldName, false);
            Pair<Boolean, T> isDeleteAndRecord = this.merge(bufferedRecord, logRecordInfo);
            if (!isDeleteAndRecord.getLeft().booleanValue()) {
                resultRecord = isDeleteAndRecord.getRight();
                this.readStats.incrementNumUpdates();
            } else {
                this.readStats.incrementNumDeletes();
            }
        } else {
            resultRecord = baseRecord;
            this.readStats.incrementNumInserts();
        }
        if (resultRecord != null) {
            this.nextRecord = this.readerContext.seal(resultRecord);
            return true;
        }
        return false;
    }

    private boolean doHasNextFallbackBaseRecord(T baseRecord) throws IOException {
        if (this.needToDoHybridStrategy) {
            BufferedRecord logRecordInfo;
            this.nextRecordPosition = this.readerContext.extractRecordPosition(baseRecord, this.readerSchema, ROW_INDEX_TEMPORARY_COLUMN_NAME, this.nextRecordPosition);
            if ((logRecordInfo = (BufferedRecord)this.records.remove(this.nextRecordPosition++)) != null) {
                this.records.remove(this.readerContext.getRecordKey(baseRecord, this.readerSchema));
                return false;
            }
        }
        return super.hasNextBaseRecord(baseRecord);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldSkip(T record, String keyFieldName, boolean isFullKey, Set<String> keys2, Schema writerSchema) {
        if (keys2.isEmpty()) {
            return false;
        }
        String recordKey = this.readerContext.getValue(record, writerSchema, keyFieldName).toString();
        if (recordKey == null) throw new HoodieKeyException("Can not extract the key for a record");
        if (recordKey.isEmpty()) {
            throw new HoodieKeyException("Can not extract the key for a record");
        }
        if (isFullKey) {
            if (keys2.contains(recordKey)) return false;
        }
        if (isFullKey) return true;
        if (!keys2.stream().noneMatch(recordKey::startsWith)) return false;
        return true;
    }

    protected static List<Long> extractRecordPositions(HoodieLogBlock logBlock, String baseFileInstantTime) throws IOException {
        ArrayList<Long> blockPositions = new ArrayList<Long>();
        String blockBaseFileInstantTime = logBlock.getBaseFileInstantTimeOfPositions();
        if (StringUtils.isNullOrEmpty(blockBaseFileInstantTime) || !baseFileInstantTime.equals(blockBaseFileInstantTime)) {
            LOG.debug("The record positions cannot be used because the base file instant time is either missing or different from the base file to merge. Instant time in the header: {}, base file instant time of the file group: {}.", (Object)blockBaseFileInstantTime, (Object)baseFileInstantTime);
            return null;
        }
        Roaring64NavigableMap positions = logBlock.getRecordPositions();
        if (positions == null || positions.isEmpty()) {
            LOG.warn("No record position info is found when attempt to do position based merge.");
            return null;
        }
        Iterator<Long> iterator2 = positions.iterator();
        while (iterator2.hasNext()) {
            blockPositions.add(iterator2.next());
        }
        if (blockPositions.isEmpty()) {
            LOG.warn("No positions are extracted.");
            return null;
        }
        return blockPositions;
    }
}

