/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieIndexPlan;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantReader;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.storage.HoodieInstantWriter;

public interface HoodieTimeline
extends HoodieInstantReader,
Serializable {
    public static final String COMMIT_ACTION = "commit";
    public static final String DELTA_COMMIT_ACTION = "deltacommit";
    public static final String CLEAN_ACTION = "clean";
    public static final String ROLLBACK_ACTION = "rollback";
    public static final String SAVEPOINT_ACTION = "savepoint";
    public static final String REPLACE_COMMIT_ACTION = "replacecommit";
    public static final String CLUSTERING_ACTION = "clustering";
    public static final String INFLIGHT_EXTENSION = ".inflight";
    public static final String COMPACTION_ACTION = "compaction";
    public static final String LOG_COMPACTION_ACTION = "logcompaction";
    public static final String REQUESTED_EXTENSION = ".requested";
    public static final String COMPLETED_EXTENSION = ".completed";
    public static final String RESTORE_ACTION = "restore";
    public static final String INDEXING_ACTION = "indexing";
    public static final String SCHEMA_COMMIT_ACTION = "schemacommit";
    public static final String[] VALID_ACTIONS_IN_TIMELINE = new String[]{"commit", "deltacommit", "clean", "savepoint", "restore", "rollback", "compaction", "logcompaction", "replacecommit", "clustering", "indexing"};
    public static final String COMMIT_EXTENSION = ".commit";
    public static final String DELTA_COMMIT_EXTENSION = ".deltacommit";
    public static final String CLEAN_EXTENSION = ".clean";
    public static final String ROLLBACK_EXTENSION = ".rollback";
    public static final String SAVEPOINT_EXTENSION = ".savepoint";
    public static final String INFLIGHT_COMMIT_EXTENSION = ".inflight";
    public static final String REQUESTED_COMMIT_EXTENSION = ".commit.requested";
    public static final String REQUESTED_DELTA_COMMIT_EXTENSION = ".deltacommit.requested";
    public static final String INFLIGHT_DELTA_COMMIT_EXTENSION = ".deltacommit.inflight";
    public static final String INFLIGHT_CLEAN_EXTENSION = ".clean.inflight";
    public static final String REQUESTED_CLEAN_EXTENSION = ".clean.requested";
    public static final String INFLIGHT_ROLLBACK_EXTENSION = ".rollback.inflight";
    public static final String REQUESTED_ROLLBACK_EXTENSION = ".rollback.requested";
    public static final String INFLIGHT_SAVEPOINT_EXTENSION = ".savepoint.inflight";
    public static final String REQUESTED_COMPACTION_SUFFIX = StringUtils.join("compaction", ".requested");
    public static final String REQUESTED_COMPACTION_EXTENSION = StringUtils.join(".", REQUESTED_COMPACTION_SUFFIX);
    public static final String COMPLETED_COMPACTION_SUFFIX = StringUtils.join("compaction", ".completed");
    public static final String INFLIGHT_COMPACTION_EXTENSION = StringUtils.join(".", "compaction", ".inflight");
    public static final String REQUESTED_RESTORE_EXTENSION = ".restore.requested";
    public static final String INFLIGHT_RESTORE_EXTENSION = ".restore.inflight";
    public static final String RESTORE_EXTENSION = ".restore";
    public static final String INFLIGHT_REPLACE_COMMIT_EXTENSION = ".replacecommit.inflight";
    public static final String REQUESTED_REPLACE_COMMIT_EXTENSION = ".replacecommit.requested";
    public static final String REPLACE_COMMIT_EXTENSION = ".replacecommit";
    public static final String INFLIGHT_CLUSTERING_COMMIT_EXTENSION = ".clustering.inflight";
    public static final String REQUESTED_CLUSTERING_COMMIT_EXTENSION = ".clustering.requested";
    public static final String INFLIGHT_INDEX_COMMIT_EXTENSION = ".indexing.inflight";
    public static final String REQUESTED_INDEX_COMMIT_EXTENSION = ".indexing.requested";
    public static final String INDEX_COMMIT_EXTENSION = ".indexing";
    public static final String SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit";
    public static final String INFLIGHT_SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit.inflight";
    public static final String REQUESTED_SAVE_SCHEMA_ACTION_EXTENSION = ".schemacommit.requested";
    public static final String REQUESTED_LOG_COMPACTION_SUFFIX = StringUtils.join("logcompaction", ".requested");
    public static final String REQUESTED_LOG_COMPACTION_EXTENSION = StringUtils.join(".", REQUESTED_LOG_COMPACTION_SUFFIX);
    public static final String INFLIGHT_LOG_COMPACTION_EXTENSION = StringUtils.join(".", "logcompaction", ".inflight");
    public static final String INVALID_INSTANT_TS = "0";
    public static final String INIT_INSTANT_TS = "00000000000000";
    public static final String METADATA_BOOTSTRAP_INSTANT_TS = "00000000000001";
    public static final String FULL_BOOTSTRAP_INSTANT_TS = "00000000000002";

    default public <T> T readInstantContent(HoodieInstant instant, Class<T> clazz) throws IOException {
        TimelineLayout layout = TimelineLayout.fromVersion(this.getTimelineLayoutVersion());
        return layout.getCommitMetadataSerDe().deserialize(instant, this.getInstantContentStream(instant), () -> this.isEmpty(instant), clazz);
    }

    default public <T> T readNonEmptyInstantContent(HoodieInstant instant, Class<T> clazz) throws IOException {
        TimelineLayout layout = TimelineLayout.fromVersion(this.getTimelineLayoutVersion());
        return layout.getCommitMetadataSerDe().deserialize(instant, this.getInstantContentStream(instant), () -> false, clazz);
    }

    default public org.apache.hudi.common.model.HoodieCommitMetadata readCommitMetadata(HoodieInstant instant) throws IOException {
        return this.readInstantContent(instant, org.apache.hudi.common.model.HoodieCommitMetadata.class);
    }

    default public org.apache.hudi.common.model.HoodieReplaceCommitMetadata readReplaceCommitMetadata(HoodieInstant instant) throws IOException {
        return this.readInstantContent(instant, org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class);
    }

    default public HoodieCommitMetadata readCommitMetadataToAvro(HoodieInstant instant) throws IOException {
        return this.readInstantContent(instant, HoodieCommitMetadata.class);
    }

    default public HoodieReplaceCommitMetadata readReplaceCommitMetadataToAvro(HoodieInstant instant) throws IOException {
        return this.readInstantContent(instant, HoodieReplaceCommitMetadata.class);
    }

    default public HoodieCleanerPlan readCleanerPlan(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieCleanerPlan.class);
    }

    default public HoodieCompactionPlan readCompactionPlan(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieCompactionPlan.class);
    }

    default public HoodieCleanMetadata readCleanMetadata(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieCleanMetadata.class);
    }

    default public HoodieRollbackPlan readRollbackPlan(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieRollbackPlan.class);
    }

    default public HoodieRollbackMetadata readRollbackMetadata(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieRollbackMetadata.class);
    }

    default public HoodieRestorePlan readRestorePlan(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieRestorePlan.class);
    }

    default public HoodieRestoreMetadata readRestoreMetadata(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieRestoreMetadata.class);
    }

    default public HoodieSavepointMetadata readSavepointMetadata(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieSavepointMetadata.class);
    }

    default public HoodieRequestedReplaceMetadata readRequestedReplaceMetadata(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieRequestedReplaceMetadata.class);
    }

    default public HoodieIndexPlan readIndexPlan(HoodieInstant instant) throws IOException {
        return this.readNonEmptyInstantContent(instant, HoodieIndexPlan.class);
    }

    public HoodieTimeline filterInflights();

    public HoodieTimeline filterInflightsAndRequested();

    public HoodieTimeline filterPendingExcludingCompaction();

    public HoodieTimeline filterPendingExcludingLogCompaction();

    public HoodieTimeline filterPendingExcludingCompactionAndLogCompaction();

    public HoodieTimeline filterCompletedInstants();

    default public <T> Option<HoodieInstantWriter> getInstantWriter(Option<T> metadata) {
        if (metadata.isEmpty()) {
            return Option.empty();
        }
        TimelineLayout layout = TimelineLayout.fromVersion(this.getTimelineLayoutVersion());
        return layout.getCommitMetadataSerDe().getInstantWriter(metadata.get());
    }

    public HoodieTimeline filterCompletedAndCompactionInstants();

    public HoodieTimeline filterCompletedOrMajorOrMinorCompactionInstants();

    public HoodieTimeline filterCompletedInstantsOrRewriteTimeline();

    public HoodieTimeline getWriteTimeline();

    public HoodieTimeline getContiguousCompletedWriteTimeline();

    public HoodieTimeline getCompletedReplaceTimeline();

    public HoodieTimeline filterPendingCompactionTimeline();

    public HoodieTimeline filterPendingLogCompactionTimeline();

    public HoodieTimeline filterPendingMajorOrMinorCompactionTimeline();

    public HoodieTimeline filterPendingReplaceTimeline();

    public HoodieTimeline filterPendingClusteringTimeline();

    public HoodieTimeline filterPendingReplaceOrClusteringTimeline();

    public HoodieTimeline filterPendingReplaceClusteringAndCompactionTimeline();

    public HoodieTimeline filterPendingRollbackTimeline();

    public HoodieTimeline filterRequestedRollbackTimeline();

    public HoodieTimeline findInstantsAfterOrEquals(String var1, int var2);

    public HoodieTimeline findInstantsAfterOrEquals(String var1);

    public HoodieTimeline findInstantsInRange(String var1, String var2);

    public HoodieTimeline findInstantsInClosedRange(String var1, String var2);

    public HoodieTimeline findInstantsInRangeByCompletionTime(String var1, String var2);

    public HoodieTimeline findInstantsModifiedAfterByCompletionTime(String var1);

    public HoodieTimeline findInstantsAfter(String var1, int var2);

    public HoodieTimeline findInstantsAfter(String var1);

    public HoodieTimeline findInstantsBefore(String var1);

    public Option<HoodieInstant> findInstantBefore(String var1);

    public HoodieTimeline findInstantsBeforeOrEquals(String var1);

    public HoodieTimeline filter(Predicate<HoodieInstant> var1);

    public HoodieTimeline filterPendingIndexTimeline();

    public HoodieTimeline filterCompletedIndexTimeline();

    public boolean empty();

    public int countInstants();

    public Option<HoodieInstant> firstInstant();

    public Option<HoodieInstant> nthInstant(int var1);

    public Option<HoodieInstant> lastInstant();

    public String getTimelineHash();

    public Option<HoodieInstant> nthFromLastInstant(int var1);

    public boolean containsInstant(HoodieInstant var1);

    public boolean containsInstant(String var1);

    public boolean containsOrBeforeTimelineStarts(String var1);

    public Stream<HoodieInstant> getInstantsAsStream();

    public List<HoodieInstant> getInstants();

    public Option<HoodieInstant> firstInstant(String var1, HoodieInstant.State var2);

    public Stream<HoodieInstant> getReverseOrderedInstants();

    public Option<String> getLatestCompletionTime();

    public Stream<HoodieInstant> getInstantsOrderedByCompletionTime();

    public boolean isBeforeTimelineStarts(String var1);

    public boolean isBeforeTimelineStartsByCompletionTime(String var1);

    public Option<HoodieInstant> getFirstNonSavepointCommit();

    public Option<HoodieInstant> getLastClusteringInstant();

    public Option<HoodieInstant> getLastPendingClusterInstant();

    public Option<HoodieInstant> getFirstPendingClusterInstant();

    public boolean isPendingClusteringInstant(String var1);

    public InputStream getInstantContentStream(HoodieInstant var1);

    public boolean isEmpty(HoodieInstant var1);

    public HoodieTimeline getCommitsTimeline();

    public HoodieTimeline getCommitsAndCompactionTimeline();

    public HoodieTimeline getAllCommitsTimeline();

    public HoodieTimeline getCommitAndReplaceTimeline();

    public HoodieTimeline getCommitTimeline();

    public HoodieTimeline getDeltaCommitTimeline();

    public HoodieTimeline getTimelineOfActions(Set<String> var1);

    public HoodieTimeline getCleanerTimeline();

    public HoodieTimeline getRollbackTimeline();

    public HoodieTimeline getRollbackAndRestoreTimeline();

    public HoodieTimeline getSavePointTimeline();

    public HoodieTimeline getRestoreTimeline();

    public HoodieTimeline mergeTimeline(HoodieTimeline var1);

    public void setInstants(List<HoodieInstant> var1);

    public TimelineLayoutVersion getTimelineLayoutVersion();

    public HoodieInstantReader getInstantReader();
}

