/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;

public class StorageBasedLockConfig
extends HoodieConfig {
    private static final String SINCE_VERSION_1_0_2 = "1.0.2";
    private static final String STORAGE_BASED_LOCK_PROPERTY_PREFIX = "hoodie.write.lock.storage.";
    public static final ConfigProperty<Long> VALIDITY_TIMEOUT_SECONDS = ConfigProperty.key("hoodie.write.lock.storage.validity.timeout.secs").defaultValue(TimeUnit.MINUTES.toSeconds(5L)).markAdvanced().sinceVersion("1.0.2").withDocumentation("For storage-based lock provider, the amount of time in seconds each new lock is valid for. The lock provider will attempt to renew its lock until it successfully extends the lock lease period or the validity timeout is reached.");
    public static final ConfigProperty<Long> HEARTBEAT_POLL_SECONDS = ConfigProperty.key("hoodie.write.lock.storage.heartbeat.poll.secs").defaultValue(30L).markAdvanced().sinceVersion("1.0.2").withDocumentation("For storage-based lock provider, the amount of time in seconds to wait before renewing the lock. Defaults to 30 seconds.");

    public long getValiditySeconds() {
        return this.getLong(VALIDITY_TIMEOUT_SECONDS);
    }

    public long getHeartbeatPollSeconds() {
        return this.getLong(HEARTBEAT_POLL_SECONDS);
    }

    public String getHudiTableBasePath() {
        return this.getString(HoodieCommonConfig.BASE_PATH);
    }

    public static class Builder {
        private final StorageBasedLockConfig lockConfig = new StorageBasedLockConfig();

        public StorageBasedLockConfig build() {
            this.lockConfig.setDefaults(StorageBasedLockConfig.class.getName());
            return this.lockConfig;
        }

        public Builder fromProperties(TypedProperties props) {
            this.lockConfig.getProps().putAll((Map<?, ?>)props);
            this.checkRequiredProps();
            return this;
        }

        private void checkRequiredProps() {
            String notExistsMsg = " does not exist!";
            if (!this.lockConfig.contains(HoodieCommonConfig.BASE_PATH)) {
                throw new IllegalArgumentException(HoodieCommonConfig.BASE_PATH.key() + notExistsMsg);
            }
            if (this.lockConfig.getLongOrDefault(VALIDITY_TIMEOUT_SECONDS) < this.lockConfig.getLongOrDefault(HEARTBEAT_POLL_SECONDS) * 10L) {
                throw new IllegalArgumentException(VALIDITY_TIMEOUT_SECONDS.key() + " should be greater than or equal to 10x " + HEARTBEAT_POLL_SECONDS.key());
            }
            if (this.lockConfig.getLongOrDefault(VALIDITY_TIMEOUT_SECONDS) < 10L) {
                throw new IllegalArgumentException(VALIDITY_TIMEOUT_SECONDS.key() + " should be greater than or equal to 10 seconds.");
            }
            if (this.lockConfig.getLongOrDefault(HEARTBEAT_POLL_SECONDS) < 1L) {
                throw new IllegalArgumentException(HEARTBEAT_POLL_SECONDS.key() + " should be greater than or equal to 1 second.");
            }
        }
    }
}

