/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class GlobalSortPartitioner<T>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final boolean shouldPopulateMetaFields;

    public GlobalSortPartitioner(HoodieWriteConfig config) {
        this.shouldPopulateMetaFields = config.populateMetaFields();
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        if (!this.shouldPopulateMetaFields) {
            throw new HoodieException(BulkInsertSortMode.GLOBAL_SORT.name() + " mode requires meta-fields to be enabled");
        }
        return records.sortBy((Function & Serializable)record -> record.getPartitionPath() + "+" + record.getRecordKey(), true, outputSparkPartitions);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

