/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileCursor;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;

public class HFileDataBlock
extends HFileBlock {
    private static final long ZERO_TS_VERSION_BYTE_LENGTH = 1L;
    protected final int uncompressedContentEndRelativeOffset;

    protected HFileDataBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.DATA, byteBuff, startOffsetInBuff);
        this.uncompressedContentEndRelativeOffset = this.uncompressedEndOffset - this.sizeCheckSum - this.startOffsetInBuff;
    }

    public int seekTo(HFileCursor cursor, Key key, int blockStartOffsetInFile) {
        int relativeOffset;
        int lastRelativeOffset = relativeOffset = cursor.getOffset() - blockStartOffsetInFile;
        Option<KeyValue> lastKeyValue = cursor.getKeyValue();
        while (relativeOffset < this.uncompressedContentEndRelativeOffset) {
            KeyValue kv = this.readKeyValue(relativeOffset);
            int comp = kv.getKey().compareTo(key);
            if (comp == 0) {
                cursor.set(relativeOffset + blockStartOffsetInFile, kv);
                return 0;
            }
            if (comp > 0) {
                if (lastKeyValue.isPresent()) {
                    cursor.set(lastRelativeOffset + blockStartOffsetInFile, lastKeyValue.get());
                } else {
                    cursor.setOffset(lastRelativeOffset + blockStartOffsetInFile);
                }
                return this.isAtFirstKey(relativeOffset) ? -2 : 1;
            }
            long increment = 8L + (long)kv.getKeyLength() + (long)kv.getValueLength() + 1L;
            lastRelativeOffset = relativeOffset;
            relativeOffset = (int)((long)relativeOffset + increment);
            lastKeyValue = Option.of(kv);
        }
        if (lastKeyValue.isPresent()) {
            cursor.set(lastRelativeOffset + blockStartOffsetInFile, lastKeyValue.get());
        } else {
            cursor.setOffset(lastRelativeOffset + blockStartOffsetInFile);
        }
        return 1;
    }

    public KeyValue readKeyValue(int offset) {
        return new KeyValue(this.byteBuff, offset);
    }

    public boolean next(HFileCursor cursor, int blockStartOffsetInFile) {
        int offset = cursor.getOffset() - blockStartOffsetInFile;
        Option<KeyValue> keyValue = cursor.getKeyValue();
        if (!keyValue.isPresent()) {
            keyValue = Option.of(this.readKeyValue(offset));
        }
        cursor.increment(8L + (long)keyValue.get().getKeyLength() + (long)keyValue.get().getValueLength() + 1L);
        return cursor.getOffset() - blockStartOffsetInFile < this.uncompressedContentEndRelativeOffset;
    }

    private boolean isAtFirstKey(int relativeOffset) {
        return relativeOffset == 33;
    }
}

