/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.keygen.AutoRecordKeyGeneratorWrapper;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;

public class AutoRecordGenWrapperKeyGenerator
extends BuiltinKeyGenerator
implements AutoRecordKeyGeneratorWrapper {
    private final BuiltinKeyGenerator keyGenerator;
    private Integer partitionId;
    private String instantTime;
    private int rowId;

    public AutoRecordGenWrapperKeyGenerator(TypedProperties config, BuiltinKeyGenerator keyGenerator) {
        super(config);
        this.keyGenerator = keyGenerator;
        this.rowId = 0;
        this.partitionId = null;
        this.instantTime = null;
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return this.generateSequenceId(this.rowId++);
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return this.keyGenerator.getPartitionPath(record);
    }

    @Override
    public String getRecordKey(Row row) {
        return this.generateSequenceId(this.rowId++);
    }

    @Override
    public UTF8String getRecordKey(InternalRow internalRow, StructType schema) {
        return UTF8String.fromString((String)this.generateSequenceId(this.rowId++));
    }

    @Override
    public String getPartitionPath(Row row) {
        return this.keyGenerator.getPartitionPath(row);
    }

    @Override
    public UTF8String getPartitionPath(InternalRow internalRow, StructType schema) {
        return this.keyGenerator.getPartitionPath(internalRow, schema);
    }

    @Override
    public List<String> getRecordKeyFieldNames() {
        return this.keyGenerator.getRecordKeyFieldNames();
    }

    @Override
    public List<String> getPartitionPathFields() {
        return this.keyGenerator.getPartitionPathFields();
    }

    @Override
    public boolean isConsistentLogicalTimestampEnabled() {
        return this.keyGenerator.isConsistentLogicalTimestampEnabled();
    }

    @Override
    public BuiltinKeyGenerator getPartitionKeyGenerator() {
        return this.keyGenerator;
    }

    private String generateSequenceId(long recordIndex) {
        if (this.partitionId == null) {
            this.partitionId = this.config.getInteger("_hoodie.record.key.gen.partition.id");
        }
        if (this.instantTime == null) {
            this.instantTime = this.config.getString("_hoodie.record.key.gen.instant.time");
        }
        return HoodieRecord.generateSequenceId(this.instantTime, this.partitionId, recordIndex);
    }
}

