/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedPartitionAwareCompactionStrategy;
import org.apache.hudi.table.action.compact.strategy.CompactionStrategy;

public class UnBoundedPartitionAwareCompactionStrategy
extends CompactionStrategy {
    @Override
    public Pair<List<HoodieCompactionOperation>, List<String>> orderAndFilter(HoodieWriteConfig config, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionWorkloads) {
        BoundedPartitionAwareCompactionStrategy boundedPartitionAwareCompactionStrategy = new BoundedPartitionAwareCompactionStrategy();
        List<HoodieCompactionOperation> operationsToExclude = boundedPartitionAwareCompactionStrategy.orderAndFilter(config, operations, pendingCompactionWorkloads).getLeft();
        ArrayList<HoodieCompactionOperation> allOperations = new ArrayList<HoodieCompactionOperation>(operations);
        allOperations.removeAll(operationsToExclude);
        return Pair.of(allOperations, Collections.emptyList());
    }

    @Override
    public Pair<List<String>, List<String>> filterPartitionPaths(HoodieWriteConfig writeConfig, List<String> partitionPaths) {
        List allPartitionPaths = partitionPaths.stream().map(partition -> partition.replace("/", "-")).sorted(Comparator.reverseOrder()).map(partitionPath -> partitionPath.replace("-", "/")).collect(Collectors.toList());
        BoundedPartitionAwareCompactionStrategy boundedPartitionAwareCompactionStrategy = new BoundedPartitionAwareCompactionStrategy();
        List<String> partitionsToExclude = boundedPartitionAwareCompactionStrategy.filterPartitionPaths(writeConfig, partitionPaths).getLeft();
        allPartitionPaths.removeAll(partitionsToExclude);
        return Pair.of(allPartitionPaths, Collections.emptyList());
    }
}

