/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.ColumnStatsIndexSupport;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimeMicrosWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowMetadataTableColumnStatsProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\n\u0014\u0001\tBQ\u0001\r\u0001\u0005\u0002EBqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004?\u0001\u0001\u0006I!\u000e\u0005\b\u007f\u0001\u0011\r\u0011\"\u0003A\u0011\u00199\u0005\u0001)A\u0005\u0003\")\u0001\n\u0001C\u0001i!)\u0011\n\u0001C\u0001\u0001\")!\n\u0001C!\u0017\")\u0011\r\u0001C\u0005E\")\u0001\u000f\u0001C\u0001c\"9\u00111\u0003\u0001\u0005B\u0005UqaBA\u000f'!\u0005\u0011q\u0004\u0004\u0007%MA\t!!\t\t\rAjA\u0011AA\u0015\u0011%\tY#\u0004b\u0001\n\u0003\ti\u0003\u0003\u0005\u0002>5\u0001\u000b\u0011BA\u0018\u0011\u001d\ty$\u0004C\u0001\u0003\u0003\u0012Qe\u00155po6+G/\u00193bi\u0006$\u0016M\u00197f\u0007>dW/\u001c8Ti\u0006$8\u000f\u0015:pG\u0016$WO]3\u000b\u0005Q)\u0012A\u00039s_\u000e,G-\u001e:fg*\u0011acF\u0001\bG>lW.\u00198e\u0015\tA\u0012$\u0001\u0003ik\u0012L'B\u0001\u000e\u001c\u0003\r\u0019\u0018\u000f\u001c\u0006\u00039u\tQa\u001d9be.T!AH\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0013aA8sO\u000e\u00011\u0003\u0002\u0001$O)\u0002\"\u0001J\u0013\u000e\u0003MI!AJ\n\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t!\u0003&\u0003\u0002*'\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\t\u0003W9j\u0011\u0001\f\u0006\u0003[m\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003_1\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002eA\u0011A\u0005A\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#A\u001b\u0011\u0007YJ4(D\u00018\u0015\u0005A\u0014!B:dC2\f\u0017B\u0001\u001e8\u0005\u0015\t%O]1z!\t!C(\u0003\u0002>'\t\u0011\u0002K]8dK\u0012,(/\u001a)be\u0006lW\r^3s\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002\u0003B\u0011!)R\u0007\u0002\u0007*\u0011A)G\u0001\u0006if\u0004Xm]\u0005\u0003\r\u000e\u0013!b\u0015;sk\u000e$H+\u001f9f\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0003)\u0001\u0018M]1nKR,'o]\u0001\u000b_V$\b/\u001e;UsB,\u0017\u0001B2bY2$\"\u0001\u0014/\u0011\u00075+\u0006L\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011+I\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!\u0001V\u001c\u0002\u000fA\f7m[1hK&\u0011ak\u0016\u0002\u0004'\u0016\f(B\u0001+8!\tI&,D\u0001\u001a\u0013\tY\u0016DA\u0002S_^DQ!\u0018\u0005A\u0002y\u000bA!\u0019:hgB\u0011AeX\u0005\u0003AN\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\u0018aE4fi\u000e{G.^7o'R\fGo\u001d,bYV,GCA2l!\t!\u0007N\u0004\u0002fMB\u0011qjN\u0005\u0003O^\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qm\u000e\u0005\u0006Y&\u0001\r!\\\u0001\fgR\fGo]0wC2,X\r\u0005\u00027]&\u0011qn\u000e\u0002\u0004\u0003:L\u0018a\u00052vS2$g)\u001b7f'f\u001cH/Z7WS\u0016<H\u0003\u0002:~\u0003\u0007\u0001\"a]>\u000e\u0003QT!!\u001e<\u0002\tYLWm\u001e\u0006\u0003ob\fQ\u0001^1cY\u0016T!!\u001f>\u0002\r\r|W.\\8o\u0015\tAR$\u0003\u0002}i\nI\u0002j\\8eS\u0016$\u0016M\u00197f\r&dWmU=ti\u0016lg+[3x\u0011\u00159(\u00021\u0001\u007f!\r1t0\\\u0005\u0004\u0003\u00039$AB(qi&|g\u000eC\u0004\u0002\u0006)\u0001\r!a\u0002\u0002\u001b\u0015tw-\u001b8f\u0007>tG/\u001a=u!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007q\u00061QM\\4j]\u0016LA!!\u0005\u0002\f\t\u0019\u0002j\\8eS\u0016,enZ5oK\u000e{g\u000e^3yi\u0006)!-^5mIV\u0011\u0011q\u0003\t\u0004I\u0005e\u0011bAA\u000e'\tI\u0001K]8dK\u0012,(/Z\u0001&'\"|w/T3uC\u0012\fG/\u0019+bE2,7i\u001c7v[:\u001cF/\u0019;t!J|7-\u001a3ve\u0016\u0004\"\u0001J\u0007\u0014\u00075\t\u0019\u0003E\u00027\u0003KI1!a\n8\u0005\u0019\te.\u001f*fMR\u0011\u0011qD\u0001\u0005\u001d\u0006kU)\u0006\u0002\u00020A!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001\u00027b]\u001eT!!!\u000f\u0002\t)\fg/Y\u0005\u0004S\u0006M\u0012!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0003\u0003\u0007\u0002R!!\u0012\u0002P\u001dj!!a\u0012\u000b\t\u0005%\u00131J\u0001\tMVt7\r^5p]*!\u0011QJA\u001c\u0003\u0011)H/\u001b7\n\t\u0005E\u0013q\t\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowMetadataTableColumnStatsProcedure
extends BaseProcedure
implements ProcedureBuilder,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowMetadataTableColumnStatsProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowMetadataTableColumnStatsProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        Set set;
        super.checkArgs(this.PARAMETERS(), args2);
        Option<Object> table = this.getArgValueOrDefault(args2, this.PARAMETERS()[0]);
        String partitions = this.getArgValueOrDefault(args2, this.PARAMETERS()[1]).getOrElse((Function0 & Serializable & scala.Serializable)() -> "").toString();
        Seq partitionsSeq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions.split(","))).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ShowMetadataTableColumnStatsProcedure.$anonfun$call$2(x$1))))).toSeq();
        String targetColumns = this.getArgValueOrDefault(args2, this.PARAMETERS()[2]).getOrElse((Function0 & Serializable & scala.Serializable)() -> "").toString();
        Seq targetColumnsSeq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetColumns.split(","))).toSeq();
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        TableSchemaResolver schemaUtil = new TableSchemaResolver(metaClient);
        StructType schema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(schemaUtil.getTableAvroSchema());
        ColumnStatsIndexSupport columnStatsIndex = new ColumnStatsIndexSupport(this.spark(), schema, metadataConfig, metaClient, ColumnStatsIndexSupport$.MODULE$.$lessinit$greater$default$5());
        Seq x$12 = targetColumnsSeq;
        boolean x$22 = false;
        Option<Set<String>> x$3 = columnStatsIndex.loadColumnStatsIndexRecords$default$2();
        HoodieData<HoodieMetadataColumnStats> colStatsRecords = columnStatsIndex.loadColumnStatsIndexRecords((Seq<String>)x$12, x$3, x$22);
        HoodieSparkEngineContext engineCtx = new HoodieSparkEngineContext(this.jsc());
        HoodieTableFileSystemView fsView = this.buildFileSystemView(table, engineCtx);
        if (partitionsSeq.isEmpty()) {
            HoodieTableMetadata metaTable = HoodieTableMetadata.create(engineCtx, metaClient.getStorage(), metadataConfig, basePath);
            set = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metaTable.getAllPartitionPaths()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)path -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestFileSlices((String)path).iterator()).asScala(), Buffer$.MODULE$.canBuildFrom())).toSet();
        } else {
            set = ((TraversableOnce)partitionsSeq.flatMap((Function1 & Serializable & scala.Serializable)partition -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(fsView.getLatestFileSlices((String)partition).iterator()).asScala(), Seq$.MODULE$.canBuildFrom())).toSet();
        }
        Set allFileSlices = set;
        Set allFileNames = (Set)allFileSlices.map((Function1 & Serializable & scala.Serializable)x$2 -> ((BaseFile)x$2.getBaseFile().get()).getFileName(), Set$.MODULE$.canBuildFrom());
        ListBuffer rows = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(colStatsRecords.collectAsList()).asScala()).filter((Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)allFileNames.contains((Object)c.getFileName())))).foreach((Function1 & Serializable & scala.Serializable)c -> rows.$plus$eq((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.getFileName(), c.getColumnName(), this.getColumnStatsValue(c.getMinValue()), this.getColumnStatsValue(c.getMaxValue()), BoxesRunTime.boxToLong((long)c.getNullCount())}))));
        return (Seq)rows.toList().sortBy((Function1 & Serializable & scala.Serializable)r -> r.getString(1), (Ordering)Ordering.String$.MODULE$);
    }

    private String getColumnStatsValue(Object stats_value) {
        Object object = stats_value;
        if (object == null) {
            return "null";
        }
        if (object instanceof IntWrapper ? true : (object instanceof BooleanWrapper ? true : (object instanceof DateWrapper ? true : (object instanceof DoubleWrapper ? true : (object instanceof FloatWrapper ? true : (object instanceof LongWrapper ? true : (object instanceof StringWrapper ? true : (object instanceof TimeMicrosWrapper ? true : object instanceof TimestampMicrosWrapper)))))))) {
            return String.valueOf(((IndexedRecord)stats_value).get(0));
        }
        if (object instanceof BytesWrapper) {
            ByteBuffer bytes_value = ((BytesWrapper)((Object)stats_value)).getValue();
            return Arrays.toString(bytes_value.array());
        }
        if (object instanceof DecimalWrapper) {
            ByteBuffer decimal_value = ((DecimalWrapper)((Object)stats_value)).getValue();
            return Arrays.toString(decimal_value.array());
        }
        throw new HoodieException(new StringBuilder(18).append("Unsupported type: ").append(stats_value.getClass().getSimpleName()).toString());
    }

    public HoodieTableFileSystemView buildFileSystemView(Option<Object> table, HoodieEngineContext engineContext) {
        String basePath = this.getBasePath(table, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        String maxInstant = metaClient.createNewInstantTime();
        Iterator instants = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeline.getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ShowMetadataTableColumnStatsProcedure.$anonfun$buildFileSystemView$1(maxInstant, x$3)));
        HoodieTimeline filteredTimeline = metaClient.getTimelineLayout().getTimelineFactory().createDefaultTimeline(new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)instants.toList()).asJava()).stream(), metaClient.getActiveTimeline().getInstantReader());
        return HoodieTableFileSystemView.fileListingBasedFileSystemView(engineContext, metaClient, filteredTimeline);
    }

    @Override
    public Procedure build() {
        return new ShowMetadataTableColumnStatsProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$2(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$buildFileSystemView$1(String maxInstant$1, HoodieInstant x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3.requestedTime())).$less((Object)maxInstant$1);
    }

    public ShowMetadataTableColumnStatsProcedure() {
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "partition", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(2, "targetColumns", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("file_name", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("column_name", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("min_value", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("max_value", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("null_number", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }
}

