/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.TruncateTableProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001\u0002\b\u0010\u0001yAQ\u0001\r\u0001\u0005\u0002EBQa\r\u0001\u0005\u0002QBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004D\u0001\u0001\u0006IA\u000f\u0005\u0006\t\u0002!\t!\u000f\u0005\u0006\u000b\u0002!\tA\u0012\u0005\u0006\u001b\u0002!\tET\u0004\u0006I>A\t!\u001a\u0004\u0006\u001d=A\tA\u001a\u0005\u0006a%!\tA\u001b\u0005\bW&\u0011\r\u0011\"\u0001m\u0011\u0019)\u0018\u0002)A\u0005[\")a/\u0003C\u0001o\n1BK];oG\u0006$X\rV1cY\u0016\u0004&o\\2fIV\u0014XM\u0003\u0002\u0011#\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005I\u0019\u0012aB2p[6\fg\u000e\u001a\u0006\u0003)U\tA\u0001[;eS*\u0011acF\u0001\u0004gFd'B\u0001\r\u001a\u0003\u0015\u0019\b/\u0019:l\u0015\tQ2$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00029\u0005\u0019qN]4\u0004\u0001M)\u0001aH\u0012'UA\u0011\u0001%I\u0007\u0002\u001f%\u0011!e\u0004\u0002\u000e\u0005\u0006\u001cX\r\u0015:pG\u0016$WO]3\u0011\u0005\u0001\"\u0013BA\u0013\u0010\u0005A\u0001&o\\2fIV\u0014XMQ;jY\u0012,'\u000f\u0005\u0002(Q5\t1#\u0003\u0002*'\t!\u0002K]8wS\u0012,7\u000fS8pI&,7i\u001c8gS\u001e\u0004\"a\u000b\u0018\u000e\u00031R!!L\f\u0002\u0011%tG/\u001a:oC2L!a\f\u0017\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012A\r\t\u0003A\u0001\tQAY;jY\u0012,\u0012!\u000e\t\u0003AYJ!aN\b\u0003\u0013A\u0013xnY3ekJ,\u0017A\u0003)B%\u0006kU\tV#S'V\t!\bE\u0002<}\u0001k\u0011\u0001\u0010\u0006\u0002{\u0005)1oY1mC&\u0011q\b\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003A\u0005K!AQ\b\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM]\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006%\u0001\u0006qCJ\fW.\u001a;feN\f!b\\;uaV$H+\u001f9f+\u00059\u0005C\u0001%L\u001b\u0005I%B\u0001&\u0016\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0015J\u0001\u0006TiJ,8\r\u001e+za\u0016\fAaY1mYR\u0011qj\u0018\t\u0004!b[fBA)W\u001d\t\u0011V+D\u0001T\u0015\t!V$\u0001\u0004=e>|GOP\u0005\u0002{%\u0011q\u000bP\u0001\ba\u0006\u001c7.Y4f\u0013\tI&LA\u0002TKFT!a\u0016\u001f\u0011\u0005qkV\"A\u000b\n\u0005y+\"a\u0001*po\")\u0001m\u0002a\u0001C\u0006!\u0011M]4t!\t\u0001#-\u0003\u0002d\u001f\ti\u0001K]8dK\u0012,(/Z!sON\fa\u0003\u0016:v]\u000e\fG/\u001a+bE2,\u0007K]8dK\u0012,(/\u001a\t\u0003A%\u0019\"!C4\u0011\u0005mB\u0017BA5=\u0005\u0019\te.\u001f*fMR\tQ-\u0001\u0003O\u00036+U#A7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018\u0001\u00027b]\u001eT\u0011A]\u0001\u0005U\u00064\u0018-\u0003\u0002u_\n11\u000b\u001e:j]\u001e\fQAT!N\u000b\u0002\nqAY;jY\u0012,'/F\u0001y!\rIhpI\u0007\u0002u*\u00111\u0010`\u0001\tMVt7\r^5p]*\u0011Q0]\u0001\u0005kRLG.\u0003\u0002\u0000u\nA1+\u001e9qY&,'\u000f")
public class TruncateTableProcedure
extends BaseProcedure
implements ProcedureBuilder,
ProvidesHoodieConfig {
    private final ProcedureParameter[] PARAMETERS;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return TruncateTableProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return TruncateTableProcedure$.MODULE$.NAME();
    }

    @Override
    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$(this, hoodieCatalogTable);
    }

    @Override
    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$(this, hoodieCatalogTable, sparkSession, isOverwritePartition, isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    @Override
    public Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$(this);
    }

    @Override
    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$(this);
    }

    @Override
    public Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$(this, useLegacyInsertModeFlow, incomingParams);
    }

    @Override
    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionSpec, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$(this, sparkSession, catalogTable, partitionSpec, extraOptions);
    }

    @Override
    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$(this, sparkSession, hoodieCatalogTable, partitionsToDrop);
    }

    @Override
    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$(this, hoodieCatalogTable, sparkSession);
    }

    @Override
    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$(this, sparkSession, hoodieCatalogTable, tableConfig, extraOptions);
    }

    @Override
    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Procedure build() {
        return new TruncateTableProcedure();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("time_cost", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));
    }

    @Override
    public Seq<Row> call(ProcedureArgs args2) {
        BoxedUnit boxedUnit;
        super.checkArgs(this.parameters(), args2);
        String tableNameStr = (String)this.getArgValueOrDefault(args2, this.parameters()[0]).get();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("start execute truncate table procedure for ").append(tableNameStr).toString());
        String partitionsStr = (String)this.getArgValueOrDefault(args2, this.parameters()[1]).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        HoodieCatalogTable catalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), tableNameStr);
        Tuple2<String, String> tuple2 = this.getDbAndTableName(tableNameStr);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String db = (String)tuple2._1();
        String tableName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)db, (Object)tableName);
        String db2 = (String)tuple22._1();
        String tableName2 = (String)tuple22._2();
        SessionCatalog catalog = this.sparkSession().sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(TableIdentifier$.MODULE$.apply(tableName2, (Option)new Some((Object)db2)));
        String tableId = table.identifier().quotedString();
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException(new StringBuilder(48).append("Operation not allowed: TRUNCATE TABLE on views: ").append(tableId).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        if (table.partitionColumnNames().isEmpty() && new StringOps(Predef$.MODULE$.augmentString(partitionsStr)).nonEmpty()) {
            throw new AnalysisException(new StringBuilder(106).append("Operation not allowed: TRUNCATE TABLE ... PARTITION is not supported ").append("for tables that are not partitioned: ").append(tableId).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5(), AnalysisException$.MODULE$.$lessinit$greater$default$6(), AnalysisException$.MODULE$.$lessinit$greater$default$7());
        }
        String basePath = catalogTable.tableLocation();
        TypedProperties properties = catalogTable.tableConfig().getProps();
        if (partitionsStr.isEmpty()) {
            StoragePath targetPath = new StoragePath(basePath);
            HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext(this.sparkSession().sparkContext()));
            HoodieStorage storage = HoodieStorageUtils.getStorage(basePath, HadoopFSUtils.getStorageConf(this.sparkSession().sessionState().newHadoopConf()));
            long startTime = System.currentTimeMillis();
            FSUtils.deleteDir(engineContext, storage, targetPath, this.sparkSession().sparkContext().defaultParallelism());
            HoodieTableMetaClient metaClient = HoodieTableMetaClient.newTableBuilder().fromProperties(properties).initTable(HadoopFSUtils.getStorageConf(this.sparkSession().sessionState().newHadoopConf()), catalogTable.tableLocation());
            catalogTable.tableConfig().clearMetadataPartitions(metaClient);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Success to execute truncate table procedure for ").append(tableNameStr).toString());
            boxedUnit = new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUCCESS", BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime))})), (List)Nil$.MODULE$);
        } else {
            Map<String, String> parameters = this.buildHoodieDropPartitionsConfig(this.sparkSession(), catalogTable, partitionsStr);
            Tuple6<Object, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, org.apache.hudi.common.util.Option<String>, SparkRDDWriteClient<?>, HoodieTableConfig> tuple6 = HoodieSparkSqlWriter$.MODULE$.write(this.sparkSession().sqlContext(), SaveMode.Append, parameters, (Dataset<Row>)this.sparkSession().emptyDataFrame(), HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6());
            if (tuple6 == null) {
                throw new MatchError(tuple6);
            }
            boolean success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
            boolean success2 = success;
            if (!success2) {
                throw new HoodieException("Truncate Hoodie Table procedure failed");
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        this.sparkSession().catalog().refreshTable(table.identifier().quotedString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Finish execute truncate table procedure for ").append(tableNameStr).toString());
        return (Seq)Nil$.MODULE$;
    }

    public TruncateTableProcedure() {
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$(this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "partitions", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
    }
}

