/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.avro;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.util.Utf8;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.avro.AvroSerializer$;
import org.apache.spark.sql.avro.AvroUtils;
import org.apache.spark.sql.avro.AvroUtils$;
import org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005uh!B\u000f\u001f\u0001\u0001B\u0003\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011u\u0002!\u0011!Q\u0001\nyB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u000f\u0002\u0011\t\u0011)A\u0005\t\"A\u0001\n\u0001B\u0001B\u0003%\u0011\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003T\u0001\u0011\u0005A\fC\u0003a\u0001\u0011\u0005\u0011\rC\u0004h\u0001\t\u0007I\u0011\u00025\t\r=\u0004\u0001\u0015!\u0003j\u0011\u001d\u0001\bA1A\u0005\nEDaA\u001e\u0001!\u0002\u0013\u0011\bbB<\u0001\u0005\u0004%I\u0001\u001f\u0005\u0007u\u0002\u0001\u000b\u0011B=\u0006\tm\u0004A\u0001 \u0005\u000b\u0003\u001f\u0001\u0001R1A\u0005\n\u0005E\u0001bBA\u001a\u0001\u0011%\u0011Q\u0007\u0005\b\u0003[\u0002A\u0011BA8\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a-\u0001\t\u0013\t)\fC\u0004\u0002<\u0002!I!!0\t\u000f\u0005\r\u0007\u0001\"\u0003\u0002F\"9\u0011q\u001a\u0001\u0005\n\u0005EwaBAq=!\u0005\u00111\u001d\u0004\u0007;yA\t!!:\t\rMKB\u0011AAt\u0011\u001d\tI/\u0007C\u0001\u0003WDq!!>\u001a\t\u0003\t9P\u0001\bBmJ|7+\u001a:jC2L'0\u001a:\u000b\u0005}\u0001\u0013\u0001B1we>T!!\t\u0012\u0002\u0007M\fHN\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h'\r\u0001\u0011f\f\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I\u0012\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005Q\n$a\u0002'pO\u001eLgnZ\u0001\u0011e>|GoQ1uC2L8\u000f\u001e+za\u0016\u001c\u0001\u0001\u0005\u00029w5\t\u0011H\u0003\u0002;A\u0005)A/\u001f9fg&\u0011A(\u000f\u0002\t\t\u0006$\u0018\rV=qK\u0006a!o\\8u\u0003Z\u0014x\u000eV=qKB\u0011q(Q\u0007\u0002\u0001*\u0011q\u0004J\u0005\u0003\u0005\u0002\u0013aaU2iK6\f\u0017\u0001\u00038vY2\f'\r\\3\u0011\u0005)*\u0015B\u0001$,\u0005\u001d\u0011un\u001c7fC:\fA\u0003]8tSRLwN\\1m\r&,G\u000eZ'bi\u000eD\u0017A\u00053bi\u0016$\u0018.\\3SK\n\f7/Z'pI\u0016\u0004\"AS(\u000f\u0005-kU\"\u0001'\u000b\u0005I\u0002\u0013B\u0001(M\u0003QaUmZ1ds\n+\u0007.\u0019<j_J\u0004v\u000e\\5ds&\u0011\u0001+\u0015\u0002\u0006-\u0006dW/Z\u0005\u0003%.\u00121\"\u00128v[\u0016\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"b!V,Y3j[\u0006C\u0001,\u0001\u001b\u0005q\u0002\"B\u001b\u0007\u0001\u00049\u0004\"B\u001f\u0007\u0001\u0004q\u0004\"B\"\u0007\u0001\u0004!\u0005\"B$\u0007\u0001\u0004!\u0005\"\u0002%\u0007\u0001\u0004IE\u0003B+^=~CQ!N\u0004A\u0002]BQ!P\u0004A\u0002yBQaQ\u0004A\u0002\u0011\u000b\u0011b]3sS\u0006d\u0017N_3\u0015\u0005\t,\u0007C\u0001\u0016d\u0013\t!7FA\u0002B]fDQA\u001a\u0005A\u0002\t\fAbY1uC2L8\u000f\u001e#bi\u0006\fa\u0002Z1uKJ+'-Y:f\rVt7-F\u0001j!\u0011Q#\u000e\u001c7\n\u0005-\\#!\u0003$v]\u000e$\u0018n\u001c82!\tQS.\u0003\u0002oW\t\u0019\u0011J\u001c;\u0002\u001f\u0011\fG/\u001a*fE\u0006\u001cXMR;oG\u0002\n1\u0003^5nKN$\u0018-\u001c9SK\n\f7/\u001a$v]\u000e,\u0012A\u001d\t\u0005U)\u001c8\u000f\u0005\u0002+i&\u0011Qo\u000b\u0002\u0005\u0019>tw-\u0001\u000buS6,7\u000f^1naJ+'-Y:f\rVt7\rI\u0001\nG>tg/\u001a:uKJ,\u0012!\u001f\t\u0005U)\u0014'-\u0001\u0006d_:4XM\u001d;fe\u0002\u0012\u0011bQ8om\u0016\u0014H/\u001a:\u0011\u000b)jx\u0010\u001c2\n\u0005y\\#!\u0003$v]\u000e$\u0018n\u001c83!\u0011\t\t!a\u0003\u000e\u0005\u0005\r!\u0002BA\u0003\u0003\u000f\t1\"\u001a=qe\u0016\u001c8/[8og*\u0019\u0011\u0011\u0002\u0011\u0002\u0011\r\fG/\u00197zgRLA!!\u0004\u0002\u0004\t\u00112\u000b]3dS\u0006d\u0017N_3e\u000f\u0016$H/\u001a:t\u0003I!WmY5nC2\u001cuN\u001c<feNLwN\\:\u0016\u0005\u0005M\u0001\u0003BA\u000b\u0003[qA!a\u0006\u0002*9!\u0011\u0011DA\u0014\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t7\u0003\u0019a$o\\8u}%\tq%\u0003\u0002&M%\u0011q\u0004J\u0005\u0004\u0003W\u0001\u0015aC\"p]Z,'o]5p]NLA!a\f\u00022\t\tB)Z2j[\u0006d7i\u001c8wKJ\u001c\u0018n\u001c8\u000b\u0007\u0005-\u0002)\u0001\u0007oK^\u001cuN\u001c<feR,'\u000f\u0006\u0006\u00028\u0005m\u0012qHA\"\u0003S\u00022!!\u000f\u0010\u001b\u0005\u0001\u0001BBA\u001f#\u0001\u0007q'\u0001\u0007dCR\fG._:u)f\u0004X\r\u0003\u0004\u0002BE\u0001\rAP\u0001\tCZ\u0014x\u000eV=qK\"9\u0011QI\tA\u0002\u0005\u001d\u0013\u0001D2bi\u0006d\u0017p\u001d;QCRD\u0007CBA%\u0003'\nIF\u0004\u0003\u0002L\u0005=c\u0002BA\u000f\u0003\u001bJ\u0011\u0001L\u0005\u0004\u0003#Z\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003+\n9FA\u0002TKFT1!!\u0015,!\u0011\tY&a\u0019\u000f\t\u0005u\u0013q\f\t\u0004\u0003;Y\u0013bAA1W\u00051\u0001K]3eK\u001aLA!!\u001a\u0002h\t11\u000b\u001e:j]\u001eT1!!\u0019,\u0011\u001d\tY'\u0005a\u0001\u0003\u000f\n\u0001\"\u0019<s_B\u000bG\u000f[\u0001\u0013]\u0016<8\u000b\u001e:vGR\u001cuN\u001c<feR,'\u000f\u0006\u0006\u0002r\u0005E\u00151TAP\u0003C\u0003bA\u000b6\u0002t\u0005m\u0004\u0003BA;\u0003oj!!a\u0002\n\t\u0005e\u0014q\u0001\u0002\f\u0013:$XM\u001d8bYJ{w\u000f\u0005\u0003\u0002~\u0005-e\u0002BA@\u0003\u000bsA!a\u0006\u0002\u0002&\u0019\u00111\u0011!\u0002\u000f\u001d,g.\u001a:jG&!\u0011qQAE\u0003-9UM\\3sS\u000e$\u0015\r^1\u000b\u0007\u0005\r\u0005)\u0003\u0003\u0002\u000e\u0006=%A\u0002*fG>\u0014HM\u0003\u0003\u0002\b\u0006%\u0005bBAJ%\u0001\u0007\u0011QS\u0001\u000fG\u0006$\u0018\r\\=tiN#(/^2u!\rA\u0014qS\u0005\u0004\u00033K$AC*ueV\u001cG\u000fV=qK\"1\u0011Q\u0014\nA\u0002y\n!\"\u0019<s_N#(/^2u\u0011\u001d\t)E\u0005a\u0001\u0003\u000fBq!a\u001b\u0013\u0001\u0004\t9%A\toK^,f.[8o\u0007>tg/\u001a:uKJ$\"\"a*\u0002*\u0006-\u0016qVAY!\u0015Q#.a\u001dc\u0011\u001d\t\u0019j\u0005a\u0001\u0003+Ca!!,\u0014\u0001\u0004q\u0014!C1we>,f.[8o\u0011\u001d\t)e\u0005a\u0001\u0003\u000fBq!a\u001b\u0014\u0001\u0004\t9%A\u0006dC:l\u0015\r]+oS>tG#\u0002#\u00028\u0006e\u0006bBAJ)\u0001\u0007\u0011Q\u0013\u0005\u0007\u0003;#\u0002\u0019\u0001 \u0002'I,7o\u001c7wK:+H\u000e\\1cY\u0016$\u0016\u0010]3\u0015\u000by\ny,!1\t\r\u0005\u0005S\u00031\u0001?\u0011\u0015\u0019U\u00031\u0001E\u0003=\u0011Xm]8mm\u0016\feO]8UsB,G\u0003BAd\u0003\u001b\u0004RAKAe\tzJ1!a3,\u0005\u0019!V\u000f\u001d7fe!1\u0011\u0011\t\fA\u0002y\n\u0011d^1s]:+H\u000e\\1cS2LG/\u001f#jM\u001a,'/\u001a8dKR1\u00111[Am\u0003;\u00042AKAk\u0013\r\t9n\u000b\u0002\u0005+:LG\u000f\u0003\u0004\u0002\\^\u0001\r\u0001R\u0001\rCZ\u0014xNT;mY\u0006\u0014G.\u001a\u0005\u0007\u0003?<\u0002\u0019\u0001#\u0002!\r\fG/\u00197zgRtU\u000f\u001c7bE2,\u0017AD!we>\u001cVM]5bY&TXM\u001d\t\u0003-f\u0019\"!G\u0015\u0015\u0005\u0005\r\u0018aG2sK\u0006$X\rR1uKJ+'-Y:f\rVt7-\u00138Xe&$X\rF\u0003j\u0003[\f\t\u0010\u0003\u0004\u0002pn\u0001\r!S\u0001\u000be\u0016\u0014\u0017m]3N_\u0012,\u0007bBAz7\u0001\u0007\u0011\u0011L\u0001\u0007M>\u0014X.\u0019;\u0002A\r\u0014X-\u0019;f)&lWm\u001d;b[B\u0014VMY1tK\u001a+hnY%o/JLG/\u001a\u000b\u0006e\u0006e\u00181 \u0005\u0007\u0003_d\u0002\u0019A%\t\u000f\u0005MH\u00041\u0001\u0002Z\u0001")
public class AvroSerializer
implements Logging {
    private Conversions.DecimalConversion decimalConversions;
    private final DataType rootCatalystType;
    private final Schema rootAvroType;
    private final boolean positionalFieldMatch;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Function1<Object, Object> converter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Function1<Object, Object> createTimestampRebaseFuncInWrite(Enumeration.Value value, String string) {
        return AvroSerializer$.MODULE$.createTimestampRebaseFuncInWrite(value, string);
    }

    public static Function1<Object, Object> createDateRebaseFuncInWrite(Enumeration.Value value, String string) {
        return AvroSerializer$.MODULE$.createDateRebaseFuncInWrite(value, string);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Object serialize(Object catalystData) {
        return this.converter().apply(catalystData);
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Function1<Object, Object> converter() {
        return this.converter;
    }

    private Conversions.DecimalConversion decimalConversions$lzycompute() {
        AvroSerializer avroSerializer = this;
        synchronized (avroSerializer) {
            if (!this.bitmap$0) {
                this.decimalConversions = new Conversions.DecimalConversion();
                this.bitmap$0 = true;
            }
        }
        return this.decimalConversions;
    }

    private Conversions.DecimalConversion decimalConversions() {
        if (!this.bitmap$0) {
            return this.decimalConversions$lzycompute();
        }
        return this.decimalConversions;
    }

    private Function2<SpecializedGetters, Object, Object> newConverter(DataType catalystType, Schema avroType, Seq<String> catalystPath, Seq<String> avroPath) {
        String errorPrefix = new StringBuilder(37).append("Cannot convert SQL ").append(AvroUtils$.MODULE$.toFieldStr(catalystPath)).append(" ").append("to Avro ").append(AvroUtils$.MODULE$.toFieldStr(avroPath)).append(" because ").toString();
        Tuple2 tuple2 = new Tuple2((Object)catalystType, (Object)avroType.getType());
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (NullType$.MODULE$.equals(dataType) && Schema.Type.NULL.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$1(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BooleanType$.MODULE$.equals(dataType) && Schema.Type.BOOLEAN.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToBoolean((boolean)getter.getBoolean(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ByteType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getByte(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (ShortType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getShort(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (IntegerType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (LongType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (FloatType$.MODULE$.equals(dataType) && Schema.Type.FLOAT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToFloat((float)getter.getFloat(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DoubleType$.MODULE$.equals(dataType) && Schema.Type.DOUBLE.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToDouble((double)getter.getDouble(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.FIXED.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$9(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType d = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (d instanceof DecimalType) {
                DecimalType decimalType = (DecimalType)d;
                if (Schema.Type.BYTES.equals(type)) {
                    LogicalType logicalType = avroType.getLogicalType();
                    LogicalTypes.Decimal decimal = LogicalTypes.decimal((int)decimalType.precision(), (int)decimalType.scale());
                    if (!(logicalType != null ? !logicalType.equals(decimal) : decimal != null)) {
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$10(this, decimalType, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.ENUM.equals(type)) {
                Set enumSymbols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getEnumSymbols()).asScala()).toSet();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$11(enumSymbols, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (StringType$.MODULE$.equals(dataType) && Schema.Type.STRING.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$12(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.FIXED.equals(type)) {
                int size = avroType.getFixedSize();
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$13(size, errorPrefix, avroType, getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (BinaryType$.MODULE$.equals(dataType) && Schema.Type.BYTES.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$14(getter, BoxesRunTime.unboxToInt((Object)ordinal));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (DateType$.MODULE$.equals(dataType) && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)AvroSerializer.$anonfun$newConverter$15(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType == null ? true : logicalType instanceof LogicalTypes.TimestampMillis) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)))));
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)AvroSerializer.$anonfun$newConverter$17(this, getter, BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                throw new IncompatibleSchemaException(new StringBuilder(51).append(errorPrefix).append("SQL type ").append(TimestampType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (TimestampNTZType$.MODULE$.equals(dataType) && Schema.Type.LONG.equals(type)) {
                LogicalType logicalType = avroType.getLogicalType();
                if (logicalType == null ? true : logicalType instanceof LogicalTypes.LocalTimestampMillis) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.microsToMillis(getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal))));
                }
                if (logicalType instanceof LogicalTypes.LocalTimestampMicros) {
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
                }
                throw new IncompatibleSchemaException(new StringBuilder(51).append(errorPrefix).append("SQL type ").append(TimestampNTZType$.MODULE$.sql()).append(" cannot be converted to Avro logical type ").append(logicalType).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType;
                DataType et = arrayType.elementType();
                boolean containsNull = arrayType.containsNull();
                if (Schema.Type.ARRAY.equals(type)) {
                    Function2<SpecializedGetters, Object, Object> elementConverter = this.newConverter(et, this.resolveNullableType(avroType.getElementType(), containsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom())));
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$20(containsNull, elementConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.RECORD.equals(type)) {
                    Function1<InternalRow, GenericData.Record> structConverter = this.newStructConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$21(structConverter, numFields, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                }
            }
        }
        if (tuple2 != null) {
            DataType st = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (st instanceof StructType) {
                StructType structType = (StructType)st;
                if (Schema.Type.UNION.equals(type)) {
                    Function1<InternalRow, Object> unionConverter = this.newUnionConverter(structType, avroType, catalystPath, avroPath);
                    int numFields = structType.length();
                    return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> unionConverter.apply((Object)getter.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), numFields));
                }
            }
        }
        if (tuple2 != null) {
            DataType dataType = (DataType)tuple2._1();
            Schema.Type type = (Schema.Type)tuple2._2();
            if (dataType instanceof MapType) {
                MapType mapType = (MapType)dataType;
                DataType kt = mapType.keyType();
                DataType vt = mapType.valueType();
                boolean valueContainsNull = mapType.valueContainsNull();
                if (Schema.Type.MAP.equals(type)) {
                    DataType dataType2 = kt;
                    StringType$ stringType$ = StringType$.MODULE$;
                    if (!(dataType2 != null ? !dataType2.equals(stringType$) : stringType$ != null)) {
                        Function2<SpecializedGetters, Object, Object> valueConverter = this.newConverter(vt, this.resolveNullableType(avroType.getValueType(), valueContainsNull), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom())));
                        return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> AvroSerializer.$anonfun$newConverter$23(valueContainsNull, valueConverter, getter, BoxesRunTime.unboxToInt((Object)ordinal));
                    }
                }
            }
        }
        if (tuple2 != null) {
            Schema.Type type = (Schema.Type)tuple2._2();
            if (tuple2._1() instanceof YearMonthIntervalType && Schema.Type.INT.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToInteger((int)getter.getInt(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        if (tuple2 != null) {
            Schema.Type type = (Schema.Type)tuple2._2();
            if (tuple2._1() instanceof DayTimeIntervalType && Schema.Type.LONG.equals(type)) {
                return (Function2 & Serializable & scala.Serializable)(getter, ordinal) -> BoxesRunTime.boxToLong((long)getter.getLong(BoxesRunTime.unboxToInt((Object)ordinal)));
            }
        }
        throw new IncompatibleSchemaException(new StringBuilder(48).append(errorPrefix).append("schema is incompatible (sqlType = ").append(catalystType.sql()).append(", avroType = ").append(avroType).append(")").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
    }

    private Function1<InternalRow, GenericData.Record> newStructConverter(StructType catalystStruct, Schema avroStruct, Seq<String> catalystPath, Seq<String> avroPath) {
        AvroUtils.AvroSchemaHelper avroSchemaHelper = new AvroUtils.AvroSchemaHelper(avroStruct, catalystStruct, avroPath, catalystPath, this.positionalFieldMatch);
        avroSchemaHelper.validateNoExtraCatalystFields(false);
        avroSchemaHelper.validateNoExtraRequiredAvroFields();
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)avroSchemaHelper.matchedFields().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AvroUtils.AvroMatchedField avroMatchedField = x0$1;
            if (avroMatchedField != null) {
                StructField catalystField = avroMatchedField.catalystField();
                Schema.Field avroField = avroMatchedField.avroField();
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(catalystField.dataType(), this.resolveNullableType(avroField.schema(), catalystField.nullable()), (Seq<String>)((Seq)catalystPath.$colon$plus((Object)catalystField.name(), Seq$.MODULE$.canBuildFrom())), (Seq<String>)((Seq)avroPath.$colon$plus((Object)avroField.name(), Seq$.MODULE$.canBuildFrom())));
                return new Tuple2((Object)BoxesRunTime.boxToInteger((int)avroField.pos()), converter);
            }
            throw new MatchError((Object)avroMatchedField);
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class)))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Function2.class));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int[] avroIndices = (int[])tuple2._1();
        Function2[] fieldConverters = (Function2[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)avroIndices, (Object)fieldConverters);
        int[] avroIndices2 = (int[])tuple22._1();
        Function2[] fieldConverters2 = (Function2[])tuple22._2();
        int numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)row -> {
            GenericData.Record result = new GenericData.Record(avroStruct);
            for (int i = 0; i < numFields; ++i) {
                if (row.isNullAt(i)) {
                    result.put(avroIndices2[i], null);
                    continue;
                }
                result.put(avroIndices2[i], fieldConverters2[i].apply(row, (Object)BoxesRunTime.boxToInteger((int)i)));
            }
            return result;
        };
    }

    /*
     * Unable to fully structure code
     */
    private Function1<InternalRow, Object> newUnionConverter(StructType catalystStruct, Schema avroUnion, Seq<String> catalystPath, Seq<String> avroPath) {
        v0 = avroUnion.getType();
        var5_5 = Schema.Type.UNION;
        if ((v0 != null ? v0.equals(var5_5) == false : var5_5 != null) || !this.canMapUnion(catalystStruct, avroUnion)) {
            throw new IncompatibleSchemaException(new StringBuilder(44).append("Cannot convert Catalyst type ").append(catalystStruct).append(" to ").append("Avro type ").append(avroUnion).append(".").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        if (avroUnion.getTypes().size() <= 0) ** GOTO lbl-1000
        v1 = ((Schema)avroUnion.getTypes().get(0)).getType();
        var7_6 = Schema.Type.NULL;
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        nullable = v2;
        avroInnerTypes = nullable != false ? (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroUnion.getTypes()).asScala()).tail() : (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroUnion.getTypes()).asScala();
        fieldConverters = (Seq)((TraversableLike)catalystStruct.zip((GenIterable)avroInnerTypes, Seq$.MODULE$.canBuildFrom())).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$newUnionConverter$1(org.apache.spark.sql.avro.AvroSerializer scala.collection.Seq scala.collection.Seq scala.Tuple2 ), (Lscala/Tuple2;)Lscala/Function2;)((AvroSerializer)this, catalystPath, avroPath), Seq$.MODULE$.canBuildFrom());
        numFields = catalystStruct.length();
        return (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$newUnionConverter$2(int org.apache.spark.sql.types.StructType org.apache.avro.Schema scala.collection.Seq boolean org.apache.spark.sql.catalyst.InternalRow ), (Lorg/apache/spark/sql/catalyst/InternalRow;)Ljava/lang/Object;)((int)numFields, (StructType)catalystStruct, (Schema)avroUnion, (Seq)fieldConverters, (boolean)nullable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canMapUnion(StructType catalystStruct, Schema avroStruct) {
        if (avroStruct.getTypes().size() > 0) {
            Schema.Type type = ((Schema)avroStruct.getTypes().get(0)).getType();
            Schema.Type type2 = Schema.Type.NULL;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                if (avroStruct.getTypes().size() - 1 == catalystStruct.length()) return true;
            }
        }
        if (avroStruct.getTypes().size() != catalystStruct.length()) return false;
        return true;
    }

    private Schema resolveNullableType(Schema avroType, boolean nullable) {
        Tuple2<Object, Schema> tuple2 = this.resolveAvroType(avroType);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean avroNullable = tuple2._1$mcZ$sp();
        Schema resolvedAvroType = (Schema)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)avroNullable), (Object)resolvedAvroType);
        boolean avroNullable2 = tuple22._1$mcZ$sp();
        Schema resolvedAvroType2 = (Schema)tuple22._2();
        this.warnNullabilityDifference(avroNullable2, nullable);
        return resolvedAvroType2;
    }

    private Tuple2<Object, Schema> resolveAvroType(Schema avroType) {
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
            Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)AvroSerializer.$anonfun$resolveAvroType$1(x$3)));
            if (fields.length() == 2 && actualType.length() == 1) {
                return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), actualType.head());
            }
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
    }

    private void warnNullabilityDifference(boolean avroNullable, boolean catalystNullable) {
        if (avroNullable && !catalystNullable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with nullable Avro schema and non-nullable catalyst schema.");
        }
        if (!avroNullable && catalystNullable) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Writing Avro files with non-nullable Avro schema and nullable catalyst schema will throw runtime exception if there is a record with null value.");
            return;
        }
    }

    private final /* synthetic */ Function1 liftedTree1$1(Schema actualAvroType$1) {
        Function1 & Serializable & scala.Serializable intersect;
        try {
            DataType dataType = this.rootCatalystType;
            if (dataType instanceof StructType) {
                StructType structType = (StructType)dataType;
                intersect = this.newStructConverter(structType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
            } else {
                SpecificInternalRow tmpRow = new SpecificInternalRow((Seq)new .colon.colon((Object)this.rootCatalystType, (List)Nil$.MODULE$));
                Function2<SpecializedGetters, Object, Object> converter = this.newConverter(this.rootCatalystType, actualAvroType$1, (Seq<String>)Nil$.MODULE$, (Seq<String>)Nil$.MODULE$);
                intersect = (Function1 & Serializable & scala.Serializable)data -> {
                    tmpRow.update(0, data);
                    return converter.apply((Object)tmpRow, (Object)BoxesRunTime.boxToInteger((int)0));
                };
            }
        }
        catch (IncompatibleSchemaException ise) {
            throw new IncompatibleSchemaException(new StringBuilder(39).append("Cannot convert SQL type ").append(this.rootCatalystType.sql()).append(" to Avro type ").append(this.rootAvroType).append(".").toString(), (Throwable)ise);
        }
        return intersect;
    }

    public static final /* synthetic */ Null$ $anonfun$newConverter$1(SpecializedGetters getter, int ordinal) {
        return null;
    }

    public static final /* synthetic */ GenericFixed $anonfun$newConverter$9(AvroSerializer $this, DecimalType x62$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x62$1.precision(), x62$1.scale());
        return $this.decimalConversions().toFixed(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x62$1.precision(), (int)x62$1.scale()));
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$10(AvroSerializer $this, DecimalType x64$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        Decimal decimal = getter.getDecimal(ordinal, x64$1.precision(), x64$1.scale());
        return $this.decimalConversions().toBytes(decimal.toJavaBigDecimal(), avroType$1, (LogicalType)LogicalTypes.decimal((int)x64$1.precision(), (int)x64$1.scale()));
    }

    public static final /* synthetic */ GenericData.EnumSymbol $anonfun$newConverter$11(Set enumSymbols$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        String data = getter.getUTF8String(ordinal).toString();
        if (!enumSymbols$1.contains((Object)data)) {
            throw new IncompatibleSchemaException(new StringBuilder(52).append(errorPrefix$1).append("\"").append(data).append("\" cannot be written since it's not defined in enum ").append(enumSymbols$1.mkString("\"", "\", \"", "\"")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.EnumSymbol(avroType$1, data);
    }

    public static final /* synthetic */ Utf8 $anonfun$newConverter$12(SpecializedGetters getter, int ordinal) {
        return new Utf8(getter.getUTF8String(ordinal).getBytes());
    }

    private static final String len2str$1(int len) {
        return new StringBuilder(1).append(len).append(" ").append((Object)(len > 1 ? "bytes" : "byte")).toString();
    }

    public static final /* synthetic */ GenericData.Fixed $anonfun$newConverter$13(int size$1, String errorPrefix$1, Schema avroType$1, SpecializedGetters getter, int ordinal) {
        byte[] data = getter.getBinary(ordinal);
        if (data.length != size$1) {
            throw new IncompatibleSchemaException(new StringBuilder(63).append(errorPrefix$1).append(AvroSerializer.len2str$1(data.length)).append(" of binary data cannot be written into FIXED type with size of ").append(AvroSerializer.len2str$1(size$1)).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return new GenericData.Fixed(avroType$1, data);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$newConverter$14(SpecializedGetters getter, int ordinal) {
        return ByteBuffer.wrap(getter.getBinary(ordinal));
    }

    public static final /* synthetic */ int $anonfun$newConverter$15(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.dateRebaseFunc().apply$mcII$sp(getter.getInt(ordinal));
    }

    public static final /* synthetic */ long $anonfun$newConverter$17(AvroSerializer $this, SpecializedGetters getter, int ordinal) {
        return $this.timestampRebaseFunc().apply$mcJJ$sp(getter.getLong(ordinal));
    }

    public static final /* synthetic */ java.util.List $anonfun$newConverter$20(boolean containsNull$1, Function2 elementConverter$1, SpecializedGetters getter, int ordinal) {
        ArrayData arrayData = getter.getArray(ordinal);
        int len = arrayData.numElements();
        Object[] result = new Object[len];
        for (int i = 0; i < len; ++i) {
            result[i] = containsNull$1 && arrayData.isNullAt(i) ? null : elementConverter$1.apply((Object)arrayData, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        return Arrays.asList(ScalaRunTime$.MODULE$.toObjectArray((Object)result));
    }

    public static final /* synthetic */ GenericData.Record $anonfun$newConverter$21(Function1 structConverter$1, int numFields$1, SpecializedGetters getter, int ordinal) {
        return (GenericData.Record)structConverter$1.apply((Object)getter.getStruct(ordinal, numFields$1));
    }

    public static final /* synthetic */ HashMap $anonfun$newConverter$23(boolean valueContainsNull$1, Function2 valueConverter$1, SpecializedGetters getter, int ordinal) {
        MapData mapData = getter.getMap(ordinal);
        int len = mapData.numElements();
        HashMap<String, Object> result = new HashMap<String, Object>(len);
        ArrayData keyArray = mapData.keyArray();
        ArrayData valueArray = mapData.valueArray();
        for (int i = 0; i < len; ++i) {
            String key = keyArray.getUTF8String(i).toString();
            Object object = valueContainsNull$1 && valueArray.isNullAt(i) ? result.put(key, null) : result.put(key, valueConverter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i)));
        }
        return result;
    }

    public static final /* synthetic */ Function2 $anonfun$newUnionConverter$1(AvroSerializer $this, Seq catalystPath$2, Seq avroPath$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            StructField f1 = (StructField)tuple2._1();
            Schema f2 = (Schema)tuple2._2();
            return $this.newConverter(f1.dataType(), f2, (Seq<String>)catalystPath$2, (Seq<String>)avroPath$2);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ Object $anonfun$newUnionConverter$2(int numFields$4, StructType catalystStruct$1, Schema avroUnion$1, Seq fieldConverters$2, boolean nullable$1, InternalRow row) {
        Object result = null;
        for (int i = 0; i < numFields$4; ++i) {
            if (row.isNullAt(i)) continue;
            if (result != null) {
                throw new IncompatibleSchemaException(new StringBuilder(92).append("Cannot convert Catalyst record ").append(catalystStruct$1).append(" to ").append("Avro union ").append(avroUnion$1).append(". Record has more than one optional values set").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
            result = ((Function2)fieldConverters$2.apply(i)).apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i));
        }
        if (!nullable$1 && result == null) {
            throw new IncompatibleSchemaException(new StringBuilder(103).append("Cannot convert Catalyst record ").append(catalystStruct$1).append(" to ").append("Avro union ").append(avroUnion$1).append(". Record has no values set, while should have exactly one").toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$resolveAvroType$1(Schema x$3) {
        Schema.Type type = x$3.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable, boolean positionalFieldMatch, Enumeration.Value datetimeRebaseMode) {
        this.rootCatalystType = rootCatalystType;
        this.rootAvroType = rootAvroType;
        this.positionalFieldMatch = positionalFieldMatch;
        Logging.$init$((Logging)this);
        this.dateRebaseFunc = AvroSerializer$.MODULE$.createDateRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        this.timestampRebaseFunc = AvroSerializer$.MODULE$.createTimestampRebaseFuncInWrite(datetimeRebaseMode, "Avro");
        Schema actualAvroType = this.resolveNullableType(rootAvroType, nullable);
        Function1 & Serializable & scala.Serializable baseConverter = this.liftedTree1$1(actualAvroType);
        this.converter = nullable ? (Function1 & Serializable & scala.Serializable)data -> {
            if (data == null) {
                return null;
            }
            return baseConverter.apply(data);
        } : baseConverter;
    }

    public AvroSerializer(DataType rootCatalystType, Schema rootAvroType, boolean nullable) {
        this(rootCatalystType, rootAvroType, nullable, false, LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE(), (Object)LegacyBehaviorPolicy$.MODULE$.CORRECTED().toString())));
    }
}

