/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.SchemaRepair;
import org.apache.spark.sql.execution.datasources.FileFormat$;
import org.apache.spark.sql.execution.datasources.SparkColumnarFileReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.Spark35ParquetReader;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReaderBuilder;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;

public final class Spark35ParquetReader$
implements SparkParquetReaderBuilder,
scala.Serializable {
    public static Spark35ParquetReader$ MODULE$;

    static {
        new Spark35ParquetReader$();
    }

    public SparkColumnarFileReader build(boolean vectorized, SQLConf sqlConf, Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sqlConf.sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.NESTED_SCHEMA_PRUNING_ENABLED().key(), sqlConf.nestedSchemaPruningEnabled());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sqlConf.caseSensitiveAnalysis());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sqlConf.isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sqlConf.isParquetINT96AsTimestamp());
        hadoopConf.setBoolean(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), new StringOps(Predef$.MODULE$.augmentString(sqlConf.getConfString(SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().key(), SQLConf$.MODULE$.LEGACY_PARQUET_NANOS_AS_LONG().defaultValueString()))).toBoolean());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key(), sqlConf.parquetInferTimestampNTZEnabled());
        boolean enableLogicalTimestampRepair = hadoopConf.getBoolean("spark.hudi.logicalTimestampField.repair.enable", true);
        boolean returningBatch = sqlConf.parquetVectorizedReaderEnabled() && ((String)options.getOrElse((Object)FileFormat$.MODULE$.OPTION_RETURNING_BATCH(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException("OPTION_RETURNING_BATCH should always be set for ParquetFileFormat. To workaround this issue, set spark.sql.parquet.enableVectorizedReader=false.");
        })).equals("true");
        ParquetOptions parquetOptions = new ParquetOptions(options, sqlConf);
        return new Spark35ParquetReader(vectorized, parquetOptions.datetimeRebaseModeInRead(), parquetOptions.int96RebaseModeInRead(), sqlConf.parquetFilterPushDown(), sqlConf.parquetFilterPushDownDate(), sqlConf.parquetFilterPushDownTimestamp(), sqlConf.parquetFilterPushDownDecimal(), sqlConf.parquetFilterPushDownInFilterThreshold(), sqlConf.parquetFilterPushDownStringPredicate(), sqlConf.caseSensitiveAnalysis(), sqlConf.isParquetINT96TimestampConversion(), sqlConf.offHeapColumnVectorEnabled(), sqlConf.parquetVectorizedReaderBatchSize(), returningBatch, sqlConf.parquetRecordFilterEnabled(), enableLogicalTimestampRepair, (Option<String>)new Some((Object)sqlConf.sessionLocalTimeZone()));
    }

    public ParquetMetadata repairFooterSchema(ParquetMetadata original, org.apache.hudi.common.util.Option<MessageType> tableSchemaOpt) {
        MessageType repairedSchema = SchemaRepair.repairLogicalTypes((MessageType)original.getFileMetaData().getSchema(), tableSchemaOpt);
        FileMetaData oldMeta = original.getFileMetaData();
        return new ParquetMetadata(new FileMetaData(repairedSchema, oldMeta.getKeyValueMetaData(), oldMeta.getCreatedBy(), oldMeta.getEncryptionType(), oldMeta.getFileDecryptor()), original.getBlocks());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Spark35ParquetReader$() {
        MODULE$ = this;
    }
}

