/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.types.DataTypeUtils$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.SparkColumnarFileReader;
import org.apache.spark.sql.execution.datasources.parquet.HoodieParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFooterReader;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowIndexUtil$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaEvolutionUtils;
import org.apache.spark.sql.execution.datasources.parquet.Spark35ParquetReader$;
import org.apache.spark.sql.execution.datasources.parquet.SparkParquetReaderBase;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001\u0002\u000e\u001c\u0001)B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tm\u0001\u0011\t\u0011)A\u0005o!A!\t\u0001B\u0001B\u0003%q\u0007\u0003\u0005D\u0001\t\u0005\t\u0015!\u00031\u0011!!\u0005A!A!\u0002\u0013\u0001\u0004\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\t\u0011\u0019\u0003!\u0011!Q\u0001\nAB\u0001b\u0012\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005a!AA\n\u0001B\u0001B\u0003%\u0001\u0007\u0003\u0005N\u0001\t\u0005\t\u0015!\u00031\u0011!q\u0005A!A!\u0002\u0013\u0001\u0004\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011\u0002%\t\u0011A\u0003!\u0011!Q\u0001\nAB\u0001\"\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\t%\u0002\u0011\t\u0011)A\u0005a!A1\u000b\u0001B\u0001B\u0003%A\u000bC\u0003X\u0001\u0011\u0005\u0001\fC\u0003l\u0001\u0011ECnB\u0004\u0002|mA\t!! \u0007\riY\u0002\u0012AA@\u0011\u00199V\u0003\"\u0001\u0002\u0014\"9\u0011QS\u000b\u0005\u0002\u0005]\u0005bBA`+\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003/,\u0012\u0011!C\u0005\u00033\u0014Ac\u00159be.\u001cT\u0007U1scV,GOU3bI\u0016\u0014(B\u0001\u000f\u001e\u0003\u001d\u0001\u0018M]9vKRT!AH\u0010\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003A\u0005\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Y\u0003C\u0001\u0017.\u001b\u0005Y\u0012B\u0001\u0018\u001c\u0005Y\u0019\u0006/\u0019:l!\u0006\u0014\u0018/^3u%\u0016\fG-\u001a:CCN,\u0017AF3oC\ndWMV3di>\u0014\u0018N_3e%\u0016\fG-\u001a:\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u000f\t{w\u000e\\3b]\u0006AB-\u0019;fi&lWMU3cCN,Wj\u001c3f\u0013:\u0014V-\u00193\u0011\u0005azdBA\u001d>!\tQ$'D\u0001<\u0015\ta\u0014&\u0001\u0004=e>|GOP\u0005\u0003}I\na\u0001\u0015:fI\u00164\u0017B\u0001!B\u0005\u0019\u0019FO]5oO*\u0011aHM\u0001\u0016S:$\u0018H\u000e*fE\u0006\u001cX-T8eK&s'+Z1e\u0003m)g.\u00192mKB\u000b'/];fi\u001aKG\u000e^3s!V\u001c\b\u000eR8x]\u0006a\u0001/^:i\t><h\u000eR1uK\u0006\t\u0002/^:i\t><h\u000eV5nKN$\u0018-\u001c9\u0002\u001fA,8\u000f\u001b#po:$UmY5nC2\f\u0011\u0004];tQ\u0012{wO\\%o\r&dG/\u001a:UQJ,7\u000f[8mIB\u0011\u0011'S\u0005\u0003\u0015J\u00121!\u00138u\u0003]\u0001Xo\u001d5E_^t7\u000b\u001e:j]\u001e\u0004&/\u001a3jG\u0006$X-A\bjg\u000e\u000b7/Z*f]NLG/\u001b<f\u0003M!\u0018.\\3ti\u0006l\u0007oQ8om\u0016\u00148/[8o\u0003e)g.\u00192mK>3g\rS3ba\u000e{G.^7o-\u0016\u001cGo\u001c:\u0002\u0011\r\f\u0007/Y2jif\faB]3ukJt\u0017N\\4CCR\u001c\u0007.\u0001\nf]\u0006\u0014G.\u001a*fG>\u0014HMR5mi\u0016\u0014\u0018\u0001H3oC\ndW\rT8hS\u000e\fG\u000eV5nKN$\u0018-\u001c9SKB\f\u0017N]\u0001\u000bi&lWMW8oK&#\u0007cA\u0019Vo%\u0011aK\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\rqJg.\u001b;?)II&l\u0017/^=~\u0003\u0017MY2eK\u001a<\u0007.\u001b6\u0011\u00051\u0002\u0001\"B\u0018\u0013\u0001\u0004\u0001\u0004\"\u0002\u001c\u0013\u0001\u00049\u0004\"\u0002\"\u0013\u0001\u00049\u0004\"B\"\u0013\u0001\u0004\u0001\u0004\"\u0002#\u0013\u0001\u0004\u0001\u0004\"B#\u0013\u0001\u0004\u0001\u0004\"\u0002$\u0013\u0001\u0004\u0001\u0004\"B$\u0013\u0001\u0004A\u0005\"B&\u0013\u0001\u0004\u0001\u0004\"\u0002'\u0013\u0001\u0004\u0001\u0004\"B'\u0013\u0001\u0004\u0001\u0004\"\u0002(\u0013\u0001\u0004\u0001\u0004\"B(\u0013\u0001\u0004A\u0005\"\u0002)\u0013\u0001\u0004\u0001\u0004\"B)\u0013\u0001\u0004\u0001\u0004\"\u0002*\u0013\u0001\u0004\u0001\u0004\"B*\u0013\u0001\u0004!\u0016A\u00023p%\u0016\fG\r\u0006\bny\u0006\u0015\u0011QCA\r\u0003\u007f\t)&!\u001b\u0011\u00079\u001chO\u0004\u0002pc:\u0011!\b]\u0005\u0002g%\u0011!OM\u0001\ba\u0006\u001c7.Y4f\u0013\t!XO\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t\u0011(\u0007\u0005\u0002xu6\t\u0001P\u0003\u0002zC\u0005A1-\u0019;bYf\u001cH/\u0003\u0002|q\nY\u0011J\u001c;fe:\fGNU8x\u0011\u0015i8\u00031\u0001\u007f\u0003\u00111\u0017\u000e\\3\u0011\u0007}\f\t!D\u0001\u001e\u0013\r\t\u0019!\b\u0002\u0010!\u0006\u0014H/\u001b;j_:,GMR5mK\"9\u0011qA\nA\u0002\u0005%\u0011A\u0004:fcVL'/\u001a3TG\",W.\u0019\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011qB\u0011\u0002\u000bQL\b/Z:\n\t\u0005M\u0011Q\u0002\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA\f'\u0001\u0007\u0011\u0011B\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\"9\u00111D\nA\u0002\u0005u\u0011!E5oi\u0016\u0014h.\u00197TG\",W.Y(qiB1\u0011qDA\u0017\u0003_i!!!\t\u000b\t\u0005\r\u0012QE\u0001\u0005kRLGN\u0003\u0003\u0002(\u0005%\u0012AB2p[6|gNC\u0002\u0002,\u0015\nA\u0001[;eS&\u0019a+!\t\u0011\t\u0005E\u00121H\u0007\u0003\u0003gQA!!\u000e\u00028\u000511o\u00195f[\u0006TA!!\u000f\u0002*\u0005A\u0011N\u001c;fe:\fG.\u0003\u0003\u0002>\u0005M\"AD%oi\u0016\u0014h.\u00197TG\",W.\u0019\u0005\b\u0003\u0003\u001a\u0002\u0019AA\"\u0003\u001d1\u0017\u000e\u001c;feN\u0004RA\\A#\u0003\u0013J1!a\u0012v\u0005\r\u0019V-\u001d\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ\u0011\u0002\u000fM|WO]2fg&!\u00111KA'\u0005\u00191\u0015\u000e\u001c;fe\"9\u0011qK\nA\u0002\u0005e\u0013AC:iCJ,GmQ8oMB!\u00111LA3\u001b\t\tiF\u0003\u0003\u0002`\u0005\u0005\u0014\u0001B2p]\u001aT1!a\u0019&\u0003\u0019A\u0017\rZ8pa&!\u0011qMA/\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111N\nA\u0002\u00055\u0014A\u0004;bE2,7k\u00195f[\u0006|\u0005\u000f\u001e\t\u0007\u0003?\ti#a\u001c\u0011\t\u0005E\u0014qO\u0007\u0003\u0003gRA!!\u000e\u0002v)\u0011A$J\u0005\u0005\u0003s\n\u0019HA\u0006NKN\u001c\u0018mZ3UsB,\u0017\u0001F*qCJ\\7'\u000e)beF,X\r\u001e*fC\u0012,'\u000f\u0005\u0002-+M9Q#!!\u0002\b\u00065\u0005cA\u0019\u0002\u0004&\u0019\u0011Q\u0011\u001a\u0003\r\u0005s\u0017PU3g!\ra\u0013\u0011R\u0005\u0004\u0003\u0017[\"!G*qCJ\\\u0007+\u0019:rk\u0016$(+Z1eKJ\u0014U/\u001b7eKJ\u00042!MAH\u0013\r\t\tJ\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0003{\nQAY;jY\u0012$\"\"!'\u0002 \u0006\r\u0016\u0011WA^!\ry\u00181T\u0005\u0004\u0003;k\"aF*qCJ\\7i\u001c7v[:\f'OR5mKJ+\u0017\rZ3s\u0011\u0019\t\tk\u0006a\u0001a\u0005Qa/Z2u_JL'0\u001a3\t\u000f\u0005\u0015v\u00031\u0001\u0002(\u000691/\u001d7D_:4\u0007\u0003BAU\u0003[k!!a+\u000b\u0007\u0005e\u0012%\u0003\u0003\u00020\u0006-&aB*R\u0019\u000e{gN\u001a\u0005\b\u0003g;\u0002\u0019AA[\u0003\u001dy\u0007\u000f^5p]N\u0004R\u0001OA\\o]J1!!/B\u0005\ri\u0015\r\u001d\u0005\b\u0003{;\u0002\u0019AA-\u0003)A\u0017\rZ8pa\u000e{gNZ\u0001\u0013e\u0016\u0004\u0018-\u001b:G_>$XM]*dQ\u0016l\u0017\r\u0006\u0004\u0002D\u0006E\u0017Q\u001b\t\u0005\u0003\u000b\fi-\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003!iW\r^1eCR\f'\u0002BA2\u0003kJA!a4\u0002H\ny\u0001+\u0019:rk\u0016$X*\u001a;bI\u0006$\u0018\rC\u0004\u0002Tb\u0001\r!a1\u0002\u0011=\u0014\u0018nZ5oC2Dq!a\u001b\u0019\u0001\u0004\ti'A\u0006sK\u0006$'+Z:pYZ,GCAAn!\u0011\ti.a:\u000e\u0005\u0005}'\u0002BAq\u0003G\fA\u0001\\1oO*\u0011\u0011Q]\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002j\u0006}'AB(cU\u0016\u001cG\u000f")
public class Spark35ParquetReader
extends SparkParquetReaderBase {
    private final boolean enableVectorizedReader;
    private final String datetimeRebaseModeInRead;
    private final String int96RebaseModeInRead;
    private final boolean enableParquetFilterPushDown;
    private final boolean pushDownDate;
    private final boolean pushDownTimestamp;
    private final boolean pushDownDecimal;
    private final int pushDownInFilterThreshold;
    private final boolean pushDownStringPredicate;
    private final boolean isCaseSensitive;
    private final boolean timestampConversion;
    private final boolean enableOffHeapColumnVector;
    private final int capacity;
    private final boolean returningBatch;
    private final boolean enableRecordFilter;
    private final boolean enableLogicalTimestampRepair;
    private final Option<String> timeZoneId;

    public static ParquetMetadata repairFooterSchema(ParquetMetadata parquetMetadata, org.apache.hudi.common.util.Option<MessageType> option) {
        return Spark35ParquetReader$.MODULE$.repairFooterSchema(parquetMetadata, option);
    }

    public static SparkColumnarFileReader build(boolean bl, SQLConf sQLConf, scala.collection.immutable.Map<String, String> map, Configuration configuration) {
        return Spark35ParquetReader$.MODULE$.build(bl, sQLConf, map, configuration);
    }

    public Iterator<InternalRow> doRead(PartitionedFile file, StructType requiredSchema, StructType partitionSchema, org.apache.hudi.common.util.Option<InternalSchema> internalSchemaOpt, Seq<Filter> filters, Configuration sharedConf, org.apache.hudi.common.util.Option<MessageType> tableSchemaOpt) {
        Iterator iterator;
        ParquetRecordReader parquetRecordReader;
        None$ none$;
        Predef$.MODULE$.assert(file.partitionValues().numFields() == partitionSchema.size());
        Path filePath = file.toPath();
        FileSplit split = new FileSplit(filePath, file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
        ParquetSchemaEvolutionUtils schemaEvolutionUtils = new ParquetSchemaEvolutionUtils(sharedConf, filePath, requiredSchema, partitionSchema, internalSchemaOpt);
        ParquetMetadata originalFooter = this.enableVectorizedReader ? ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)false) : ParquetFooterReader.readFooter((Configuration)sharedConf, (PartitionedFile)file, (boolean)true);
        ParquetMetadata fileFooter = this.enableLogicalTimestampRepair ? Spark35ParquetReader$.MODULE$.repairFooterSchema(originalFooter, tableSchemaOpt) : originalFooter;
        FileMetaData footerFileMetaData = fileFooter.getFileMetaData();
        Map map = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec datetimeRebaseSpec = DataSourceUtils$.MODULE$.datetimeRebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map.get(x$1), this.datetimeRebaseModeInRead);
        Map map2 = footerFileMetaData.getKeyValueMetaData();
        RebaseDateTime.RebaseSpec int96RebaseSpec = DataSourceUtils$.MODULE$.int96RebaseSpec((Function1 & Serializable & scala.Serializable)x$1 -> (String)map2.get(x$1), this.int96RebaseModeInRead);
        if (this.enableParquetFilterPushDown) {
            MessageType parquetSchema = footerFileMetaData.getSchema();
            ParquetFilters parquetFilters = new ParquetFilters(parquetSchema, this.pushDownDate, this.pushDownTimestamp, this.pushDownDecimal, this.pushDownStringPredicate, this.pushDownInFilterThreshold, this.isCaseSensitive, datetimeRebaseSpec);
            none$ = ((TraversableOnce)((TraversableLike)filters.map((Function1 & Serializable & scala.Serializable)filter -> schemaEvolutionUtils.rebuildFilterFromParquet(filter), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(x$1)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
        } else {
            none$ = None$.MODULE$;
        }
        None$ pushed = none$;
        None$ convertTz = this.timestampConversion && !Spark35ParquetReader.isCreatedByParquetMr$1(footerFileMetaData) ? new Some((Object)DateTimeUtils$.MODULE$.getZoneId(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
        TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
        TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(schemaEvolutionUtils.getHadoopConfClone(footerFileMetaData, this.enableVectorizedReader), attemptId);
        if (pushed.isDefined()) {
            ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
        }
        Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (this.enableVectorizedReader) {
            RecordReaderIterator recordReaderIterator;
            VectorizedParquetRecordReader vectorizedReader = schemaEvolutionUtils.buildVectorizedReader((ZoneId)convertTz.orNull(Predef$.MODULE$.$conforms()), datetimeRebaseSpec.mode().toString(), datetimeRebaseSpec.timeZone(), int96RebaseSpec.mode().toString(), int96RebaseSpec.timeZone(), this.enableOffHeapColumnVector && taskContext.isDefined(), this.capacity);
            RecordReaderIterator iter = new RecordReaderIterator((RecordReader)vectorizedReader);
            try {
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext, Option$.MODULE$.apply((Object)fileFooter));
                vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                if (this.returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            }
            catch (Throwable e) {
                iter.close();
                throw e;
            }
            return recordReaderIterator;
        }
        HoodieParquetReadSupport readSupport = new HoodieParquetReadSupport((Option)convertTz, false, this.enableLogicalTimestampRepair, datetimeRebaseSpec, int96RebaseSpec, tableSchemaOpt);
        if (pushed.isDefined() && this.enableRecordFilter) {
            FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
        } else {
            parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
        }
        ParquetRecordReader reader = parquetRecordReader;
        RecordReader readerWithRowIndexes = ParquetRowIndexUtil$.MODULE$.addRowIndexToRecordReaderIfNeeded(reader, requiredSchema);
        RecordReaderIterator iter = new RecordReaderIterator(readerWithRowIndexes);
        try {
            readerWithRowIndexes.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
            Seq fullSchema = (Seq)DataTypeUtils$.MODULE$.toAttributes(requiredSchema).$plus$plus((GenTraversableOnce)DataTypeUtils$.MODULE$.toAttributes(partitionSchema), Seq$.MODULE$.canBuildFrom());
            UnsafeProjection unsafeProjection = schemaEvolutionUtils.generateUnsafeProjection(fullSchema, this.timeZoneId);
            if (partitionSchema.length() == 0) {
                iterator = iter.map((Function1)unsafeProjection);
            } else {
                JoinedRow joinedRow = new JoinedRow();
                iterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
            }
        }
        catch (Throwable e) {
            iter.close();
            throw e;
        }
        return iterator;
    }

    private static final boolean isCreatedByParquetMr$1(FileMetaData footerFileMetaData$1) {
        return footerFileMetaData$1.getCreatedBy().startsWith("parquet-mr");
    }

    public Spark35ParquetReader(boolean enableVectorizedReader, String datetimeRebaseModeInRead, String int96RebaseModeInRead, boolean enableParquetFilterPushDown, boolean pushDownDate, boolean pushDownTimestamp, boolean pushDownDecimal, int pushDownInFilterThreshold, boolean pushDownStringPredicate, boolean isCaseSensitive, boolean timestampConversion, boolean enableOffHeapColumnVector, int capacity, boolean returningBatch, boolean enableRecordFilter, boolean enableLogicalTimestampRepair, Option<String> timeZoneId) {
        this.enableVectorizedReader = enableVectorizedReader;
        this.datetimeRebaseModeInRead = datetimeRebaseModeInRead;
        this.int96RebaseModeInRead = int96RebaseModeInRead;
        this.enableParquetFilterPushDown = enableParquetFilterPushDown;
        this.pushDownDate = pushDownDate;
        this.pushDownTimestamp = pushDownTimestamp;
        this.pushDownDecimal = pushDownDecimal;
        this.pushDownInFilterThreshold = pushDownInFilterThreshold;
        this.pushDownStringPredicate = pushDownStringPredicate;
        this.isCaseSensitive = isCaseSensitive;
        this.timestampConversion = timestampConversion;
        this.enableOffHeapColumnVector = enableOffHeapColumnVector;
        this.capacity = capacity;
        this.returningBatch = returningBatch;
        this.enableRecordFilter = enableRecordFilter;
        this.enableLogicalTimestampRepair = enableLogicalTimestampRepair;
        this.timeZoneId = timeZoneId;
        super(enableVectorizedReader, enableParquetFilterPushDown, pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownInFilterThreshold, isCaseSensitive, timestampConversion, enableOffHeapColumnVector, capacity, returningBatch, enableRecordFilter, enableLogicalTimestampRepair, timeZoneId);
    }
}

