/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitExtraMetadataProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u0001\u0003\u0001E\u0011\u0001e\u00155po\u000e{W.\\5u\u000bb$(/Y'fi\u0006$\u0017\r^1Qe>\u001cW\rZ;sK*\u00111\u0001B\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\u0003\u0007\u0003\u001d\u0019w.\\7b]\u0012T!a\u0002\u0005\u0002\t!,H-\u001b\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\n\u0001\u0011\u001dq\u0002A1A\u0005\n}\t!\u0002U!S\u00036+E+\u0012*T+\u0005\u0001\u0003cA\u0011%M5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014O%\u0011\u0001F\u0001\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'\u000f\u0003\u0004+\u0001\u0001\u0006I\u0001I\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003gA\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019)\u0004\u0001)A\u0005]\u0005aq*\u0016+Q+R{F+\u0017)FA!)q\u0007\u0001C\u0001?\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000be\u0002A\u0011A\u0017\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0003<\u0001\u0011\u0005C(\u0001\u0003dC2dGCA\u001fN!\rqd)\u0013\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA##\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002FEA\u0011!jS\u0007\u0002\u0011%\u0011A\n\u0003\u0002\u0004%><\b\"\u0002(;\u0001\u0004y\u0015\u0001B1sON\u0004\"a\u0005)\n\u0005E\u0013!!\u0004)s_\u000e,G-\u001e:f\u0003J<7\u000fC\u0003T\u0001\u0011\u0005C+A\u0003ck&dG-F\u0001V!\t\u0019b+\u0003\u0002X\u0005\tI\u0001K]8dK\u0012,(/\u001a\u0005\u00063\u0002!IAW\u0001\u0018O\u0016$8i\\7nSR4uN\u001d'bgRLen\u001d;b]R$\"aW5\u0011\u0007\u0005bf,\u0003\u0002^E\t1q\n\u001d;j_:\u0004\"aX4\u000e\u0003\u0001T!!\u00192\u0002\u0011QLW.\u001a7j]\u0016T!a\u00193\u0002\u000bQ\f'\r\\3\u000b\u0005\u00154\u0017AB2p[6|gN\u0003\u0002\b\u0019%\u0011\u0001\u000e\u0019\u0002\u000e\u0011>|G-[3J]N$\u0018M\u001c;\t\u000b\u0005D\u0006\u0019\u00016\u0011\u0005}[\u0017B\u00017a\u00059Aun\u001c3jKRKW.\u001a7j]\u0016DQA\u001c\u0001\u0005\n=\f1cZ3u\u0007>lW.\u001b;G_JLen\u001d;b]R$2a\u00179r\u0011\u0015\tW\u000e1\u0001k\u0011\u0015\u0011X\u000e1\u0001t\u0003-Ign\u001d;b]R$\u0016.\\3\u0011\u0005Q<hBA\u0011v\u0013\t1(%\u0001\u0004Qe\u0016$WMZ\u0005\u0003qf\u0014aa\u0015;sS:<'B\u0001<#\u0011\u0015Y\b\u0001\"\u0003}\u0003]9W\r\u001e%p_\u0012LWmQ8n[&$X*\u001a;bI\u0006$\u0018\rF\u0003~\u0003\u0013\tY\u0001E\u0002\"9z\u00042a`A\u0003\u001b\t\t\tAC\u0002\u0002\u0004\u0011\fQ!\\8eK2LA!a\u0002\u0002\u0002\t!\u0002j\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006DQ!\u0019>A\u0002)Da!!\u0004{\u0001\u0004Y\u0016!\u00045p_\u0012LW-\u00138ti\u0006tGoB\u0004\u0002\u0012\tA\t!a\u0005\u0002AMCwn^\"p[6LG/\u0012=ue\u0006lU\r^1eCR\f\u0007K]8dK\u0012,(/\u001a\t\u0004'\u0005UaAB\u0001\u0003\u0011\u0003\t9b\u0005\u0003\u0002\u0016\u0005e\u0001cA\u0011\u0002\u001c%\u0019\u0011Q\u0004\u0012\u0003\r\u0005s\u0017PU3g\u0011\u001dQ\u0012Q\u0003C\u0001\u0003C!\"!a\u0005\t\u0015\u0005\u0015\u0012Q\u0003b\u0001\n\u0003\t9#\u0001\u0003O\u00036+UCAA\u0015!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tA\u0001\\1oO*\u0011\u00111G\u0001\u0005U\u00064\u0018-C\u0002y\u0003[A\u0011\"!\u000f\u0002\u0016\u0001\u0006I!!\u000b\u0002\u000b9\u000bU*\u0012\u0011\t\u0011\u0005u\u0012Q\u0003C\u0001\u0003\u007f\tqAY;jY\u0012,'/\u0006\u0002\u0002BA)\u00111IA'-5\u0011\u0011Q\t\u0006\u0005\u0003\u000f\nI%\u0001\u0005gk:\u001cG/[8o\u0015\u0011\tY%!\r\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u001f\n)E\u0001\u0005TkB\u0004H.[3s\u0001")
public class ShowCommitExtraMetadataProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)100)), ProcedureParameter$.MODULE$.optional(2, "instant_time", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(3, "metadata_key", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_key", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_value", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Option<HoodieInstant> hoodieInstantOption;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        Option<Object> instantTime = this.getArgValueOrDefault(args, this.PARAMETERS()[2]);
        Option<Object> metadataKey = this.getArgValueOrDefault(args, this.PARAMETERS()[3]);
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> option = hoodieInstantOption = instantTime.isEmpty() ? this.getCommitForLastInstant(timeline) : this.getCommitForInstant(timeline, (String)instantTime.get());
        if (hoodieInstantOption.isEmpty()) {
            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " not found in Commits ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, timeline})));
        }
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " not found commitMetadata in Commits ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, timeline})));
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        String timestamp = ((HoodieInstant)hoodieInstantOption.get()).getTimestamp();
        String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
        java.util.Map metadatas = metadataKey.isEmpty() ? meta.getExtraMetadata() : JavaConversions$.MODULE$.mutableMapAsJavaMap((Map)JavaConversions$.MODULE$.mapAsScalaMap(meta.getExtraMetadata()).filter((Function1)new Serializable(this, metadataKey){
            public static final long serialVersionUID = 0L;
            private final Option metadataKey$1;

            public final boolean apply(Tuple2<String, String> r) {
                return ((String)r._1()).equals(((String)this.metadataKey$1.get()).trim());
            }
            {
                this.metadataKey$1 = metadataKey$1;
            }
        }));
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.mapAsScalaMap(metadatas).foreach((Function1)new Serializable(this, timestamp, action, rows){
            public static final long serialVersionUID = 0L;
            private final String timestamp$1;
            private final String action$1;
            private final ArrayList rows$1;

            public final boolean apply(Tuple2<String, String> r) {
                return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timestamp$1, this.action$1, r._1(), r._2()})));
            }
            {
                this.timestamp$1 = timestamp$1;
                this.action$1 = action$1;
                this.rows$1 = rows$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitExtraMetadataProcedure();
    }

    private Option<HoodieInstant> getCommitForLastInstant(HoodieTimeline timeline) {
        Optional instantOptional = timeline.getReverseOrderedInstants().findFirst();
        return instantOptional.isPresent() ? Option$.MODULE$.apply(instantOptional.get()) : Option$.MODULE$.empty();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.asScalaBuffer(instants).find((Function1)new Serializable(this, timeline){
            public static final long serialVersionUID = 0L;
            private final HoodieTimeline timeline$1;

            public final boolean apply(HoodieInstant i) {
                return this.timeline$1.containsInstant(i);
            }
            {
                this.timeline$1 = timeline$1;
            }
        });
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply(HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply(HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieCommitMetadata.class));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }
}

