/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005%c\u0001B\u0001\u0003\u0001E\u0011\u0001d\u00155po\u000e{W.\\5u\r&dWm\u001d)s_\u000e,G-\u001e:f\u0015\t\u0019A!\u0001\u0006qe>\u001cW\rZ;sKNT!!\u0002\u0004\u0002\u000f\r|W.\\1oI*\u0011q\u0001C\u0001\u0005QV$\u0017N\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001%Y\u0001\"a\u0005\u000b\u000e\u0003\tI!!\u0006\u0002\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t\u0019r#\u0003\u0002\u0019\u0005\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM\u001d\u0005\u00065\u0001!\taG\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003q\u0001\"a\u0005\u0001\t\u000fy\u0001!\u0019!C\u0005?\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003\u0001\u00022!\t\u0013'\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#!B!se\u0006L\bCA\n(\u0013\tA#A\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\bB\u0002\u0016\u0001A\u0003%\u0001%A\u0006Q\u0003J\u000bU*\u0012+F%N\u0003\u0003b\u0002\u0017\u0001\u0005\u0004%I!L\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001/!\ty#'D\u00011\u0015\t\t\u0004\"A\u0003usB,7/\u0003\u00024a\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\rU\u0002\u0001\u0015!\u0003/\u00031yU\u000b\u0016)V)~#\u0016\fU#!\u0011\u00159\u0004\u0001\"\u0001 \u0003)\u0001\u0018M]1nKR,'o\u001d\u0005\u0006s\u0001!\t!L\u0001\u000b_V$\b/\u001e;UsB,\u0007\"B\u001e\u0001\t\u0003b\u0014\u0001B2bY2$\"!P'\u0011\u0007y2\u0015J\u0004\u0002@\t:\u0011\u0001iQ\u0007\u0002\u0003*\u0011!\tE\u0001\u0007yI|w\u000e\u001e \n\u0003\rJ!!\u0012\u0012\u0002\u000fA\f7m[1hK&\u0011q\t\u0013\u0002\u0004'\u0016\f(BA##!\tQ5*D\u0001\t\u0013\ta\u0005BA\u0002S_^DQA\u0014\u001eA\u0002=\u000bA!\u0019:hgB\u00111\u0003U\u0005\u0003#\n\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\b\"B*\u0001\t\u0003\"\u0016!\u00022vS2$W#A+\u0011\u0005M1\u0016BA,\u0003\u0005%\u0001&o\\2fIV\u0014X\rC\u0003Z\u0001\u0011%!,A\nhKR\u001cu.\\7ji\u001a{'/\u00138ti\u0006tG\u000fF\u0002\\S6\u00042!\t/_\u0013\ti&E\u0001\u0004PaRLwN\u001c\t\u0003?\u001el\u0011\u0001\u0019\u0006\u0003C\n\f\u0001\u0002^5nK2Lg.\u001a\u0006\u0003G\u0012\fQ\u0001^1cY\u0016T!!\u001a4\u0002\r\r|W.\\8o\u0015\t9A\"\u0003\u0002iA\ni\u0001j\\8eS\u0016Len\u001d;b]RDQ!\u0019-A\u0002)\u0004\"aX6\n\u00051\u0004'A\u0004%p_\u0012LW\rV5nK2Lg.\u001a\u0005\u0006]b\u0003\ra\\\u0001\fS:\u001cH/\u00198u)&lW\r\u0005\u0002qg:\u0011\u0011%]\u0005\u0003e\n\na\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!O\t\u0005\u0006o\u0002!I\u0001_\u0001\u0018O\u0016$\bj\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006$R!_A\u0001\u0003\u0007\u00012!\t/{!\tYh0D\u0001}\u0015\tiH-A\u0003n_\u0012,G.\u0003\u0002\u0000y\n!\u0002j\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006DQ!\u0019<A\u0002)Da!!\u0002w\u0001\u0004Y\u0016!\u00045p_\u0012LW-\u00138ti\u0006tGoB\u0004\u0002\n\tA\t!a\u0003\u00021MCwn^\"p[6LGOR5mKN\u0004&o\\2fIV\u0014X\rE\u0002\u0014\u0003\u001b1a!\u0001\u0002\t\u0002\u0005=1\u0003BA\u0007\u0003#\u00012!IA\n\u0013\r\t)B\t\u0002\u0007\u0003:L(+\u001a4\t\u000fi\ti\u0001\"\u0001\u0002\u001aQ\u0011\u00111\u0002\u0005\u000b\u0003;\tiA1A\u0005\u0002\u0005}\u0011\u0001\u0002(B\u001b\u0016+\"!!\t\u0011\t\u0005\r\u0012QF\u0007\u0003\u0003KQA!a\n\u0002*\u0005!A.\u00198h\u0015\t\tY#\u0001\u0003kCZ\f\u0017b\u0001;\u0002&!I\u0011\u0011GA\u0007A\u0003%\u0011\u0011E\u0001\u0006\u001d\u0006kU\t\t\u0005\t\u0003k\ti\u0001\"\u0001\u00028\u00059!-^5mI\u0016\u0014XCAA\u001d!\u0015\tY$!\u0012\u0017\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005\r\u0013\u0011F\u0001\u0005kRLG.\u0003\u0003\u0002H\u0005u\"\u0001C*vaBd\u0017.\u001a:")
public class ShowCommitFilesProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_records_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitFilesProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Commit ", " not found in Commits ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instantTime, timeline})));
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.asScalaSet(meta.getPartitionToWriteStats().entrySet()).foreach((Function1)new Serializable(this, hoodieInstantOption, rows){
            public static final long serialVersionUID = 0L;
            private final Option hoodieInstantOption$1;
            public final ArrayList rows$1;

            public final void apply(Map.Entry<String, List<HoodieWriteStat>> entry) {
                String action = ((HoodieInstant)this.hoodieInstantOption$1.get()).getAction();
                String path = entry.getKey();
                List<HoodieWriteStat> stats = entry.getValue();
                JavaConversions$.MODULE$.asScalaBuffer(stats).foreach((Function1)new Serializable(this, action, path){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$call$1 $outer;
                    private final String action$1;
                    private final String path$1;

                    public final boolean apply(HoodieWriteStat stat) {
                        return this.$outer.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.action$1, this.path$1, stat.getFileId(), stat.getPrevCommit(), BoxesRunTime.boxToLong((long)stat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)stat.getNumWrites()), BoxesRunTime.boxToLong((long)stat.getTotalWriteBytes()), BoxesRunTime.boxToLong((long)stat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)stat.getFileSizeInBytes())})));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.action$1 = action$1;
                        this.path$1 = path$1;
                    }
                });
            }
            {
                this.hoodieInstantOption$1 = hoodieInstantOption$1;
                this.rows$1 = rows$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitFilesProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.asScalaBuffer(instants).find((Function1)new Serializable(this, timeline){
            public static final long serialVersionUID = 0L;
            private final HoodieTimeline timeline$1;

            public final boolean apply(HoodieInstant i) {
                return this.timeline$1.containsInstant(i);
            }
            {
                this.timeline$1 = timeline$1;
            }
        });
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply(HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply(HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieCommitMetadata.class));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }
}

