/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowFsPathDetailProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001E\u0011\u0011d\u00155po\u001a\u001b\b+\u0019;i\t\u0016$\u0018-\u001b7Qe>\u001cW\rZ;sK*\u00111\u0001B\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\u0003\u0007\u0003\u001d\u0019w.\\7b]\u0012T!a\u0002\u0005\u0002\t!,H-\u001b\u0006\u0003\u0013)\t1a]9m\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<7\u0001A\n\u0004\u0001I1\u0002CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111cF\u0005\u00031\t\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\t\u000bi\u0001A\u0011A\u000e\u0002\rqJg.\u001b;?)\u0005a\u0002CA\n\u0001\u0011\u001dq\u0002A1A\u0005\n}\t!\u0002U!S\u00036+E+\u0012*T+\u0005\u0001\u0003cA\u0011%M5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#EA\u0003BeJ\f\u0017\u0010\u0005\u0002\u0014O%\u0011\u0001F\u0001\u0002\u0013!J|7-\u001a3ve\u0016\u0004\u0016M]1nKR,'\u000f\u0003\u0004+\u0001\u0001\u0006I\u0001I\u0001\f!\u0006\u0013\u0016)T#U\u000bJ\u001b\u0006\u0005C\u0004-\u0001\t\u0007I\u0011B\u0017\u0002\u0017=+F\u000bU+U?RK\u0006+R\u000b\u0002]A\u0011qFM\u0007\u0002a)\u0011\u0011\u0007C\u0001\u0006if\u0004Xm]\u0005\u0003gA\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011\u0019)\u0004\u0001)A\u0005]\u0005aq*\u0016+Q+R{F+\u0017)FA!)q\u0007\u0001C\u0001?\u0005Q\u0001/\u0019:b[\u0016$XM]:\t\u000be\u0002A\u0011A\u0017\u0002\u0015=,H\u000f];u)f\u0004X\rC\u0003<\u0001\u0011\u0005C(\u0001\u0003dC2dGCA\u001fN!\rqd)\u0013\b\u0003\u007f\u0011s!\u0001Q\"\u000e\u0003\u0005S!A\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0013BA##\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u0012%\u0003\u0007M+\u0017O\u0003\u0002FEA\u0011!jS\u0007\u0002\u0011%\u0011A\n\u0003\u0002\u0004%><\b\"\u0002(;\u0001\u0004y\u0015\u0001B1sON\u0004\"a\u0005)\n\u0005E\u0013!!\u0004)s_\u000e,G-\u001e:f\u0003J<7\u000fC\u0003T\u0001\u0011\u0005A+A\u0006hKR4\u0015\u000e\\3TSj,GCA+]!\t1\u0016L\u0004\u0002\"/&\u0011\u0001LI\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002YE!)QL\u0015a\u0001=\u0006!1/\u001b>f!\t\ts,\u0003\u0002aE\t!Aj\u001c8h\u0011\u0015\u0011\u0007\u0001\"\u0011d\u0003\u0015\u0011W/\u001b7e+\u0005!\u0007CA\nf\u0013\t1'AA\u0005Qe>\u001cW\rZ;sK\u001e)\u0001N\u0001E\u0001S\u0006I2\u000b[8x\rN\u0004\u0016\r\u001e5EKR\f\u0017\u000e\u001c)s_\u000e,G-\u001e:f!\t\u0019\"NB\u0003\u0002\u0005!\u00051n\u0005\u0002kYB\u0011\u0011%\\\u0005\u0003]\n\u0012a!\u00118z%\u00164\u0007\"\u0002\u000ek\t\u0003\u0001H#A5\t\u000fIT'\u0019!C\u0001g\u0006!a*Q'F+\u0005!\bCA;{\u001b\u00051(BA<y\u0003\u0011a\u0017M\\4\u000b\u0003e\fAA[1wC&\u0011!L\u001e\u0005\u0007y*\u0004\u000b\u0011\u0002;\u0002\u000b9\u000bU*\u0012\u0011\t\u000byTG\u0011A@\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011\u0011\u0001\t\u0006\u0003\u0007\tiAF\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005Aa-\u001e8di&|gNC\u0002\u0002\fa\fA!\u001e;jY&!\u0011qBA\u0003\u0005!\u0019V\u000f\u001d9mS\u0016\u0014\b")
public class ShowFsPathDetailProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "is_sub", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(2, "sort", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true))});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("path_num", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("file_num", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("storage_size", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("storage_size(unit)", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("storage_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("space_consumed", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("quota", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("space_quota", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowFsPathDetailProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowFsPathDetailProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String srcPath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        boolean isSub = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        boolean sort = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        Path path = new Path(srcPath);
        FileSystem fs = FSUtils.getFs((Path)path, (Configuration)this.jsc().hadoopConfiguration());
        FileStatus[] status = isSub ? fs.listStatus(path) : fs.globStatus(path);
        ArrayList rows = new ArrayList();
        if (Predef$.MODULE$.refArrayOps((Object[])status).nonEmpty()) {
            Predef$.MODULE$.refArrayOps((Object[])status).indices().foreach((Function1)new Serializable(this, fs, status, rows){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ShowFsPathDetailProcedure $outer;
                private final FileSystem fs$1;
                private final FileStatus[] status$1;
                private final List rows$1;

                public final boolean apply(int i) {
                    return this.apply$mcZI$sp(i);
                }

                public boolean apply$mcZI$sp(int i) {
                    ContentSummary summary = this.fs$1.getContentSummary(this.status$1[i].getPath());
                    String storagePath = this.status$1[i].getPath().toString();
                    return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)summary.getDirectoryCount()), BoxesRunTime.boxToLong((long)summary.getFileCount()), BoxesRunTime.boxToLong((long)summary.getLength()), this.$outer.getFileSize(summary.getLength()), storagePath, BoxesRunTime.boxToLong((long)summary.getQuota()), BoxesRunTime.boxToLong((long)summary.getSpaceConsumed()), BoxesRunTime.boxToLong((long)summary.getSpaceQuota())})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fs$1 = fs$1;
                    this.status$1 = status$1;
                    this.rows$1 = rows$1;
                }
            });
        }
        Dataset df = this.spark().sqlContext().createDataFrame(rows, this.OUTPUT_TYPE());
        return sort ? Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("storage_size").desc()})).collect()) : Predef$.MODULE$.wrapRefArray((Object[])df.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{df.apply("file_num").desc()})).collect());
    }

    public String getFileSize(long size) {
        int GB = 0x40000000;
        int MB = 0x100000;
        int KB = 1024;
        DecimalFormat df = new DecimalFormat("0.00");
        String resultSize = size / (long)GB >= 1L ? new StringBuilder().append((Object)df.format((float)((double)size / (double)GB))).append((Object)"GB").toString() : (size / (long)MB >= 1L ? new StringBuilder().append((Object)df.format((float)((double)size / (double)MB))).append((Object)"MB").toString() : (size / (long)KB >= 1L ? new StringBuilder().append((Object)df.format((float)((double)size / (double)KB))).append((Object)"KB").toString() : new StringBuilder().append(size).append((Object)"B").toString()));
        return resultSize;
    }

    @Override
    public Procedure build() {
        return new ShowFsPathDetailProcedure();
    }
}

