/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowInvalidParquetProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001#\tY2\u000b[8x\u0013:4\u0018\r\\5e!\u0006\u0014\u0018/^3u!J|7-\u001a3ve\u0016T!a\u0001\u0003\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u0006\r\u000591m\\7nC:$'BA\u0004\t\u0003\u0011AW\u000fZ5\u000b\u0005%Q\u0011aA:rY*\u00111\u0002D\u0001\u0006gB\f'o\u001b\u0006\u0003\u001b9\ta!\u00199bG\",'\"A\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0011b\u0003\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"aE\f\n\u0005a\u0011!\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\tA\u0004\u0005\u0002\u0014\u0001!9a\u0004\u0001b\u0001\n\u0013y\u0012A\u0003)B%\u0006kU\tV#S'V\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0002G\u0005)1oY1mC&\u0011QE\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003'\u001dJ!\u0001\u000b\u0002\u0003%A\u0013xnY3ekJ,\u0007+\u0019:b[\u0016$XM\u001d\u0005\u0007U\u0001\u0001\u000b\u0011\u0002\u0011\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000b\t\u0005\bY\u0001\u0011\r\u0011\"\u0003.\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR!!\r\u0005\u0002\u000bQL\b/Z:\n\u0005M\u0002$AC*ueV\u001cG\u000fV=qK\"1Q\u0007\u0001Q\u0001\n9\nAbT+U!V#v\fV-Q\u000b\u0002BQa\u000e\u0001\u0005\u0002}\t!\u0002]1sC6,G/\u001a:t\u0011\u0015I\u0004\u0001\"\u0001.\u0003)yW\u000f\u001e9viRK\b/\u001a\u0005\u0006w\u0001!\t\u0005P\u0001\u0005G\u0006dG\u000e\u0006\u0002>\u001bB\u0019aHR%\u000f\u0005}\"eB\u0001!D\u001b\u0005\t%B\u0001\"\u0011\u0003\u0019a$o\\8u}%\t1%\u0003\u0002FE\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005\r\u0019V-\u001d\u0006\u0003\u000b\n\u0002\"AS&\u000e\u0003!I!\u0001\u0014\u0005\u0003\u0007I{w\u000fC\u0003Ou\u0001\u0007q*\u0001\u0003be\u001e\u001c\bCA\nQ\u0013\t\t&AA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm\u001d\u0005\u0006'\u0002!\t\u0005V\u0001\u0006EVLG\u000eZ\u000b\u00029\u001d)aK\u0001E\u0001/\u0006Y2\u000b[8x\u0013:4\u0018\r\\5e!\u0006\u0014\u0018/^3u!J|7-\u001a3ve\u0016\u0004\"a\u0005-\u0007\u000b\u0005\u0011\u0001\u0012A-\u0014\u0005aS\u0006CA\u0011\\\u0013\ta&E\u0001\u0004B]f\u0014VM\u001a\u0005\u00065a#\tA\u0018\u000b\u0002/\"9\u0001\r\u0017b\u0001\n\u0003\t\u0017\u0001\u0002(B\u001b\u0016+\u0012A\u0019\t\u0003G\"l\u0011\u0001\u001a\u0006\u0003K\u001a\fA\u0001\\1oO*\tq-\u0001\u0003kCZ\f\u0017BA5e\u0005\u0019\u0019FO]5oO\"11\u000e\u0017Q\u0001\n\t\fQAT!N\u000b\u0002BQ!\u001c-\u0005\u00029\fqAY;jY\u0012,'/F\u0001p!\r\u0001XOF\u0007\u0002c*\u0011!o]\u0001\tMVt7\r^5p]*\u0011AOZ\u0001\u0005kRLG.\u0003\u0002wc\nA1+\u001e9qY&,'\u000f")
public class ShowInvalidParquetProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "path", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("path", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowInvalidParquetProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowInvalidParquetProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String srcPath = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        java.util.List partitionPaths = FSUtils.getAllPartitionPaths((HoodieEngineContext)new HoodieSparkEngineContext(this.jsc()), (String)srcPath, (boolean)false, (boolean)false);
        JavaRDD javaRdd = this.jsc().parallelize(partitionPaths, partitionPaths.size());
        SerializableConfiguration serHadoopConf = new SerializableConfiguration(this.jsc().hadoopConfiguration());
        return Predef$.MODULE$.wrapRefArray((Object[])javaRdd.rdd().map((Function1)new Serializable(this, srcPath, serHadoopConf){
            public static final long serialVersionUID = 0L;
            private final String srcPath$1;
            private final SerializableConfiguration serHadoopConf$1;

            public final FileStatus[] apply(String part) {
                FileSystem fs = FSUtils.getFs((Path)new Path(this.srcPath$1), (Configuration)this.serHadoopConf$1.get());
                return FSUtils.getAllDataFilesInPartition((FileSystem)fs, (Path)FSUtils.getPartitionPath((String)this.srcPath$1, (String)part));
            }
            {
                this.srcPath$1 = srcPath$1;
                this.serHadoopConf$1 = serHadoopConf$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(FileStatus.class))).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<FileStatus> apply(FileStatus[] x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1).toList();
            }
        }, ClassTag$.MODULE$.apply(FileStatus.class)).filter((Function1)new Serializable(this, serHadoopConf){
            public static final long serialVersionUID = 0L;
            private final SerializableConfiguration serHadoopConf$1;

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final boolean apply(FileStatus status) {
                void var3_3;
                BoxedUnit boxedUnit;
                Path filePath = status.getPath();
                boolean isInvalid = false;
                if (!filePath.toString().endsWith(".parquet")) {
                    boxedUnit = BoxedUnit.UNIT;
                    return (boolean)var3_3;
                }
                try {
                    boxedUnit = ParquetFileReader.readFooter((Configuration)this.serHadoopConf$1.get(), (Path)filePath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData();
                    return (boolean)var3_3;
                }
                catch (Exception exception) {
                    isInvalid = exception.getMessage().contains("is not a Parquet file");
                    boxedUnit = BoxedUnit.UNIT;
                }
                return (boolean)var3_3;
            }
            {
                this.serHadoopConf$1 = serHadoopConf$1;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(FileStatus status) {
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{status.getPath().toString()}));
            }
        }, ClassTag$.MODULE$.apply(Row.class)).collect());
    }

    @Override
    public ShowInvalidParquetProcedure build() {
        return new ShowInvalidParquetProcedure();
    }
}

