/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.ArrayList;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowTablePropertiesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0001\u0002\u0001#\ta2\u000b[8x)\u0006\u0014G.\u001a)s_B,'\u000f^5fgB\u0013xnY3ekJ,'BA\u0002\u0005\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u0003\u000b\u0019\tqaY8n[\u0006tGM\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\r\u0001!C\u0006\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011QBQ1tKB\u0013xnY3ekJ,\u0007CA\n\u0018\u0013\tA\"A\u0001\tQe>\u001cW\rZ;sK\n+\u0018\u000e\u001c3fe\")!\u0004\u0001C\u00017\u00051A(\u001b8jiz\"\u0012\u0001\b\t\u0003'\u0001AqA\b\u0001C\u0002\u0013%q$\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012\u0001\t\t\u0004C\u00112S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005M9\u0013B\u0001\u0015\u0003\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\t\r)\u0002\u0001\u0015!\u0003!\u0003-\u0001\u0016IU!N\u000bR+%k\u0015\u0011\t\u000f1\u0002!\u0019!C\u0005[\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\t\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0004G\u0001\u0006TiJ,8\r\u001e+za\u0016Da!\u000e\u0001!\u0002\u0013q\u0013\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0003\"B\u001c\u0001\t\u0003y\u0012A\u00039be\u0006lW\r^3sg\")\u0011\b\u0001C\u0001[\u0005Qq.\u001e;qkR$\u0016\u0010]3\t\u000bm\u0002A\u0011\t\u001f\u0002\t\r\fG\u000e\u001c\u000b\u0003{5\u00032A\u0010$J\u001d\tyDI\u0004\u0002A\u00076\t\u0011I\u0003\u0002C!\u00051AH]8pizJ\u0011aI\u0005\u0003\u000b\n\nq\u0001]1dW\u0006<W-\u0003\u0002H\u0011\n\u00191+Z9\u000b\u0005\u0015\u0013\u0003C\u0001&L\u001b\u0005A\u0011B\u0001'\t\u0005\r\u0011vn\u001e\u0005\u0006\u001dj\u0002\raT\u0001\u0005CJ<7\u000f\u0005\u0002\u0014!&\u0011\u0011K\u0001\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\t\u000bM\u0003A\u0011\t+\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003U\u0003\"a\u0005,\n\u0005]\u0013!!\u0003)s_\u000e,G-\u001e:f\u000f\u0015I&\u0001#\u0001[\u0003q\u0019\u0006n\\<UC\ndW\r\u0015:pa\u0016\u0014H/[3t!J|7-\u001a3ve\u0016\u0004\"aE.\u0007\u000b\u0005\u0011\u0001\u0012\u0001/\u0014\u0005mk\u0006CA\u0011_\u0013\ty&E\u0001\u0004B]f\u0014VM\u001a\u0005\u00065m#\t!\u0019\u000b\u00025\"91m\u0017b\u0001\n\u0003!\u0017\u0001\u0002(B\u001b\u0016+\u0012!\u001a\t\u0003M.l\u0011a\u001a\u0006\u0003Q&\fA\u0001\\1oO*\t!.\u0001\u0003kCZ\f\u0017B\u00017h\u0005\u0019\u0019FO]5oO\"1an\u0017Q\u0001\n\u0015\fQAT!N\u000b\u0002BQ\u0001].\u0005\u0002E\fqAY;jY\u0012,'/F\u0001s!\r\u0019\bPF\u0007\u0002i*\u0011QO^\u0001\tMVt7\r^5p]*\u0011q/[\u0001\u0005kRLG.\u0003\u0002zi\nA1+\u001e9qY&,'\u000f")
public class ShowTablePropertiesProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10))});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("key", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("value", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowTablePropertiesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowTablePropertiesProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        TypedProperties tableProps = metaClient.getTableConfig().getProps();
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.propertiesAsScalaMap((Properties)tableProps).foreach((Function1)new Serializable(this, rows){
            public static final long serialVersionUID = 0L;
            private final ArrayList rows$1;

            public final boolean apply(Tuple2<String, String> p) {
                return this.rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p._1(), p._2()})));
            }
            {
                this.rows$1 = rows$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Row apply(Object r) {
                return (Row)r;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowTablePropertiesProcedure();
    }
}

