/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.cli;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceWriteOptions;
import org.apache.hudi.cli.SchemaProvider;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaSparkContext;

public class BootstrapExecutorUtils
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(BootstrapExecutorUtils.class);
    private final Config cfg;
    private final transient JavaSparkContext jssc;
    private final TypedProperties props;
    private final Configuration configuration;
    private final HoodieWriteConfig bootstrapConfig;
    private final transient FileSystem fs;
    private final String bootstrapBasePath;
    public static final String CHECKPOINT_KEY = "deltastreamer.checkpoint.key";

    public BootstrapExecutorUtils(Config cfg, JavaSparkContext jssc, FileSystem fs, Configuration conf, TypedProperties properties) throws IOException {
        this.cfg = cfg;
        this.jssc = jssc;
        this.fs = fs;
        this.configuration = conf;
        this.props = properties;
        ValidationUtils.checkArgument((boolean)properties.containsKey((Object)HoodieTableConfig.BOOTSTRAP_BASE_PATH.key()), (String)(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key() + " must be specified."));
        this.bootstrapBasePath = properties.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key());
        this.props.putIfAbsent((Object)DataSourceWriteOptions.PAYLOAD_CLASS_NAME().key(), DataSourceWriteOptions.PAYLOAD_CLASS_NAME().defaultValue());
        SchemaProvider schemaProvider = BootstrapExecutorUtils.createSchemaProvider(cfg.schemaProviderClass, this.props, jssc);
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withPath(cfg.basePath).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(Boolean.valueOf(false)).build()).forTable(cfg.tableName).withIndexConfig(HoodieIndexConfig.newBuilder().withIndexType(HoodieIndex.IndexType.BLOOM).build()).withAutoCommit(true).withProps((Map)this.props);
        if (null != schemaProvider && null != schemaProvider.getTargetSchema()) {
            builder = builder.withSchema(schemaProvider.getTargetSchema().toString());
        }
        this.bootstrapConfig = builder.build();
        LOG.info((Object)("Created bootstrap executor with configs : " + this.bootstrapConfig.getProps()));
    }

    public static SchemaProvider createSchemaProvider(String schemaProviderClass, TypedProperties cfg, JavaSparkContext jssc) throws IOException {
        try {
            return StringUtils.isNullOrEmpty((String)schemaProviderClass) ? null : (SchemaProvider)ReflectionUtils.loadClass((String)schemaProviderClass, (Object[])new Object[]{cfg, jssc});
        }
        catch (Throwable e) {
            throw new IOException("Could not load schema provider class " + schemaProviderClass, e);
        }
    }

    public void execute() throws IOException {
        this.initializeTable();
        try (SparkRDDWriteClient bootstrapClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(this.jssc), this.bootstrapConfig);){
            HashMap<String, String> checkpointCommitMetadata = new HashMap<String, String>();
            checkpointCommitMetadata.put(CHECKPOINT_KEY, Config.checkpoint);
            bootstrapClient.bootstrap(Option.of(checkpointCommitMetadata));
            this.syncHive();
        }
    }

    private void syncHive() {
        if (this.cfg.enableHiveSync.booleanValue()) {
            TypedProperties metaProps = new TypedProperties();
            metaProps.putAll((Map)this.props);
            metaProps.put((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)this.cfg.basePath);
            metaProps.put((Object)HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), (Object)this.cfg.baseFileFormat);
            if (this.props.getBoolean(HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC.key(), ((Boolean)HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC.defaultValue()).booleanValue())) {
                metaProps.put((Object)HiveSyncConfigHolder.HIVE_SYNC_BUCKET_SYNC_SPEC.key(), (Object)HiveSyncConfig.getBucketSpec((String)this.props.getString(HoodieIndexConfig.BUCKET_INDEX_HASH_FIELD.key()), (int)this.props.getInteger(HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key())));
            }
            new HiveSyncTool((Properties)metaProps, this.configuration).syncHoodieTable();
        }
    }

    private void initializeTable() throws IOException {
        Path basePath = new Path(this.cfg.basePath);
        if (this.fs.exists(basePath)) {
            if (this.cfg.bootstrapOverwrite.booleanValue()) {
                LOG.warn((Object)"Target base path already exists, overwrite it");
                this.fs.delete(basePath, true);
            } else {
                throw new HoodieException("target base path already exists at " + this.cfg.basePath + ". Cannot bootstrap data on top of an existing table");
            }
        }
        HoodieTableMetaClient.withPropertyBuilder().fromProperties((Properties)this.props).setTableType(this.cfg.tableType).setTableName(this.cfg.tableName).setArchiveLogFolder((String)HoodieTableConfig.ARCHIVELOG_FOLDER.defaultValue()).setPayloadClassName(this.cfg.payloadClass).setBaseFileFormat(this.cfg.baseFileFormat).setBootstrapIndexClass(this.cfg.bootstrapIndexClass).setBootstrapBasePath(this.bootstrapBasePath).initTable(new Configuration(this.jssc.hadoopConfiguration()), this.cfg.basePath);
    }

    public static class Config {
        private String tableName;
        private String tableType;
        private String basePath;
        private String baseFileFormat;
        private String bootstrapIndexClass;
        private String schemaProviderClass;
        private String payloadClass;
        private Boolean enableHiveSync;
        private Boolean bootstrapOverwrite;
        public static String checkpoint = null;

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public void setTableType(String tableType) {
            this.tableType = tableType;
        }

        public void setBasePath(String basePath) {
            this.basePath = basePath;
        }

        public void setBaseFileFormat(String baseFileFormat) {
            this.baseFileFormat = baseFileFormat;
        }

        public void setBootstrapIndexClass(String bootstrapIndexClass) {
            this.bootstrapIndexClass = bootstrapIndexClass;
        }

        public void setSchemaProviderClass(String schemaProviderClass) {
            this.schemaProviderClass = schemaProviderClass;
        }

        public void setPayloadClass(String payloadClass) {
            this.payloadClass = payloadClass;
        }

        public void setEnableHiveSync(Boolean enableHiveSync) {
            this.enableHiveSync = enableHiveSync;
        }

        public void setBootstrapOverwrite(Boolean bootstrapOverwrite) {
            this.bootstrapOverwrite = bootstrapOverwrite;
        }
    }
}

