/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunCompactionProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Set$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\t\u0013\u0001\u0005BQ\u0001\u000e\u0001\u0005\u0002UBqa\u000e\u0001C\u0002\u0013%\u0001\b\u0003\u0004C\u0001\u0001\u0006I!\u000f\u0005\b\u0007\u0002\u0011\r\u0011\"\u0003E\u0011\u0019Y\u0005\u0001)A\u0005\u000b\")A\n\u0001C\u0001q!)Q\n\u0001C\u0001\t\")a\n\u0001C!\u001f\")Q\r\u0001C\u0005M\")A\u000f\u0001C!k\u001e)\u0011P\u0005E\u0001u\u001a)\u0011C\u0005E\u0001w\")A\u0007\u0004C\u0001\u007f\"I\u0011\u0011\u0001\u0007C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003+a\u0001\u0015!\u0003\u0002\u0006!9\u0011q\u0003\u0007\u0005\u0002\u0005e!A\u0006*v]\u000e{W\u000e]1di&|g\u000e\u0015:pG\u0016$WO]3\u000b\u0005M!\u0012A\u00039s_\u000e,G-\u001e:fg*\u0011QCF\u0001\bG>lW.\u00198e\u0015\t9\u0002$\u0001\u0003ik\u0012L'BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011#\u0002\u0001#M%r\u0003CA\u0012%\u001b\u0005\u0011\u0012BA\u0013\u0013\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u00111eJ\u0005\u0003QI\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0011\u0005)bS\"A\u0016\u000b\u0005]a\u0012BA\u0017,\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u!\ty#'D\u00011\u0015\t\t$$\u0001\u0005j]R,'O\\1m\u0013\t\u0019\u0004GA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u00051\u0004CA\u0012\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002sA\u0019!(P \u000e\u0003mR\u0011\u0001P\u0001\u0006g\u000e\fG.Y\u0005\u0003}m\u0012Q!\u0011:sCf\u0004\"a\t!\n\u0005\u0005\u0013\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005)\u0005C\u0001$J\u001b\u00059%B\u0001%\u0019\u0003\u0015!\u0018\u0010]3t\u0013\tQuI\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\n!\u0002]1sC6,G/\u001a:t\u0003)yW\u000f\u001e9viRK\b/Z\u0001\u0005G\u0006dG\u000e\u0006\u0002QAB\u0019\u0011+\u0017/\u000f\u0005I;fBA*W\u001b\u0005!&BA+!\u0003\u0019a$o\\8u}%\tA(\u0003\u0002Yw\u00059\u0001/Y2lC\u001e,\u0017B\u0001.\\\u0005\r\u0019V-\u001d\u0006\u00031n\u0002\"!\u00180\u000e\u0003aI!a\u0018\r\u0003\u0007I{w\u000fC\u0003b\u0011\u0001\u0007!-\u0001\u0003be\u001e\u001c\bCA\u0012d\u0013\t!'CA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\u000fQ\u0006tG\r\\3SKN\u0004xN\\:f)\t9'\u000e\u0005\u0002;Q&\u0011\u0011n\u000f\u0002\u0005+:LG\u000fC\u0003l\u0013\u0001\u0007A.\u0001\u0005nKR\fG-\u0019;b!\ti'/D\u0001o\u0015\ty\u0007/A\u0003n_\u0012,GN\u0003\u0002rW\u000511m\\7n_:L!a\u001d8\u0003)!{w\u000eZ5f\u0007>lW.\u001b;NKR\fG-\u0019;b\u0003\u0015\u0011W/\u001b7e+\u00051\bCA\u0012x\u0013\tA(CA\u0005Qe>\u001cW\rZ;sK\u00061\"+\u001e8D_6\u0004\u0018m\u0019;j_:\u0004&o\\2fIV\u0014X\r\u0005\u0002$\u0019M\u0011A\u0002 \t\u0003uuL!A`\u001e\u0003\r\u0005s\u0017PU3g)\u0005Q\u0018\u0001\u0002(B\u001b\u0016+\"!!\u0002\u0011\t\u0005\u001d\u0011\u0011C\u0007\u0003\u0003\u0013QA!a\u0003\u0002\u000e\u0005!A.\u00198h\u0015\t\ty!\u0001\u0003kCZ\f\u0017\u0002BA\n\u0003\u0013\u0011aa\u0015;sS:<\u0017!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0003\u00037\u0001R!!\b\u0002(\u0019j!!a\b\u000b\t\u0005\u0005\u00121E\u0001\tMVt7\r^5p]*!\u0011QEA\u0007\u0003\u0011)H/\u001b7\n\t\u0005%\u0012q\u0004\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class RunCompactionProcedure
extends BaseProcedure
implements ProcedureBuilder,
SparkAdapterSupport,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return RunCompactionProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunCompactionProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        RunCompactionProcedure runCompactionProcedure = this;
        synchronized (runCompactionProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        return !this.bitmap$0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String operation = ((String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get()).toLowerCase();
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[2]);
        Option<Object> instantTimestamp = this.getArgValueOrDefault(args, this.PARAMETERS()[3]);
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieClientFromPath(this.sparkSession(), basePath, Predef$.MODULE$.Map().empty());
        ObjectRef willCompactionInstants = ObjectRef.create((Object)((Seq)Seq$.MODULE$.empty()));
        String string = operation;
        if ("schedule".equals(string)) {
            BoxedUnit boxedUnit;
            String instantTime = (String)instantTimestamp.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> HoodieActiveTimeline.createNewInstantTime());
            if (client.scheduleCompactionAtInstant(instantTime, org.apache.hudi.common.util.Option.empty())) {
                willCompactionInstants.elem = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTime}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if ("run".equals(string)) {
            BoxedUnit boxedUnit;
            Seq seq;
            HoodieActiveTimeline timeLine = metaClient.getActiveTimeline();
            Seq pendingCompactionInstants = (Seq)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(timeLine.getWriteTimeline().getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)RunCompactionProcedure.$anonfun$call$3(p))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTimestamp()).toSeq().sortBy((Function1 & Serializable & scala.Serializable)f -> f, (Ordering)Ordering.String$.MODULE$);
            if (instantTimestamp.isEmpty()) {
                String instantTime;
                seq = pendingCompactionInstants.nonEmpty() ? pendingCompactionInstants : (client.scheduleCompactionAtInstant(instantTime = HoodieActiveTimeline.createNewInstantTime(), org.apache.hudi.common.util.Option.empty()) ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTime})) : (Seq)Seq$.MODULE$.empty());
            } else if (pendingCompactionInstants.contains((Object)instantTimestamp.get().toString())) {
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{instantTimestamp.get().toString()}));
            } else {
                throw new IllegalArgumentException(new StringBuilder(83).append("Compaction instant: ").append(instantTimestamp.get()).append(" is not found in ").append(basePath).append(", Available pending compaction instants are: ").append(pendingCompactionInstants.mkString(",")).append(" ").toString());
            }
            willCompactionInstants.elem = seq;
            if (((Seq)willCompactionInstants.elem).isEmpty()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("No need to compaction on ").append(basePath).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Run compaction at instants: [").append(((Seq)willCompactionInstants$1.elem).mkString(",")).append("] on ").append(basePath).toString());
                HoodieTimer timer = new HoodieTimer();
                timer.startTimer();
                ((Seq)willCompactionInstants.elem).foreach((Function1 & Serializable & scala.Serializable)compactionInstant -> {
                    RunCompactionProcedure.$anonfun$call$8(this, client, compactionInstant);
                    return BoxedUnit.UNIT;
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Finish Run compaction at instants: [").append(((Seq)willCompactionInstants$1.elem).mkString(",")).append("],").append(" spend: ").append(timer.endTimer()).append("ms").toString());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(34).append("Unsupported compaction operation: ").append(operation).toString());
        }
        Seq compactionInstants = (Seq)((SeqLike)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.reloadActiveTimeline().getInstants().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)instant -> BoxesRunTime.boxToBoolean((boolean)RunCompactionProcedure.$anonfun$call$10(willCompactionInstants, instant))).toSeq().sortBy((Function1 & Serializable & scala.Serializable)p -> p.getTimestamp(), (Ordering)Ordering.String$.MODULE$)).reverse();
        return (Seq)((TraversableLike)compactionInstants.map((Function1 & Serializable & scala.Serializable)instant -> new Tuple2(instant, (Object)CompactionUtils.getCompactionPlan((HoodieTableMetaClient)metaClient, (String)instant.getTimestamp())), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            HoodieInstant instant = (HoodieInstant)tuple2._1();
            HoodieCompactionPlan plan = (HoodieCompactionPlan)tuple2._2();
            Row row = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{instant.getTimestamp(), BoxesRunTime.boxToInteger((int)plan.getOperations().size()), instant.getState().name()}));
            return row;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private void handleResponse(HoodieCommitMetadata metadata) {
        List writeStats = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaSet(metadata.getPartitionToWriteStats().entrySet()).flatMap((Function1 & Serializable & scala.Serializable)e -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer((java.util.List)e.getValue()), Set$.MODULE$.canBuildFrom())).toList();
        long errorsCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)writeStats.map((Function1 & Serializable & scala.Serializable)state -> BoxesRunTime.boxToLong((long)state.getTotalWriteErrors()), List$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        if (errorsCount > 0L) {
            throw new HoodieException(new StringBuilder(27).append(" Found ").append(errorsCount).append(" when writing record").toString());
        }
    }

    @Override
    public Procedure build() {
        return new RunCompactionProcedure();
    }

    public static final /* synthetic */ boolean $anonfun$call$3(HoodieInstant p) {
        String string = p.getAction();
        String string2 = "compaction";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$call$8(RunCompactionProcedure $this, SparkRDDWriteClient client$1, String compactionInstant) {
        HoodieWriteMetadata writeResponse = client$1.compact(compactionInstant);
        $this.handleResponse((HoodieCommitMetadata)writeResponse.getCommitMetadata().get());
        client$1.commitCompaction(compactionInstant, (HoodieCommitMetadata)writeResponse.getCommitMetadata().get(), org.apache.hudi.common.util.Option.empty());
    }

    public static final /* synthetic */ boolean $anonfun$call$10(ObjectRef willCompactionInstants$1, HoodieInstant instant) {
        return ((Seq)willCompactionInstants$1.elem).contains((Object)instant.getTimestamp());
    }

    public RunCompactionProcedure() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "op", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(2, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(3, "timestamp", DataTypes.LongType, None$.MODULE$)});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("operation_size", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("state", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

