/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001\u0002\n\u0014\u0001\tBQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00049\u0001\u0001\u0006Ia\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!)!\t\u0001C\u0001]!)1\t\u0001C\u0001u!)A\t\u0001C!\u000b\")1\f\u0001C!9\")\u0001\r\u0001C\u0005C\")a\u0010\u0001C\u0005\u007f\u001e9\u0011QC\n\t\u0002\u0005]aA\u0002\n\u0014\u0011\u0003\tI\u0002\u0003\u0004+\u001b\u0011\u0005\u0011\u0011\u0005\u0005\n\u0003Gi!\u0019!C\u0001\u0003KA\u0001\"!\u000e\u000eA\u0003%\u0011q\u0005\u0005\b\u0003oiA\u0011AA\u001d\u0005a\u0019\u0006n\\<D_6l\u0017\u000e\u001e$jY\u0016\u001c\bK]8dK\u0012,(/\u001a\u0006\u0003)U\t!\u0002\u001d:pG\u0016$WO]3t\u0015\t1r#A\u0004d_6l\u0017M\u001c3\u000b\u0005aI\u0012\u0001\u00025vI&T!AG\u000e\u0002\u0007M\fHN\u0003\u0002\u001d;\u0005)1\u000f]1sW*\u0011adH\u0001\u0007CB\f7\r[3\u000b\u0003\u0001\n1a\u001c:h\u0007\u0001\u00192\u0001A\u0012(!\t!S%D\u0001\u0014\u0013\t13CA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003I!J!!K\n\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001-!\t!\u0003!\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012a\f\t\u0004aM*T\"A\u0019\u000b\u0003I\nQa]2bY\u0006L!\u0001N\u0019\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u00112\u0014BA\u001c\u0014\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001<!\tat(D\u0001>\u0015\tq\u0014$A\u0003usB,7/\u0003\u0002A{\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011aI\u0016\t\u0004\u000f>\u0013fB\u0001%N\u001d\tIE*D\u0001K\u0015\tY\u0015%\u0001\u0004=e>|GOP\u0005\u0002e%\u0011a*M\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0016KA\u0002TKFT!AT\u0019\u0011\u0005M#V\"A\r\n\u0005UK\"a\u0001*po\")q\u000b\u0003a\u00011\u0006!\u0011M]4t!\t!\u0013,\u0003\u0002['\ti\u0001K]8dK\u0012,(/Z!sON\fQAY;jY\u0012,\u0012!\u0018\t\u0003IyK!aX\n\u0003\u0013A\u0013xnY3ekJ,\u0017aE4fi\u000e{W.\\5u\r>\u0014\u0018J\\:uC:$Hc\u00012qiB\u0019\u0001gY3\n\u0005\u0011\f$AB(qi&|g\u000e\u0005\u0002g]6\tqM\u0003\u0002iS\u0006AA/[7fY&tWM\u0003\u0002kW\u0006)A/\u00192mK*\u0011A.\\\u0001\u0007G>lWn\u001c8\u000b\u0005ai\u0012BA8h\u00055Aun\u001c3jK&s7\u000f^1oi\")\u0001N\u0003a\u0001cB\u0011aM]\u0005\u0003g\u001e\u0014a\u0002S8pI&,G+[7fY&tW\rC\u0003v\u0015\u0001\u0007a/A\u0006j]N$\u0018M\u001c;US6,\u0007CA<|\u001d\tA\u0018\u0010\u0005\u0002Jc%\u0011!0M\u0001\u0007!J,G-\u001a4\n\u0005ql(AB*ue&twM\u0003\u0002{c\u00059r-\u001a;I_>$\u0017.Z\"p[6LG/T3uC\u0012\fG/\u0019\u000b\u0007\u0003\u0003\ty!!\u0005\u0011\tA\u001a\u00171\u0001\t\u0005\u0003\u000b\tY!\u0004\u0002\u0002\b)\u0019\u0011\u0011B6\u0002\u000b5|G-\u001a7\n\t\u00055\u0011q\u0001\u0002\u0015\u0011>|G-[3D_6l\u0017\u000e^'fi\u0006$\u0017\r^1\t\u000b!\\\u0001\u0019A9\t\r\u0005M1\u00021\u0001c\u00035Awn\u001c3jK&s7\u000f^1oi\u0006A2\u000b[8x\u0007>lW.\u001b;GS2,7\u000f\u0015:pG\u0016$WO]3\u0011\u0005\u0011j1cA\u0007\u0002\u001cA\u0019\u0001'!\b\n\u0007\u0005}\u0011G\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003/\tAAT!N\u000bV\u0011\u0011q\u0005\t\u0005\u0003S\t\u0019$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011a\u0017M\\4\u000b\u0005\u0005E\u0012\u0001\u00026bm\u0006L1\u0001`A\u0016\u0003\u0015q\u0015)T#!\u0003\u001d\u0011W/\u001b7eKJ,\"!a\u000f\u0011\u000b\u0005u\u0012qI\u0014\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\n\u0001BZ;oGRLwN\u001c\u0006\u0005\u0003\u000b\ny#\u0001\u0003vi&d\u0017\u0002BA%\u0003\u007f\u0011\u0001bU;qa2LWM\u001d")
public class ShowCommitFilesProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType, None$.MODULE$)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_records_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitFilesProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(this.jsc().hadoopConfiguration()).setBasePath(basePath).build();
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList rows = new ArrayList();
        JavaConversions$.MODULE$.deprecated$u0020asScalaSet(meta.getPartitionToWriteStats().entrySet()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ShowCommitFilesProcedure.$anonfun$call$1(hoodieInstantOption, rows, entry);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitFilesProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTimeline timeline, String instantTime) {
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{new HoodieInstant(false, "commit", instantTime), new HoodieInstant(false, "replacecommit", instantTime), new HoodieInstant(false, "deltacommit", instantTime)});
        Option hoodieInstant = JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(instants).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        Option option;
        if (hoodieInstant.isDefined()) {
            String string = ((HoodieInstant)hoodieInstant.get()).getAction();
            String string2 = "replacecommit";
            option = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply(HoodieReplaceCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieReplaceCommitMetadata.class)) : Option$.MODULE$.apply(HoodieCommitMetadata.fromBytes((byte[])((byte[])timeline.getInstantDetails((HoodieInstant)hoodieInstant.get()).get()), HoodieCommitMetadata.class));
        } else {
            option = Option$.MODULE$.empty();
        }
        return option;
    }

    public static final /* synthetic */ void $anonfun$call$1(Option hoodieInstantOption$1, ArrayList rows$1, Map.Entry entry) {
        String action = ((HoodieInstant)hoodieInstantOption$1.get()).getAction();
        String path = (String)entry.getKey();
        List stats = (List)entry.getValue();
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(stats).foreach((Function1 & Serializable & scala.Serializable)stat -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, path, stat.getFileId(), stat.getPrevCommit(), BoxesRunTime.boxToLong((long)stat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)stat.getNumWrites()), BoxesRunTime.boxToLong((long)stat.getTotalWriteBytes()), BoxesRunTime.boxToLong((long)stat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)stat.getFileSizeInBytes())})))));
    }
}

