/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.client.SparkTaskContextSupplier;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.io.storage.HoodieAvroParquetWriter;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;

public final class SparkHelpers$ {
    public static SparkHelpers$ MODULE$;

    static {
        new SparkHelpers$();
    }

    public void skipKeysAndWriteNewFile(String instantTime, FileSystem fs, Path sourceFile, Path destinationFile, Set<String> keysToSkip) throws Exception {
        List sourceRecords = BaseFileUtils.getInstance((HoodieFileFormat)HoodieFileFormat.PARQUET).readAvroRecords(fs.getConf(), sourceFile);
        Schema schema = ((GenericContainer)sourceRecords.get(0)).getSchema();
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)new StringOps(Predef$.MODULE$.augmentString((String)HoodieIndexConfig.BLOOM_FILTER_NUM_ENTRIES_VALUE.defaultValue())).toInt(), (double)new StringOps(Predef$.MODULE$.augmentString((String)HoodieIndexConfig.BLOOM_FILTER_FPP_VALUE.defaultValue())).toDouble(), (int)new StringOps(Predef$.MODULE$.augmentString((String)HoodieIndexConfig.BLOOM_INDEX_FILTER_DYNAMIC_MAX_ENTRIES.defaultValue())).toInt(), (String)((String)HoodieIndexConfig.BLOOM_FILTER_TYPE.defaultValue()));
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter(fs.getConf()).convert(schema), schema, Option.of((Object)filter));
        HoodieParquetConfig parquetConfig = new HoodieParquetConfig((Object)writeSupport, CompressionCodecName.GZIP, new StringOps(Predef$.MODULE$.augmentString((String)HoodieStorageConfig.PARQUET_BLOCK_SIZE.defaultValue())).toInt(), new StringOps(Predef$.MODULE$.augmentString((String)HoodieStorageConfig.PARQUET_PAGE_SIZE.defaultValue())).toInt(), (long)new StringOps(Predef$.MODULE$.augmentString((String)HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.defaultValue())).toInt(), fs.getConf(), new StringOps(Predef$.MODULE$.augmentString((String)HoodieStorageConfig.PARQUET_COMPRESSION_RATIO_FRACTION.defaultValue())).toDouble(), Predef$.MODULE$.Boolean2boolean((Boolean)HoodieStorageConfig.PARQUET_DICTIONARY_ENABLED.defaultValue()));
        parquetConfig.getHadoopConf().setClassLoader(Thread.currentThread().getContextClassLoader());
        HoodieAvroParquetWriter writer = new HoodieAvroParquetWriter(destinationFile, parquetConfig, instantTime, (TaskContextSupplier)new SparkTaskContextSupplier(), true);
        JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(sourceRecords).foreach((Function1 & Serializable & scala.Serializable)rec -> {
            SparkHelpers$.$anonfun$skipKeysAndWriteNewFile$1(keysToSkip, writer, rec);
            return BoxedUnit.UNIT;
        });
        writer.close();
    }

    public static final /* synthetic */ void $anonfun$skipKeysAndWriteNewFile$1(Set keysToSkip$1, HoodieAvroParquetWriter writer$1, GenericRecord rec) {
        block0: {
            String key = rec.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            if (keysToSkip$1.contains((Object)key)) break block0;
            writer$1.writeAvro(key, (IndexedRecord)rec);
        }
    }

    private SparkHelpers$() {
        MODULE$ = this;
    }
}

